require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_GENERIC_LOCAL_H)) {
    eval 'sub _ASM_GENERIC_LOCAL_H {1;}' unless defined(&_ASM_GENERIC_LOCAL_H);
    require 'linux/config.ph';
    require 'linux/percpu.ph';
    require 'linux/hardirq.ph';
    require 'asm/types.ph';
    if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 32) {
	eval 'sub LOCAL_INIT {
	    my($i) = @_;
    	    eval q({  &ATOMIC_INIT($i) });
	}' unless defined(&LOCAL_INIT);
	eval 'sub local_read {
	    my($l) = @_;
    	    eval q(( &atomic_read(($l)-> &a)));
	}' unless defined(&local_read);
	eval 'sub local_set {
	    my($l,$i) = @_;
    	    eval q( &atomic_set((($l)-> &a),($i)));
	}' unless defined(&local_set);
	eval 'sub local_inc {
	    my($l) = @_;
    	    eval q( &atomic_inc(($l)-> &a));
	}' unless defined(&local_inc);
	eval 'sub local_dec {
	    my($l) = @_;
    	    eval q( &atomic_dec(($l)-> &a));
	}' unless defined(&local_dec);
	eval 'sub local_add {
	    my($i,$l) = @_;
    	    eval q( &atomic_add(($i),(($l)-> &a)));
	}' unless defined(&local_add);
	eval 'sub local_sub {
	    my($i,$l) = @_;
    	    eval q( &atomic_sub(($i),(($l)-> &a)));
	}' unless defined(&local_sub);
	eval 'sub __local_inc {
	    my($l) = @_;
    	    eval q( &local_set(($l),  &local_read($l) + 1));
	}' unless defined(&__local_inc);
	eval 'sub __local_dec {
	    my($l) = @_;
    	    eval q( &local_set(($l),  &local_read($l) - 1));
	}' unless defined(&__local_dec);
	eval 'sub __local_add {
	    my($i,$l) = @_;
    	    eval q( &local_set(($l),  &local_read($l) + ($i)));
	}' unless defined(&__local_add);
	eval 'sub __local_sub {
	    my($i,$l) = @_;
    	    eval q( &local_set(($l),  &local_read($l) - ($i)));
	}' unless defined(&__local_sub);
    } else {
	eval 'sub _LOCAL_VAR {
	    my($l) = @_;
    	    eval q((($l)-> $v[! &in_interrupt() + ! &in_irq()]));
	}' unless defined(&_LOCAL_VAR);
	eval 'sub LOCAL_INIT {
	    my($i) = @_;
    	    eval q({ { ($i), 0, 0} });
	}' unless defined(&LOCAL_INIT);
	eval 'sub local_read {
	    my($l) = @_;
    	    eval q({  ($l->{v[0]}) +  ($l->{v[1]}) +  ($l->{v[2]}); });
	}' unless defined(&local_read);
	eval 'sub local_set {
	    my($l,$v) = @_;
    	    eval q({  ($l->{v[0]}) = $v;  ($l->{v[1]}) =  ($l->{v[2]}) = 0; });
	}' unless defined(&local_set);
	eval 'sub local_inc {
	    my($l) = @_;
    	    eval q({  &preempt_disable();  &_LOCAL_VAR($l)++;  &preempt_enable(); });
	}' unless defined(&local_inc);
	eval 'sub local_dec {
	    my($l) = @_;
    	    eval q({  &preempt_disable();  &_LOCAL_VAR($l)--;  &preempt_enable(); });
	}' unless defined(&local_dec);
	eval 'sub local_add {
	    my($v,$l) = @_;
    	    eval q({  &preempt_disable();  &_LOCAL_VAR($l) += $v;  &preempt_enable(); });
	}' unless defined(&local_add);
	eval 'sub local_sub {
	    my($v,$l) = @_;
    	    eval q({  &preempt_disable();  &_LOCAL_VAR($l) -= $v;  &preempt_enable(); });
	}' unless defined(&local_sub);
	eval 'sub __local_inc {
	    my($l) = @_;
    	    eval q((($l)-> $v[0]++));
	}' unless defined(&__local_inc);
	eval 'sub __local_dec {
	    my($l) = @_;
    	    eval q((($l)-> $v[0]--));
	}' unless defined(&__local_dec);
	eval 'sub __local_add {
	    my($i,$l) = @_;
    	    eval q((($l)-> $v[0] += ($i)));
	}' unless defined(&__local_add);
	eval 'sub __local_sub {
	    my($i,$l) = @_;
    	    eval q((($l)-> $v[0] -= ($i)));
	}' unless defined(&__local_sub);
    }
    eval 'sub cpu_local_read {
        my($v) = @_;
	    eval q( &local_read(& &__get_cpu_var($v)));
    }' unless defined(&cpu_local_read);
    eval 'sub cpu_local_set {
        my($v, $i) = @_;
	    eval q( &local_set(& &__get_cpu_var($v), ($i)));
    }' unless defined(&cpu_local_set);
    eval 'sub cpu_local_inc {
        my($v) = @_;
	    eval q( &local_inc(& &__get_cpu_var($v)));
    }' unless defined(&cpu_local_inc);
    eval 'sub cpu_local_dec {
        my($v) = @_;
	    eval q( &local_dec(& &__get_cpu_var($v)));
    }' unless defined(&cpu_local_dec);
    eval 'sub cpu_local_add {
        my($i, $v) = @_;
	    eval q( &local_add(($i), & &__get_cpu_var($v)));
    }' unless defined(&cpu_local_add);
    eval 'sub cpu_local_sub {
        my($i, $v) = @_;
	    eval q( &local_sub(($i), & &__get_cpu_var($v)));
    }' unless defined(&cpu_local_sub);
    eval 'sub __cpu_local_inc {
        my($v) = @_;
	    eval q( &__local_inc(& &__get_cpu_var($v)));
    }' unless defined(&__cpu_local_inc);
    eval 'sub __cpu_local_dec {
        my($v) = @_;
	    eval q( &__local_dec(& &__get_cpu_var($v)));
    }' unless defined(&__cpu_local_dec);
    eval 'sub __cpu_local_add {
        my($i, $v) = @_;
	    eval q( &__local_add(($i), & &__get_cpu_var($v)));
    }' unless defined(&__cpu_local_add);
    eval 'sub __cpu_local_sub {
        my($i, $v) = @_;
	    eval q( &__local_sub(($i), & &__get_cpu_var($v)));
    }' unless defined(&__cpu_local_sub);
}
1;
