require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_GENERIC_PCI_DMA_COMPAT_H)) {
    eval 'sub _ASM_GENERIC_PCI_DMA_COMPAT_H {1;}' unless defined(&_ASM_GENERIC_PCI_DMA_COMPAT_H);
    require 'linux/dma-mapping.ph';
    eval 'sub pci_alloc_consistent {
        my($hwdev,$size,$dma_handle) = @_;
	    eval q({  &dma_alloc_coherent($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $size, $dma_handle,  &GFP_ATOMIC); });
    }' unless defined(&pci_alloc_consistent);
    eval 'sub pci_free_consistent {
        my($hwdev,$size,$vaddr,$dma_handle) = @_;
	    eval q({  &dma_free_coherent($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $size, $vaddr, $dma_handle); });
    }' unless defined(&pci_free_consistent);
    eval 'sub pci_map_single {
        my($hwdev,$ptr,$size,$direction) = @_;
	    eval q({  &dma_map_single($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $ptr, $size, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_map_single);
    eval 'sub pci_unmap_single {
        my($hwdev,$dma_addr,$size,$direction) = @_;
	    eval q({  &dma_unmap_single($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $dma_addr, $size, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_unmap_single);
    eval 'sub pci_map_page {
        my($hwdev,$page,$offset,$size,$direction) = @_;
	    eval q({  &dma_map_page($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $page, $offset, $size, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_map_page);
    eval 'sub pci_unmap_page {
        my($hwdev,$dma_address,$size,$direction) = @_;
	    eval q({  &dma_unmap_page($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $dma_address, $size, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_unmap_page);
    eval 'sub pci_map_sg {
        my($hwdev,$sg,$nents,$direction) = @_;
	    eval q({  &dma_map_sg($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $sg, $nents, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_map_sg);
    eval 'sub pci_unmap_sg {
        my($hwdev,$sg,$nents,$direction) = @_;
	    eval q({  &dma_unmap_sg($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $sg, $nents, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_unmap_sg);
    eval 'sub pci_dma_sync_single_for_cpu {
        my($hwdev,$dma_handle,$size,$direction) = @_;
	    eval q({  &dma_sync_single_for_cpu($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $dma_handle, $size, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_dma_sync_single_for_cpu);
    eval 'sub pci_dma_sync_single_for_device {
        my($hwdev,$dma_handle,$size,$direction) = @_;
	    eval q({  &dma_sync_single_for_device($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $dma_handle, $size, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_dma_sync_single_for_device);
    eval 'sub pci_dma_sync_sg_for_cpu {
        my($hwdev,$sg,$nelems,$direction) = @_;
	    eval q({  &dma_sync_sg_for_cpu($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $sg, $nelems, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_dma_sync_sg_for_cpu);
    eval 'sub pci_dma_sync_sg_for_device {
        my($hwdev,$sg,$nelems,$direction) = @_;
	    eval q({  &dma_sync_sg_for_device($hwdev ==  &NULL ?  &NULL :  ($hwdev->{dev}), $sg, $nelems, ( &enum  &dma_data_direction)$direction); });
    }' unless defined(&pci_dma_sync_sg_for_device);
    eval 'sub pci_dma_mapping_error {
        my($dma_addr) = @_;
	    eval q({  &dma_mapping_error($dma_addr); });
    }' unless defined(&pci_dma_mapping_error);
}
1;
