require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_MC146818RTC_H)) {
    eval 'sub _ASM_MC146818RTC_H {1;}' unless defined(&_ASM_MC146818RTC_H);
    require 'asm/io.ph';
    require 'asm/system.ph';
    require 'linux/mc146818rtc.ph';
    unless(defined(&RTC_PORT)) {
	eval 'sub RTC_PORT {
	    my($x) = @_;
    	    eval q((0x70 + ($x)));
	}' unless defined(&RTC_PORT);
	eval 'sub RTC_ALWAYS_BCD {1;}' unless defined(&RTC_ALWAYS_BCD);
    }
    if(defined(&__HAVE_ARCH_CMPXCHG)) {
	require 'linux/smp.ph';
	eval 'sub unlock_cmos {
	    my($void) = @_;
    	    eval q({  &cmos_lock = 0; });
	}' unless defined(&unlock_cmos);
	eval 'sub do_i_have_lock_cmos {
	    my($void) = @_;
    	    eval q({ ( &cmos_lock >> 8) == ( &smp_processor_id()+1); });
	}' unless defined(&do_i_have_lock_cmos);
	eval 'sub current_lock_cmos_reg {
	    my($void) = @_;
    	    eval q({  &cmos_lock & 0xff; });
	}' unless defined(&current_lock_cmos_reg);
	eval 'sub lock_cmos_prefix {
	    my($reg) = @_;
    	    eval q( &do { \'unsigned long cmos_flags\';  &local_irq_save( &cmos_flags);  &lock_cmos($reg));
	}' unless defined(&lock_cmos_prefix);
	eval 'sub lock_cmos_suffix {
	    my($reg) = @_;
    	    eval q( &unlock_cmos();  &local_irq_restore( &cmos_flags); }  &while (0));
	}' unless defined(&lock_cmos_suffix);
    } else {
	eval 'sub lock_cmos_prefix {
	    my($reg) = @_;
    	    eval q( &do {}  &while (0));
	}' unless defined(&lock_cmos_prefix);
	eval 'sub lock_cmos_suffix {
	    my($reg) = @_;
    	    eval q( &do {}  &while (0));
	}' unless defined(&lock_cmos_suffix);
	eval 'sub lock_cmos {
	    my($reg) = @_;
    	    eval q();
	}' unless defined(&lock_cmos);
	eval 'sub unlock_cmos () {
	    eval q();
	}' unless defined(&unlock_cmos);
	eval 'sub do_i_have_lock_cmos () {
	    eval q(0);
	}' unless defined(&do_i_have_lock_cmos);
	eval 'sub current_lock_cmos_reg () {
	    eval q(0);
	}' unless defined(&current_lock_cmos_reg);
    }
    eval 'sub CMOS_READ {
        my($addr) = @_;
	    eval q( &rtc_cmos_read($addr));
    }' unless defined(&CMOS_READ);
    eval 'sub CMOS_WRITE {
        my($val, $addr) = @_;
	    eval q( &rtc_cmos_write($val, $addr));
    }' unless defined(&CMOS_WRITE);
    eval 'sub RTC_IRQ {8;}' unless defined(&RTC_IRQ);
}
1;
