require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ELF_H)) {
    eval 'sub _ELF_H {1;}' unless defined(&_ELF_H);
    require 'features.ph';
    require 'stdint.ph';
    eval 'sub EI_NIDENT {(16);}' unless defined(&EI_NIDENT);
    eval 'sub EI_MAG0 {0;}' unless defined(&EI_MAG0);
    eval 'sub ELFMAG0 {0x7f;}' unless defined(&ELFMAG0);
    eval 'sub EI_MAG1 {1;}' unless defined(&EI_MAG1);
    eval 'sub ELFMAG1 {ord(\'E\');}' unless defined(&ELFMAG1);
    eval 'sub EI_MAG2 {2;}' unless defined(&EI_MAG2);
    eval 'sub ELFMAG2 {ord(\'L\');}' unless defined(&ELFMAG2);
    eval 'sub EI_MAG3 {3;}' unless defined(&EI_MAG3);
    eval 'sub ELFMAG3 {ord(\'F\');}' unless defined(&ELFMAG3);
    eval 'sub ELFMAG {"\\177ELF";}' unless defined(&ELFMAG);
    eval 'sub SELFMAG {4;}' unless defined(&SELFMAG);
    eval 'sub EI_CLASS {4;}' unless defined(&EI_CLASS);
    eval 'sub ELFCLASSNONE {0;}' unless defined(&ELFCLASSNONE);
    eval 'sub ELFCLASS32 {1;}' unless defined(&ELFCLASS32);
    eval 'sub ELFCLASS64 {2;}' unless defined(&ELFCLASS64);
    eval 'sub ELFCLASSNUM {3;}' unless defined(&ELFCLASSNUM);
    eval 'sub EI_DATA {5;}' unless defined(&EI_DATA);
    eval 'sub ELFDATANONE {0;}' unless defined(&ELFDATANONE);
    eval 'sub ELFDATA2LSB {1;}' unless defined(&ELFDATA2LSB);
    eval 'sub ELFDATA2MSB {2;}' unless defined(&ELFDATA2MSB);
    eval 'sub ELFDATANUM {3;}' unless defined(&ELFDATANUM);
    eval 'sub EI_VERSION {6;}' unless defined(&EI_VERSION);
    eval 'sub EI_OSABI {7;}' unless defined(&EI_OSABI);
    eval 'sub ELFOSABI_NONE {0;}' unless defined(&ELFOSABI_NONE);
    eval 'sub ELFOSABI_SYSV {0;}' unless defined(&ELFOSABI_SYSV);
    eval 'sub ELFOSABI_HPUX {1;}' unless defined(&ELFOSABI_HPUX);
    eval 'sub ELFOSABI_NETBSD {2;}' unless defined(&ELFOSABI_NETBSD);
    eval 'sub ELFOSABI_LINUX {3;}' unless defined(&ELFOSABI_LINUX);
    eval 'sub ELFOSABI_SOLARIS {6;}' unless defined(&ELFOSABI_SOLARIS);
    eval 'sub ELFOSABI_AIX {7;}' unless defined(&ELFOSABI_AIX);
    eval 'sub ELFOSABI_IRIX {8;}' unless defined(&ELFOSABI_IRIX);
    eval 'sub ELFOSABI_FREEBSD {9;}' unless defined(&ELFOSABI_FREEBSD);
    eval 'sub ELFOSABI_TRU64 {10;}' unless defined(&ELFOSABI_TRU64);
    eval 'sub ELFOSABI_MODESTO {11;}' unless defined(&ELFOSABI_MODESTO);
    eval 'sub ELFOSABI_OPENBSD {12;}' unless defined(&ELFOSABI_OPENBSD);
    eval 'sub ELFOSABI_ARM {97;}' unless defined(&ELFOSABI_ARM);
    eval 'sub ELFOSABI_STANDALONE {255;}' unless defined(&ELFOSABI_STANDALONE);
    eval 'sub EI_ABIVERSION {8;}' unless defined(&EI_ABIVERSION);
    eval 'sub EI_PAD {9;}' unless defined(&EI_PAD);
    eval 'sub ET_NONE {0;}' unless defined(&ET_NONE);
    eval 'sub ET_REL {1;}' unless defined(&ET_REL);
    eval 'sub ET_EXEC {2;}' unless defined(&ET_EXEC);
    eval 'sub ET_DYN {3;}' unless defined(&ET_DYN);
    eval 'sub ET_CORE {4;}' unless defined(&ET_CORE);
    eval 'sub ET_NUM {5;}' unless defined(&ET_NUM);
    eval 'sub ET_LOOS {0xfe00;}' unless defined(&ET_LOOS);
    eval 'sub ET_HIOS {0xfeff;}' unless defined(&ET_HIOS);
    eval 'sub ET_LOPROC {0xff00;}' unless defined(&ET_LOPROC);
    eval 'sub ET_HIPROC {0xffff;}' unless defined(&ET_HIPROC);
    eval 'sub EM_NONE {0;}' unless defined(&EM_NONE);
    eval 'sub EM_M32 {1;}' unless defined(&EM_M32);
    eval 'sub EM_SPARC {2;}' unless defined(&EM_SPARC);
    eval 'sub EM_386 {3;}' unless defined(&EM_386);
    eval 'sub EM_68K {4;}' unless defined(&EM_68K);
    eval 'sub EM_88K {5;}' unless defined(&EM_88K);
    eval 'sub EM_860 {7;}' unless defined(&EM_860);
    eval 'sub EM_MIPS {8;}' unless defined(&EM_MIPS);
    eval 'sub EM_S370 {9;}' unless defined(&EM_S370);
    eval 'sub EM_MIPS_RS3_LE {10;}' unless defined(&EM_MIPS_RS3_LE);
    eval 'sub EM_PARISC {15;}' unless defined(&EM_PARISC);
    eval 'sub EM_VPP500 {17;}' unless defined(&EM_VPP500);
    eval 'sub EM_SPARC32PLUS {18;}' unless defined(&EM_SPARC32PLUS);
    eval 'sub EM_960 {19;}' unless defined(&EM_960);
    eval 'sub EM_PPC {20;}' unless defined(&EM_PPC);
    eval 'sub EM_PPC64 {21;}' unless defined(&EM_PPC64);
    eval 'sub EM_S390 {22;}' unless defined(&EM_S390);
    eval 'sub EM_V800 {36;}' unless defined(&EM_V800);
    eval 'sub EM_FR20 {37;}' unless defined(&EM_FR20);
    eval 'sub EM_RH32 {38;}' unless defined(&EM_RH32);
    eval 'sub EM_RCE {39;}' unless defined(&EM_RCE);
    eval 'sub EM_ARM {40;}' unless defined(&EM_ARM);
    eval 'sub EM_FAKE_ALPHA {41;}' unless defined(&EM_FAKE_ALPHA);
    eval 'sub EM_SH {42;}' unless defined(&EM_SH);
    eval 'sub EM_SPARCV9 {43;}' unless defined(&EM_SPARCV9);
    eval 'sub EM_TRICORE {44;}' unless defined(&EM_TRICORE);
    eval 'sub EM_ARC {45;}' unless defined(&EM_ARC);
    eval 'sub EM_H8_300 {46;}' unless defined(&EM_H8_300);
    eval 'sub EM_H8_300H {47;}' unless defined(&EM_H8_300H);
    eval 'sub EM_H8S {48;}' unless defined(&EM_H8S);
    eval 'sub EM_H8_500 {49;}' unless defined(&EM_H8_500);
    eval 'sub EM_IA_64 {50;}' unless defined(&EM_IA_64);
    eval 'sub EM_MIPS_X {51;}' unless defined(&EM_MIPS_X);
    eval 'sub EM_COLDFIRE {52;}' unless defined(&EM_COLDFIRE);
    eval 'sub EM_68HC12 {53;}' unless defined(&EM_68HC12);
    eval 'sub EM_MMA {54;}' unless defined(&EM_MMA);
    eval 'sub EM_PCP {55;}' unless defined(&EM_PCP);
    eval 'sub EM_NCPU {56;}' unless defined(&EM_NCPU);
    eval 'sub EM_NDR1 {57;}' unless defined(&EM_NDR1);
    eval 'sub EM_STARCORE {58;}' unless defined(&EM_STARCORE);
    eval 'sub EM_ME16 {59;}' unless defined(&EM_ME16);
    eval 'sub EM_ST100 {60;}' unless defined(&EM_ST100);
    eval 'sub EM_TINYJ {61;}' unless defined(&EM_TINYJ);
    eval 'sub EM_X86_64 {62;}' unless defined(&EM_X86_64);
    eval 'sub EM_PDSP {63;}' unless defined(&EM_PDSP);
    eval 'sub EM_FX66 {66;}' unless defined(&EM_FX66);
    eval 'sub EM_ST9PLUS {67;}' unless defined(&EM_ST9PLUS);
    eval 'sub EM_ST7 {68;}' unless defined(&EM_ST7);
    eval 'sub EM_68HC16 {69;}' unless defined(&EM_68HC16);
    eval 'sub EM_68HC11 {70;}' unless defined(&EM_68HC11);
    eval 'sub EM_68HC08 {71;}' unless defined(&EM_68HC08);
    eval 'sub EM_68HC05 {72;}' unless defined(&EM_68HC05);
    eval 'sub EM_SVX {73;}' unless defined(&EM_SVX);
    eval 'sub EM_ST19 {74;}' unless defined(&EM_ST19);
    eval 'sub EM_VAX {75;}' unless defined(&EM_VAX);
    eval 'sub EM_CRIS {76;}' unless defined(&EM_CRIS);
    eval 'sub EM_JAVELIN {77;}' unless defined(&EM_JAVELIN);
    eval 'sub EM_FIREPATH {78;}' unless defined(&EM_FIREPATH);
    eval 'sub EM_ZSP {79;}' unless defined(&EM_ZSP);
    eval 'sub EM_MMIX {80;}' unless defined(&EM_MMIX);
    eval 'sub EM_HUANY {81;}' unless defined(&EM_HUANY);
    eval 'sub EM_PRISM {82;}' unless defined(&EM_PRISM);
    eval 'sub EM_AVR {83;}' unless defined(&EM_AVR);
    eval 'sub EM_FR30 {84;}' unless defined(&EM_FR30);
    eval 'sub EM_D10V {85;}' unless defined(&EM_D10V);
    eval 'sub EM_D30V {86;}' unless defined(&EM_D30V);
    eval 'sub EM_V850 {87;}' unless defined(&EM_V850);
    eval 'sub EM_M32R {88;}' unless defined(&EM_M32R);
    eval 'sub EM_MN10300 {89;}' unless defined(&EM_MN10300);
    eval 'sub EM_MN10200 {90;}' unless defined(&EM_MN10200);
    eval 'sub EM_PJ {91;}' unless defined(&EM_PJ);
    eval 'sub EM_OPENRISC {92;}' unless defined(&EM_OPENRISC);
    eval 'sub EM_ARC_A5 {93;}' unless defined(&EM_ARC_A5);
    eval 'sub EM_XTENSA {94;}' unless defined(&EM_XTENSA);
    eval 'sub EM_NUM {95;}' unless defined(&EM_NUM);
    eval 'sub EM_ALPHA {0x9026;}' unless defined(&EM_ALPHA);
    eval 'sub EV_NONE {0;}' unless defined(&EV_NONE);
    eval 'sub EV_CURRENT {1;}' unless defined(&EV_CURRENT);
    eval 'sub EV_NUM {2;}' unless defined(&EV_NUM);
    eval 'sub SHN_UNDEF {0;}' unless defined(&SHN_UNDEF);
    eval 'sub SHN_LORESERVE {0xff00;}' unless defined(&SHN_LORESERVE);
    eval 'sub SHN_LOPROC {0xff00;}' unless defined(&SHN_LOPROC);
    eval 'sub SHN_BEFORE {0xff00;}' unless defined(&SHN_BEFORE);
    eval 'sub SHN_AFTER {0xff01;}' unless defined(&SHN_AFTER);
    eval 'sub SHN_HIPROC {0xff1f;}' unless defined(&SHN_HIPROC);
    eval 'sub SHN_LOOS {0xff20;}' unless defined(&SHN_LOOS);
    eval 'sub SHN_HIOS {0xff3f;}' unless defined(&SHN_HIOS);
    eval 'sub SHN_ABS {0xfff1;}' unless defined(&SHN_ABS);
    eval 'sub SHN_COMMON {0xfff2;}' unless defined(&SHN_COMMON);
    eval 'sub SHN_XINDEX {0xffff;}' unless defined(&SHN_XINDEX);
    eval 'sub SHN_HIRESERVE {0xffff;}' unless defined(&SHN_HIRESERVE);
    eval 'sub SHT_NULL {0;}' unless defined(&SHT_NULL);
    eval 'sub SHT_PROGBITS {1;}' unless defined(&SHT_PROGBITS);
    eval 'sub SHT_SYMTAB {2;}' unless defined(&SHT_SYMTAB);
    eval 'sub SHT_STRTAB {3;}' unless defined(&SHT_STRTAB);
    eval 'sub SHT_RELA {4;}' unless defined(&SHT_RELA);
    eval 'sub SHT_HASH {5;}' unless defined(&SHT_HASH);
    eval 'sub SHT_DYNAMIC {6;}' unless defined(&SHT_DYNAMIC);
    eval 'sub SHT_NOTE {7;}' unless defined(&SHT_NOTE);
    eval 'sub SHT_NOBITS {8;}' unless defined(&SHT_NOBITS);
    eval 'sub SHT_REL {9;}' unless defined(&SHT_REL);
    eval 'sub SHT_SHLIB {10;}' unless defined(&SHT_SHLIB);
    eval 'sub SHT_DYNSYM {11;}' unless defined(&SHT_DYNSYM);
    eval 'sub SHT_INIT_ARRAY {14;}' unless defined(&SHT_INIT_ARRAY);
    eval 'sub SHT_FINI_ARRAY {15;}' unless defined(&SHT_FINI_ARRAY);
    eval 'sub SHT_PREINIT_ARRAY {16;}' unless defined(&SHT_PREINIT_ARRAY);
    eval 'sub SHT_GROUP {17;}' unless defined(&SHT_GROUP);
    eval 'sub SHT_SYMTAB_SHNDX {18;}' unless defined(&SHT_SYMTAB_SHNDX);
    eval 'sub SHT_NUM {19;}' unless defined(&SHT_NUM);
    eval 'sub SHT_LOOS {0x60000000;}' unless defined(&SHT_LOOS);
    eval 'sub SHT_GNU_LIBLIST {0x6ffffff7;}' unless defined(&SHT_GNU_LIBLIST);
    eval 'sub SHT_CHECKSUM {0x6ffffff8;}' unless defined(&SHT_CHECKSUM);
    eval 'sub SHT_LOSUNW {0x6ffffffa;}' unless defined(&SHT_LOSUNW);
    eval 'sub SHT_SUNW_move {0x6ffffffa;}' unless defined(&SHT_SUNW_move);
    eval 'sub SHT_SUNW_COMDAT {0x6ffffffb;}' unless defined(&SHT_SUNW_COMDAT);
    eval 'sub SHT_SUNW_syminfo {0x6ffffffc;}' unless defined(&SHT_SUNW_syminfo);
    eval 'sub SHT_GNU_verdef {0x6ffffffd;}' unless defined(&SHT_GNU_verdef);
    eval 'sub SHT_GNU_verneed {0x6ffffffe;}' unless defined(&SHT_GNU_verneed);
    eval 'sub SHT_GNU_versym {0x6fffffff;}' unless defined(&SHT_GNU_versym);
    eval 'sub SHT_HISUNW {0x6fffffff;}' unless defined(&SHT_HISUNW);
    eval 'sub SHT_HIOS {0x6fffffff;}' unless defined(&SHT_HIOS);
    eval 'sub SHT_LOPROC {0x70000000;}' unless defined(&SHT_LOPROC);
    eval 'sub SHT_HIPROC {0x7fffffff;}' unless defined(&SHT_HIPROC);
    eval 'sub SHT_LOUSER {0x80000000;}' unless defined(&SHT_LOUSER);
    eval 'sub SHT_HIUSER {0x8fffffff;}' unless defined(&SHT_HIUSER);
    eval 'sub SHF_WRITE {(1<< 0);}' unless defined(&SHF_WRITE);
    eval 'sub SHF_ALLOC {(1<< 1);}' unless defined(&SHF_ALLOC);
    eval 'sub SHF_EXECINSTR {(1<< 2);}' unless defined(&SHF_EXECINSTR);
    eval 'sub SHF_MERGE {(1<< 4);}' unless defined(&SHF_MERGE);
    eval 'sub SHF_STRINGS {(1<< 5);}' unless defined(&SHF_STRINGS);
    eval 'sub SHF_INFO_LINK {(1<< 6);}' unless defined(&SHF_INFO_LINK);
    eval 'sub SHF_LINK_ORDER {(1<< 7);}' unless defined(&SHF_LINK_ORDER);
    eval 'sub SHF_OS_NONCONFORMING {(1<< 8);}' unless defined(&SHF_OS_NONCONFORMING);
    eval 'sub SHF_GROUP {(1<< 9);}' unless defined(&SHF_GROUP);
    eval 'sub SHF_TLS {(1<< 10);}' unless defined(&SHF_TLS);
    eval 'sub SHF_MASKOS {0xff00000;}' unless defined(&SHF_MASKOS);
    eval 'sub SHF_MASKPROC {0xf0000000;}' unless defined(&SHF_MASKPROC);
    eval 'sub SHF_ORDERED {(1<< 30);}' unless defined(&SHF_ORDERED);
    eval 'sub SHF_EXCLUDE {(1<< 31);}' unless defined(&SHF_EXCLUDE);
    eval 'sub GRP_COMDAT {0x1;}' unless defined(&GRP_COMDAT);
    eval 'sub SYMINFO_BT_SELF {0xffff;}' unless defined(&SYMINFO_BT_SELF);
    eval 'sub SYMINFO_BT_PARENT {0xfffe;}' unless defined(&SYMINFO_BT_PARENT);
    eval 'sub SYMINFO_BT_LOWRESERVE {0xff00;}' unless defined(&SYMINFO_BT_LOWRESERVE);
    eval 'sub SYMINFO_FLG_DIRECT {0x1;}' unless defined(&SYMINFO_FLG_DIRECT);
    eval 'sub SYMINFO_FLG_PASSTHRU {0x2;}' unless defined(&SYMINFO_FLG_PASSTHRU);
    eval 'sub SYMINFO_FLG_COPY {0x4;}' unless defined(&SYMINFO_FLG_COPY);
    eval 'sub SYMINFO_FLG_LAZYLOAD {0x8;}' unless defined(&SYMINFO_FLG_LAZYLOAD);
    eval 'sub SYMINFO_NONE {0;}' unless defined(&SYMINFO_NONE);
    eval 'sub SYMINFO_CURRENT {1;}' unless defined(&SYMINFO_CURRENT);
    eval 'sub SYMINFO_NUM {2;}' unless defined(&SYMINFO_NUM);
    eval 'sub ELF32_ST_BIND {
        my($val) = @_;
	    eval q((( ($val)) >> 4));
    }' unless defined(&ELF32_ST_BIND);
    eval 'sub ELF32_ST_TYPE {
        my($val) = @_;
	    eval q((($val) & 0xf));
    }' unless defined(&ELF32_ST_TYPE);
    eval 'sub ELF32_ST_INFO {
        my($bind, $type) = @_;
	    eval q(((($bind) << 4) + (($type) & 0xf)));
    }' unless defined(&ELF32_ST_INFO);
    eval 'sub ELF64_ST_BIND {
        my($val) = @_;
	    eval q( &ELF32_ST_BIND ($val));
    }' unless defined(&ELF64_ST_BIND);
    eval 'sub ELF64_ST_TYPE {
        my($val) = @_;
	    eval q( &ELF32_ST_TYPE ($val));
    }' unless defined(&ELF64_ST_TYPE);
    eval 'sub ELF64_ST_INFO {
        my($bind, $type) = @_;
	    eval q( &ELF32_ST_INFO (($bind), ($type)));
    }' unless defined(&ELF64_ST_INFO);
    eval 'sub STB_LOCAL {0;}' unless defined(&STB_LOCAL);
    eval 'sub STB_GLOBAL {1;}' unless defined(&STB_GLOBAL);
    eval 'sub STB_WEAK {2;}' unless defined(&STB_WEAK);
    eval 'sub STB_NUM {3;}' unless defined(&STB_NUM);
    eval 'sub STB_LOOS {10;}' unless defined(&STB_LOOS);
    eval 'sub STB_HIOS {12;}' unless defined(&STB_HIOS);
    eval 'sub STB_LOPROC {13;}' unless defined(&STB_LOPROC);
    eval 'sub STB_HIPROC {15;}' unless defined(&STB_HIPROC);
    eval 'sub STT_NOTYPE {0;}' unless defined(&STT_NOTYPE);
    eval 'sub STT_OBJECT {1;}' unless defined(&STT_OBJECT);
    eval 'sub STT_FUNC {2;}' unless defined(&STT_FUNC);
    eval 'sub STT_SECTION {3;}' unless defined(&STT_SECTION);
    eval 'sub STT_FILE {4;}' unless defined(&STT_FILE);
    eval 'sub STT_COMMON {5;}' unless defined(&STT_COMMON);
    eval 'sub STT_TLS {6;}' unless defined(&STT_TLS);
    eval 'sub STT_NUM {7;}' unless defined(&STT_NUM);
    eval 'sub STT_LOOS {10;}' unless defined(&STT_LOOS);
    eval 'sub STT_HIOS {12;}' unless defined(&STT_HIOS);
    eval 'sub STT_LOPROC {13;}' unless defined(&STT_LOPROC);
    eval 'sub STT_HIPROC {15;}' unless defined(&STT_HIPROC);
    eval 'sub STN_UNDEF {0;}' unless defined(&STN_UNDEF);
    eval 'sub ELF32_ST_VISIBILITY {
        my($o) = @_;
	    eval q((($o) & 0x3));
    }' unless defined(&ELF32_ST_VISIBILITY);
    eval 'sub ELF64_ST_VISIBILITY {
        my($o) = @_;
	    eval q( &ELF32_ST_VISIBILITY ($o));
    }' unless defined(&ELF64_ST_VISIBILITY);
    eval 'sub STV_DEFAULT {0;}' unless defined(&STV_DEFAULT);
    eval 'sub STV_INTERNAL {1;}' unless defined(&STV_INTERNAL);
    eval 'sub STV_HIDDEN {2;}' unless defined(&STV_HIDDEN);
    eval 'sub STV_PROTECTED {3;}' unless defined(&STV_PROTECTED);
    eval 'sub ELF32_R_SYM {
        my($val) = @_;
	    eval q((($val) >> 8));
    }' unless defined(&ELF32_R_SYM);
    eval 'sub ELF32_R_TYPE {
        my($val) = @_;
	    eval q((($val) & 0xff));
    }' unless defined(&ELF32_R_TYPE);
    eval 'sub ELF32_R_INFO {
        my($sym, $type) = @_;
	    eval q(((($sym) << 8) + (($type) & 0xff)));
    }' unless defined(&ELF32_R_INFO);
    eval 'sub ELF64_R_SYM {
        my($i) = @_;
	    eval q((($i) >> 32));
    }' unless defined(&ELF64_R_SYM);
    eval 'sub ELF64_R_TYPE {
        my($i) = @_;
	    eval q((($i) & 0xffffffff));
    }' unless defined(&ELF64_R_TYPE);
    eval 'sub ELF64_R_INFO {
        my($sym,$type) = @_;
	    eval q((((( &Elf64_Xword) ($sym)) << 32) + ($type)));
    }' unless defined(&ELF64_R_INFO);
    eval 'sub PT_NULL {0;}' unless defined(&PT_NULL);
    eval 'sub PT_LOAD {1;}' unless defined(&PT_LOAD);
    eval 'sub PT_DYNAMIC {2;}' unless defined(&PT_DYNAMIC);
    eval 'sub PT_INTERP {3;}' unless defined(&PT_INTERP);
    eval 'sub PT_NOTE {4;}' unless defined(&PT_NOTE);
    eval 'sub PT_SHLIB {5;}' unless defined(&PT_SHLIB);
    eval 'sub PT_PHDR {6;}' unless defined(&PT_PHDR);
    eval 'sub PT_TLS {7;}' unless defined(&PT_TLS);
    eval 'sub PT_NUM {8;}' unless defined(&PT_NUM);
    eval 'sub PT_LOOS {0x60000000;}' unless defined(&PT_LOOS);
    eval 'sub PT_GNU_EH_FRAME {0x6474e550;}' unless defined(&PT_GNU_EH_FRAME);
    eval 'sub PT_GNU_STACK {0x6474e551;}' unless defined(&PT_GNU_STACK);
    eval 'sub PT_GNU_RELRO {0x6474e552;}' unless defined(&PT_GNU_RELRO);
    eval 'sub PT_LOSUNW {0x6ffffffa;}' unless defined(&PT_LOSUNW);
    eval 'sub PT_SUNWBSS {0x6ffffffa;}' unless defined(&PT_SUNWBSS);
    eval 'sub PT_SUNWSTACK {0x6ffffffb;}' unless defined(&PT_SUNWSTACK);
    eval 'sub PT_HISUNW {0x6fffffff;}' unless defined(&PT_HISUNW);
    eval 'sub PT_HIOS {0x6fffffff;}' unless defined(&PT_HIOS);
    eval 'sub PT_LOPROC {0x70000000;}' unless defined(&PT_LOPROC);
    eval 'sub PT_HIPROC {0x7fffffff;}' unless defined(&PT_HIPROC);
    eval 'sub PF_X {(1<< 0);}' unless defined(&PF_X);
    eval 'sub PF_W {(1<< 1);}' unless defined(&PF_W);
    eval 'sub PF_R {(1<< 2);}' unless defined(&PF_R);
    eval 'sub PF_MASKOS {0xff00000;}' unless defined(&PF_MASKOS);
    eval 'sub PF_MASKPROC {0xf0000000;}' unless defined(&PF_MASKPROC);
    eval 'sub NT_PRSTATUS {1;}' unless defined(&NT_PRSTATUS);
    eval 'sub NT_FPREGSET {2;}' unless defined(&NT_FPREGSET);
    eval 'sub NT_PRPSINFO {3;}' unless defined(&NT_PRPSINFO);
    eval 'sub NT_PRXREG {4;}' unless defined(&NT_PRXREG);
    eval 'sub NT_TASKSTRUCT {4;}' unless defined(&NT_TASKSTRUCT);
    eval 'sub NT_PLATFORM {5;}' unless defined(&NT_PLATFORM);
    eval 'sub NT_AUXV {6;}' unless defined(&NT_AUXV);
    eval 'sub NT_GWINDOWS {7;}' unless defined(&NT_GWINDOWS);
    eval 'sub NT_ASRS {8;}' unless defined(&NT_ASRS);
    eval 'sub NT_PSTATUS {10;}' unless defined(&NT_PSTATUS);
    eval 'sub NT_PSINFO {13;}' unless defined(&NT_PSINFO);
    eval 'sub NT_PRCRED {14;}' unless defined(&NT_PRCRED);
    eval 'sub NT_UTSNAME {15;}' unless defined(&NT_UTSNAME);
    eval 'sub NT_LWPSTATUS {16;}' unless defined(&NT_LWPSTATUS);
    eval 'sub NT_LWPSINFO {17;}' unless defined(&NT_LWPSINFO);
    eval 'sub NT_PRFPXREG {20;}' unless defined(&NT_PRFPXREG);
    eval 'sub NT_VERSION {1;}' unless defined(&NT_VERSION);
    eval 'sub DT_NULL {0;}' unless defined(&DT_NULL);
    eval 'sub DT_NEEDED {1;}' unless defined(&DT_NEEDED);
    eval 'sub DT_PLTRELSZ {2;}' unless defined(&DT_PLTRELSZ);
    eval 'sub DT_PLTGOT {3;}' unless defined(&DT_PLTGOT);
    eval 'sub DT_HASH {4;}' unless defined(&DT_HASH);
    eval 'sub DT_STRTAB {5;}' unless defined(&DT_STRTAB);
    eval 'sub DT_SYMTAB {6;}' unless defined(&DT_SYMTAB);
    eval 'sub DT_RELA {7;}' unless defined(&DT_RELA);
    eval 'sub DT_RELASZ {8;}' unless defined(&DT_RELASZ);
    eval 'sub DT_RELAENT {9;}' unless defined(&DT_RELAENT);
    eval 'sub DT_STRSZ {10;}' unless defined(&DT_STRSZ);
    eval 'sub DT_SYMENT {11;}' unless defined(&DT_SYMENT);
    eval 'sub DT_INIT {12;}' unless defined(&DT_INIT);
    eval 'sub DT_FINI {13;}' unless defined(&DT_FINI);
    eval 'sub DT_SONAME {14;}' unless defined(&DT_SONAME);
    eval 'sub DT_RPATH {15;}' unless defined(&DT_RPATH);
    eval 'sub DT_SYMBOLIC {16;}' unless defined(&DT_SYMBOLIC);
    eval 'sub DT_REL {17;}' unless defined(&DT_REL);
    eval 'sub DT_RELSZ {18;}' unless defined(&DT_RELSZ);
    eval 'sub DT_RELENT {19;}' unless defined(&DT_RELENT);
    eval 'sub DT_PLTREL {20;}' unless defined(&DT_PLTREL);
    eval 'sub DT_DEBUG {21;}' unless defined(&DT_DEBUG);
    eval 'sub DT_TEXTREL {22;}' unless defined(&DT_TEXTREL);
    eval 'sub DT_JMPREL {23;}' unless defined(&DT_JMPREL);
    eval 'sub DT_BIND_NOW {24;}' unless defined(&DT_BIND_NOW);
    eval 'sub DT_INIT_ARRAY {25;}' unless defined(&DT_INIT_ARRAY);
    eval 'sub DT_FINI_ARRAY {26;}' unless defined(&DT_FINI_ARRAY);
    eval 'sub DT_INIT_ARRAYSZ {27;}' unless defined(&DT_INIT_ARRAYSZ);
    eval 'sub DT_FINI_ARRAYSZ {28;}' unless defined(&DT_FINI_ARRAYSZ);
    eval 'sub DT_RUNPATH {29;}' unless defined(&DT_RUNPATH);
    eval 'sub DT_FLAGS {30;}' unless defined(&DT_FLAGS);
    eval 'sub DT_ENCODING {32;}' unless defined(&DT_ENCODING);
    eval 'sub DT_PREINIT_ARRAY {32;}' unless defined(&DT_PREINIT_ARRAY);
    eval 'sub DT_PREINIT_ARRAYSZ {33;}' unless defined(&DT_PREINIT_ARRAYSZ);
    eval 'sub DT_NUM {34;}' unless defined(&DT_NUM);
    eval 'sub DT_LOOS {0x6000000d;}' unless defined(&DT_LOOS);
    eval 'sub DT_HIOS {0x6ffff000;}' unless defined(&DT_HIOS);
    eval 'sub DT_LOPROC {0x70000000;}' unless defined(&DT_LOPROC);
    eval 'sub DT_HIPROC {0x7fffffff;}' unless defined(&DT_HIPROC);
    eval 'sub DT_PROCNUM { &DT_MIPS_NUM;}' unless defined(&DT_PROCNUM);
    eval 'sub DT_VALRNGLO {0x6ffffd00;}' unless defined(&DT_VALRNGLO);
    eval 'sub DT_GNU_PRELINKED {0x6ffffdf5;}' unless defined(&DT_GNU_PRELINKED);
    eval 'sub DT_GNU_CONFLICTSZ {0x6ffffdf6;}' unless defined(&DT_GNU_CONFLICTSZ);
    eval 'sub DT_GNU_LIBLISTSZ {0x6ffffdf7;}' unless defined(&DT_GNU_LIBLISTSZ);
    eval 'sub DT_CHECKSUM {0x6ffffdf8;}' unless defined(&DT_CHECKSUM);
    eval 'sub DT_PLTPADSZ {0x6ffffdf9;}' unless defined(&DT_PLTPADSZ);
    eval 'sub DT_MOVEENT {0x6ffffdfa;}' unless defined(&DT_MOVEENT);
    eval 'sub DT_MOVESZ {0x6ffffdfb;}' unless defined(&DT_MOVESZ);
    eval 'sub DT_FEATURE_1 {0x6ffffdfc;}' unless defined(&DT_FEATURE_1);
    eval 'sub DT_POSFLAG_1 {0x6ffffdfd;}' unless defined(&DT_POSFLAG_1);
    eval 'sub DT_SYMINSZ {0x6ffffdfe;}' unless defined(&DT_SYMINSZ);
    eval 'sub DT_SYMINENT {0x6ffffdff;}' unless defined(&DT_SYMINENT);
    eval 'sub DT_VALRNGHI {0x6ffffdff;}' unless defined(&DT_VALRNGHI);
    eval 'sub DT_VALTAGIDX {
        my($tag) = @_;
	    eval q(( &DT_VALRNGHI - ($tag)));
    }' unless defined(&DT_VALTAGIDX);
    eval 'sub DT_VALNUM {12;}' unless defined(&DT_VALNUM);
    eval 'sub DT_ADDRRNGLO {0x6ffffe00;}' unless defined(&DT_ADDRRNGLO);
    eval 'sub DT_GNU_CONFLICT {0x6ffffef8;}' unless defined(&DT_GNU_CONFLICT);
    eval 'sub DT_GNU_LIBLIST {0x6ffffef9;}' unless defined(&DT_GNU_LIBLIST);
    eval 'sub DT_CONFIG {0x6ffffefa;}' unless defined(&DT_CONFIG);
    eval 'sub DT_DEPAUDIT {0x6ffffefb;}' unless defined(&DT_DEPAUDIT);
    eval 'sub DT_AUDIT {0x6ffffefc;}' unless defined(&DT_AUDIT);
    eval 'sub DT_PLTPAD {0x6ffffefd;}' unless defined(&DT_PLTPAD);
    eval 'sub DT_MOVETAB {0x6ffffefe;}' unless defined(&DT_MOVETAB);
    eval 'sub DT_SYMINFO {0x6ffffeff;}' unless defined(&DT_SYMINFO);
    eval 'sub DT_ADDRRNGHI {0x6ffffeff;}' unless defined(&DT_ADDRRNGHI);
    eval 'sub DT_ADDRTAGIDX {
        my($tag) = @_;
	    eval q(( &DT_ADDRRNGHI - ($tag)));
    }' unless defined(&DT_ADDRTAGIDX);
    eval 'sub DT_ADDRNUM {10;}' unless defined(&DT_ADDRNUM);
    eval 'sub DT_VERSYM {0x6ffffff0;}' unless defined(&DT_VERSYM);
    eval 'sub DT_RELACOUNT {0x6ffffff9;}' unless defined(&DT_RELACOUNT);
    eval 'sub DT_RELCOUNT {0x6ffffffa;}' unless defined(&DT_RELCOUNT);
    eval 'sub DT_FLAGS_1 {0x6ffffffb;}' unless defined(&DT_FLAGS_1);
    eval 'sub DT_VERDEF {0x6ffffffc;}' unless defined(&DT_VERDEF);
    eval 'sub DT_VERDEFNUM {0x6ffffffd;}' unless defined(&DT_VERDEFNUM);
    eval 'sub DT_VERNEED {0x6ffffffe;}' unless defined(&DT_VERNEED);
    eval 'sub DT_VERNEEDNUM {0x6fffffff;}' unless defined(&DT_VERNEEDNUM);
    eval 'sub DT_VERSIONTAGIDX {
        my($tag) = @_;
	    eval q(( &DT_VERNEEDNUM - ($tag)));
    }' unless defined(&DT_VERSIONTAGIDX);
    eval 'sub DT_VERSIONTAGNUM {16;}' unless defined(&DT_VERSIONTAGNUM);
    eval 'sub DT_AUXILIARY {0x7ffffffd;}' unless defined(&DT_AUXILIARY);
    eval 'sub DT_FILTER {0x7fffffff;}' unless defined(&DT_FILTER);
    eval 'sub DT_EXTRATAGIDX {
        my($tag) = @_;
	    eval q((( &Elf32_Word)-(( &Elf32_Sword) ($tag) <<1>>1)-1));
    }' unless defined(&DT_EXTRATAGIDX);
    eval 'sub DT_EXTRANUM {3;}' unless defined(&DT_EXTRANUM);
    eval 'sub DF_ORIGIN {0x1;}' unless defined(&DF_ORIGIN);
    eval 'sub DF_SYMBOLIC {0x2;}' unless defined(&DF_SYMBOLIC);
    eval 'sub DF_TEXTREL {0x4;}' unless defined(&DF_TEXTREL);
    eval 'sub DF_BIND_NOW {0x8;}' unless defined(&DF_BIND_NOW);
    eval 'sub DF_STATIC_TLS {0x10;}' unless defined(&DF_STATIC_TLS);
    eval 'sub DF_1_NOW {0x1;}' unless defined(&DF_1_NOW);
    eval 'sub DF_1_GLOBAL {0x2;}' unless defined(&DF_1_GLOBAL);
    eval 'sub DF_1_GROUP {0x4;}' unless defined(&DF_1_GROUP);
    eval 'sub DF_1_NODELETE {0x8;}' unless defined(&DF_1_NODELETE);
    eval 'sub DF_1_LOADFLTR {0x10;}' unless defined(&DF_1_LOADFLTR);
    eval 'sub DF_1_INITFIRST {0x20;}' unless defined(&DF_1_INITFIRST);
    eval 'sub DF_1_NOOPEN {0x40;}' unless defined(&DF_1_NOOPEN);
    eval 'sub DF_1_ORIGIN {0x80;}' unless defined(&DF_1_ORIGIN);
    eval 'sub DF_1_DIRECT {0x100;}' unless defined(&DF_1_DIRECT);
    eval 'sub DF_1_TRANS {0x200;}' unless defined(&DF_1_TRANS);
    eval 'sub DF_1_INTERPOSE {0x400;}' unless defined(&DF_1_INTERPOSE);
    eval 'sub DF_1_NODEFLIB {0x800;}' unless defined(&DF_1_NODEFLIB);
    eval 'sub DF_1_NODUMP {0x1000;}' unless defined(&DF_1_NODUMP);
    eval 'sub DF_1_CONFALT {0x2000;}' unless defined(&DF_1_CONFALT);
    eval 'sub DF_1_ENDFILTEE {0x4000;}' unless defined(&DF_1_ENDFILTEE);
    eval 'sub DF_1_DISPRELDNE {0x8000;}' unless defined(&DF_1_DISPRELDNE);
    eval 'sub DF_1_DISPRELPND {0x10000;}' unless defined(&DF_1_DISPRELPND);
    eval 'sub DTF_1_PARINIT {0x1;}' unless defined(&DTF_1_PARINIT);
    eval 'sub DTF_1_CONFEXP {0x2;}' unless defined(&DTF_1_CONFEXP);
    eval 'sub DF_P1_LAZYLOAD {0x1;}' unless defined(&DF_P1_LAZYLOAD);
    eval 'sub DF_P1_GROUPPERM {0x2;}' unless defined(&DF_P1_GROUPPERM);
    eval 'sub VER_DEF_NONE {0;}' unless defined(&VER_DEF_NONE);
    eval 'sub VER_DEF_CURRENT {1;}' unless defined(&VER_DEF_CURRENT);
    eval 'sub VER_DEF_NUM {2;}' unless defined(&VER_DEF_NUM);
    eval 'sub VER_FLG_BASE {0x1;}' unless defined(&VER_FLG_BASE);
    eval 'sub VER_FLG_WEAK {0x2;}' unless defined(&VER_FLG_WEAK);
    eval 'sub VER_NDX_LOCAL {0;}' unless defined(&VER_NDX_LOCAL);
    eval 'sub VER_NDX_GLOBAL {1;}' unless defined(&VER_NDX_GLOBAL);
    eval 'sub VER_NDX_LORESERVE {0xff00;}' unless defined(&VER_NDX_LORESERVE);
    eval 'sub VER_NDX_ELIMINATE {0xff01;}' unless defined(&VER_NDX_ELIMINATE);
    eval 'sub VER_NEED_NONE {0;}' unless defined(&VER_NEED_NONE);
    eval 'sub VER_NEED_CURRENT {1;}' unless defined(&VER_NEED_CURRENT);
    eval 'sub VER_NEED_NUM {2;}' unless defined(&VER_NEED_NUM);
    eval 'sub VER_FLG_WEAK {0x2;}' unless defined(&VER_FLG_WEAK);
    eval 'sub AT_NULL {0;}' unless defined(&AT_NULL);
    eval 'sub AT_IGNORE {1;}' unless defined(&AT_IGNORE);
    eval 'sub AT_EXECFD {2;}' unless defined(&AT_EXECFD);
    eval 'sub AT_PHDR {3;}' unless defined(&AT_PHDR);
    eval 'sub AT_PHENT {4;}' unless defined(&AT_PHENT);
    eval 'sub AT_PHNUM {5;}' unless defined(&AT_PHNUM);
    eval 'sub AT_PAGESZ {6;}' unless defined(&AT_PAGESZ);
    eval 'sub AT_BASE {7;}' unless defined(&AT_BASE);
    eval 'sub AT_FLAGS {8;}' unless defined(&AT_FLAGS);
    eval 'sub AT_ENTRY {9;}' unless defined(&AT_ENTRY);
    eval 'sub AT_NOTELF {10;}' unless defined(&AT_NOTELF);
    eval 'sub AT_UID {11;}' unless defined(&AT_UID);
    eval 'sub AT_EUID {12;}' unless defined(&AT_EUID);
    eval 'sub AT_GID {13;}' unless defined(&AT_GID);
    eval 'sub AT_EGID {14;}' unless defined(&AT_EGID);
    eval 'sub AT_CLKTCK {17;}' unless defined(&AT_CLKTCK);
    eval 'sub AT_PLATFORM {15;}' unless defined(&AT_PLATFORM);
    eval 'sub AT_HWCAP {16;}' unless defined(&AT_HWCAP);
    eval 'sub AT_FPUCW {18;}' unless defined(&AT_FPUCW);
    eval 'sub AT_DCACHEBSIZE {19;}' unless defined(&AT_DCACHEBSIZE);
    eval 'sub AT_ICACHEBSIZE {20;}' unless defined(&AT_ICACHEBSIZE);
    eval 'sub AT_UCACHEBSIZE {21;}' unless defined(&AT_UCACHEBSIZE);
    eval 'sub AT_IGNOREPPC {22;}' unless defined(&AT_IGNOREPPC);
    eval 'sub AT_SECURE {23;}' unless defined(&AT_SECURE);
    eval 'sub AT_SYSINFO {32;}' unless defined(&AT_SYSINFO);
    eval 'sub AT_SYSINFO_EHDR {33;}' unless defined(&AT_SYSINFO_EHDR);
    eval 'sub AT_L1I_CACHESHAPE {34;}' unless defined(&AT_L1I_CACHESHAPE);
    eval 'sub AT_L1D_CACHESHAPE {35;}' unless defined(&AT_L1D_CACHESHAPE);
    eval 'sub AT_L2_CACHESHAPE {36;}' unless defined(&AT_L2_CACHESHAPE);
    eval 'sub AT_L3_CACHESHAPE {37;}' unless defined(&AT_L3_CACHESHAPE);
    eval 'sub ELF_NOTE_SOLARIS {"SUNW Solaris";}' unless defined(&ELF_NOTE_SOLARIS);
    eval 'sub ELF_NOTE_GNU {"GNU";}' unless defined(&ELF_NOTE_GNU);
    eval 'sub ELF_NOTE_PAGESIZE_HINT {1;}' unless defined(&ELF_NOTE_PAGESIZE_HINT);
    eval 'sub ELF_NOTE_ABI {1;}' unless defined(&ELF_NOTE_ABI);
    eval 'sub ELF_NOTE_OS_LINUX {0;}' unless defined(&ELF_NOTE_OS_LINUX);
    eval 'sub ELF_NOTE_OS_GNU {1;}' unless defined(&ELF_NOTE_OS_GNU);
    eval 'sub ELF_NOTE_OS_SOLARIS2 {2;}' unless defined(&ELF_NOTE_OS_SOLARIS2);
    eval 'sub ELF_NOTE_OS_FREEBSD {3;}' unless defined(&ELF_NOTE_OS_FREEBSD);
    eval 'sub ELF32_M_SYM {
        my($info) = @_;
	    eval q((($info) >> 8));
    }' unless defined(&ELF32_M_SYM);
    eval 'sub ELF32_M_SIZE {
        my($info) = @_;
	    eval q(( ($info)));
    }' unless defined(&ELF32_M_SIZE);
    eval 'sub ELF32_M_INFO {
        my($sym, $size) = @_;
	    eval q(((($sym) << 8) +  ($size)));
    }' unless defined(&ELF32_M_INFO);
    eval 'sub ELF64_M_SYM {
        my($info) = @_;
	    eval q( &ELF32_M_SYM ($info));
    }' unless defined(&ELF64_M_SYM);
    eval 'sub ELF64_M_SIZE {
        my($info) = @_;
	    eval q( &ELF32_M_SIZE ($info));
    }' unless defined(&ELF64_M_SIZE);
    eval 'sub ELF64_M_INFO {
        my($sym, $size) = @_;
	    eval q( &ELF32_M_INFO ($sym, $size));
    }' unless defined(&ELF64_M_INFO);
    eval 'sub EF_CPU32 {0x810000;}' unless defined(&EF_CPU32);
    eval 'sub R_68K_NONE {0;}' unless defined(&R_68K_NONE);
    eval 'sub R_68K_32 {1;}' unless defined(&R_68K_32);
    eval 'sub R_68K_16 {2;}' unless defined(&R_68K_16);
    eval 'sub R_68K_8 {3;}' unless defined(&R_68K_8);
    eval 'sub R_68K_PC32 {4;}' unless defined(&R_68K_PC32);
    eval 'sub R_68K_PC16 {5;}' unless defined(&R_68K_PC16);
    eval 'sub R_68K_PC8 {6;}' unless defined(&R_68K_PC8);
    eval 'sub R_68K_GOT32 {7;}' unless defined(&R_68K_GOT32);
    eval 'sub R_68K_GOT16 {8;}' unless defined(&R_68K_GOT16);
    eval 'sub R_68K_GOT8 {9;}' unless defined(&R_68K_GOT8);
    eval 'sub R_68K_GOT32O {10;}' unless defined(&R_68K_GOT32O);
    eval 'sub R_68K_GOT16O {11;}' unless defined(&R_68K_GOT16O);
    eval 'sub R_68K_GOT8O {12;}' unless defined(&R_68K_GOT8O);
    eval 'sub R_68K_PLT32 {13;}' unless defined(&R_68K_PLT32);
    eval 'sub R_68K_PLT16 {14;}' unless defined(&R_68K_PLT16);
    eval 'sub R_68K_PLT8 {15;}' unless defined(&R_68K_PLT8);
    eval 'sub R_68K_PLT32O {16;}' unless defined(&R_68K_PLT32O);
    eval 'sub R_68K_PLT16O {17;}' unless defined(&R_68K_PLT16O);
    eval 'sub R_68K_PLT8O {18;}' unless defined(&R_68K_PLT8O);
    eval 'sub R_68K_COPY {19;}' unless defined(&R_68K_COPY);
    eval 'sub R_68K_GLOB_DAT {20;}' unless defined(&R_68K_GLOB_DAT);
    eval 'sub R_68K_JMP_SLOT {21;}' unless defined(&R_68K_JMP_SLOT);
    eval 'sub R_68K_RELATIVE {22;}' unless defined(&R_68K_RELATIVE);
    eval 'sub R_68K_NUM {23;}' unless defined(&R_68K_NUM);
    eval 'sub R_386_NONE {0;}' unless defined(&R_386_NONE);
    eval 'sub R_386_32 {1;}' unless defined(&R_386_32);
    eval 'sub R_386_PC32 {2;}' unless defined(&R_386_PC32);
    eval 'sub R_386_GOT32 {3;}' unless defined(&R_386_GOT32);
    eval 'sub R_386_PLT32 {4;}' unless defined(&R_386_PLT32);
    eval 'sub R_386_COPY {5;}' unless defined(&R_386_COPY);
    eval 'sub R_386_GLOB_DAT {6;}' unless defined(&R_386_GLOB_DAT);
    eval 'sub R_386_JMP_SLOT {7;}' unless defined(&R_386_JMP_SLOT);
    eval 'sub R_386_RELATIVE {8;}' unless defined(&R_386_RELATIVE);
    eval 'sub R_386_GOTOFF {9;}' unless defined(&R_386_GOTOFF);
    eval 'sub R_386_GOTPC {10;}' unless defined(&R_386_GOTPC);
    eval 'sub R_386_32PLT {11;}' unless defined(&R_386_32PLT);
    eval 'sub R_386_TLS_TPOFF {14;}' unless defined(&R_386_TLS_TPOFF);
    eval 'sub R_386_TLS_IE {15;}' unless defined(&R_386_TLS_IE);
    eval 'sub R_386_TLS_GOTIE {16;}' unless defined(&R_386_TLS_GOTIE);
    eval 'sub R_386_TLS_LE {17;}' unless defined(&R_386_TLS_LE);
    eval 'sub R_386_TLS_GD {18;}' unless defined(&R_386_TLS_GD);
    eval 'sub R_386_TLS_LDM {19;}' unless defined(&R_386_TLS_LDM);
    eval 'sub R_386_16 {20;}' unless defined(&R_386_16);
    eval 'sub R_386_PC16 {21;}' unless defined(&R_386_PC16);
    eval 'sub R_386_8 {22;}' unless defined(&R_386_8);
    eval 'sub R_386_PC8 {23;}' unless defined(&R_386_PC8);
    eval 'sub R_386_TLS_GD_32 {24;}' unless defined(&R_386_TLS_GD_32);
    eval 'sub R_386_TLS_GD_PUSH {25;}' unless defined(&R_386_TLS_GD_PUSH);
    eval 'sub R_386_TLS_GD_CALL {26;}' unless defined(&R_386_TLS_GD_CALL);
    eval 'sub R_386_TLS_GD_POP {27;}' unless defined(&R_386_TLS_GD_POP);
    eval 'sub R_386_TLS_LDM_32 {28;}' unless defined(&R_386_TLS_LDM_32);
    eval 'sub R_386_TLS_LDM_PUSH {29;}' unless defined(&R_386_TLS_LDM_PUSH);
    eval 'sub R_386_TLS_LDM_CALL {30;}' unless defined(&R_386_TLS_LDM_CALL);
    eval 'sub R_386_TLS_LDM_POP {31;}' unless defined(&R_386_TLS_LDM_POP);
    eval 'sub R_386_TLS_LDO_32 {32;}' unless defined(&R_386_TLS_LDO_32);
    eval 'sub R_386_TLS_IE_32 {33;}' unless defined(&R_386_TLS_IE_32);
    eval 'sub R_386_TLS_LE_32 {34;}' unless defined(&R_386_TLS_LE_32);
    eval 'sub R_386_TLS_DTPMOD32 {35;}' unless defined(&R_386_TLS_DTPMOD32);
    eval 'sub R_386_TLS_DTPOFF32 {36;}' unless defined(&R_386_TLS_DTPOFF32);
    eval 'sub R_386_TLS_TPOFF32 {37;}' unless defined(&R_386_TLS_TPOFF32);
    eval 'sub R_386_NUM {38;}' unless defined(&R_386_NUM);
    eval 'sub STT_SPARC_REGISTER {13;}' unless defined(&STT_SPARC_REGISTER);
    eval 'sub EF_SPARCV9_MM {3;}' unless defined(&EF_SPARCV9_MM);
    eval 'sub EF_SPARCV9_TSO {0;}' unless defined(&EF_SPARCV9_TSO);
    eval 'sub EF_SPARCV9_PSO {1;}' unless defined(&EF_SPARCV9_PSO);
    eval 'sub EF_SPARCV9_RMO {2;}' unless defined(&EF_SPARCV9_RMO);
    eval 'sub EF_SPARC_LEDATA {0x800000;}' unless defined(&EF_SPARC_LEDATA);
    eval 'sub EF_SPARC_EXT_MASK {0xffff00;}' unless defined(&EF_SPARC_EXT_MASK);
    eval 'sub EF_SPARC_32PLUS {0x100;}' unless defined(&EF_SPARC_32PLUS);
    eval 'sub EF_SPARC_SUN_US1 {0x200;}' unless defined(&EF_SPARC_SUN_US1);
    eval 'sub EF_SPARC_HAL_R1 {0x400;}' unless defined(&EF_SPARC_HAL_R1);
    eval 'sub EF_SPARC_SUN_US3 {0x800;}' unless defined(&EF_SPARC_SUN_US3);
    eval 'sub R_SPARC_NONE {0;}' unless defined(&R_SPARC_NONE);
    eval 'sub R_SPARC_8 {1;}' unless defined(&R_SPARC_8);
    eval 'sub R_SPARC_16 {2;}' unless defined(&R_SPARC_16);
    eval 'sub R_SPARC_32 {3;}' unless defined(&R_SPARC_32);
    eval 'sub R_SPARC_DISP8 {4;}' unless defined(&R_SPARC_DISP8);
    eval 'sub R_SPARC_DISP16 {5;}' unless defined(&R_SPARC_DISP16);
    eval 'sub R_SPARC_DISP32 {6;}' unless defined(&R_SPARC_DISP32);
    eval 'sub R_SPARC_WDISP30 {7;}' unless defined(&R_SPARC_WDISP30);
    eval 'sub R_SPARC_WDISP22 {8;}' unless defined(&R_SPARC_WDISP22);
    eval 'sub R_SPARC_HI22 {9;}' unless defined(&R_SPARC_HI22);
    eval 'sub R_SPARC_22 {10;}' unless defined(&R_SPARC_22);
    eval 'sub R_SPARC_13 {11;}' unless defined(&R_SPARC_13);
    eval 'sub R_SPARC_LO10 {12;}' unless defined(&R_SPARC_LO10);
    eval 'sub R_SPARC_GOT10 {13;}' unless defined(&R_SPARC_GOT10);
    eval 'sub R_SPARC_GOT13 {14;}' unless defined(&R_SPARC_GOT13);
    eval 'sub R_SPARC_GOT22 {15;}' unless defined(&R_SPARC_GOT22);
    eval 'sub R_SPARC_PC10 {16;}' unless defined(&R_SPARC_PC10);
    eval 'sub R_SPARC_PC22 {17;}' unless defined(&R_SPARC_PC22);
    eval 'sub R_SPARC_WPLT30 {18;}' unless defined(&R_SPARC_WPLT30);
    eval 'sub R_SPARC_COPY {19;}' unless defined(&R_SPARC_COPY);
    eval 'sub R_SPARC_GLOB_DAT {20;}' unless defined(&R_SPARC_GLOB_DAT);
    eval 'sub R_SPARC_JMP_SLOT {21;}' unless defined(&R_SPARC_JMP_SLOT);
    eval 'sub R_SPARC_RELATIVE {22;}' unless defined(&R_SPARC_RELATIVE);
    eval 'sub R_SPARC_UA32 {23;}' unless defined(&R_SPARC_UA32);
    eval 'sub R_SPARC_PLT32 {24;}' unless defined(&R_SPARC_PLT32);
    eval 'sub R_SPARC_HIPLT22 {25;}' unless defined(&R_SPARC_HIPLT22);
    eval 'sub R_SPARC_LOPLT10 {26;}' unless defined(&R_SPARC_LOPLT10);
    eval 'sub R_SPARC_PCPLT32 {27;}' unless defined(&R_SPARC_PCPLT32);
    eval 'sub R_SPARC_PCPLT22 {28;}' unless defined(&R_SPARC_PCPLT22);
    eval 'sub R_SPARC_PCPLT10 {29;}' unless defined(&R_SPARC_PCPLT10);
    eval 'sub R_SPARC_10 {30;}' unless defined(&R_SPARC_10);
    eval 'sub R_SPARC_11 {31;}' unless defined(&R_SPARC_11);
    eval 'sub R_SPARC_64 {32;}' unless defined(&R_SPARC_64);
    eval 'sub R_SPARC_OLO10 {33;}' unless defined(&R_SPARC_OLO10);
    eval 'sub R_SPARC_HH22 {34;}' unless defined(&R_SPARC_HH22);
    eval 'sub R_SPARC_HM10 {35;}' unless defined(&R_SPARC_HM10);
    eval 'sub R_SPARC_LM22 {36;}' unless defined(&R_SPARC_LM22);
    eval 'sub R_SPARC_PC_HH22 {37;}' unless defined(&R_SPARC_PC_HH22);
    eval 'sub R_SPARC_PC_HM10 {38;}' unless defined(&R_SPARC_PC_HM10);
    eval 'sub R_SPARC_PC_LM22 {39;}' unless defined(&R_SPARC_PC_LM22);
    eval 'sub R_SPARC_WDISP16 {40;}' unless defined(&R_SPARC_WDISP16);
    eval 'sub R_SPARC_WDISP19 {41;}' unless defined(&R_SPARC_WDISP19);
    eval 'sub R_SPARC_7 {43;}' unless defined(&R_SPARC_7);
    eval 'sub R_SPARC_5 {44;}' unless defined(&R_SPARC_5);
    eval 'sub R_SPARC_6 {45;}' unless defined(&R_SPARC_6);
    eval 'sub R_SPARC_DISP64 {46;}' unless defined(&R_SPARC_DISP64);
    eval 'sub R_SPARC_PLT64 {47;}' unless defined(&R_SPARC_PLT64);
    eval 'sub R_SPARC_HIX22 {48;}' unless defined(&R_SPARC_HIX22);
    eval 'sub R_SPARC_LOX10 {49;}' unless defined(&R_SPARC_LOX10);
    eval 'sub R_SPARC_H44 {50;}' unless defined(&R_SPARC_H44);
    eval 'sub R_SPARC_M44 {51;}' unless defined(&R_SPARC_M44);
    eval 'sub R_SPARC_L44 {52;}' unless defined(&R_SPARC_L44);
    eval 'sub R_SPARC_REGISTER {53;}' unless defined(&R_SPARC_REGISTER);
    eval 'sub R_SPARC_UA64 {54;}' unless defined(&R_SPARC_UA64);
    eval 'sub R_SPARC_UA16 {55;}' unless defined(&R_SPARC_UA16);
    eval 'sub R_SPARC_TLS_GD_HI22 {56;}' unless defined(&R_SPARC_TLS_GD_HI22);
    eval 'sub R_SPARC_TLS_GD_LO10 {57;}' unless defined(&R_SPARC_TLS_GD_LO10);
    eval 'sub R_SPARC_TLS_GD_ADD {58;}' unless defined(&R_SPARC_TLS_GD_ADD);
    eval 'sub R_SPARC_TLS_GD_CALL {59;}' unless defined(&R_SPARC_TLS_GD_CALL);
    eval 'sub R_SPARC_TLS_LDM_HI22 {60;}' unless defined(&R_SPARC_TLS_LDM_HI22);
    eval 'sub R_SPARC_TLS_LDM_LO10 {61;}' unless defined(&R_SPARC_TLS_LDM_LO10);
    eval 'sub R_SPARC_TLS_LDM_ADD {62;}' unless defined(&R_SPARC_TLS_LDM_ADD);
    eval 'sub R_SPARC_TLS_LDM_CALL {63;}' unless defined(&R_SPARC_TLS_LDM_CALL);
    eval 'sub R_SPARC_TLS_LDO_HIX22 {64;}' unless defined(&R_SPARC_TLS_LDO_HIX22);
    eval 'sub R_SPARC_TLS_LDO_LOX10 {65;}' unless defined(&R_SPARC_TLS_LDO_LOX10);
    eval 'sub R_SPARC_TLS_LDO_ADD {66;}' unless defined(&R_SPARC_TLS_LDO_ADD);
    eval 'sub R_SPARC_TLS_IE_HI22 {67;}' unless defined(&R_SPARC_TLS_IE_HI22);
    eval 'sub R_SPARC_TLS_IE_LO10 {68;}' unless defined(&R_SPARC_TLS_IE_LO10);
    eval 'sub R_SPARC_TLS_IE_LD {69;}' unless defined(&R_SPARC_TLS_IE_LD);
    eval 'sub R_SPARC_TLS_IE_LDX {70;}' unless defined(&R_SPARC_TLS_IE_LDX);
    eval 'sub R_SPARC_TLS_IE_ADD {71;}' unless defined(&R_SPARC_TLS_IE_ADD);
    eval 'sub R_SPARC_TLS_LE_HIX22 {72;}' unless defined(&R_SPARC_TLS_LE_HIX22);
    eval 'sub R_SPARC_TLS_LE_LOX10 {73;}' unless defined(&R_SPARC_TLS_LE_LOX10);
    eval 'sub R_SPARC_TLS_DTPMOD32 {74;}' unless defined(&R_SPARC_TLS_DTPMOD32);
    eval 'sub R_SPARC_TLS_DTPMOD64 {75;}' unless defined(&R_SPARC_TLS_DTPMOD64);
    eval 'sub R_SPARC_TLS_DTPOFF32 {76;}' unless defined(&R_SPARC_TLS_DTPOFF32);
    eval 'sub R_SPARC_TLS_DTPOFF64 {77;}' unless defined(&R_SPARC_TLS_DTPOFF64);
    eval 'sub R_SPARC_TLS_TPOFF32 {78;}' unless defined(&R_SPARC_TLS_TPOFF32);
    eval 'sub R_SPARC_TLS_TPOFF64 {79;}' unless defined(&R_SPARC_TLS_TPOFF64);
    eval 'sub R_SPARC_NUM {80;}' unless defined(&R_SPARC_NUM);
    eval 'sub DT_SPARC_REGISTER {0x70000001;}' unless defined(&DT_SPARC_REGISTER);
    eval 'sub DT_SPARC_NUM {2;}' unless defined(&DT_SPARC_NUM);
    eval 'sub HWCAP_SPARC_FLUSH {1;}' unless defined(&HWCAP_SPARC_FLUSH);
    eval 'sub HWCAP_SPARC_STBAR {2;}' unless defined(&HWCAP_SPARC_STBAR);
    eval 'sub HWCAP_SPARC_SWAP {4;}' unless defined(&HWCAP_SPARC_SWAP);
    eval 'sub HWCAP_SPARC_MULDIV {8;}' unless defined(&HWCAP_SPARC_MULDIV);
    eval 'sub HWCAP_SPARC_V9 {16;}' unless defined(&HWCAP_SPARC_V9);
    eval 'sub HWCAP_SPARC_ULTRA3 {32;}' unless defined(&HWCAP_SPARC_ULTRA3);
    eval 'sub HWCAP_SPARC_BLKINIT {64;}' unless defined(&HWCAP_SPARC_BLKINIT);
    eval 'sub EF_MIPS_NOREORDER {1;}' unless defined(&EF_MIPS_NOREORDER);
    eval 'sub EF_MIPS_PIC {2;}' unless defined(&EF_MIPS_PIC);
    eval 'sub EF_MIPS_CPIC {4;}' unless defined(&EF_MIPS_CPIC);
    eval 'sub EF_MIPS_XGOT {8;}' unless defined(&EF_MIPS_XGOT);
    eval 'sub EF_MIPS_64BIT_WHIRL {16;}' unless defined(&EF_MIPS_64BIT_WHIRL);
    eval 'sub EF_MIPS_ABI2 {32;}' unless defined(&EF_MIPS_ABI2);
    eval 'sub EF_MIPS_ABI_ON32 {64;}' unless defined(&EF_MIPS_ABI_ON32);
    eval 'sub EF_MIPS_ARCH {0xf0000000;}' unless defined(&EF_MIPS_ARCH);
    eval 'sub EF_MIPS_ARCH_1 {0x;}' unless defined(&EF_MIPS_ARCH_1);
    eval 'sub EF_MIPS_ARCH_2 {0x10000000;}' unless defined(&EF_MIPS_ARCH_2);
    eval 'sub EF_MIPS_ARCH_3 {0x20000000;}' unless defined(&EF_MIPS_ARCH_3);
    eval 'sub EF_MIPS_ARCH_4 {0x30000000;}' unless defined(&EF_MIPS_ARCH_4);
    eval 'sub EF_MIPS_ARCH_5 {0x40000000;}' unless defined(&EF_MIPS_ARCH_5);
    eval 'sub EF_MIPS_ARCH_32 {0x60000000;}' unless defined(&EF_MIPS_ARCH_32);
    eval 'sub EF_MIPS_ARCH_64 {0x70000000;}' unless defined(&EF_MIPS_ARCH_64);
    eval 'sub E_MIPS_ARCH_1 {0x;}' unless defined(&E_MIPS_ARCH_1);
    eval 'sub E_MIPS_ARCH_2 {0x10000000;}' unless defined(&E_MIPS_ARCH_2);
    eval 'sub E_MIPS_ARCH_3 {0x20000000;}' unless defined(&E_MIPS_ARCH_3);
    eval 'sub E_MIPS_ARCH_4 {0x30000000;}' unless defined(&E_MIPS_ARCH_4);
    eval 'sub E_MIPS_ARCH_5 {0x40000000;}' unless defined(&E_MIPS_ARCH_5);
    eval 'sub E_MIPS_ARCH_32 {0x60000000;}' unless defined(&E_MIPS_ARCH_32);
    eval 'sub E_MIPS_ARCH_64 {0x70000000;}' unless defined(&E_MIPS_ARCH_64);
    eval 'sub SHN_MIPS_ACOMMON {0xff00;}' unless defined(&SHN_MIPS_ACOMMON);
    eval 'sub SHN_MIPS_TEXT {0xff01;}' unless defined(&SHN_MIPS_TEXT);
    eval 'sub SHN_MIPS_DATA {0xff02;}' unless defined(&SHN_MIPS_DATA);
    eval 'sub SHN_MIPS_SCOMMON {0xff03;}' unless defined(&SHN_MIPS_SCOMMON);
    eval 'sub SHN_MIPS_SUNDEFINED {0xff04;}' unless defined(&SHN_MIPS_SUNDEFINED);
    eval 'sub SHT_MIPS_LIBLIST {0x70000000;}' unless defined(&SHT_MIPS_LIBLIST);
    eval 'sub SHT_MIPS_MSYM {0x70000001;}' unless defined(&SHT_MIPS_MSYM);
    eval 'sub SHT_MIPS_CONFLICT {0x70000002;}' unless defined(&SHT_MIPS_CONFLICT);
    eval 'sub SHT_MIPS_GPTAB {0x70000003;}' unless defined(&SHT_MIPS_GPTAB);
    eval 'sub SHT_MIPS_UCODE {0x70000004;}' unless defined(&SHT_MIPS_UCODE);
    eval 'sub SHT_MIPS_DEBUG {0x70000005;}' unless defined(&SHT_MIPS_DEBUG);
    eval 'sub SHT_MIPS_REGINFO {0x70000006;}' unless defined(&SHT_MIPS_REGINFO);
    eval 'sub SHT_MIPS_PACKAGE {0x70000007;}' unless defined(&SHT_MIPS_PACKAGE);
    eval 'sub SHT_MIPS_PACKSYM {0x70000008;}' unless defined(&SHT_MIPS_PACKSYM);
    eval 'sub SHT_MIPS_RELD {0x70000009;}' unless defined(&SHT_MIPS_RELD);
    eval 'sub SHT_MIPS_IFACE {0x7000000b;}' unless defined(&SHT_MIPS_IFACE);
    eval 'sub SHT_MIPS_CONTENT {0x7000000c;}' unless defined(&SHT_MIPS_CONTENT);
    eval 'sub SHT_MIPS_OPTIONS {0x7000000d;}' unless defined(&SHT_MIPS_OPTIONS);
    eval 'sub SHT_MIPS_SHDR {0x70000010;}' unless defined(&SHT_MIPS_SHDR);
    eval 'sub SHT_MIPS_FDESC {0x70000011;}' unless defined(&SHT_MIPS_FDESC);
    eval 'sub SHT_MIPS_EXTSYM {0x70000012;}' unless defined(&SHT_MIPS_EXTSYM);
    eval 'sub SHT_MIPS_DENSE {0x70000013;}' unless defined(&SHT_MIPS_DENSE);
    eval 'sub SHT_MIPS_PDESC {0x70000014;}' unless defined(&SHT_MIPS_PDESC);
    eval 'sub SHT_MIPS_LOCSYM {0x70000015;}' unless defined(&SHT_MIPS_LOCSYM);
    eval 'sub SHT_MIPS_AUXSYM {0x70000016;}' unless defined(&SHT_MIPS_AUXSYM);
    eval 'sub SHT_MIPS_OPTSYM {0x70000017;}' unless defined(&SHT_MIPS_OPTSYM);
    eval 'sub SHT_MIPS_LOCSTR {0x70000018;}' unless defined(&SHT_MIPS_LOCSTR);
    eval 'sub SHT_MIPS_LINE {0x70000019;}' unless defined(&SHT_MIPS_LINE);
    eval 'sub SHT_MIPS_RFDESC {0x7000001a;}' unless defined(&SHT_MIPS_RFDESC);
    eval 'sub SHT_MIPS_DELTASYM {0x7000001b;}' unless defined(&SHT_MIPS_DELTASYM);
    eval 'sub SHT_MIPS_DELTAINST {0x7000001c;}' unless defined(&SHT_MIPS_DELTAINST);
    eval 'sub SHT_MIPS_DELTACLASS {0x7000001d;}' unless defined(&SHT_MIPS_DELTACLASS);
    eval 'sub SHT_MIPS_DWARF {0x7000001e;}' unless defined(&SHT_MIPS_DWARF);
    eval 'sub SHT_MIPS_DELTADECL {0x7000001f;}' unless defined(&SHT_MIPS_DELTADECL);
    eval 'sub SHT_MIPS_SYMBOL_LIB {0x70000020;}' unless defined(&SHT_MIPS_SYMBOL_LIB);
    eval 'sub SHT_MIPS_EVENTS {0x70000021;}' unless defined(&SHT_MIPS_EVENTS);
    eval 'sub SHT_MIPS_TRANSLATE {0x70000022;}' unless defined(&SHT_MIPS_TRANSLATE);
    eval 'sub SHT_MIPS_PIXIE {0x70000023;}' unless defined(&SHT_MIPS_PIXIE);
    eval 'sub SHT_MIPS_XLATE {0x70000024;}' unless defined(&SHT_MIPS_XLATE);
    eval 'sub SHT_MIPS_XLATE_DEBUG {0x70000025;}' unless defined(&SHT_MIPS_XLATE_DEBUG);
    eval 'sub SHT_MIPS_WHIRL {0x70000026;}' unless defined(&SHT_MIPS_WHIRL);
    eval 'sub SHT_MIPS_EH_REGION {0x70000027;}' unless defined(&SHT_MIPS_EH_REGION);
    eval 'sub SHT_MIPS_XLATE_OLD {0x70000028;}' unless defined(&SHT_MIPS_XLATE_OLD);
    eval 'sub SHT_MIPS_PDR_EXCEPTION {0x70000029;}' unless defined(&SHT_MIPS_PDR_EXCEPTION);
    eval 'sub SHF_MIPS_GPREL {0x10000000;}' unless defined(&SHF_MIPS_GPREL);
    eval 'sub SHF_MIPS_MERGE {0x20000000;}' unless defined(&SHF_MIPS_MERGE);
    eval 'sub SHF_MIPS_ADDR {0x40000000;}' unless defined(&SHF_MIPS_ADDR);
    eval 'sub SHF_MIPS_STRINGS {0x80000000;}' unless defined(&SHF_MIPS_STRINGS);
    eval 'sub SHF_MIPS_NOSTRIP {0x8000000;}' unless defined(&SHF_MIPS_NOSTRIP);
    eval 'sub SHF_MIPS_LOCAL {0x4000000;}' unless defined(&SHF_MIPS_LOCAL);
    eval 'sub SHF_MIPS_NAMES {0x2000000;}' unless defined(&SHF_MIPS_NAMES);
    eval 'sub SHF_MIPS_NODUPE {0x1000000;}' unless defined(&SHF_MIPS_NODUPE);
    eval 'sub STO_MIPS_DEFAULT {0x;}' unless defined(&STO_MIPS_DEFAULT);
    eval 'sub STO_MIPS_INTERNAL {0x1;}' unless defined(&STO_MIPS_INTERNAL);
    eval 'sub STO_MIPS_HIDDEN {0x2;}' unless defined(&STO_MIPS_HIDDEN);
    eval 'sub STO_MIPS_PROTECTED {0x3;}' unless defined(&STO_MIPS_PROTECTED);
    eval 'sub STO_MIPS_SC_ALIGN_UNUSED {0xff;}' unless defined(&STO_MIPS_SC_ALIGN_UNUSED);
    eval 'sub STB_MIPS_SPLIT_COMMON {13;}' unless defined(&STB_MIPS_SPLIT_COMMON);
    eval 'sub ODK_NULL {0;}' unless defined(&ODK_NULL);
    eval 'sub ODK_REGINFO {1;}' unless defined(&ODK_REGINFO);
    eval 'sub ODK_EXCEPTIONS {2;}' unless defined(&ODK_EXCEPTIONS);
    eval 'sub ODK_PAD {3;}' unless defined(&ODK_PAD);
    eval 'sub ODK_HWPATCH {4;}' unless defined(&ODK_HWPATCH);
    eval 'sub ODK_FILL {5;}' unless defined(&ODK_FILL);
    eval 'sub ODK_TAGS {6;}' unless defined(&ODK_TAGS);
    eval 'sub ODK_HWAND {7;}' unless defined(&ODK_HWAND);
    eval 'sub ODK_HWOR {8;}' unless defined(&ODK_HWOR);
    eval 'sub OEX_FPU_MIN {0x1f;}' unless defined(&OEX_FPU_MIN);
    eval 'sub OEX_FPU_MAX {0x1f00;}' unless defined(&OEX_FPU_MAX);
    eval 'sub OEX_PAGE0 {0x10000;}' unless defined(&OEX_PAGE0);
    eval 'sub OEX_SMM {0x20000;}' unless defined(&OEX_SMM);
    eval 'sub OEX_FPDBUG {0x40000;}' unless defined(&OEX_FPDBUG);
    eval 'sub OEX_PRECISEFP { &OEX_FPDBUG;}' unless defined(&OEX_PRECISEFP);
    eval 'sub OEX_DISMISS {0x80000;}' unless defined(&OEX_DISMISS);
    eval 'sub OEX_FPU_INVAL {0x10;}' unless defined(&OEX_FPU_INVAL);
    eval 'sub OEX_FPU_DIV0 {0x8;}' unless defined(&OEX_FPU_DIV0);
    eval 'sub OEX_FPU_OFLO {0x4;}' unless defined(&OEX_FPU_OFLO);
    eval 'sub OEX_FPU_UFLO {0x2;}' unless defined(&OEX_FPU_UFLO);
    eval 'sub OEX_FPU_INEX {0x1;}' unless defined(&OEX_FPU_INEX);
    eval 'sub OHW_R4KEOP {0x1;}' unless defined(&OHW_R4KEOP);
    eval 'sub OHW_R8KPFETCH {0x2;}' unless defined(&OHW_R8KPFETCH);
    eval 'sub OHW_R5KEOP {0x4;}' unless defined(&OHW_R5KEOP);
    eval 'sub OHW_R5KCVTL {0x8;}' unless defined(&OHW_R5KCVTL);
    eval 'sub OPAD_PREFIX {0x1;}' unless defined(&OPAD_PREFIX);
    eval 'sub OPAD_POSTFIX {0x2;}' unless defined(&OPAD_POSTFIX);
    eval 'sub OPAD_SYMBOL {0x4;}' unless defined(&OPAD_SYMBOL);
    eval 'sub OHWA0_R4KEOP_CHECKED {0x1;}' unless defined(&OHWA0_R4KEOP_CHECKED);
    eval 'sub OHWA1_R4KEOP_CLEAN {0x2;}' unless defined(&OHWA1_R4KEOP_CLEAN);
    eval 'sub R_MIPS_NONE {0;}' unless defined(&R_MIPS_NONE);
    eval 'sub R_MIPS_16 {1;}' unless defined(&R_MIPS_16);
    eval 'sub R_MIPS_32 {2;}' unless defined(&R_MIPS_32);
    eval 'sub R_MIPS_REL32 {3;}' unless defined(&R_MIPS_REL32);
    eval 'sub R_MIPS_26 {4;}' unless defined(&R_MIPS_26);
    eval 'sub R_MIPS_HI16 {5;}' unless defined(&R_MIPS_HI16);
    eval 'sub R_MIPS_LO16 {6;}' unless defined(&R_MIPS_LO16);
    eval 'sub R_MIPS_GPREL16 {7;}' unless defined(&R_MIPS_GPREL16);
    eval 'sub R_MIPS_LITERAL {8;}' unless defined(&R_MIPS_LITERAL);
    eval 'sub R_MIPS_GOT16 {9;}' unless defined(&R_MIPS_GOT16);
    eval 'sub R_MIPS_PC16 {10;}' unless defined(&R_MIPS_PC16);
    eval 'sub R_MIPS_CALL16 {11;}' unless defined(&R_MIPS_CALL16);
    eval 'sub R_MIPS_GPREL32 {12;}' unless defined(&R_MIPS_GPREL32);
    eval 'sub R_MIPS_SHIFT5 {16;}' unless defined(&R_MIPS_SHIFT5);
    eval 'sub R_MIPS_SHIFT6 {17;}' unless defined(&R_MIPS_SHIFT6);
    eval 'sub R_MIPS_64 {18;}' unless defined(&R_MIPS_64);
    eval 'sub R_MIPS_GOT_DISP {19;}' unless defined(&R_MIPS_GOT_DISP);
    eval 'sub R_MIPS_GOT_PAGE {20;}' unless defined(&R_MIPS_GOT_PAGE);
    eval 'sub R_MIPS_GOT_OFST {21;}' unless defined(&R_MIPS_GOT_OFST);
    eval 'sub R_MIPS_GOT_HI16 {22;}' unless defined(&R_MIPS_GOT_HI16);
    eval 'sub R_MIPS_GOT_LO16 {23;}' unless defined(&R_MIPS_GOT_LO16);
    eval 'sub R_MIPS_SUB {24;}' unless defined(&R_MIPS_SUB);
    eval 'sub R_MIPS_INSERT_A {25;}' unless defined(&R_MIPS_INSERT_A);
    eval 'sub R_MIPS_INSERT_B {26;}' unless defined(&R_MIPS_INSERT_B);
    eval 'sub R_MIPS_DELETE {27;}' unless defined(&R_MIPS_DELETE);
    eval 'sub R_MIPS_HIGHER {28;}' unless defined(&R_MIPS_HIGHER);
    eval 'sub R_MIPS_HIGHEST {29;}' unless defined(&R_MIPS_HIGHEST);
    eval 'sub R_MIPS_CALL_HI16 {30;}' unless defined(&R_MIPS_CALL_HI16);
    eval 'sub R_MIPS_CALL_LO16 {31;}' unless defined(&R_MIPS_CALL_LO16);
    eval 'sub R_MIPS_SCN_DISP {32;}' unless defined(&R_MIPS_SCN_DISP);
    eval 'sub R_MIPS_REL16 {33;}' unless defined(&R_MIPS_REL16);
    eval 'sub R_MIPS_ADD_IMMEDIATE {34;}' unless defined(&R_MIPS_ADD_IMMEDIATE);
    eval 'sub R_MIPS_PJUMP {35;}' unless defined(&R_MIPS_PJUMP);
    eval 'sub R_MIPS_RELGOT {36;}' unless defined(&R_MIPS_RELGOT);
    eval 'sub R_MIPS_JALR {37;}' unless defined(&R_MIPS_JALR);
    eval 'sub R_MIPS_TLS_DTPMOD32 {38;}' unless defined(&R_MIPS_TLS_DTPMOD32);
    eval 'sub R_MIPS_TLS_DTPREL32 {39;}' unless defined(&R_MIPS_TLS_DTPREL32);
    eval 'sub R_MIPS_TLS_DTPMOD64 {40;}' unless defined(&R_MIPS_TLS_DTPMOD64);
    eval 'sub R_MIPS_TLS_DTPREL64 {41;}' unless defined(&R_MIPS_TLS_DTPREL64);
    eval 'sub R_MIPS_TLS_GD {42;}' unless defined(&R_MIPS_TLS_GD);
    eval 'sub R_MIPS_TLS_LDM {43;}' unless defined(&R_MIPS_TLS_LDM);
    eval 'sub R_MIPS_TLS_DTPREL_HI16 {44;}' unless defined(&R_MIPS_TLS_DTPREL_HI16);
    eval 'sub R_MIPS_TLS_DTPREL_LO16 {45;}' unless defined(&R_MIPS_TLS_DTPREL_LO16);
    eval 'sub R_MIPS_TLS_GOTTPREL {46;}' unless defined(&R_MIPS_TLS_GOTTPREL);
    eval 'sub R_MIPS_TLS_TPREL32 {47;}' unless defined(&R_MIPS_TLS_TPREL32);
    eval 'sub R_MIPS_TLS_TPREL64 {48;}' unless defined(&R_MIPS_TLS_TPREL64);
    eval 'sub R_MIPS_TLS_TPREL_HI16 {49;}' unless defined(&R_MIPS_TLS_TPREL_HI16);
    eval 'sub R_MIPS_TLS_TPREL_LO16 {50;}' unless defined(&R_MIPS_TLS_TPREL_LO16);
    eval 'sub R_MIPS_NUM {51;}' unless defined(&R_MIPS_NUM);
    eval 'sub PT_MIPS_REGINFO {0x70000000;}' unless defined(&PT_MIPS_REGINFO);
    eval 'sub PT_MIPS_RTPROC {0x70000001;}' unless defined(&PT_MIPS_RTPROC);
    eval 'sub PT_MIPS_OPTIONS {0x70000002;}' unless defined(&PT_MIPS_OPTIONS);
    eval 'sub PF_MIPS_LOCAL {0x10000000;}' unless defined(&PF_MIPS_LOCAL);
    eval 'sub DT_MIPS_RLD_VERSION {0x70000001;}' unless defined(&DT_MIPS_RLD_VERSION);
    eval 'sub DT_MIPS_TIME_STAMP {0x70000002;}' unless defined(&DT_MIPS_TIME_STAMP);
    eval 'sub DT_MIPS_ICHECKSUM {0x70000003;}' unless defined(&DT_MIPS_ICHECKSUM);
    eval 'sub DT_MIPS_IVERSION {0x70000004;}' unless defined(&DT_MIPS_IVERSION);
    eval 'sub DT_MIPS_FLAGS {0x70000005;}' unless defined(&DT_MIPS_FLAGS);
    eval 'sub DT_MIPS_BASE_ADDRESS {0x70000006;}' unless defined(&DT_MIPS_BASE_ADDRESS);
    eval 'sub DT_MIPS_MSYM {0x70000007;}' unless defined(&DT_MIPS_MSYM);
    eval 'sub DT_MIPS_CONFLICT {0x70000008;}' unless defined(&DT_MIPS_CONFLICT);
    eval 'sub DT_MIPS_LIBLIST {0x70000009;}' unless defined(&DT_MIPS_LIBLIST);
    eval 'sub DT_MIPS_LOCAL_GOTNO {0x7000000a;}' unless defined(&DT_MIPS_LOCAL_GOTNO);
    eval 'sub DT_MIPS_CONFLICTNO {0x7000000b;}' unless defined(&DT_MIPS_CONFLICTNO);
    eval 'sub DT_MIPS_LIBLISTNO {0x70000010;}' unless defined(&DT_MIPS_LIBLISTNO);
    eval 'sub DT_MIPS_SYMTABNO {0x70000011;}' unless defined(&DT_MIPS_SYMTABNO);
    eval 'sub DT_MIPS_UNREFEXTNO {0x70000012;}' unless defined(&DT_MIPS_UNREFEXTNO);
    eval 'sub DT_MIPS_GOTSYM {0x70000013;}' unless defined(&DT_MIPS_GOTSYM);
    eval 'sub DT_MIPS_HIPAGENO {0x70000014;}' unless defined(&DT_MIPS_HIPAGENO);
    eval 'sub DT_MIPS_RLD_MAP {0x70000016;}' unless defined(&DT_MIPS_RLD_MAP);
    eval 'sub DT_MIPS_DELTA_CLASS {0x70000017;}' unless defined(&DT_MIPS_DELTA_CLASS);
    eval 'sub DT_MIPS_DELTA_CLASS_NO {0x70000018;}' unless defined(&DT_MIPS_DELTA_CLASS_NO);
    eval 'sub DT_MIPS_DELTA_INSTANCE {0x70000019;}' unless defined(&DT_MIPS_DELTA_INSTANCE);
    eval 'sub DT_MIPS_DELTA_INSTANCE_NO {0x7000001a;}' unless defined(&DT_MIPS_DELTA_INSTANCE_NO);
    eval 'sub DT_MIPS_DELTA_RELOC {0x7000001b;}' unless defined(&DT_MIPS_DELTA_RELOC);
    eval 'sub DT_MIPS_DELTA_RELOC_NO {0x7000001c;}' unless defined(&DT_MIPS_DELTA_RELOC_NO);
    eval 'sub DT_MIPS_DELTA_SYM {0x7000001d;}' unless defined(&DT_MIPS_DELTA_SYM);
    eval 'sub DT_MIPS_DELTA_SYM_NO {0x7000001e;}' unless defined(&DT_MIPS_DELTA_SYM_NO);
    eval 'sub DT_MIPS_DELTA_CLASSSYM {0x70000020;}' unless defined(&DT_MIPS_DELTA_CLASSSYM);
    eval 'sub DT_MIPS_DELTA_CLASSSYM_NO {0x70000021;}' unless defined(&DT_MIPS_DELTA_CLASSSYM_NO);
    eval 'sub DT_MIPS_CXX_FLAGS {0x70000022;}' unless defined(&DT_MIPS_CXX_FLAGS);
    eval 'sub DT_MIPS_PIXIE_INIT {0x70000023;}' unless defined(&DT_MIPS_PIXIE_INIT);
    eval 'sub DT_MIPS_SYMBOL_LIB {0x70000024;}' unless defined(&DT_MIPS_SYMBOL_LIB);
    eval 'sub DT_MIPS_LOCALPAGE_GOTIDX {0x70000025;}' unless defined(&DT_MIPS_LOCALPAGE_GOTIDX);
    eval 'sub DT_MIPS_LOCAL_GOTIDX {0x70000026;}' unless defined(&DT_MIPS_LOCAL_GOTIDX);
    eval 'sub DT_MIPS_HIDDEN_GOTIDX {0x70000027;}' unless defined(&DT_MIPS_HIDDEN_GOTIDX);
    eval 'sub DT_MIPS_PROTECTED_GOTIDX {0x70000028;}' unless defined(&DT_MIPS_PROTECTED_GOTIDX);
    eval 'sub DT_MIPS_OPTIONS {0x70000029;}' unless defined(&DT_MIPS_OPTIONS);
    eval 'sub DT_MIPS_INTERFACE {0x7000002a;}' unless defined(&DT_MIPS_INTERFACE);
    eval 'sub DT_MIPS_DYNSTR_ALIGN {0x7000002b;}' unless defined(&DT_MIPS_DYNSTR_ALIGN);
    eval 'sub DT_MIPS_INTERFACE_SIZE {0x7000002c;}' unless defined(&DT_MIPS_INTERFACE_SIZE);
    eval 'sub DT_MIPS_RLD_TEXT_RESOLVE_ADDR {0x7000002d;}' unless defined(&DT_MIPS_RLD_TEXT_RESOLVE_ADDR);
    eval 'sub DT_MIPS_PERF_SUFFIX {0x7000002e;}' unless defined(&DT_MIPS_PERF_SUFFIX);
    eval 'sub DT_MIPS_COMPACT_SIZE {0x7000002f;}' unless defined(&DT_MIPS_COMPACT_SIZE);
    eval 'sub DT_MIPS_GP_VALUE {0x70000030;}' unless defined(&DT_MIPS_GP_VALUE);
    eval 'sub DT_MIPS_AUX_DYNAMIC {0x70000031;}' unless defined(&DT_MIPS_AUX_DYNAMIC);
    eval 'sub DT_MIPS_NUM {0x32;}' unless defined(&DT_MIPS_NUM);
    eval 'sub RHF_NONE {0;}' unless defined(&RHF_NONE);
    eval 'sub RHF_QUICKSTART {(1<< 0);}' unless defined(&RHF_QUICKSTART);
    eval 'sub RHF_NOTPOT {(1<< 1);}' unless defined(&RHF_NOTPOT);
    eval 'sub RHF_NO_LIBRARY_REPLACEMENT {(1<< 2);}' unless defined(&RHF_NO_LIBRARY_REPLACEMENT);
    eval 'sub RHF_NO_MOVE {(1<< 3);}' unless defined(&RHF_NO_MOVE);
    eval 'sub RHF_SGI_ONLY {(1<< 4);}' unless defined(&RHF_SGI_ONLY);
    eval 'sub RHF_GUARANTEE_INIT {(1<< 5);}' unless defined(&RHF_GUARANTEE_INIT);
    eval 'sub RHF_DELTA_C_PLUS_PLUS {(1<< 6);}' unless defined(&RHF_DELTA_C_PLUS_PLUS);
    eval 'sub RHF_GUARANTEE_START_INIT {(1<< 7);}' unless defined(&RHF_GUARANTEE_START_INIT);
    eval 'sub RHF_PIXIE {(1<< 8);}' unless defined(&RHF_PIXIE);
    eval 'sub RHF_DEFAULT_DELAY_LOAD {(1<< 9);}' unless defined(&RHF_DEFAULT_DELAY_LOAD);
    eval 'sub RHF_REQUICKSTART {(1<< 10);}' unless defined(&RHF_REQUICKSTART);
    eval 'sub RHF_REQUICKSTARTED {(1<< 11);}' unless defined(&RHF_REQUICKSTARTED);
    eval 'sub RHF_CORD {(1<< 12);}' unless defined(&RHF_CORD);
    eval 'sub RHF_NO_UNRES_UNDEF {(1<< 13);}' unless defined(&RHF_NO_UNRES_UNDEF);
    eval 'sub RHF_RLD_ORDER_SAFE {(1<< 14);}' unless defined(&RHF_RLD_ORDER_SAFE);
    eval 'sub LL_NONE {0;}' unless defined(&LL_NONE);
    eval 'sub LL_EXACT_MATCH {(1<< 0);}' unless defined(&LL_EXACT_MATCH);
    eval 'sub LL_IGNORE_INT_VER {(1<< 1);}' unless defined(&LL_IGNORE_INT_VER);
    eval 'sub LL_REQUIRE_MINOR {(1<< 2);}' unless defined(&LL_REQUIRE_MINOR);
    eval 'sub LL_EXPORTS {(1<< 3);}' unless defined(&LL_EXPORTS);
    eval 'sub LL_DELAY_LOAD {(1<< 4);}' unless defined(&LL_DELAY_LOAD);
    eval 'sub LL_DELTA {(1<< 5);}' unless defined(&LL_DELTA);
    eval 'sub EF_PARISC_TRAPNIL {0x10000;}' unless defined(&EF_PARISC_TRAPNIL);
    eval 'sub EF_PARISC_EXT {0x20000;}' unless defined(&EF_PARISC_EXT);
    eval 'sub EF_PARISC_LSB {0x40000;}' unless defined(&EF_PARISC_LSB);
    eval 'sub EF_PARISC_WIDE {0x80000;}' unless defined(&EF_PARISC_WIDE);
    eval 'sub EF_PARISC_NO_KABP {0x100000;}' unless defined(&EF_PARISC_NO_KABP);
    eval 'sub EF_PARISC_LAZYSWAP {0x400000;}' unless defined(&EF_PARISC_LAZYSWAP);
    eval 'sub EF_PARISC_ARCH {0xffff;}' unless defined(&EF_PARISC_ARCH);
    eval 'sub EFA_PARISC_1_0 {0x20b;}' unless defined(&EFA_PARISC_1_0);
    eval 'sub EFA_PARISC_1_1 {0x210;}' unless defined(&EFA_PARISC_1_1);
    eval 'sub EFA_PARISC_2_0 {0x214;}' unless defined(&EFA_PARISC_2_0);
    eval 'sub SHN_PARISC_ANSI_COMMON {0xff00;}' unless defined(&SHN_PARISC_ANSI_COMMON);
    eval 'sub SHN_PARISC_HUGE_COMMON {0xff01;}' unless defined(&SHN_PARISC_HUGE_COMMON);
    eval 'sub SHT_PARISC_EXT {0x70000000;}' unless defined(&SHT_PARISC_EXT);
    eval 'sub SHT_PARISC_UNWIND {0x70000001;}' unless defined(&SHT_PARISC_UNWIND);
    eval 'sub SHT_PARISC_DOC {0x70000002;}' unless defined(&SHT_PARISC_DOC);
    eval 'sub SHF_PARISC_SHORT {0x20000000;}' unless defined(&SHF_PARISC_SHORT);
    eval 'sub SHF_PARISC_HUGE {0x40000000;}' unless defined(&SHF_PARISC_HUGE);
    eval 'sub SHF_PARISC_SBP {0x80000000;}' unless defined(&SHF_PARISC_SBP);
    eval 'sub STT_PARISC_MILLICODE {13;}' unless defined(&STT_PARISC_MILLICODE);
    eval 'sub STT_HP_OPAQUE {( &STT_LOOS + 0x1);}' unless defined(&STT_HP_OPAQUE);
    eval 'sub STT_HP_STUB {( &STT_LOOS + 0x2);}' unless defined(&STT_HP_STUB);
    eval 'sub R_PARISC_NONE {0;}' unless defined(&R_PARISC_NONE);
    eval 'sub R_PARISC_DIR32 {1;}' unless defined(&R_PARISC_DIR32);
    eval 'sub R_PARISC_DIR21L {2;}' unless defined(&R_PARISC_DIR21L);
    eval 'sub R_PARISC_DIR17R {3;}' unless defined(&R_PARISC_DIR17R);
    eval 'sub R_PARISC_DIR17F {4;}' unless defined(&R_PARISC_DIR17F);
    eval 'sub R_PARISC_DIR14R {6;}' unless defined(&R_PARISC_DIR14R);
    eval 'sub R_PARISC_PCREL32 {9;}' unless defined(&R_PARISC_PCREL32);
    eval 'sub R_PARISC_PCREL21L {10;}' unless defined(&R_PARISC_PCREL21L);
    eval 'sub R_PARISC_PCREL17R {11;}' unless defined(&R_PARISC_PCREL17R);
    eval 'sub R_PARISC_PCREL17F {12;}' unless defined(&R_PARISC_PCREL17F);
    eval 'sub R_PARISC_PCREL14R {14;}' unless defined(&R_PARISC_PCREL14R);
    eval 'sub R_PARISC_DPREL21L {18;}' unless defined(&R_PARISC_DPREL21L);
    eval 'sub R_PARISC_DPREL14R {22;}' unless defined(&R_PARISC_DPREL14R);
    eval 'sub R_PARISC_GPREL21L {26;}' unless defined(&R_PARISC_GPREL21L);
    eval 'sub R_PARISC_GPREL14R {30;}' unless defined(&R_PARISC_GPREL14R);
    eval 'sub R_PARISC_LTOFF21L {34;}' unless defined(&R_PARISC_LTOFF21L);
    eval 'sub R_PARISC_LTOFF14R {38;}' unless defined(&R_PARISC_LTOFF14R);
    eval 'sub R_PARISC_SECREL32 {41;}' unless defined(&R_PARISC_SECREL32);
    eval 'sub R_PARISC_SEGBASE {48;}' unless defined(&R_PARISC_SEGBASE);
    eval 'sub R_PARISC_SEGREL32 {49;}' unless defined(&R_PARISC_SEGREL32);
    eval 'sub R_PARISC_PLTOFF21L {50;}' unless defined(&R_PARISC_PLTOFF21L);
    eval 'sub R_PARISC_PLTOFF14R {54;}' unless defined(&R_PARISC_PLTOFF14R);
    eval 'sub R_PARISC_LTOFF_FPTR32 {57;}' unless defined(&R_PARISC_LTOFF_FPTR32);
    eval 'sub R_PARISC_LTOFF_FPTR21L {58;}' unless defined(&R_PARISC_LTOFF_FPTR21L);
    eval 'sub R_PARISC_LTOFF_FPTR14R {62;}' unless defined(&R_PARISC_LTOFF_FPTR14R);
    eval 'sub R_PARISC_FPTR64 {64;}' unless defined(&R_PARISC_FPTR64);
    eval 'sub R_PARISC_PLABEL32 {65;}' unless defined(&R_PARISC_PLABEL32);
    eval 'sub R_PARISC_PCREL64 {72;}' unless defined(&R_PARISC_PCREL64);
    eval 'sub R_PARISC_PCREL22F {74;}' unless defined(&R_PARISC_PCREL22F);
    eval 'sub R_PARISC_PCREL14WR {75;}' unless defined(&R_PARISC_PCREL14WR);
    eval 'sub R_PARISC_PCREL14DR {76;}' unless defined(&R_PARISC_PCREL14DR);
    eval 'sub R_PARISC_PCREL16F {77;}' unless defined(&R_PARISC_PCREL16F);
    eval 'sub R_PARISC_PCREL16WF {78;}' unless defined(&R_PARISC_PCREL16WF);
    eval 'sub R_PARISC_PCREL16DF {79;}' unless defined(&R_PARISC_PCREL16DF);
    eval 'sub R_PARISC_DIR64 {80;}' unless defined(&R_PARISC_DIR64);
    eval 'sub R_PARISC_DIR14WR {83;}' unless defined(&R_PARISC_DIR14WR);
    eval 'sub R_PARISC_DIR14DR {84;}' unless defined(&R_PARISC_DIR14DR);
    eval 'sub R_PARISC_DIR16F {85;}' unless defined(&R_PARISC_DIR16F);
    eval 'sub R_PARISC_DIR16WF {86;}' unless defined(&R_PARISC_DIR16WF);
    eval 'sub R_PARISC_DIR16DF {87;}' unless defined(&R_PARISC_DIR16DF);
    eval 'sub R_PARISC_GPREL64 {88;}' unless defined(&R_PARISC_GPREL64);
    eval 'sub R_PARISC_GPREL14WR {91;}' unless defined(&R_PARISC_GPREL14WR);
    eval 'sub R_PARISC_GPREL14DR {92;}' unless defined(&R_PARISC_GPREL14DR);
    eval 'sub R_PARISC_GPREL16F {93;}' unless defined(&R_PARISC_GPREL16F);
    eval 'sub R_PARISC_GPREL16WF {94;}' unless defined(&R_PARISC_GPREL16WF);
    eval 'sub R_PARISC_GPREL16DF {95;}' unless defined(&R_PARISC_GPREL16DF);
    eval 'sub R_PARISC_LTOFF64 {96;}' unless defined(&R_PARISC_LTOFF64);
    eval 'sub R_PARISC_LTOFF14WR {99;}' unless defined(&R_PARISC_LTOFF14WR);
    eval 'sub R_PARISC_LTOFF14DR {100;}' unless defined(&R_PARISC_LTOFF14DR);
    eval 'sub R_PARISC_LTOFF16F {101;}' unless defined(&R_PARISC_LTOFF16F);
    eval 'sub R_PARISC_LTOFF16WF {102;}' unless defined(&R_PARISC_LTOFF16WF);
    eval 'sub R_PARISC_LTOFF16DF {103;}' unless defined(&R_PARISC_LTOFF16DF);
    eval 'sub R_PARISC_SECREL64 {104;}' unless defined(&R_PARISC_SECREL64);
    eval 'sub R_PARISC_SEGREL64 {112;}' unless defined(&R_PARISC_SEGREL64);
    eval 'sub R_PARISC_PLTOFF14WR {115;}' unless defined(&R_PARISC_PLTOFF14WR);
    eval 'sub R_PARISC_PLTOFF14DR {116;}' unless defined(&R_PARISC_PLTOFF14DR);
    eval 'sub R_PARISC_PLTOFF16F {117;}' unless defined(&R_PARISC_PLTOFF16F);
    eval 'sub R_PARISC_PLTOFF16WF {118;}' unless defined(&R_PARISC_PLTOFF16WF);
    eval 'sub R_PARISC_PLTOFF16DF {119;}' unless defined(&R_PARISC_PLTOFF16DF);
    eval 'sub R_PARISC_LTOFF_FPTR64 {120;}' unless defined(&R_PARISC_LTOFF_FPTR64);
    eval 'sub R_PARISC_LTOFF_FPTR14WR {123;}' unless defined(&R_PARISC_LTOFF_FPTR14WR);
    eval 'sub R_PARISC_LTOFF_FPTR14DR {124;}' unless defined(&R_PARISC_LTOFF_FPTR14DR);
    eval 'sub R_PARISC_LTOFF_FPTR16F {125;}' unless defined(&R_PARISC_LTOFF_FPTR16F);
    eval 'sub R_PARISC_LTOFF_FPTR16WF {126;}' unless defined(&R_PARISC_LTOFF_FPTR16WF);
    eval 'sub R_PARISC_LTOFF_FPTR16DF {127;}' unless defined(&R_PARISC_LTOFF_FPTR16DF);
    eval 'sub R_PARISC_LORESERVE {128;}' unless defined(&R_PARISC_LORESERVE);
    eval 'sub R_PARISC_COPY {128;}' unless defined(&R_PARISC_COPY);
    eval 'sub R_PARISC_IPLT {129;}' unless defined(&R_PARISC_IPLT);
    eval 'sub R_PARISC_EPLT {130;}' unless defined(&R_PARISC_EPLT);
    eval 'sub R_PARISC_TPREL32 {153;}' unless defined(&R_PARISC_TPREL32);
    eval 'sub R_PARISC_TPREL21L {154;}' unless defined(&R_PARISC_TPREL21L);
    eval 'sub R_PARISC_TPREL14R {158;}' unless defined(&R_PARISC_TPREL14R);
    eval 'sub R_PARISC_LTOFF_TP21L {162;}' unless defined(&R_PARISC_LTOFF_TP21L);
    eval 'sub R_PARISC_LTOFF_TP14R {166;}' unless defined(&R_PARISC_LTOFF_TP14R);
    eval 'sub R_PARISC_LTOFF_TP14F {167;}' unless defined(&R_PARISC_LTOFF_TP14F);
    eval 'sub R_PARISC_TPREL64 {216;}' unless defined(&R_PARISC_TPREL64);
    eval 'sub R_PARISC_TPREL14WR {219;}' unless defined(&R_PARISC_TPREL14WR);
    eval 'sub R_PARISC_TPREL14DR {220;}' unless defined(&R_PARISC_TPREL14DR);
    eval 'sub R_PARISC_TPREL16F {221;}' unless defined(&R_PARISC_TPREL16F);
    eval 'sub R_PARISC_TPREL16WF {222;}' unless defined(&R_PARISC_TPREL16WF);
    eval 'sub R_PARISC_TPREL16DF {223;}' unless defined(&R_PARISC_TPREL16DF);
    eval 'sub R_PARISC_LTOFF_TP64 {224;}' unless defined(&R_PARISC_LTOFF_TP64);
    eval 'sub R_PARISC_LTOFF_TP14WR {227;}' unless defined(&R_PARISC_LTOFF_TP14WR);
    eval 'sub R_PARISC_LTOFF_TP14DR {228;}' unless defined(&R_PARISC_LTOFF_TP14DR);
    eval 'sub R_PARISC_LTOFF_TP16F {229;}' unless defined(&R_PARISC_LTOFF_TP16F);
    eval 'sub R_PARISC_LTOFF_TP16WF {230;}' unless defined(&R_PARISC_LTOFF_TP16WF);
    eval 'sub R_PARISC_LTOFF_TP16DF {231;}' unless defined(&R_PARISC_LTOFF_TP16DF);
    eval 'sub R_PARISC_HIRESERVE {255;}' unless defined(&R_PARISC_HIRESERVE);
    eval 'sub PT_HP_TLS {( &PT_LOOS + 0x);}' unless defined(&PT_HP_TLS);
    eval 'sub PT_HP_CORE_NONE {( &PT_LOOS + 0x1);}' unless defined(&PT_HP_CORE_NONE);
    eval 'sub PT_HP_CORE_VERSION {( &PT_LOOS + 0x2);}' unless defined(&PT_HP_CORE_VERSION);
    eval 'sub PT_HP_CORE_KERNEL {( &PT_LOOS + 0x3);}' unless defined(&PT_HP_CORE_KERNEL);
    eval 'sub PT_HP_CORE_COMM {( &PT_LOOS + 0x4);}' unless defined(&PT_HP_CORE_COMM);
    eval 'sub PT_HP_CORE_PROC {( &PT_LOOS + 0x5);}' unless defined(&PT_HP_CORE_PROC);
    eval 'sub PT_HP_CORE_LOADABLE {( &PT_LOOS + 0x6);}' unless defined(&PT_HP_CORE_LOADABLE);
    eval 'sub PT_HP_CORE_STACK {( &PT_LOOS + 0x7);}' unless defined(&PT_HP_CORE_STACK);
    eval 'sub PT_HP_CORE_SHM {( &PT_LOOS + 0x8);}' unless defined(&PT_HP_CORE_SHM);
    eval 'sub PT_HP_CORE_MMF {( &PT_LOOS + 0x9);}' unless defined(&PT_HP_CORE_MMF);
    eval 'sub PT_HP_PARALLEL {( &PT_LOOS + 0x10);}' unless defined(&PT_HP_PARALLEL);
    eval 'sub PT_HP_FASTBIND {( &PT_LOOS + 0x11);}' unless defined(&PT_HP_FASTBIND);
    eval 'sub PT_HP_OPT_ANNOT {( &PT_LOOS + 0x12);}' unless defined(&PT_HP_OPT_ANNOT);
    eval 'sub PT_HP_HSL_ANNOT {( &PT_LOOS + 0x13);}' unless defined(&PT_HP_HSL_ANNOT);
    eval 'sub PT_HP_STACK {( &PT_LOOS + 0x14);}' unless defined(&PT_HP_STACK);
    eval 'sub PT_PARISC_ARCHEXT {0x70000000;}' unless defined(&PT_PARISC_ARCHEXT);
    eval 'sub PT_PARISC_UNWIND {0x70000001;}' unless defined(&PT_PARISC_UNWIND);
    eval 'sub PF_PARISC_SBP {0x8000000;}' unless defined(&PF_PARISC_SBP);
    eval 'sub PF_HP_PAGE_SIZE {0x100000;}' unless defined(&PF_HP_PAGE_SIZE);
    eval 'sub PF_HP_FAR_SHARED {0x200000;}' unless defined(&PF_HP_FAR_SHARED);
    eval 'sub PF_HP_NEAR_SHARED {0x400000;}' unless defined(&PF_HP_NEAR_SHARED);
    eval 'sub PF_HP_CODE {0x1000000;}' unless defined(&PF_HP_CODE);
    eval 'sub PF_HP_MODIFY {0x2000000;}' unless defined(&PF_HP_MODIFY);
    eval 'sub PF_HP_LAZYSWAP {0x4000000;}' unless defined(&PF_HP_LAZYSWAP);
    eval 'sub PF_HP_SBP {0x8000000;}' unless defined(&PF_HP_SBP);
    eval 'sub EF_ALPHA_32BIT {1;}' unless defined(&EF_ALPHA_32BIT);
    eval 'sub EF_ALPHA_CANRELAX {2;}' unless defined(&EF_ALPHA_CANRELAX);
    eval 'sub SHT_ALPHA_DEBUG {0x70000001;}' unless defined(&SHT_ALPHA_DEBUG);
    eval 'sub SHT_ALPHA_REGINFO {0x70000002;}' unless defined(&SHT_ALPHA_REGINFO);
    eval 'sub SHF_ALPHA_GPREL {0x10000000;}' unless defined(&SHF_ALPHA_GPREL);
    eval 'sub STO_ALPHA_NOPV {0x80;}' unless defined(&STO_ALPHA_NOPV);
    eval 'sub STO_ALPHA_STD_GPLOAD {0x88;}' unless defined(&STO_ALPHA_STD_GPLOAD);
    eval 'sub R_ALPHA_NONE {0;}' unless defined(&R_ALPHA_NONE);
    eval 'sub R_ALPHA_REFLONG {1;}' unless defined(&R_ALPHA_REFLONG);
    eval 'sub R_ALPHA_REFQUAD {2;}' unless defined(&R_ALPHA_REFQUAD);
    eval 'sub R_ALPHA_GPREL32 {3;}' unless defined(&R_ALPHA_GPREL32);
    eval 'sub R_ALPHA_LITERAL {4;}' unless defined(&R_ALPHA_LITERAL);
    eval 'sub R_ALPHA_LITUSE {5;}' unless defined(&R_ALPHA_LITUSE);
    eval 'sub R_ALPHA_GPDISP {6;}' unless defined(&R_ALPHA_GPDISP);
    eval 'sub R_ALPHA_BRADDR {7;}' unless defined(&R_ALPHA_BRADDR);
    eval 'sub R_ALPHA_HINT {8;}' unless defined(&R_ALPHA_HINT);
    eval 'sub R_ALPHA_SREL16 {9;}' unless defined(&R_ALPHA_SREL16);
    eval 'sub R_ALPHA_SREL32 {10;}' unless defined(&R_ALPHA_SREL32);
    eval 'sub R_ALPHA_SREL64 {11;}' unless defined(&R_ALPHA_SREL64);
    eval 'sub R_ALPHA_GPRELHIGH {17;}' unless defined(&R_ALPHA_GPRELHIGH);
    eval 'sub R_ALPHA_GPRELLOW {18;}' unless defined(&R_ALPHA_GPRELLOW);
    eval 'sub R_ALPHA_GPREL16 {19;}' unless defined(&R_ALPHA_GPREL16);
    eval 'sub R_ALPHA_COPY {24;}' unless defined(&R_ALPHA_COPY);
    eval 'sub R_ALPHA_GLOB_DAT {25;}' unless defined(&R_ALPHA_GLOB_DAT);
    eval 'sub R_ALPHA_JMP_SLOT {26;}' unless defined(&R_ALPHA_JMP_SLOT);
    eval 'sub R_ALPHA_RELATIVE {27;}' unless defined(&R_ALPHA_RELATIVE);
    eval 'sub R_ALPHA_TLS_GD_HI {28;}' unless defined(&R_ALPHA_TLS_GD_HI);
    eval 'sub R_ALPHA_TLSGD {29;}' unless defined(&R_ALPHA_TLSGD);
    eval 'sub R_ALPHA_TLS_LDM {30;}' unless defined(&R_ALPHA_TLS_LDM);
    eval 'sub R_ALPHA_DTPMOD64 {31;}' unless defined(&R_ALPHA_DTPMOD64);
    eval 'sub R_ALPHA_GOTDTPREL {32;}' unless defined(&R_ALPHA_GOTDTPREL);
    eval 'sub R_ALPHA_DTPREL64 {33;}' unless defined(&R_ALPHA_DTPREL64);
    eval 'sub R_ALPHA_DTPRELHI {34;}' unless defined(&R_ALPHA_DTPRELHI);
    eval 'sub R_ALPHA_DTPRELLO {35;}' unless defined(&R_ALPHA_DTPRELLO);
    eval 'sub R_ALPHA_DTPREL16 {36;}' unless defined(&R_ALPHA_DTPREL16);
    eval 'sub R_ALPHA_GOTTPREL {37;}' unless defined(&R_ALPHA_GOTTPREL);
    eval 'sub R_ALPHA_TPREL64 {38;}' unless defined(&R_ALPHA_TPREL64);
    eval 'sub R_ALPHA_TPRELHI {39;}' unless defined(&R_ALPHA_TPRELHI);
    eval 'sub R_ALPHA_TPRELLO {40;}' unless defined(&R_ALPHA_TPRELLO);
    eval 'sub R_ALPHA_TPREL16 {41;}' unless defined(&R_ALPHA_TPREL16);
    eval 'sub R_ALPHA_NUM {46;}' unless defined(&R_ALPHA_NUM);
    eval 'sub LITUSE_ALPHA_ADDR {0;}' unless defined(&LITUSE_ALPHA_ADDR);
    eval 'sub LITUSE_ALPHA_BASE {1;}' unless defined(&LITUSE_ALPHA_BASE);
    eval 'sub LITUSE_ALPHA_BYTOFF {2;}' unless defined(&LITUSE_ALPHA_BYTOFF);
    eval 'sub LITUSE_ALPHA_JSR {3;}' unless defined(&LITUSE_ALPHA_JSR);
    eval 'sub LITUSE_ALPHA_TLS_GD {4;}' unless defined(&LITUSE_ALPHA_TLS_GD);
    eval 'sub LITUSE_ALPHA_TLS_LDM {5;}' unless defined(&LITUSE_ALPHA_TLS_LDM);
    eval 'sub DT_ALPHA_PLTRO {( &DT_LOPROC + 0);}' unless defined(&DT_ALPHA_PLTRO);
    eval 'sub DT_ALPHA_NUM {1;}' unless defined(&DT_ALPHA_NUM);
    eval 'sub EF_PPC_EMB {0x80000000;}' unless defined(&EF_PPC_EMB);
    eval 'sub EF_PPC_RELOCATABLE {0x10000;}' unless defined(&EF_PPC_RELOCATABLE);
    eval 'sub EF_PPC_RELOCATABLE_LIB {0x8000;}' unless defined(&EF_PPC_RELOCATABLE_LIB);
    eval 'sub R_PPC_NONE {0;}' unless defined(&R_PPC_NONE);
    eval 'sub R_PPC_ADDR32 {1;}' unless defined(&R_PPC_ADDR32);
    eval 'sub R_PPC_ADDR24 {2;}' unless defined(&R_PPC_ADDR24);
    eval 'sub R_PPC_ADDR16 {3;}' unless defined(&R_PPC_ADDR16);
    eval 'sub R_PPC_ADDR16_LO {4;}' unless defined(&R_PPC_ADDR16_LO);
    eval 'sub R_PPC_ADDR16_HI {5;}' unless defined(&R_PPC_ADDR16_HI);
    eval 'sub R_PPC_ADDR16_HA {6;}' unless defined(&R_PPC_ADDR16_HA);
    eval 'sub R_PPC_ADDR14 {7;}' unless defined(&R_PPC_ADDR14);
    eval 'sub R_PPC_ADDR14_BRTAKEN {8;}' unless defined(&R_PPC_ADDR14_BRTAKEN);
    eval 'sub R_PPC_ADDR14_BRNTAKEN {9;}' unless defined(&R_PPC_ADDR14_BRNTAKEN);
    eval 'sub R_PPC_REL24 {10;}' unless defined(&R_PPC_REL24);
    eval 'sub R_PPC_REL14 {11;}' unless defined(&R_PPC_REL14);
    eval 'sub R_PPC_REL14_BRTAKEN {12;}' unless defined(&R_PPC_REL14_BRTAKEN);
    eval 'sub R_PPC_REL14_BRNTAKEN {13;}' unless defined(&R_PPC_REL14_BRNTAKEN);
    eval 'sub R_PPC_GOT16 {14;}' unless defined(&R_PPC_GOT16);
    eval 'sub R_PPC_GOT16_LO {15;}' unless defined(&R_PPC_GOT16_LO);
    eval 'sub R_PPC_GOT16_HI {16;}' unless defined(&R_PPC_GOT16_HI);
    eval 'sub R_PPC_GOT16_HA {17;}' unless defined(&R_PPC_GOT16_HA);
    eval 'sub R_PPC_PLTREL24 {18;}' unless defined(&R_PPC_PLTREL24);
    eval 'sub R_PPC_COPY {19;}' unless defined(&R_PPC_COPY);
    eval 'sub R_PPC_GLOB_DAT {20;}' unless defined(&R_PPC_GLOB_DAT);
    eval 'sub R_PPC_JMP_SLOT {21;}' unless defined(&R_PPC_JMP_SLOT);
    eval 'sub R_PPC_RELATIVE {22;}' unless defined(&R_PPC_RELATIVE);
    eval 'sub R_PPC_LOCAL24PC {23;}' unless defined(&R_PPC_LOCAL24PC);
    eval 'sub R_PPC_UADDR32 {24;}' unless defined(&R_PPC_UADDR32);
    eval 'sub R_PPC_UADDR16 {25;}' unless defined(&R_PPC_UADDR16);
    eval 'sub R_PPC_REL32 {26;}' unless defined(&R_PPC_REL32);
    eval 'sub R_PPC_PLT32 {27;}' unless defined(&R_PPC_PLT32);
    eval 'sub R_PPC_PLTREL32 {28;}' unless defined(&R_PPC_PLTREL32);
    eval 'sub R_PPC_PLT16_LO {29;}' unless defined(&R_PPC_PLT16_LO);
    eval 'sub R_PPC_PLT16_HI {30;}' unless defined(&R_PPC_PLT16_HI);
    eval 'sub R_PPC_PLT16_HA {31;}' unless defined(&R_PPC_PLT16_HA);
    eval 'sub R_PPC_SDAREL16 {32;}' unless defined(&R_PPC_SDAREL16);
    eval 'sub R_PPC_SECTOFF {33;}' unless defined(&R_PPC_SECTOFF);
    eval 'sub R_PPC_SECTOFF_LO {34;}' unless defined(&R_PPC_SECTOFF_LO);
    eval 'sub R_PPC_SECTOFF_HI {35;}' unless defined(&R_PPC_SECTOFF_HI);
    eval 'sub R_PPC_SECTOFF_HA {36;}' unless defined(&R_PPC_SECTOFF_HA);
    eval 'sub R_PPC_TLS {67;}' unless defined(&R_PPC_TLS);
    eval 'sub R_PPC_DTPMOD32 {68;}' unless defined(&R_PPC_DTPMOD32);
    eval 'sub R_PPC_TPREL16 {69;}' unless defined(&R_PPC_TPREL16);
    eval 'sub R_PPC_TPREL16_LO {70;}' unless defined(&R_PPC_TPREL16_LO);
    eval 'sub R_PPC_TPREL16_HI {71;}' unless defined(&R_PPC_TPREL16_HI);
    eval 'sub R_PPC_TPREL16_HA {72;}' unless defined(&R_PPC_TPREL16_HA);
    eval 'sub R_PPC_TPREL32 {73;}' unless defined(&R_PPC_TPREL32);
    eval 'sub R_PPC_DTPREL16 {74;}' unless defined(&R_PPC_DTPREL16);
    eval 'sub R_PPC_DTPREL16_LO {75;}' unless defined(&R_PPC_DTPREL16_LO);
    eval 'sub R_PPC_DTPREL16_HI {76;}' unless defined(&R_PPC_DTPREL16_HI);
    eval 'sub R_PPC_DTPREL16_HA {77;}' unless defined(&R_PPC_DTPREL16_HA);
    eval 'sub R_PPC_DTPREL32 {78;}' unless defined(&R_PPC_DTPREL32);
    eval 'sub R_PPC_GOT_TLSGD16 {79;}' unless defined(&R_PPC_GOT_TLSGD16);
    eval 'sub R_PPC_GOT_TLSGD16_LO {80;}' unless defined(&R_PPC_GOT_TLSGD16_LO);
    eval 'sub R_PPC_GOT_TLSGD16_HI {81;}' unless defined(&R_PPC_GOT_TLSGD16_HI);
    eval 'sub R_PPC_GOT_TLSGD16_HA {82;}' unless defined(&R_PPC_GOT_TLSGD16_HA);
    eval 'sub R_PPC_GOT_TLSLD16 {83;}' unless defined(&R_PPC_GOT_TLSLD16);
    eval 'sub R_PPC_GOT_TLSLD16_LO {84;}' unless defined(&R_PPC_GOT_TLSLD16_LO);
    eval 'sub R_PPC_GOT_TLSLD16_HI {85;}' unless defined(&R_PPC_GOT_TLSLD16_HI);
    eval 'sub R_PPC_GOT_TLSLD16_HA {86;}' unless defined(&R_PPC_GOT_TLSLD16_HA);
    eval 'sub R_PPC_GOT_TPREL16 {87;}' unless defined(&R_PPC_GOT_TPREL16);
    eval 'sub R_PPC_GOT_TPREL16_LO {88;}' unless defined(&R_PPC_GOT_TPREL16_LO);
    eval 'sub R_PPC_GOT_TPREL16_HI {89;}' unless defined(&R_PPC_GOT_TPREL16_HI);
    eval 'sub R_PPC_GOT_TPREL16_HA {90;}' unless defined(&R_PPC_GOT_TPREL16_HA);
    eval 'sub R_PPC_GOT_DTPREL16 {91;}' unless defined(&R_PPC_GOT_DTPREL16);
    eval 'sub R_PPC_GOT_DTPREL16_LO {92;}' unless defined(&R_PPC_GOT_DTPREL16_LO);
    eval 'sub R_PPC_GOT_DTPREL16_HI {93;}' unless defined(&R_PPC_GOT_DTPREL16_HI);
    eval 'sub R_PPC_GOT_DTPREL16_HA {94;}' unless defined(&R_PPC_GOT_DTPREL16_HA);
    eval 'sub R_PPC_NUM {95;}' unless defined(&R_PPC_NUM);
    eval 'sub R_PPC_EMB_NADDR32 {101;}' unless defined(&R_PPC_EMB_NADDR32);
    eval 'sub R_PPC_EMB_NADDR16 {102;}' unless defined(&R_PPC_EMB_NADDR16);
    eval 'sub R_PPC_EMB_NADDR16_LO {103;}' unless defined(&R_PPC_EMB_NADDR16_LO);
    eval 'sub R_PPC_EMB_NADDR16_HI {104;}' unless defined(&R_PPC_EMB_NADDR16_HI);
    eval 'sub R_PPC_EMB_NADDR16_HA {105;}' unless defined(&R_PPC_EMB_NADDR16_HA);
    eval 'sub R_PPC_EMB_SDAI16 {106;}' unless defined(&R_PPC_EMB_SDAI16);
    eval 'sub R_PPC_EMB_SDA2I16 {107;}' unless defined(&R_PPC_EMB_SDA2I16);
    eval 'sub R_PPC_EMB_SDA2REL {108;}' unless defined(&R_PPC_EMB_SDA2REL);
    eval 'sub R_PPC_EMB_SDA21 {109;}' unless defined(&R_PPC_EMB_SDA21);
    eval 'sub R_PPC_EMB_MRKREF {110;}' unless defined(&R_PPC_EMB_MRKREF);
    eval 'sub R_PPC_EMB_RELSEC16 {111;}' unless defined(&R_PPC_EMB_RELSEC16);
    eval 'sub R_PPC_EMB_RELST_LO {112;}' unless defined(&R_PPC_EMB_RELST_LO);
    eval 'sub R_PPC_EMB_RELST_HI {113;}' unless defined(&R_PPC_EMB_RELST_HI);
    eval 'sub R_PPC_EMB_RELST_HA {114;}' unless defined(&R_PPC_EMB_RELST_HA);
    eval 'sub R_PPC_EMB_BIT_FLD {115;}' unless defined(&R_PPC_EMB_BIT_FLD);
    eval 'sub R_PPC_EMB_RELSDA {116;}' unless defined(&R_PPC_EMB_RELSDA);
    eval 'sub R_PPC_DIAB_SDA21_LO {180;}' unless defined(&R_PPC_DIAB_SDA21_LO);
    eval 'sub R_PPC_DIAB_SDA21_HI {181;}' unless defined(&R_PPC_DIAB_SDA21_HI);
    eval 'sub R_PPC_DIAB_SDA21_HA {182;}' unless defined(&R_PPC_DIAB_SDA21_HA);
    eval 'sub R_PPC_DIAB_RELSDA_LO {183;}' unless defined(&R_PPC_DIAB_RELSDA_LO);
    eval 'sub R_PPC_DIAB_RELSDA_HI {184;}' unless defined(&R_PPC_DIAB_RELSDA_HI);
    eval 'sub R_PPC_DIAB_RELSDA_HA {185;}' unless defined(&R_PPC_DIAB_RELSDA_HA);
    eval 'sub R_PPC_REL16 {249;}' unless defined(&R_PPC_REL16);
    eval 'sub R_PPC_REL16_LO {250;}' unless defined(&R_PPC_REL16_LO);
    eval 'sub R_PPC_REL16_HI {251;}' unless defined(&R_PPC_REL16_HI);
    eval 'sub R_PPC_REL16_HA {252;}' unless defined(&R_PPC_REL16_HA);
    eval 'sub R_PPC_TOC16 {255;}' unless defined(&R_PPC_TOC16);
    eval 'sub DT_PPC_GOT {( &DT_LOPROC + 0);}' unless defined(&DT_PPC_GOT);
    eval 'sub DT_PPC_NUM {1;}' unless defined(&DT_PPC_NUM);
    eval 'sub R_PPC64_NONE { &R_PPC_NONE;}' unless defined(&R_PPC64_NONE);
    eval 'sub R_PPC64_ADDR32 { &R_PPC_ADDR32;}' unless defined(&R_PPC64_ADDR32);
    eval 'sub R_PPC64_ADDR24 { &R_PPC_ADDR24;}' unless defined(&R_PPC64_ADDR24);
    eval 'sub R_PPC64_ADDR16 { &R_PPC_ADDR16;}' unless defined(&R_PPC64_ADDR16);
    eval 'sub R_PPC64_ADDR16_LO { &R_PPC_ADDR16_LO;}' unless defined(&R_PPC64_ADDR16_LO);
    eval 'sub R_PPC64_ADDR16_HI { &R_PPC_ADDR16_HI;}' unless defined(&R_PPC64_ADDR16_HI);
    eval 'sub R_PPC64_ADDR16_HA { &R_PPC_ADDR16_HA;}' unless defined(&R_PPC64_ADDR16_HA);
    eval 'sub R_PPC64_ADDR14 { &R_PPC_ADDR14;}' unless defined(&R_PPC64_ADDR14);
    eval 'sub R_PPC64_ADDR14_BRTAKEN { &R_PPC_ADDR14_BRTAKEN;}' unless defined(&R_PPC64_ADDR14_BRTAKEN);
    eval 'sub R_PPC64_ADDR14_BRNTAKEN { &R_PPC_ADDR14_BRNTAKEN;}' unless defined(&R_PPC64_ADDR14_BRNTAKEN);
    eval 'sub R_PPC64_REL24 { &R_PPC_REL24;}' unless defined(&R_PPC64_REL24);
    eval 'sub R_PPC64_REL14 { &R_PPC_REL14;}' unless defined(&R_PPC64_REL14);
    eval 'sub R_PPC64_REL14_BRTAKEN { &R_PPC_REL14_BRTAKEN;}' unless defined(&R_PPC64_REL14_BRTAKEN);
    eval 'sub R_PPC64_REL14_BRNTAKEN { &R_PPC_REL14_BRNTAKEN;}' unless defined(&R_PPC64_REL14_BRNTAKEN);
    eval 'sub R_PPC64_GOT16 { &R_PPC_GOT16;}' unless defined(&R_PPC64_GOT16);
    eval 'sub R_PPC64_GOT16_LO { &R_PPC_GOT16_LO;}' unless defined(&R_PPC64_GOT16_LO);
    eval 'sub R_PPC64_GOT16_HI { &R_PPC_GOT16_HI;}' unless defined(&R_PPC64_GOT16_HI);
    eval 'sub R_PPC64_GOT16_HA { &R_PPC_GOT16_HA;}' unless defined(&R_PPC64_GOT16_HA);
    eval 'sub R_PPC64_COPY { &R_PPC_COPY;}' unless defined(&R_PPC64_COPY);
    eval 'sub R_PPC64_GLOB_DAT { &R_PPC_GLOB_DAT;}' unless defined(&R_PPC64_GLOB_DAT);
    eval 'sub R_PPC64_JMP_SLOT { &R_PPC_JMP_SLOT;}' unless defined(&R_PPC64_JMP_SLOT);
    eval 'sub R_PPC64_RELATIVE { &R_PPC_RELATIVE;}' unless defined(&R_PPC64_RELATIVE);
    eval 'sub R_PPC64_UADDR32 { &R_PPC_UADDR32;}' unless defined(&R_PPC64_UADDR32);
    eval 'sub R_PPC64_UADDR16 { &R_PPC_UADDR16;}' unless defined(&R_PPC64_UADDR16);
    eval 'sub R_PPC64_REL32 { &R_PPC_REL32;}' unless defined(&R_PPC64_REL32);
    eval 'sub R_PPC64_PLT32 { &R_PPC_PLT32;}' unless defined(&R_PPC64_PLT32);
    eval 'sub R_PPC64_PLTREL32 { &R_PPC_PLTREL32;}' unless defined(&R_PPC64_PLTREL32);
    eval 'sub R_PPC64_PLT16_LO { &R_PPC_PLT16_LO;}' unless defined(&R_PPC64_PLT16_LO);
    eval 'sub R_PPC64_PLT16_HI { &R_PPC_PLT16_HI;}' unless defined(&R_PPC64_PLT16_HI);
    eval 'sub R_PPC64_PLT16_HA { &R_PPC_PLT16_HA;}' unless defined(&R_PPC64_PLT16_HA);
    eval 'sub R_PPC64_SECTOFF { &R_PPC_SECTOFF;}' unless defined(&R_PPC64_SECTOFF);
    eval 'sub R_PPC64_SECTOFF_LO { &R_PPC_SECTOFF_LO;}' unless defined(&R_PPC64_SECTOFF_LO);
    eval 'sub R_PPC64_SECTOFF_HI { &R_PPC_SECTOFF_HI;}' unless defined(&R_PPC64_SECTOFF_HI);
    eval 'sub R_PPC64_SECTOFF_HA { &R_PPC_SECTOFF_HA;}' unless defined(&R_PPC64_SECTOFF_HA);
    eval 'sub R_PPC64_ADDR30 {37;}' unless defined(&R_PPC64_ADDR30);
    eval 'sub R_PPC64_ADDR64 {38;}' unless defined(&R_PPC64_ADDR64);
    eval 'sub R_PPC64_ADDR16_HIGHER {39;}' unless defined(&R_PPC64_ADDR16_HIGHER);
    eval 'sub R_PPC64_ADDR16_HIGHERA {40;}' unless defined(&R_PPC64_ADDR16_HIGHERA);
    eval 'sub R_PPC64_ADDR16_HIGHEST {41;}' unless defined(&R_PPC64_ADDR16_HIGHEST);
    eval 'sub R_PPC64_ADDR16_HIGHESTA {42;}' unless defined(&R_PPC64_ADDR16_HIGHESTA);
    eval 'sub R_PPC64_UADDR64 {43;}' unless defined(&R_PPC64_UADDR64);
    eval 'sub R_PPC64_REL64 {44;}' unless defined(&R_PPC64_REL64);
    eval 'sub R_PPC64_PLT64 {45;}' unless defined(&R_PPC64_PLT64);
    eval 'sub R_PPC64_PLTREL64 {46;}' unless defined(&R_PPC64_PLTREL64);
    eval 'sub R_PPC64_TOC16 {47;}' unless defined(&R_PPC64_TOC16);
    eval 'sub R_PPC64_TOC16_LO {48;}' unless defined(&R_PPC64_TOC16_LO);
    eval 'sub R_PPC64_TOC16_HI {49;}' unless defined(&R_PPC64_TOC16_HI);
    eval 'sub R_PPC64_TOC16_HA {50;}' unless defined(&R_PPC64_TOC16_HA);
    eval 'sub R_PPC64_TOC {51;}' unless defined(&R_PPC64_TOC);
    eval 'sub R_PPC64_PLTGOT16 {52;}' unless defined(&R_PPC64_PLTGOT16);
    eval 'sub R_PPC64_PLTGOT16_LO {53;}' unless defined(&R_PPC64_PLTGOT16_LO);
    eval 'sub R_PPC64_PLTGOT16_HI {54;}' unless defined(&R_PPC64_PLTGOT16_HI);
    eval 'sub R_PPC64_PLTGOT16_HA {55;}' unless defined(&R_PPC64_PLTGOT16_HA);
    eval 'sub R_PPC64_ADDR16_DS {56;}' unless defined(&R_PPC64_ADDR16_DS);
    eval 'sub R_PPC64_ADDR16_LO_DS {57;}' unless defined(&R_PPC64_ADDR16_LO_DS);
    eval 'sub R_PPC64_GOT16_DS {58;}' unless defined(&R_PPC64_GOT16_DS);
    eval 'sub R_PPC64_GOT16_LO_DS {59;}' unless defined(&R_PPC64_GOT16_LO_DS);
    eval 'sub R_PPC64_PLT16_LO_DS {60;}' unless defined(&R_PPC64_PLT16_LO_DS);
    eval 'sub R_PPC64_SECTOFF_DS {61;}' unless defined(&R_PPC64_SECTOFF_DS);
    eval 'sub R_PPC64_SECTOFF_LO_DS {62;}' unless defined(&R_PPC64_SECTOFF_LO_DS);
    eval 'sub R_PPC64_TOC16_DS {63;}' unless defined(&R_PPC64_TOC16_DS);
    eval 'sub R_PPC64_TOC16_LO_DS {64;}' unless defined(&R_PPC64_TOC16_LO_DS);
    eval 'sub R_PPC64_PLTGOT16_DS {65;}' unless defined(&R_PPC64_PLTGOT16_DS);
    eval 'sub R_PPC64_PLTGOT16_LO_DS {66;}' unless defined(&R_PPC64_PLTGOT16_LO_DS);
    eval 'sub R_PPC64_TLS {67;}' unless defined(&R_PPC64_TLS);
    eval 'sub R_PPC64_DTPMOD64 {68;}' unless defined(&R_PPC64_DTPMOD64);
    eval 'sub R_PPC64_TPREL16 {69;}' unless defined(&R_PPC64_TPREL16);
    eval 'sub R_PPC64_TPREL16_LO {70;}' unless defined(&R_PPC64_TPREL16_LO);
    eval 'sub R_PPC64_TPREL16_HI {71;}' unless defined(&R_PPC64_TPREL16_HI);
    eval 'sub R_PPC64_TPREL16_HA {72;}' unless defined(&R_PPC64_TPREL16_HA);
    eval 'sub R_PPC64_TPREL64 {73;}' unless defined(&R_PPC64_TPREL64);
    eval 'sub R_PPC64_DTPREL16 {74;}' unless defined(&R_PPC64_DTPREL16);
    eval 'sub R_PPC64_DTPREL16_LO {75;}' unless defined(&R_PPC64_DTPREL16_LO);
    eval 'sub R_PPC64_DTPREL16_HI {76;}' unless defined(&R_PPC64_DTPREL16_HI);
    eval 'sub R_PPC64_DTPREL16_HA {77;}' unless defined(&R_PPC64_DTPREL16_HA);
    eval 'sub R_PPC64_DTPREL64 {78;}' unless defined(&R_PPC64_DTPREL64);
    eval 'sub R_PPC64_GOT_TLSGD16 {79;}' unless defined(&R_PPC64_GOT_TLSGD16);
    eval 'sub R_PPC64_GOT_TLSGD16_LO {80;}' unless defined(&R_PPC64_GOT_TLSGD16_LO);
    eval 'sub R_PPC64_GOT_TLSGD16_HI {81;}' unless defined(&R_PPC64_GOT_TLSGD16_HI);
    eval 'sub R_PPC64_GOT_TLSGD16_HA {82;}' unless defined(&R_PPC64_GOT_TLSGD16_HA);
    eval 'sub R_PPC64_GOT_TLSLD16 {83;}' unless defined(&R_PPC64_GOT_TLSLD16);
    eval 'sub R_PPC64_GOT_TLSLD16_LO {84;}' unless defined(&R_PPC64_GOT_TLSLD16_LO);
    eval 'sub R_PPC64_GOT_TLSLD16_HI {85;}' unless defined(&R_PPC64_GOT_TLSLD16_HI);
    eval 'sub R_PPC64_GOT_TLSLD16_HA {86;}' unless defined(&R_PPC64_GOT_TLSLD16_HA);
    eval 'sub R_PPC64_GOT_TPREL16_DS {87;}' unless defined(&R_PPC64_GOT_TPREL16_DS);
    eval 'sub R_PPC64_GOT_TPREL16_LO_DS {88;}' unless defined(&R_PPC64_GOT_TPREL16_LO_DS);
    eval 'sub R_PPC64_GOT_TPREL16_HI {89;}' unless defined(&R_PPC64_GOT_TPREL16_HI);
    eval 'sub R_PPC64_GOT_TPREL16_HA {90;}' unless defined(&R_PPC64_GOT_TPREL16_HA);
    eval 'sub R_PPC64_GOT_DTPREL16_DS {91;}' unless defined(&R_PPC64_GOT_DTPREL16_DS);
    eval 'sub R_PPC64_GOT_DTPREL16_LO_DS {92;}' unless defined(&R_PPC64_GOT_DTPREL16_LO_DS);
    eval 'sub R_PPC64_GOT_DTPREL16_HI {93;}' unless defined(&R_PPC64_GOT_DTPREL16_HI);
    eval 'sub R_PPC64_GOT_DTPREL16_HA {94;}' unless defined(&R_PPC64_GOT_DTPREL16_HA);
    eval 'sub R_PPC64_TPREL16_DS {95;}' unless defined(&R_PPC64_TPREL16_DS);
    eval 'sub R_PPC64_TPREL16_LO_DS {96;}' unless defined(&R_PPC64_TPREL16_LO_DS);
    eval 'sub R_PPC64_TPREL16_HIGHER {97;}' unless defined(&R_PPC64_TPREL16_HIGHER);
    eval 'sub R_PPC64_TPREL16_HIGHERA {98;}' unless defined(&R_PPC64_TPREL16_HIGHERA);
    eval 'sub R_PPC64_TPREL16_HIGHEST {99;}' unless defined(&R_PPC64_TPREL16_HIGHEST);
    eval 'sub R_PPC64_TPREL16_HIGHESTA {100;}' unless defined(&R_PPC64_TPREL16_HIGHESTA);
    eval 'sub R_PPC64_DTPREL16_DS {101;}' unless defined(&R_PPC64_DTPREL16_DS);
    eval 'sub R_PPC64_DTPREL16_LO_DS {102;}' unless defined(&R_PPC64_DTPREL16_LO_DS);
    eval 'sub R_PPC64_DTPREL16_HIGHER {103;}' unless defined(&R_PPC64_DTPREL16_HIGHER);
    eval 'sub R_PPC64_DTPREL16_HIGHERA {104;}' unless defined(&R_PPC64_DTPREL16_HIGHERA);
    eval 'sub R_PPC64_DTPREL16_HIGHEST {105;}' unless defined(&R_PPC64_DTPREL16_HIGHEST);
    eval 'sub R_PPC64_DTPREL16_HIGHESTA {106;}' unless defined(&R_PPC64_DTPREL16_HIGHESTA);
    eval 'sub R_PPC64_NUM {107;}' unless defined(&R_PPC64_NUM);
    eval 'sub DT_PPC64_GLINK {( &DT_LOPROC + 0);}' unless defined(&DT_PPC64_GLINK);
    eval 'sub DT_PPC64_OPD {( &DT_LOPROC + 1);}' unless defined(&DT_PPC64_OPD);
    eval 'sub DT_PPC64_OPDSZ {( &DT_LOPROC + 2);}' unless defined(&DT_PPC64_OPDSZ);
    eval 'sub DT_PPC64_NUM {3;}' unless defined(&DT_PPC64_NUM);
    eval 'sub EF_ARM_RELEXEC {0x1;}' unless defined(&EF_ARM_RELEXEC);
    eval 'sub EF_ARM_HASENTRY {0x2;}' unless defined(&EF_ARM_HASENTRY);
    eval 'sub EF_ARM_INTERWORK {0x4;}' unless defined(&EF_ARM_INTERWORK);
    eval 'sub EF_ARM_APCS_26 {0x8;}' unless defined(&EF_ARM_APCS_26);
    eval 'sub EF_ARM_APCS_FLOAT {0x10;}' unless defined(&EF_ARM_APCS_FLOAT);
    eval 'sub EF_ARM_PIC {0x20;}' unless defined(&EF_ARM_PIC);
    eval 'sub EF_ARM_ALIGN8 {0x40;}' unless defined(&EF_ARM_ALIGN8);
    eval 'sub EF_ARM_NEW_ABI {0x80;}' unless defined(&EF_ARM_NEW_ABI);
    eval 'sub EF_ARM_OLD_ABI {0x100;}' unless defined(&EF_ARM_OLD_ABI);
    eval 'sub EF_ARM_SYMSARESORTED {0x4;}' unless defined(&EF_ARM_SYMSARESORTED);
    eval 'sub EF_ARM_DYNSYMSUSESEGIDX {0x8;}' unless defined(&EF_ARM_DYNSYMSUSESEGIDX);
    eval 'sub EF_ARM_MAPSYMSFIRST {0x10;}' unless defined(&EF_ARM_MAPSYMSFIRST);
    eval 'sub EF_ARM_EABIMASK {0xff000000;}' unless defined(&EF_ARM_EABIMASK);
    eval 'sub EF_ARM_EABI_VERSION {
        my($flags) = @_;
	    eval q((($flags) &  &EF_ARM_EABIMASK));
    }' unless defined(&EF_ARM_EABI_VERSION);
    eval 'sub EF_ARM_EABI_UNKNOWN {0x;}' unless defined(&EF_ARM_EABI_UNKNOWN);
    eval 'sub EF_ARM_EABI_VER1 {0x1000000;}' unless defined(&EF_ARM_EABI_VER1);
    eval 'sub EF_ARM_EABI_VER2 {0x2000000;}' unless defined(&EF_ARM_EABI_VER2);
    eval 'sub STT_ARM_TFUNC {0xd;}' unless defined(&STT_ARM_TFUNC);
    eval 'sub SHF_ARM_ENTRYSECT {0x10000000;}' unless defined(&SHF_ARM_ENTRYSECT);
    eval 'sub SHF_ARM_COMDEF {0x80000000;}' unless defined(&SHF_ARM_COMDEF);
    eval 'sub PF_ARM_SB {0x10000000;}' unless defined(&PF_ARM_SB);
    eval 'sub PT_ARM_EXIDX {0x70000001;}' unless defined(&PT_ARM_EXIDX);
    eval 'sub R_ARM_NONE {0;}' unless defined(&R_ARM_NONE);
    eval 'sub R_ARM_PC24 {1;}' unless defined(&R_ARM_PC24);
    eval 'sub R_ARM_ABS32 {2;}' unless defined(&R_ARM_ABS32);
    eval 'sub R_ARM_REL32 {3;}' unless defined(&R_ARM_REL32);
    eval 'sub R_ARM_PC13 {4;}' unless defined(&R_ARM_PC13);
    eval 'sub R_ARM_ABS16 {5;}' unless defined(&R_ARM_ABS16);
    eval 'sub R_ARM_ABS12 {6;}' unless defined(&R_ARM_ABS12);
    eval 'sub R_ARM_THM_ABS5 {7;}' unless defined(&R_ARM_THM_ABS5);
    eval 'sub R_ARM_ABS8 {8;}' unless defined(&R_ARM_ABS8);
    eval 'sub R_ARM_SBREL32 {9;}' unless defined(&R_ARM_SBREL32);
    eval 'sub R_ARM_THM_PC22 {10;}' unless defined(&R_ARM_THM_PC22);
    eval 'sub R_ARM_THM_PC8 {11;}' unless defined(&R_ARM_THM_PC8);
    eval 'sub R_ARM_AMP_VCALL9 {12;}' unless defined(&R_ARM_AMP_VCALL9);
    eval 'sub R_ARM_SWI24 {13;}' unless defined(&R_ARM_SWI24);
    eval 'sub R_ARM_THM_SWI8 {14;}' unless defined(&R_ARM_THM_SWI8);
    eval 'sub R_ARM_XPC25 {15;}' unless defined(&R_ARM_XPC25);
    eval 'sub R_ARM_THM_XPC22 {16;}' unless defined(&R_ARM_THM_XPC22);
    eval 'sub R_ARM_TLS_DTPMOD32 {17;}' unless defined(&R_ARM_TLS_DTPMOD32);
    eval 'sub R_ARM_TLS_DTPOFF32 {18;}' unless defined(&R_ARM_TLS_DTPOFF32);
    eval 'sub R_ARM_TLS_TPOFF32 {19;}' unless defined(&R_ARM_TLS_TPOFF32);
    eval 'sub R_ARM_COPY {20;}' unless defined(&R_ARM_COPY);
    eval 'sub R_ARM_GLOB_DAT {21;}' unless defined(&R_ARM_GLOB_DAT);
    eval 'sub R_ARM_JUMP_SLOT {22;}' unless defined(&R_ARM_JUMP_SLOT);
    eval 'sub R_ARM_RELATIVE {23;}' unless defined(&R_ARM_RELATIVE);
    eval 'sub R_ARM_GOTOFF {24;}' unless defined(&R_ARM_GOTOFF);
    eval 'sub R_ARM_GOTPC {25;}' unless defined(&R_ARM_GOTPC);
    eval 'sub R_ARM_GOT32 {26;}' unless defined(&R_ARM_GOT32);
    eval 'sub R_ARM_PLT32 {27;}' unless defined(&R_ARM_PLT32);
    eval 'sub R_ARM_ALU_PCREL_7_0 {32;}' unless defined(&R_ARM_ALU_PCREL_7_0);
    eval 'sub R_ARM_ALU_PCREL_15_8 {33;}' unless defined(&R_ARM_ALU_PCREL_15_8);
    eval 'sub R_ARM_ALU_PCREL_23_15 {34;}' unless defined(&R_ARM_ALU_PCREL_23_15);
    eval 'sub R_ARM_LDR_SBREL_11_0 {35;}' unless defined(&R_ARM_LDR_SBREL_11_0);
    eval 'sub R_ARM_ALU_SBREL_19_12 {36;}' unless defined(&R_ARM_ALU_SBREL_19_12);
    eval 'sub R_ARM_ALU_SBREL_27_20 {37;}' unless defined(&R_ARM_ALU_SBREL_27_20);
    eval 'sub R_ARM_GNU_VTENTRY {100;}' unless defined(&R_ARM_GNU_VTENTRY);
    eval 'sub R_ARM_GNU_VTINHERIT {101;}' unless defined(&R_ARM_GNU_VTINHERIT);
    eval 'sub R_ARM_THM_PC11 {102;}' unless defined(&R_ARM_THM_PC11);
    eval 'sub R_ARM_THM_PC9 {103;}' unless defined(&R_ARM_THM_PC9);
    eval 'sub R_ARM_TLS_GD32 {104;}' unless defined(&R_ARM_TLS_GD32);
    eval 'sub R_ARM_TLS_LDM32 {105;}' unless defined(&R_ARM_TLS_LDM32);
    eval 'sub R_ARM_TLS_LDO32 {106;}' unless defined(&R_ARM_TLS_LDO32);
    eval 'sub R_ARM_TLS_IE32 {107;}' unless defined(&R_ARM_TLS_IE32);
    eval 'sub R_ARM_TLS_LE32 {108;}' unless defined(&R_ARM_TLS_LE32);
    eval 'sub R_ARM_RXPC25 {249;}' unless defined(&R_ARM_RXPC25);
    eval 'sub R_ARM_RSBREL32 {250;}' unless defined(&R_ARM_RSBREL32);
    eval 'sub R_ARM_THM_RPC22 {251;}' unless defined(&R_ARM_THM_RPC22);
    eval 'sub R_ARM_RREL32 {252;}' unless defined(&R_ARM_RREL32);
    eval 'sub R_ARM_RABS22 {253;}' unless defined(&R_ARM_RABS22);
    eval 'sub R_ARM_RPC24 {254;}' unless defined(&R_ARM_RPC24);
    eval 'sub R_ARM_RBASE {255;}' unless defined(&R_ARM_RBASE);
    eval 'sub R_ARM_NUM {256;}' unless defined(&R_ARM_NUM);
    eval 'sub EF_IA_64_MASKOS {0xf;}' unless defined(&EF_IA_64_MASKOS);
    eval 'sub EF_IA_64_ABI64 {0x10;}' unless defined(&EF_IA_64_ABI64);
    eval 'sub EF_IA_64_ARCH {0xff000000;}' unless defined(&EF_IA_64_ARCH);
    eval 'sub PT_IA_64_ARCHEXT {( &PT_LOPROC + 0);}' unless defined(&PT_IA_64_ARCHEXT);
    eval 'sub PT_IA_64_UNWIND {( &PT_LOPROC + 1);}' unless defined(&PT_IA_64_UNWIND);
    eval 'sub PT_IA_64_HP_OPT_ANOT {( &PT_LOOS + 0x12);}' unless defined(&PT_IA_64_HP_OPT_ANOT);
    eval 'sub PT_IA_64_HP_HSL_ANOT {( &PT_LOOS + 0x13);}' unless defined(&PT_IA_64_HP_HSL_ANOT);
    eval 'sub PT_IA_64_HP_STACK {( &PT_LOOS + 0x14);}' unless defined(&PT_IA_64_HP_STACK);
    eval 'sub PF_IA_64_NORECOV {0x80000000;}' unless defined(&PF_IA_64_NORECOV);
    eval 'sub SHT_IA_64_EXT {( &SHT_LOPROC + 0);}' unless defined(&SHT_IA_64_EXT);
    eval 'sub SHT_IA_64_UNWIND {( &SHT_LOPROC + 1);}' unless defined(&SHT_IA_64_UNWIND);
    eval 'sub SHF_IA_64_SHORT {0x10000000;}' unless defined(&SHF_IA_64_SHORT);
    eval 'sub SHF_IA_64_NORECOV {0x20000000;}' unless defined(&SHF_IA_64_NORECOV);
    eval 'sub DT_IA_64_PLT_RESERVE {( &DT_LOPROC + 0);}' unless defined(&DT_IA_64_PLT_RESERVE);
    eval 'sub DT_IA_64_NUM {1;}' unless defined(&DT_IA_64_NUM);
    eval 'sub R_IA64_NONE {0x;}' unless defined(&R_IA64_NONE);
    eval 'sub R_IA64_IMM14 {0x21;}' unless defined(&R_IA64_IMM14);
    eval 'sub R_IA64_IMM22 {0x22;}' unless defined(&R_IA64_IMM22);
    eval 'sub R_IA64_IMM64 {0x23;}' unless defined(&R_IA64_IMM64);
    eval 'sub R_IA64_DIR32MSB {0x24;}' unless defined(&R_IA64_DIR32MSB);
    eval 'sub R_IA64_DIR32LSB {0x25;}' unless defined(&R_IA64_DIR32LSB);
    eval 'sub R_IA64_DIR64MSB {0x26;}' unless defined(&R_IA64_DIR64MSB);
    eval 'sub R_IA64_DIR64LSB {0x27;}' unless defined(&R_IA64_DIR64LSB);
    eval 'sub R_IA64_GPREL22 {0x2a;}' unless defined(&R_IA64_GPREL22);
    eval 'sub R_IA64_GPREL64I {0x2b;}' unless defined(&R_IA64_GPREL64I);
    eval 'sub R_IA64_GPREL32MSB {0x2c;}' unless defined(&R_IA64_GPREL32MSB);
    eval 'sub R_IA64_GPREL32LSB {0x2d;}' unless defined(&R_IA64_GPREL32LSB);
    eval 'sub R_IA64_GPREL64MSB {0x2e;}' unless defined(&R_IA64_GPREL64MSB);
    eval 'sub R_IA64_GPREL64LSB {0x2f;}' unless defined(&R_IA64_GPREL64LSB);
    eval 'sub R_IA64_LTOFF22 {0x32;}' unless defined(&R_IA64_LTOFF22);
    eval 'sub R_IA64_LTOFF64I {0x33;}' unless defined(&R_IA64_LTOFF64I);
    eval 'sub R_IA64_PLTOFF22 {0x3a;}' unless defined(&R_IA64_PLTOFF22);
    eval 'sub R_IA64_PLTOFF64I {0x3b;}' unless defined(&R_IA64_PLTOFF64I);
    eval 'sub R_IA64_PLTOFF64MSB {0x3e;}' unless defined(&R_IA64_PLTOFF64MSB);
    eval 'sub R_IA64_PLTOFF64LSB {0x3f;}' unless defined(&R_IA64_PLTOFF64LSB);
    eval 'sub R_IA64_FPTR64I {0x43;}' unless defined(&R_IA64_FPTR64I);
    eval 'sub R_IA64_FPTR32MSB {0x44;}' unless defined(&R_IA64_FPTR32MSB);
    eval 'sub R_IA64_FPTR32LSB {0x45;}' unless defined(&R_IA64_FPTR32LSB);
    eval 'sub R_IA64_FPTR64MSB {0x46;}' unless defined(&R_IA64_FPTR64MSB);
    eval 'sub R_IA64_FPTR64LSB {0x47;}' unless defined(&R_IA64_FPTR64LSB);
    eval 'sub R_IA64_PCREL60B {0x48;}' unless defined(&R_IA64_PCREL60B);
    eval 'sub R_IA64_PCREL21B {0x49;}' unless defined(&R_IA64_PCREL21B);
    eval 'sub R_IA64_PCREL21M {0x4a;}' unless defined(&R_IA64_PCREL21M);
    eval 'sub R_IA64_PCREL21F {0x4b;}' unless defined(&R_IA64_PCREL21F);
    eval 'sub R_IA64_PCREL32MSB {0x4c;}' unless defined(&R_IA64_PCREL32MSB);
    eval 'sub R_IA64_PCREL32LSB {0x4d;}' unless defined(&R_IA64_PCREL32LSB);
    eval 'sub R_IA64_PCREL64MSB {0x4e;}' unless defined(&R_IA64_PCREL64MSB);
    eval 'sub R_IA64_PCREL64LSB {0x4f;}' unless defined(&R_IA64_PCREL64LSB);
    eval 'sub R_IA64_LTOFF_FPTR22 {0x52;}' unless defined(&R_IA64_LTOFF_FPTR22);
    eval 'sub R_IA64_LTOFF_FPTR64I {0x53;}' unless defined(&R_IA64_LTOFF_FPTR64I);
    eval 'sub R_IA64_LTOFF_FPTR32MSB {0x54;}' unless defined(&R_IA64_LTOFF_FPTR32MSB);
    eval 'sub R_IA64_LTOFF_FPTR32LSB {0x55;}' unless defined(&R_IA64_LTOFF_FPTR32LSB);
    eval 'sub R_IA64_LTOFF_FPTR64MSB {0x56;}' unless defined(&R_IA64_LTOFF_FPTR64MSB);
    eval 'sub R_IA64_LTOFF_FPTR64LSB {0x57;}' unless defined(&R_IA64_LTOFF_FPTR64LSB);
    eval 'sub R_IA64_SEGREL32MSB {0x5c;}' unless defined(&R_IA64_SEGREL32MSB);
    eval 'sub R_IA64_SEGREL32LSB {0x5d;}' unless defined(&R_IA64_SEGREL32LSB);
    eval 'sub R_IA64_SEGREL64MSB {0x5e;}' unless defined(&R_IA64_SEGREL64MSB);
    eval 'sub R_IA64_SEGREL64LSB {0x5f;}' unless defined(&R_IA64_SEGREL64LSB);
    eval 'sub R_IA64_SECREL32MSB {0x64;}' unless defined(&R_IA64_SECREL32MSB);
    eval 'sub R_IA64_SECREL32LSB {0x65;}' unless defined(&R_IA64_SECREL32LSB);
    eval 'sub R_IA64_SECREL64MSB {0x66;}' unless defined(&R_IA64_SECREL64MSB);
    eval 'sub R_IA64_SECREL64LSB {0x67;}' unless defined(&R_IA64_SECREL64LSB);
    eval 'sub R_IA64_REL32MSB {0x6c;}' unless defined(&R_IA64_REL32MSB);
    eval 'sub R_IA64_REL32LSB {0x6d;}' unless defined(&R_IA64_REL32LSB);
    eval 'sub R_IA64_REL64MSB {0x6e;}' unless defined(&R_IA64_REL64MSB);
    eval 'sub R_IA64_REL64LSB {0x6f;}' unless defined(&R_IA64_REL64LSB);
    eval 'sub R_IA64_LTV32MSB {0x74;}' unless defined(&R_IA64_LTV32MSB);
    eval 'sub R_IA64_LTV32LSB {0x75;}' unless defined(&R_IA64_LTV32LSB);
    eval 'sub R_IA64_LTV64MSB {0x76;}' unless defined(&R_IA64_LTV64MSB);
    eval 'sub R_IA64_LTV64LSB {0x77;}' unless defined(&R_IA64_LTV64LSB);
    eval 'sub R_IA64_PCREL21BI {0x79;}' unless defined(&R_IA64_PCREL21BI);
    eval 'sub R_IA64_PCREL22 {0x7a;}' unless defined(&R_IA64_PCREL22);
    eval 'sub R_IA64_PCREL64I {0x7b;}' unless defined(&R_IA64_PCREL64I);
    eval 'sub R_IA64_IPLTMSB {0x80;}' unless defined(&R_IA64_IPLTMSB);
    eval 'sub R_IA64_IPLTLSB {0x81;}' unless defined(&R_IA64_IPLTLSB);
    eval 'sub R_IA64_COPY {0x84;}' unless defined(&R_IA64_COPY);
    eval 'sub R_IA64_SUB {0x85;}' unless defined(&R_IA64_SUB);
    eval 'sub R_IA64_LTOFF22X {0x86;}' unless defined(&R_IA64_LTOFF22X);
    eval 'sub R_IA64_LDXMOV {0x87;}' unless defined(&R_IA64_LDXMOV);
    eval 'sub R_IA64_TPREL14 {0x91;}' unless defined(&R_IA64_TPREL14);
    eval 'sub R_IA64_TPREL22 {0x92;}' unless defined(&R_IA64_TPREL22);
    eval 'sub R_IA64_TPREL64I {0x93;}' unless defined(&R_IA64_TPREL64I);
    eval 'sub R_IA64_TPREL64MSB {0x96;}' unless defined(&R_IA64_TPREL64MSB);
    eval 'sub R_IA64_TPREL64LSB {0x97;}' unless defined(&R_IA64_TPREL64LSB);
    eval 'sub R_IA64_LTOFF_TPREL22 {0x9a;}' unless defined(&R_IA64_LTOFF_TPREL22);
    eval 'sub R_IA64_DTPMOD64MSB {0xa6;}' unless defined(&R_IA64_DTPMOD64MSB);
    eval 'sub R_IA64_DTPMOD64LSB {0xa7;}' unless defined(&R_IA64_DTPMOD64LSB);
    eval 'sub R_IA64_LTOFF_DTPMOD22 {0xaa;}' unless defined(&R_IA64_LTOFF_DTPMOD22);
    eval 'sub R_IA64_DTPREL14 {0xb1;}' unless defined(&R_IA64_DTPREL14);
    eval 'sub R_IA64_DTPREL22 {0xb2;}' unless defined(&R_IA64_DTPREL22);
    eval 'sub R_IA64_DTPREL64I {0xb3;}' unless defined(&R_IA64_DTPREL64I);
    eval 'sub R_IA64_DTPREL32MSB {0xb4;}' unless defined(&R_IA64_DTPREL32MSB);
    eval 'sub R_IA64_DTPREL32LSB {0xb5;}' unless defined(&R_IA64_DTPREL32LSB);
    eval 'sub R_IA64_DTPREL64MSB {0xb6;}' unless defined(&R_IA64_DTPREL64MSB);
    eval 'sub R_IA64_DTPREL64LSB {0xb7;}' unless defined(&R_IA64_DTPREL64LSB);
    eval 'sub R_IA64_LTOFF_DTPREL22 {0xba;}' unless defined(&R_IA64_LTOFF_DTPREL22);
    eval 'sub R_SH_NONE {0;}' unless defined(&R_SH_NONE);
    eval 'sub R_SH_DIR32 {1;}' unless defined(&R_SH_DIR32);
    eval 'sub R_SH_REL32 {2;}' unless defined(&R_SH_REL32);
    eval 'sub R_SH_DIR8WPN {3;}' unless defined(&R_SH_DIR8WPN);
    eval 'sub R_SH_IND12W {4;}' unless defined(&R_SH_IND12W);
    eval 'sub R_SH_DIR8WPL {5;}' unless defined(&R_SH_DIR8WPL);
    eval 'sub R_SH_DIR8WPZ {6;}' unless defined(&R_SH_DIR8WPZ);
    eval 'sub R_SH_DIR8BP {7;}' unless defined(&R_SH_DIR8BP);
    eval 'sub R_SH_DIR8W {8;}' unless defined(&R_SH_DIR8W);
    eval 'sub R_SH_DIR8L {9;}' unless defined(&R_SH_DIR8L);
    eval 'sub R_SH_SWITCH16 {25;}' unless defined(&R_SH_SWITCH16);
    eval 'sub R_SH_SWITCH32 {26;}' unless defined(&R_SH_SWITCH32);
    eval 'sub R_SH_USES {27;}' unless defined(&R_SH_USES);
    eval 'sub R_SH_COUNT {28;}' unless defined(&R_SH_COUNT);
    eval 'sub R_SH_ALIGN {29;}' unless defined(&R_SH_ALIGN);
    eval 'sub R_SH_CODE {30;}' unless defined(&R_SH_CODE);
    eval 'sub R_SH_DATA {31;}' unless defined(&R_SH_DATA);
    eval 'sub R_SH_LABEL {32;}' unless defined(&R_SH_LABEL);
    eval 'sub R_SH_SWITCH8 {33;}' unless defined(&R_SH_SWITCH8);
    eval 'sub R_SH_GNU_VTINHERIT {34;}' unless defined(&R_SH_GNU_VTINHERIT);
    eval 'sub R_SH_GNU_VTENTRY {35;}' unless defined(&R_SH_GNU_VTENTRY);
    eval 'sub R_SH_TLS_GD_32 {144;}' unless defined(&R_SH_TLS_GD_32);
    eval 'sub R_SH_TLS_LD_32 {145;}' unless defined(&R_SH_TLS_LD_32);
    eval 'sub R_SH_TLS_LDO_32 {146;}' unless defined(&R_SH_TLS_LDO_32);
    eval 'sub R_SH_TLS_IE_32 {147;}' unless defined(&R_SH_TLS_IE_32);
    eval 'sub R_SH_TLS_LE_32 {148;}' unless defined(&R_SH_TLS_LE_32);
    eval 'sub R_SH_TLS_DTPMOD32 {149;}' unless defined(&R_SH_TLS_DTPMOD32);
    eval 'sub R_SH_TLS_DTPOFF32 {150;}' unless defined(&R_SH_TLS_DTPOFF32);
    eval 'sub R_SH_TLS_TPOFF32 {151;}' unless defined(&R_SH_TLS_TPOFF32);
    eval 'sub R_SH_GOT32 {160;}' unless defined(&R_SH_GOT32);
    eval 'sub R_SH_PLT32 {161;}' unless defined(&R_SH_PLT32);
    eval 'sub R_SH_COPY {162;}' unless defined(&R_SH_COPY);
    eval 'sub R_SH_GLOB_DAT {163;}' unless defined(&R_SH_GLOB_DAT);
    eval 'sub R_SH_JMP_SLOT {164;}' unless defined(&R_SH_JMP_SLOT);
    eval 'sub R_SH_RELATIVE {165;}' unless defined(&R_SH_RELATIVE);
    eval 'sub R_SH_GOTOFF {166;}' unless defined(&R_SH_GOTOFF);
    eval 'sub R_SH_GOTPC {167;}' unless defined(&R_SH_GOTPC);
    eval 'sub R_SH_NUM {256;}' unless defined(&R_SH_NUM);
    eval 'sub R_390_NONE {0;}' unless defined(&R_390_NONE);
    eval 'sub R_390_8 {1;}' unless defined(&R_390_8);
    eval 'sub R_390_12 {2;}' unless defined(&R_390_12);
    eval 'sub R_390_16 {3;}' unless defined(&R_390_16);
    eval 'sub R_390_32 {4;}' unless defined(&R_390_32);
    eval 'sub R_390_PC32 {5;}' unless defined(&R_390_PC32);
    eval 'sub R_390_GOT12 {6;}' unless defined(&R_390_GOT12);
    eval 'sub R_390_GOT32 {7;}' unless defined(&R_390_GOT32);
    eval 'sub R_390_PLT32 {8;}' unless defined(&R_390_PLT32);
    eval 'sub R_390_COPY {9;}' unless defined(&R_390_COPY);
    eval 'sub R_390_GLOB_DAT {10;}' unless defined(&R_390_GLOB_DAT);
    eval 'sub R_390_JMP_SLOT {11;}' unless defined(&R_390_JMP_SLOT);
    eval 'sub R_390_RELATIVE {12;}' unless defined(&R_390_RELATIVE);
    eval 'sub R_390_GOTOFF32 {13;}' unless defined(&R_390_GOTOFF32);
    eval 'sub R_390_GOTPC {14;}' unless defined(&R_390_GOTPC);
    eval 'sub R_390_GOT16 {15;}' unless defined(&R_390_GOT16);
    eval 'sub R_390_PC16 {16;}' unless defined(&R_390_PC16);
    eval 'sub R_390_PC16DBL {17;}' unless defined(&R_390_PC16DBL);
    eval 'sub R_390_PLT16DBL {18;}' unless defined(&R_390_PLT16DBL);
    eval 'sub R_390_PC32DBL {19;}' unless defined(&R_390_PC32DBL);
    eval 'sub R_390_PLT32DBL {20;}' unless defined(&R_390_PLT32DBL);
    eval 'sub R_390_GOTPCDBL {21;}' unless defined(&R_390_GOTPCDBL);
    eval 'sub R_390_64 {22;}' unless defined(&R_390_64);
    eval 'sub R_390_PC64 {23;}' unless defined(&R_390_PC64);
    eval 'sub R_390_GOT64 {24;}' unless defined(&R_390_GOT64);
    eval 'sub R_390_PLT64 {25;}' unless defined(&R_390_PLT64);
    eval 'sub R_390_GOTENT {26;}' unless defined(&R_390_GOTENT);
    eval 'sub R_390_GOTOFF16 {27;}' unless defined(&R_390_GOTOFF16);
    eval 'sub R_390_GOTOFF64 {28;}' unless defined(&R_390_GOTOFF64);
    eval 'sub R_390_GOTPLT12 {29;}' unless defined(&R_390_GOTPLT12);
    eval 'sub R_390_GOTPLT16 {30;}' unless defined(&R_390_GOTPLT16);
    eval 'sub R_390_GOTPLT32 {31;}' unless defined(&R_390_GOTPLT32);
    eval 'sub R_390_GOTPLT64 {32;}' unless defined(&R_390_GOTPLT64);
    eval 'sub R_390_GOTPLTENT {33;}' unless defined(&R_390_GOTPLTENT);
    eval 'sub R_390_PLTOFF16 {34;}' unless defined(&R_390_PLTOFF16);
    eval 'sub R_390_PLTOFF32 {35;}' unless defined(&R_390_PLTOFF32);
    eval 'sub R_390_PLTOFF64 {36;}' unless defined(&R_390_PLTOFF64);
    eval 'sub R_390_TLS_LOAD {37;}' unless defined(&R_390_TLS_LOAD);
    eval 'sub R_390_TLS_GDCALL {38;}' unless defined(&R_390_TLS_GDCALL);
    eval 'sub R_390_TLS_LDCALL {39;}' unless defined(&R_390_TLS_LDCALL);
    eval 'sub R_390_TLS_GD32 {40;}' unless defined(&R_390_TLS_GD32);
    eval 'sub R_390_TLS_GD64 {41;}' unless defined(&R_390_TLS_GD64);
    eval 'sub R_390_TLS_GOTIE12 {42;}' unless defined(&R_390_TLS_GOTIE12);
    eval 'sub R_390_TLS_GOTIE32 {43;}' unless defined(&R_390_TLS_GOTIE32);
    eval 'sub R_390_TLS_GOTIE64 {44;}' unless defined(&R_390_TLS_GOTIE64);
    eval 'sub R_390_TLS_LDM32 {45;}' unless defined(&R_390_TLS_LDM32);
    eval 'sub R_390_TLS_LDM64 {46;}' unless defined(&R_390_TLS_LDM64);
    eval 'sub R_390_TLS_IE32 {47;}' unless defined(&R_390_TLS_IE32);
    eval 'sub R_390_TLS_IE64 {48;}' unless defined(&R_390_TLS_IE64);
    eval 'sub R_390_TLS_IEENT {49;}' unless defined(&R_390_TLS_IEENT);
    eval 'sub R_390_TLS_LE32 {50;}' unless defined(&R_390_TLS_LE32);
    eval 'sub R_390_TLS_LE64 {51;}' unless defined(&R_390_TLS_LE64);
    eval 'sub R_390_TLS_LDO32 {52;}' unless defined(&R_390_TLS_LDO32);
    eval 'sub R_390_TLS_LDO64 {53;}' unless defined(&R_390_TLS_LDO64);
    eval 'sub R_390_TLS_DTPMOD {54;}' unless defined(&R_390_TLS_DTPMOD);
    eval 'sub R_390_TLS_DTPOFF {55;}' unless defined(&R_390_TLS_DTPOFF);
    eval 'sub R_390_TLS_TPOFF {56;}' unless defined(&R_390_TLS_TPOFF);
    eval 'sub R_390_20 {57;}' unless defined(&R_390_20);
    eval 'sub R_390_GOT20 {58;}' unless defined(&R_390_GOT20);
    eval 'sub R_390_GOTPLT20 {59;}' unless defined(&R_390_GOTPLT20);
    eval 'sub R_390_TLS_GOTIE20 {60;}' unless defined(&R_390_TLS_GOTIE20);
    eval 'sub R_390_NUM {61;}' unless defined(&R_390_NUM);
    eval 'sub R_CRIS_NONE {0;}' unless defined(&R_CRIS_NONE);
    eval 'sub R_CRIS_8 {1;}' unless defined(&R_CRIS_8);
    eval 'sub R_CRIS_16 {2;}' unless defined(&R_CRIS_16);
    eval 'sub R_CRIS_32 {3;}' unless defined(&R_CRIS_32);
    eval 'sub R_CRIS_8_PCREL {4;}' unless defined(&R_CRIS_8_PCREL);
    eval 'sub R_CRIS_16_PCREL {5;}' unless defined(&R_CRIS_16_PCREL);
    eval 'sub R_CRIS_32_PCREL {6;}' unless defined(&R_CRIS_32_PCREL);
    eval 'sub R_CRIS_GNU_VTINHERIT {7;}' unless defined(&R_CRIS_GNU_VTINHERIT);
    eval 'sub R_CRIS_GNU_VTENTRY {8;}' unless defined(&R_CRIS_GNU_VTENTRY);
    eval 'sub R_CRIS_COPY {9;}' unless defined(&R_CRIS_COPY);
    eval 'sub R_CRIS_GLOB_DAT {10;}' unless defined(&R_CRIS_GLOB_DAT);
    eval 'sub R_CRIS_JUMP_SLOT {11;}' unless defined(&R_CRIS_JUMP_SLOT);
    eval 'sub R_CRIS_RELATIVE {12;}' unless defined(&R_CRIS_RELATIVE);
    eval 'sub R_CRIS_16_GOT {13;}' unless defined(&R_CRIS_16_GOT);
    eval 'sub R_CRIS_32_GOT {14;}' unless defined(&R_CRIS_32_GOT);
    eval 'sub R_CRIS_16_GOTPLT {15;}' unless defined(&R_CRIS_16_GOTPLT);
    eval 'sub R_CRIS_32_GOTPLT {16;}' unless defined(&R_CRIS_32_GOTPLT);
    eval 'sub R_CRIS_32_GOTREL {17;}' unless defined(&R_CRIS_32_GOTREL);
    eval 'sub R_CRIS_32_PLT_GOTREL {18;}' unless defined(&R_CRIS_32_PLT_GOTREL);
    eval 'sub R_CRIS_32_PLT_PCREL {19;}' unless defined(&R_CRIS_32_PLT_PCREL);
    eval 'sub R_CRIS_NUM {20;}' unless defined(&R_CRIS_NUM);
    eval 'sub R_X86_64_NONE {0;}' unless defined(&R_X86_64_NONE);
    eval 'sub R_X86_64_64 {1;}' unless defined(&R_X86_64_64);
    eval 'sub R_X86_64_PC32 {2;}' unless defined(&R_X86_64_PC32);
    eval 'sub R_X86_64_GOT32 {3;}' unless defined(&R_X86_64_GOT32);
    eval 'sub R_X86_64_PLT32 {4;}' unless defined(&R_X86_64_PLT32);
    eval 'sub R_X86_64_COPY {5;}' unless defined(&R_X86_64_COPY);
    eval 'sub R_X86_64_GLOB_DAT {6;}' unless defined(&R_X86_64_GLOB_DAT);
    eval 'sub R_X86_64_JUMP_SLOT {7;}' unless defined(&R_X86_64_JUMP_SLOT);
    eval 'sub R_X86_64_RELATIVE {8;}' unless defined(&R_X86_64_RELATIVE);
    eval 'sub R_X86_64_GOTPCREL {9;}' unless defined(&R_X86_64_GOTPCREL);
    eval 'sub R_X86_64_32 {10;}' unless defined(&R_X86_64_32);
    eval 'sub R_X86_64_32S {11;}' unless defined(&R_X86_64_32S);
    eval 'sub R_X86_64_16 {12;}' unless defined(&R_X86_64_16);
    eval 'sub R_X86_64_PC16 {13;}' unless defined(&R_X86_64_PC16);
    eval 'sub R_X86_64_8 {14;}' unless defined(&R_X86_64_8);
    eval 'sub R_X86_64_PC8 {15;}' unless defined(&R_X86_64_PC8);
    eval 'sub R_X86_64_DTPMOD64 {16;}' unless defined(&R_X86_64_DTPMOD64);
    eval 'sub R_X86_64_DTPOFF64 {17;}' unless defined(&R_X86_64_DTPOFF64);
    eval 'sub R_X86_64_TPOFF64 {18;}' unless defined(&R_X86_64_TPOFF64);
    eval 'sub R_X86_64_TLSGD {19;}' unless defined(&R_X86_64_TLSGD);
    eval 'sub R_X86_64_TLSLD {20;}' unless defined(&R_X86_64_TLSLD);
    eval 'sub R_X86_64_DTPOFF32 {21;}' unless defined(&R_X86_64_DTPOFF32);
    eval 'sub R_X86_64_GOTTPOFF {22;}' unless defined(&R_X86_64_GOTTPOFF);
    eval 'sub R_X86_64_TPOFF32 {23;}' unless defined(&R_X86_64_TPOFF32);
    eval 'sub R_X86_64_NUM {24;}' unless defined(&R_X86_64_NUM);
    eval 'sub R_MN10300_NONE {0;}' unless defined(&R_MN10300_NONE);
    eval 'sub R_MN10300_32 {1;}' unless defined(&R_MN10300_32);
    eval 'sub R_MN10300_16 {2;}' unless defined(&R_MN10300_16);
    eval 'sub R_MN10300_8 {3;}' unless defined(&R_MN10300_8);
    eval 'sub R_MN10300_PCREL32 {4;}' unless defined(&R_MN10300_PCREL32);
    eval 'sub R_MN10300_PCREL16 {5;}' unless defined(&R_MN10300_PCREL16);
    eval 'sub R_MN10300_PCREL8 {6;}' unless defined(&R_MN10300_PCREL8);
    eval 'sub R_MN10300_GNU_VTINHERIT {7;}' unless defined(&R_MN10300_GNU_VTINHERIT);
    eval 'sub R_MN10300_GNU_VTENTRY {8;}' unless defined(&R_MN10300_GNU_VTENTRY);
    eval 'sub R_MN10300_24 {9;}' unless defined(&R_MN10300_24);
    eval 'sub R_MN10300_GOTPC32 {10;}' unless defined(&R_MN10300_GOTPC32);
    eval 'sub R_MN10300_GOTPC16 {11;}' unless defined(&R_MN10300_GOTPC16);
    eval 'sub R_MN10300_GOTOFF32 {12;}' unless defined(&R_MN10300_GOTOFF32);
    eval 'sub R_MN10300_GOTOFF24 {13;}' unless defined(&R_MN10300_GOTOFF24);
    eval 'sub R_MN10300_GOTOFF16 {14;}' unless defined(&R_MN10300_GOTOFF16);
    eval 'sub R_MN10300_PLT32 {15;}' unless defined(&R_MN10300_PLT32);
    eval 'sub R_MN10300_PLT16 {16;}' unless defined(&R_MN10300_PLT16);
    eval 'sub R_MN10300_GOT32 {17;}' unless defined(&R_MN10300_GOT32);
    eval 'sub R_MN10300_GOT24 {18;}' unless defined(&R_MN10300_GOT24);
    eval 'sub R_MN10300_GOT16 {19;}' unless defined(&R_MN10300_GOT16);
    eval 'sub R_MN10300_COPY {20;}' unless defined(&R_MN10300_COPY);
    eval 'sub R_MN10300_GLOB_DAT {21;}' unless defined(&R_MN10300_GLOB_DAT);
    eval 'sub R_MN10300_JMP_SLOT {22;}' unless defined(&R_MN10300_JMP_SLOT);
    eval 'sub R_MN10300_RELATIVE {23;}' unless defined(&R_MN10300_RELATIVE);
    eval 'sub R_MN10300_NUM {24;}' unless defined(&R_MN10300_NUM);
    eval 'sub R_M32R_NONE {0;}' unless defined(&R_M32R_NONE);
    eval 'sub R_M32R_16 {1;}' unless defined(&R_M32R_16);
    eval 'sub R_M32R_32 {2;}' unless defined(&R_M32R_32);
    eval 'sub R_M32R_24 {3;}' unless defined(&R_M32R_24);
    eval 'sub R_M32R_10_PCREL {4;}' unless defined(&R_M32R_10_PCREL);
    eval 'sub R_M32R_18_PCREL {5;}' unless defined(&R_M32R_18_PCREL);
    eval 'sub R_M32R_26_PCREL {6;}' unless defined(&R_M32R_26_PCREL);
    eval 'sub R_M32R_HI16_ULO {7;}' unless defined(&R_M32R_HI16_ULO);
    eval 'sub R_M32R_HI16_SLO {8;}' unless defined(&R_M32R_HI16_SLO);
    eval 'sub R_M32R_LO16 {9;}' unless defined(&R_M32R_LO16);
    eval 'sub R_M32R_SDA16 {10;}' unless defined(&R_M32R_SDA16);
    eval 'sub R_M32R_GNU_VTINHERIT {11;}' unless defined(&R_M32R_GNU_VTINHERIT);
    eval 'sub R_M32R_GNU_VTENTRY {12;}' unless defined(&R_M32R_GNU_VTENTRY);
    eval 'sub R_M32R_16_RELA {33;}' unless defined(&R_M32R_16_RELA);
    eval 'sub R_M32R_32_RELA {34;}' unless defined(&R_M32R_32_RELA);
    eval 'sub R_M32R_24_RELA {35;}' unless defined(&R_M32R_24_RELA);
    eval 'sub R_M32R_10_PCREL_RELA {36;}' unless defined(&R_M32R_10_PCREL_RELA);
    eval 'sub R_M32R_18_PCREL_RELA {37;}' unless defined(&R_M32R_18_PCREL_RELA);
    eval 'sub R_M32R_26_PCREL_RELA {38;}' unless defined(&R_M32R_26_PCREL_RELA);
    eval 'sub R_M32R_HI16_ULO_RELA {39;}' unless defined(&R_M32R_HI16_ULO_RELA);
    eval 'sub R_M32R_HI16_SLO_RELA {40;}' unless defined(&R_M32R_HI16_SLO_RELA);
    eval 'sub R_M32R_LO16_RELA {41;}' unless defined(&R_M32R_LO16_RELA);
    eval 'sub R_M32R_SDA16_RELA {42;}' unless defined(&R_M32R_SDA16_RELA);
    eval 'sub R_M32R_RELA_GNU_VTINHERIT {43;}' unless defined(&R_M32R_RELA_GNU_VTINHERIT);
    eval 'sub R_M32R_RELA_GNU_VTENTRY {44;}' unless defined(&R_M32R_RELA_GNU_VTENTRY);
    eval 'sub R_M32R_REL32 {45;}' unless defined(&R_M32R_REL32);
    eval 'sub R_M32R_GOT24 {48;}' unless defined(&R_M32R_GOT24);
    eval 'sub R_M32R_26_PLTREL {49;}' unless defined(&R_M32R_26_PLTREL);
    eval 'sub R_M32R_COPY {50;}' unless defined(&R_M32R_COPY);
    eval 'sub R_M32R_GLOB_DAT {51;}' unless defined(&R_M32R_GLOB_DAT);
    eval 'sub R_M32R_JMP_SLOT {52;}' unless defined(&R_M32R_JMP_SLOT);
    eval 'sub R_M32R_RELATIVE {53;}' unless defined(&R_M32R_RELATIVE);
    eval 'sub R_M32R_GOTOFF {54;}' unless defined(&R_M32R_GOTOFF);
    eval 'sub R_M32R_GOTPC24 {55;}' unless defined(&R_M32R_GOTPC24);
    eval 'sub R_M32R_GOT16_HI_ULO {56;}' unless defined(&R_M32R_GOT16_HI_ULO);
    eval 'sub R_M32R_GOT16_HI_SLO {57;}' unless defined(&R_M32R_GOT16_HI_SLO);
    eval 'sub R_M32R_GOT16_LO {58;}' unless defined(&R_M32R_GOT16_LO);
    eval 'sub R_M32R_GOTPC_HI_ULO {59;}' unless defined(&R_M32R_GOTPC_HI_ULO);
    eval 'sub R_M32R_GOTPC_HI_SLO {60;}' unless defined(&R_M32R_GOTPC_HI_SLO);
    eval 'sub R_M32R_GOTPC_LO {61;}' unless defined(&R_M32R_GOTPC_LO);
    eval 'sub R_M32R_GOTOFF_HI_ULO {62;}' unless defined(&R_M32R_GOTOFF_HI_ULO);
    eval 'sub R_M32R_GOTOFF_HI_SLO {63;}' unless defined(&R_M32R_GOTOFF_HI_SLO);
    eval 'sub R_M32R_GOTOFF_LO {64;}' unless defined(&R_M32R_GOTOFF_LO);
    eval 'sub R_M32R_NUM {256;}' unless defined(&R_M32R_NUM);
}
1;
