require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_BLKDEV_H)) {
    eval 'sub _LINUX_BLKDEV_H {1;}' unless defined(&_LINUX_BLKDEV_H);
    require 'linux/config.ph';
    require 'linux/major.ph';
    require 'linux/genhd.ph';
    require 'linux/list.ph';
    require 'linux/timer.ph';
    require 'linux/workqueue.ph';
    require 'linux/pagemap.ph';
    require 'linux/backing-dev.ph';
    require 'linux/wait.ph';
    require 'linux/mempool.ph';
    require 'linux/bio.ph';
    require 'linux/module.ph';
    require 'linux/stringify.ph';
    require 'asm/scatterlist.ph';
    eval 'sub BLKDEV_MIN_RQ {4;}' unless defined(&BLKDEV_MIN_RQ);
    eval 'sub BLKDEV_MAX_RQ {128;}' unless defined(&BLKDEV_MAX_RQ);
    eval 'sub BLK_MAX_CDB {16;}' unless defined(&BLK_MAX_CDB);
    eval("sub __REQ_RW () { 0; }") unless defined(&__REQ_RW);
    eval("sub __REQ_FAILFAST () { 1; }") unless defined(&__REQ_FAILFAST);
    eval("sub __REQ_SORTED () { 2; }") unless defined(&__REQ_SORTED);
    eval("sub __REQ_SOFTBARRIER () { 3; }") unless defined(&__REQ_SOFTBARRIER);
    eval("sub __REQ_HARDBARRIER () { 4; }") unless defined(&__REQ_HARDBARRIER);
    eval("sub __REQ_FUA () { 5; }") unless defined(&__REQ_FUA);
    eval("sub __REQ_CMD () { 6; }") unless defined(&__REQ_CMD);
    eval("sub __REQ_NOMERGE () { 7; }") unless defined(&__REQ_NOMERGE);
    eval("sub __REQ_STARTED () { 8; }") unless defined(&__REQ_STARTED);
    eval("sub __REQ_DONTPREP () { 9; }") unless defined(&__REQ_DONTPREP);
    eval("sub __REQ_QUEUED () { 10; }") unless defined(&__REQ_QUEUED);
    eval("sub __REQ_ELVPRIV () { 11; }") unless defined(&__REQ_ELVPRIV);
    eval("sub __REQ_PC () { 12; }") unless defined(&__REQ_PC);
    eval("sub __REQ_BLOCK_PC () { 13; }") unless defined(&__REQ_BLOCK_PC);
    eval("sub __REQ_SENSE () { 14; }") unless defined(&__REQ_SENSE);
    eval("sub __REQ_FAILED () { 15; }") unless defined(&__REQ_FAILED);
    eval("sub __REQ_QUIET () { 16; }") unless defined(&__REQ_QUIET);
    eval("sub __REQ_SPECIAL () { 17; }") unless defined(&__REQ_SPECIAL);
    eval("sub __REQ_DRIVE_CMD () { 18; }") unless defined(&__REQ_DRIVE_CMD);
    eval("sub __REQ_DRIVE_TASK () { 19; }") unless defined(&__REQ_DRIVE_TASK);
    eval("sub __REQ_DRIVE_TASKFILE () { 20; }") unless defined(&__REQ_DRIVE_TASKFILE);
    eval("sub __REQ_PREEMPT () { 21; }") unless defined(&__REQ_PREEMPT);
    eval("sub __REQ_PM_SUSPEND () { 22; }") unless defined(&__REQ_PM_SUSPEND);
    eval("sub __REQ_PM_RESUME () { 23; }") unless defined(&__REQ_PM_RESUME);
    eval("sub __REQ_PM_SHUTDOWN () { 24; }") unless defined(&__REQ_PM_SHUTDOWN);
    eval("sub __REQ_ORDERED_COLOR () { 25; }") unless defined(&__REQ_ORDERED_COLOR);
    eval("sub __REQ_NR_BITS () { 26; }") unless defined(&__REQ_NR_BITS);
    eval 'sub REQ_RW {(1<<  &__REQ_RW);}' unless defined(&REQ_RW);
    eval 'sub REQ_FAILFAST {(1<<  &__REQ_FAILFAST);}' unless defined(&REQ_FAILFAST);
    eval 'sub REQ_SORTED {(1<<  &__REQ_SORTED);}' unless defined(&REQ_SORTED);
    eval 'sub REQ_SOFTBARRIER {(1<<  &__REQ_SOFTBARRIER);}' unless defined(&REQ_SOFTBARRIER);
    eval 'sub REQ_HARDBARRIER {(1<<  &__REQ_HARDBARRIER);}' unless defined(&REQ_HARDBARRIER);
    eval 'sub REQ_FUA {(1<<  &__REQ_FUA);}' unless defined(&REQ_FUA);
    eval 'sub REQ_CMD {(1<<  &__REQ_CMD);}' unless defined(&REQ_CMD);
    eval 'sub REQ_NOMERGE {(1<<  &__REQ_NOMERGE);}' unless defined(&REQ_NOMERGE);
    eval 'sub REQ_STARTED {(1<<  &__REQ_STARTED);}' unless defined(&REQ_STARTED);
    eval 'sub REQ_DONTPREP {(1<<  &__REQ_DONTPREP);}' unless defined(&REQ_DONTPREP);
    eval 'sub REQ_QUEUED {(1<<  &__REQ_QUEUED);}' unless defined(&REQ_QUEUED);
    eval 'sub REQ_ELVPRIV {(1<<  &__REQ_ELVPRIV);}' unless defined(&REQ_ELVPRIV);
    eval 'sub REQ_PC {(1<<  &__REQ_PC);}' unless defined(&REQ_PC);
    eval 'sub REQ_BLOCK_PC {(1<<  &__REQ_BLOCK_PC);}' unless defined(&REQ_BLOCK_PC);
    eval 'sub REQ_SENSE {(1<<  &__REQ_SENSE);}' unless defined(&REQ_SENSE);
    eval 'sub REQ_FAILED {(1<<  &__REQ_FAILED);}' unless defined(&REQ_FAILED);
    eval 'sub REQ_QUIET {(1<<  &__REQ_QUIET);}' unless defined(&REQ_QUIET);
    eval 'sub REQ_SPECIAL {(1<<  &__REQ_SPECIAL);}' unless defined(&REQ_SPECIAL);
    eval 'sub REQ_DRIVE_CMD {(1<<  &__REQ_DRIVE_CMD);}' unless defined(&REQ_DRIVE_CMD);
    eval 'sub REQ_DRIVE_TASK {(1<<  &__REQ_DRIVE_TASK);}' unless defined(&REQ_DRIVE_TASK);
    eval 'sub REQ_DRIVE_TASKFILE {(1<<  &__REQ_DRIVE_TASKFILE);}' unless defined(&REQ_DRIVE_TASKFILE);
    eval 'sub REQ_PREEMPT {(1<<  &__REQ_PREEMPT);}' unless defined(&REQ_PREEMPT);
    eval 'sub REQ_PM_SUSPEND {(1<<  &__REQ_PM_SUSPEND);}' unless defined(&REQ_PM_SUSPEND);
    eval 'sub REQ_PM_RESUME {(1<<  &__REQ_PM_RESUME);}' unless defined(&REQ_PM_RESUME);
    eval 'sub REQ_PM_SHUTDOWN {(1<<  &__REQ_PM_SHUTDOWN);}' unless defined(&REQ_PM_SHUTDOWN);
    eval 'sub REQ_ORDERED_COLOR {(1<<  &__REQ_ORDERED_COLOR);}' unless defined(&REQ_ORDERED_COLOR);
    require 'linux/elevator.ph';
    eval("sub Queue_down () { 0; }") unless defined(&Queue_down);
    eval("sub Queue_up () { 1; }") unless defined(&Queue_up);
    eval 'sub RQ_INACTIVE {(-1);}' unless defined(&RQ_INACTIVE);
    eval 'sub RQ_ACTIVE {1;}' unless defined(&RQ_ACTIVE);
    eval 'sub RQ_SCSI_BUSY {0xffff;}' unless defined(&RQ_SCSI_BUSY);
    eval 'sub RQ_SCSI_DONE {0xfffe;}' unless defined(&RQ_SCSI_DONE);
    eval 'sub RQ_SCSI_DISCONNECTING {0xffe0;}' unless defined(&RQ_SCSI_DISCONNECTING);
    eval 'sub QUEUE_FLAG_CLUSTER {0;}' unless defined(&QUEUE_FLAG_CLUSTER);
    eval 'sub QUEUE_FLAG_QUEUED {1;}' unless defined(&QUEUE_FLAG_QUEUED);
    eval 'sub QUEUE_FLAG_STOPPED {2;}' unless defined(&QUEUE_FLAG_STOPPED);
    eval 'sub QUEUE_FLAG_READFULL {3;}' unless defined(&QUEUE_FLAG_READFULL);
    eval 'sub QUEUE_FLAG_WRITEFULL {4;}' unless defined(&QUEUE_FLAG_WRITEFULL);
    eval 'sub QUEUE_FLAG_DEAD {5;}' unless defined(&QUEUE_FLAG_DEAD);
    eval 'sub QUEUE_FLAG_REENTER {6;}' unless defined(&QUEUE_FLAG_REENTER);
    eval 'sub QUEUE_FLAG_PLUGGED {7;}' unless defined(&QUEUE_FLAG_PLUGGED);
    eval 'sub QUEUE_FLAG_ELVSWITCH {8;}' unless defined(&QUEUE_FLAG_ELVSWITCH);
    eval("sub QUEUE_ORDERED_NONE () { 0x00; }") unless defined(&QUEUE_ORDERED_NONE);
    eval("sub QUEUE_ORDERED_DRAIN () { 0x01; }") unless defined(&QUEUE_ORDERED_DRAIN);
    eval("sub QUEUE_ORDERED_TAG () { 0x02; }") unless defined(&QUEUE_ORDERED_TAG);
    eval("sub QUEUE_ORDERED_PREFLUSH () { 0x10; }") unless defined(&QUEUE_ORDERED_PREFLUSH);
    eval("sub QUEUE_ORDERED_POSTFLUSH () { 0x20; }") unless defined(&QUEUE_ORDERED_POSTFLUSH);
    eval("sub QUEUE_ORDERED_FUA () { 0x40; }") unless defined(&QUEUE_ORDERED_FUA);
    eval("sub QUEUE_ORDERED_DRAIN_FLUSH () { QUEUE_ORDERED_DRAIN|QUEUE_ORDERED_PREFLUSH|QUEUE_ORDERED_POSTFLUSH; }") unless defined(&QUEUE_ORDERED_DRAIN_FLUSH);
    eval("sub QUEUE_ORDERED_DRAIN_FUA () { QUEUE_ORDERED_DRAIN|QUEUE_ORDERED_PREFLUSH|QUEUE_ORDERED_FUA; }") unless defined(&QUEUE_ORDERED_DRAIN_FUA);
    eval("sub QUEUE_ORDERED_TAG_FLUSH () { QUEUE_ORDERED_TAG|QUEUE_ORDERED_PREFLUSH|QUEUE_ORDERED_POSTFLUSH; }") unless defined(&QUEUE_ORDERED_TAG_FLUSH);
    eval("sub QUEUE_ORDERED_TAG_FUA () { QUEUE_ORDERED_TAG|QUEUE_ORDERED_PREFLUSH|QUEUE_ORDERED_FUA; }") unless defined(&QUEUE_ORDERED_TAG_FUA);
    eval("sub QUEUE_ORDSEQ_STARTED () { 0x01; }") unless defined(&QUEUE_ORDSEQ_STARTED);
    eval("sub QUEUE_ORDSEQ_DRAIN () { 0x02; }") unless defined(&QUEUE_ORDSEQ_DRAIN);
    eval("sub QUEUE_ORDSEQ_PREFLUSH () { 0x04; }") unless defined(&QUEUE_ORDSEQ_PREFLUSH);
    eval("sub QUEUE_ORDSEQ_BAR () { 0x08; }") unless defined(&QUEUE_ORDSEQ_BAR);
    eval("sub QUEUE_ORDSEQ_POSTFLUSH () { 0x10; }") unless defined(&QUEUE_ORDSEQ_POSTFLUSH);
    eval("sub QUEUE_ORDSEQ_DONE () { 0x20; }") unless defined(&QUEUE_ORDSEQ_DONE);
    eval 'sub blk_queue_plugged {
        my($q) = @_;
	    eval q( &test_bit( &QUEUE_FLAG_PLUGGED, ($q)-> &queue_flags));
    }' unless defined(&blk_queue_plugged);
    eval 'sub blk_queue_tagged {
        my($q) = @_;
	    eval q( &test_bit( &QUEUE_FLAG_QUEUED, ($q)-> &queue_flags));
    }' unless defined(&blk_queue_tagged);
    eval 'sub blk_queue_stopped {
        my($q) = @_;
	    eval q( &test_bit( &QUEUE_FLAG_STOPPED, ($q)-> &queue_flags));
    }' unless defined(&blk_queue_stopped);
    eval 'sub blk_queue_flushing {
        my($q) = @_;
	    eval q((($q)-> &ordseq));
    }' unless defined(&blk_queue_flushing);
    eval 'sub blk_fs_request {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_CMD));
    }' unless defined(&blk_fs_request);
    eval 'sub blk_pc_request {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_BLOCK_PC));
    }' unless defined(&blk_pc_request);
    eval 'sub blk_noretry_request {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_FAILFAST));
    }' unless defined(&blk_noretry_request);
    eval 'sub blk_rq_started {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_STARTED));
    }' unless defined(&blk_rq_started);
    eval 'sub blk_account_rq {
        my($rq) = @_;
	    eval q(( &blk_rq_started($rq)  &&  &blk_fs_request($rq)));
    }' unless defined(&blk_account_rq);
    eval 'sub blk_pm_suspend_request {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_PM_SUSPEND));
    }' unless defined(&blk_pm_suspend_request);
    eval 'sub blk_pm_resume_request {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_PM_RESUME));
    }' unless defined(&blk_pm_resume_request);
    eval 'sub blk_pm_request {
        my($rq) = @_;
	    eval q((($rq)-> &flags & ( &REQ_PM_SUSPEND |  &REQ_PM_RESUME)));
    }' unless defined(&blk_pm_request);
    eval 'sub blk_sorted_rq {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_SORTED));
    }' unless defined(&blk_sorted_rq);
    eval 'sub blk_barrier_rq {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_HARDBARRIER));
    }' unless defined(&blk_barrier_rq);
    eval 'sub blk_fua_rq {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_FUA));
    }' unless defined(&blk_fua_rq);
    eval 'sub list_entry_rq {
        my($ptr) = @_;
	    eval q( &list_entry(($ptr), \'struct request\',  &queuelist));
    }' unless defined(&list_entry_rq);
    eval 'sub rq_data_dir {
        my($rq) = @_;
	    eval q((($rq)-> &flags & 1));
    }' unless defined(&rq_data_dir);
    eval 'sub blk_queue_full {
        my($q,$rw) = @_;
	    eval q({  &if ($rw ==  &READ)  &test_bit( &QUEUE_FLAG_READFULL,  ($q->{queue_flags}));  &test_bit( &QUEUE_FLAG_WRITEFULL,  ($q->{queue_flags})); });
    }' unless defined(&blk_queue_full);
    eval 'sub blk_set_queue_full {
        my($q,$rw) = @_;
	    eval q({  &if ($rw ==  &READ)  &set_bit( &QUEUE_FLAG_READFULL,  ($q->{queue_flags}));  &else  &set_bit( &QUEUE_FLAG_WRITEFULL,  ($q->{queue_flags})); });
    }' unless defined(&blk_set_queue_full);
    eval 'sub blk_clear_queue_full {
        my($q,$rw) = @_;
	    eval q({  &if ($rw ==  &READ)  &clear_bit( &QUEUE_FLAG_READFULL,  ($q->{queue_flags}));  &else  &clear_bit( &QUEUE_FLAG_WRITEFULL,  ($q->{queue_flags})); });
    }' unless defined(&blk_clear_queue_full);
    eval 'sub RQ_NOMERGE_FLAGS {( &REQ_NOMERGE |  &REQ_STARTED |  &REQ_HARDBARRIER |  &REQ_SOFTBARRIER);}' unless defined(&RQ_NOMERGE_FLAGS);
    eval 'sub rq_mergeable {
        my($rq) = @_;
	    eval q((!(($rq)-> &flags &  &RQ_NOMERGE_FLAGS)  &&  &blk_fs_request(($rq))));
    }' unless defined(&rq_mergeable);
    eval 'sub blk_queue_headactive {
        my($q, $head_active) = @_;
	    eval q();
    }' unless defined(&blk_queue_headactive);
    eval 'sub BLKPREP_OK {0;}' unless defined(&BLKPREP_OK);
    eval 'sub BLKPREP_KILL {1;}' unless defined(&BLKPREP_KILL);
    eval 'sub BLKPREP_DEFER {2;}' unless defined(&BLKPREP_DEFER);
    eval 'sub BLK_BOUNCE_HIGH {(( &u64) &blk_max_low_pfn <<  &PAGE_SHIFT);}' unless defined(&BLK_BOUNCE_HIGH);
    eval 'sub BLK_BOUNCE_ANY {(( &u64) &blk_max_pfn <<  &PAGE_SHIFT);}' unless defined(&BLK_BOUNCE_ANY);
    eval 'sub BLK_BOUNCE_ISA {( &ISA_DMA_THRESHOLD);}' unless defined(&BLK_BOUNCE_ISA);
    if(defined(&CONFIG_MMU)) {
    } else {
	eval 'sub init_emergency_isa_pool {
	    my($void) = @_;
    	    eval q({ 0; });
	}' unless defined(&init_emergency_isa_pool);
	eval 'sub blk_queue_bounce {
	    my($q,$bio) = @_;
    	    eval q({ });
	}' unless defined(&blk_queue_bounce);
    }
    eval 'sub rq_for_each_bio {
        my($_bio, $rq) = @_;
	    eval q( &if (( ($rq->{bio})))  &for ($_bio = ($rq)-> &bio; $_bio; $_bio =  ($_bio->{bi_next})));
    }' unless defined(&rq_for_each_bio);
    eval 'sub request_queue_t {
        eval q(* &bdev_get_queue(\'struct block_device\' * &bdev) {  ($bdev->{bd_disk}->{queue}); });
    }' unless defined(&request_queue_t);
    eval 'sub blk_run_backing_dev {
        my($bdi,$page) = @_;
	    eval q({  &if ($bdi  &&  ($bdi->{unplug_io_fn}))  ($bdi->{unplug_io_fn})($bdi, $page); });
    }' unless defined(&blk_run_backing_dev);
    eval 'sub blk_run_address_space {
        my($mapping) = @_;
	    eval q({  &if ($mapping)  &blk_run_backing_dev( ($mapping->{backing_dev_info}),  &NULL); });
    }' unless defined(&blk_run_address_space);
    eval 'sub rq_all_done {
        my($rq,$nr_bytes) = @_;
	    eval q({  &if ( &blk_fs_request($rq)) ($nr_bytes >= ( ($rq->{hard_nr_sectors}) << 9));  &else  &if ( &blk_pc_request($rq)) $nr_bytes >=  ($rq->{data_len}); 0; });
    }' unless defined(&rq_all_done);
    eval 'sub end_io_error {
        my($uptodate) = @_;
	    eval q(( &unlikely(($uptodate) <= 0)));
    }' unless defined(&end_io_error);
    eval 'sub blkdev_dequeue_request {
        my($req) = @_;
	    eval q({  &elv_dequeue_request( ($req->{q}), $req); });
    }' unless defined(&blkdev_dequeue_request);
    eval 'sub blk_put_queue {
        my($q) = @_;
	    eval q( &blk_cleanup_queue(($q)));
    }' unless defined(&blk_put_queue);
    eval 'sub blk_queue_tag_depth {
        my($q) = @_;
	    eval q((($q)-> ($queue_tags->{busy})));
    }' unless defined(&blk_queue_tag_depth);
    eval 'sub blk_queue_tag_queue {
        my($q) = @_;
	    eval q((($q)-> ($queue_tags->{busy}) < ($q)-> ($queue_tags->{max_depth})));
    }' unless defined(&blk_queue_tag_queue);
    eval 'sub blk_rq_tagged {
        my($rq) = @_;
	    eval q((($rq)-> &flags &  &REQ_QUEUED));
    }' unless defined(&blk_rq_tagged);
    eval 'sub MAX_PHYS_SEGMENTS {128;}' unless defined(&MAX_PHYS_SEGMENTS);
    eval 'sub MAX_HW_SEGMENTS {128;}' unless defined(&MAX_HW_SEGMENTS);
    eval 'sub SAFE_MAX_SECTORS {255;}' unless defined(&SAFE_MAX_SECTORS);
    eval 'sub BLK_DEF_MAX_SECTORS {1024;}' unless defined(&BLK_DEF_MAX_SECTORS);
    eval 'sub MAX_SEGMENT_SIZE {65536;}' unless defined(&MAX_SEGMENT_SIZE);
    eval 'sub blkdev_entry_to_request {
        my($entry) = @_;
	    eval q( &list_entry(($entry), \'struct request\',  &queuelist));
    }' unless defined(&blkdev_entry_to_request);
    eval 'sub queue_hardsect_size {
        my($q) = @_;
	    eval q({ \'int\'  &retval = 512;  &if ($q  &&  ($q->{hardsect_size}))  &retval =  ($q->{hardsect_size});  &retval; });
    }' unless defined(&queue_hardsect_size);
    eval 'sub bdev_hardsect_size {
        my($bdev) = @_;
	    eval q({  &queue_hardsect_size( &bdev_get_queue($bdev)); });
    }' unless defined(&bdev_hardsect_size);
    eval 'sub queue_dma_alignment {
        my($q) = @_;
	    eval q({ \'int\'  &retval = 511;  &if ($q  &&  ($q->{dma_alignment}))  &retval =  ($q->{dma_alignment});  &retval; });
    }' unless defined(&queue_dma_alignment);
    eval 'sub bdev_dma_aligment {
        my($bdev) = @_;
	    eval q({  &queue_dma_alignment( &bdev_get_queue($bdev)); });
    }' unless defined(&bdev_dma_aligment);
    eval 'sub blk_finished_io {
        my($nsects) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&blk_finished_io);
    eval 'sub blk_started_io {
        my($nsects) = @_;
	    eval q( &do { }  &while (0));
    }' unless defined(&blk_started_io);
    eval 'sub block_size {
        my($bdev) = @_;
	    eval q({  ($bdev->{bd_block_size}); });
    }' unless defined(&block_size);
    eval 'sub put_dev_sector {
        my($p) = @_;
	    eval q({  &page_cache_release( ($p->{v})); });
    }' unless defined(&put_dev_sector);
    if(defined(&CONFIG_LBD)) {
	require 'asm/div64.ph';
	eval 'sub sector_div {
	    my($a, $b) = @_;
    	    eval q( &do_div($a, $b));
	}' unless defined(&sector_div);
    } else {
	eval 'sub sector_div {
	    my($n, $b) = @_;
    	    eval q(( { \'int\'  &_res;  &_res = ($n) % ($b); ($n) /= ($b);  &_res; } ));
	}' unless defined(&sector_div);
    }
    eval 'sub MODULE_ALIAS_BLOCKDEV {
        my($major,$minor) = @_;
	    eval q( &MODULE_ALIAS(\\"block-major-\\"  &__stringify($major) \\"-\\"  &__stringify($minor)));
    }' unless defined(&MODULE_ALIAS_BLOCKDEV);
    eval 'sub MODULE_ALIAS_BLOCKDEV_MAJOR {
        my($major) = @_;
	    eval q( &MODULE_ALIAS(\\"block-major-\\"  &__stringify($major) \\"-*\\"));
    }' unless defined(&MODULE_ALIAS_BLOCKDEV_MAJOR);
}
1;
