require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_DCCP_H)) {
    eval 'sub _LINUX_DCCP_H {1;}' unless defined(&_LINUX_DCCP_H);
    require 'linux/types.ph';
    require 'asm/byteorder.ph';
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Adjust your <asm/byteorder.h> defines");
    }
    if(defined( &__LITTLE_ENDIAN_BITFIELD)) {
    }
 elsif(defined( &__BIG_ENDIAN_BITFIELD)) {
    } else {
	die("Adjust your <asm/byteorder.h> defines");
    }
    eval("sub DCCP_PKT_REQUEST () { 0; }") unless defined(&DCCP_PKT_REQUEST);
    eval("sub DCCP_PKT_RESPONSE () { 1; }") unless defined(&DCCP_PKT_RESPONSE);
    eval("sub DCCP_PKT_DATA () { 2; }") unless defined(&DCCP_PKT_DATA);
    eval("sub DCCP_PKT_ACK () { 3; }") unless defined(&DCCP_PKT_ACK);
    eval("sub DCCP_PKT_DATAACK () { 4; }") unless defined(&DCCP_PKT_DATAACK);
    eval("sub DCCP_PKT_CLOSEREQ () { 5; }") unless defined(&DCCP_PKT_CLOSEREQ);
    eval("sub DCCP_PKT_CLOSE () { 6; }") unless defined(&DCCP_PKT_CLOSE);
    eval("sub DCCP_PKT_RESET () { 7; }") unless defined(&DCCP_PKT_RESET);
    eval("sub DCCP_PKT_SYNC () { 8; }") unless defined(&DCCP_PKT_SYNC);
    eval("sub DCCP_PKT_SYNCACK () { 9; }") unless defined(&DCCP_PKT_SYNCACK);
    eval("sub DCCP_PKT_INVALID () { 10; }") unless defined(&DCCP_PKT_INVALID);
    eval 'sub DCCP_NR_PKT_TYPES { &DCCP_PKT_INVALID;}' unless defined(&DCCP_NR_PKT_TYPES);
    eval 'sub dccp_packet_hdr_len {
        my($type) = @_;
	    eval q({  &if ($type ==  &DCCP_PKT_DATA) 0;  &if ($type ==  &DCCP_PKT_DATAACK || $type ==  &DCCP_PKT_ACK || $type ==  &DCCP_PKT_SYNC || $type ==  &DCCP_PKT_SYNCACK || $type ==  &DCCP_PKT_CLOSE || $type ==  &DCCP_PKT_CLOSEREQ) $sizeof{\'struct dccp_hdr_ack_bits\'};  &if ($type ==  &DCCP_PKT_REQUEST) $sizeof{\'struct dccp_hdr_request\'};  &if ($type ==  &DCCP_PKT_RESPONSE) $sizeof{\'struct dccp_hdr_response\'}; $sizeof{\'struct dccp_hdr_reset\'}; });
    }' unless defined(&dccp_packet_hdr_len);
    eval("sub DCCP_RESET_CODE_UNSPECIFIED () { 0; }") unless defined(&DCCP_RESET_CODE_UNSPECIFIED);
    eval("sub DCCP_RESET_CODE_CLOSED () { 1; }") unless defined(&DCCP_RESET_CODE_CLOSED);
    eval("sub DCCP_RESET_CODE_ABORTED () { 2; }") unless defined(&DCCP_RESET_CODE_ABORTED);
    eval("sub DCCP_RESET_CODE_NO_CONNECTION () { 3; }") unless defined(&DCCP_RESET_CODE_NO_CONNECTION);
    eval("sub DCCP_RESET_CODE_PACKET_ERROR () { 4; }") unless defined(&DCCP_RESET_CODE_PACKET_ERROR);
    eval("sub DCCP_RESET_CODE_OPTION_ERROR () { 5; }") unless defined(&DCCP_RESET_CODE_OPTION_ERROR);
    eval("sub DCCP_RESET_CODE_MANDATORY_ERROR () { 6; }") unless defined(&DCCP_RESET_CODE_MANDATORY_ERROR);
    eval("sub DCCP_RESET_CODE_CONNECTION_REFUSED () { 7; }") unless defined(&DCCP_RESET_CODE_CONNECTION_REFUSED);
    eval("sub DCCP_RESET_CODE_BAD_SERVICE_CODE () { 8; }") unless defined(&DCCP_RESET_CODE_BAD_SERVICE_CODE);
    eval("sub DCCP_RESET_CODE_TOO_BUSY () { 9; }") unless defined(&DCCP_RESET_CODE_TOO_BUSY);
    eval("sub DCCP_RESET_CODE_BAD_INIT_COOKIE () { 10; }") unless defined(&DCCP_RESET_CODE_BAD_INIT_COOKIE);
    eval("sub DCCP_RESET_CODE_AGGRESSION_PENALTY () { 11; }") unless defined(&DCCP_RESET_CODE_AGGRESSION_PENALTY);
    eval("sub DCCPO_PADDING () { 0; }") unless defined(&DCCPO_PADDING);
    eval("sub DCCPO_MANDATORY () { 1; }") unless defined(&DCCPO_MANDATORY);
    eval("sub DCCPO_MIN_RESERVED () { 3; }") unless defined(&DCCPO_MIN_RESERVED);
    eval("sub DCCPO_MAX_RESERVED () { 31; }") unless defined(&DCCPO_MAX_RESERVED);
    eval("sub DCCPO_NDP_COUNT () { 37; }") unless defined(&DCCPO_NDP_COUNT);
    eval("sub DCCPO_ACK_VECTOR_0 () { 38; }") unless defined(&DCCPO_ACK_VECTOR_0);
    eval("sub DCCPO_ACK_VECTOR_1 () { 39; }") unless defined(&DCCPO_ACK_VECTOR_1);
    eval("sub DCCPO_TIMESTAMP () { 41; }") unless defined(&DCCPO_TIMESTAMP);
    eval("sub DCCPO_TIMESTAMP_ECHO () { 42; }") unless defined(&DCCPO_TIMESTAMP_ECHO);
    eval("sub DCCPO_ELAPSED_TIME () { 43; }") unless defined(&DCCPO_ELAPSED_TIME);
    eval("sub DCCPO_MAX () { 45; }") unless defined(&DCCPO_MAX);
    eval("sub DCCPO_MIN_CCID_SPECIFIC () { 128; }") unless defined(&DCCPO_MIN_CCID_SPECIFIC);
    eval("sub DCCPO_MAX_CCID_SPECIFIC () { 255; }") unless defined(&DCCPO_MAX_CCID_SPECIFIC);
    eval("sub DCCPF_RESERVED () { 0; }") unless defined(&DCCPF_RESERVED);
    eval("sub DCCPF_SEQUENCE_WINDOW () { 3; }") unless defined(&DCCPF_SEQUENCE_WINDOW);
    eval("sub DCCPF_SEND_ACK_VECTOR () { 6; }") unless defined(&DCCPF_SEND_ACK_VECTOR);
    eval("sub DCCPF_SEND_NDP_COUNT () { 7; }") unless defined(&DCCPF_SEND_NDP_COUNT);
    eval("sub DCCPF_MIN_CCID_SPECIFIC () { 128; }") unless defined(&DCCPF_MIN_CCID_SPECIFIC);
    eval("sub DCCPF_MAX_CCID_SPECIFIC () { 255; }") unless defined(&DCCPF_MAX_CCID_SPECIFIC);
    eval 'sub DCCP_SOCKOPT_PACKET_SIZE {1;}' unless defined(&DCCP_SOCKOPT_PACKET_SIZE);
    eval 'sub DCCP_SOCKOPT_SERVICE {2;}' unless defined(&DCCP_SOCKOPT_SERVICE);
    eval 'sub DCCP_SOCKOPT_CCID_RX_INFO {128;}' unless defined(&DCCP_SOCKOPT_CCID_RX_INFO);
    eval 'sub DCCP_SOCKOPT_CCID_TX_INFO {192;}' unless defined(&DCCP_SOCKOPT_CCID_TX_INFO);
    eval 'sub DCCP_SERVICE_LIST_MAX_LEN {32;}' unless defined(&DCCP_SERVICE_LIST_MAX_LEN);
    if(defined(&__KERNEL__)) {
	require 'linux/in.ph';
	require 'linux/list.ph';
	require 'linux/uio.ph';
	require 'linux/workqueue.ph';
	require 'net/inet_connection_sock.ph';
	require 'net/inet_sock.ph';
	require 'net/inet_timewait_sock.ph';
	require 'net/tcp_states.ph';
	eval("sub DCCP_OPEN () { TCP_ESTABLISHED; }") unless defined(&DCCP_OPEN);
	eval("sub DCCP_REQUESTING () { TCP_SYN_SENT; }") unless defined(&DCCP_REQUESTING);
	eval("sub DCCP_PARTOPEN () { TCP_FIN_WAIT1; }") unless defined(&DCCP_PARTOPEN);
	eval("sub DCCP_LISTEN () { TCP_LISTEN; }") unless defined(&DCCP_LISTEN);
	eval("sub DCCP_RESPOND () { TCP_SYN_RECV; }") unless defined(&DCCP_RESPOND);
	eval("sub DCCP_CLOSING () { TCP_CLOSING; }") unless defined(&DCCP_CLOSING);
	eval("sub DCCP_TIME_WAIT () { TCP_TIME_WAIT; }") unless defined(&DCCP_TIME_WAIT);
	eval("sub DCCP_CLOSED () { TCP_CLOSE; }") unless defined(&DCCP_CLOSED);
	eval("sub DCCP_MAX_STATES () { TCP_MAX_STATES; }") unless defined(&DCCP_MAX_STATES);
	eval 'sub DCCP_STATE_MASK {0xf;}' unless defined(&DCCP_STATE_MASK);
	eval 'sub DCCP_ACTION_FIN {(1<<7);}' unless defined(&DCCP_ACTION_FIN);
	eval("sub DCCPF_OPEN () { TCPF_ESTABLISHED; }") unless defined(&DCCPF_OPEN);
	eval("sub DCCPF_REQUESTING () { TCPF_SYN_SENT; }") unless defined(&DCCPF_REQUESTING);
	eval("sub DCCPF_PARTOPEN () { TCPF_FIN_WAIT1; }") unless defined(&DCCPF_PARTOPEN);
	eval("sub DCCPF_LISTEN () { TCPF_LISTEN; }") unless defined(&DCCPF_LISTEN);
	eval("sub DCCPF_RESPOND () { TCPF_SYN_RECV; }") unless defined(&DCCPF_RESPOND);
	eval("sub DCCPF_CLOSING () { TCPF_CLOSING; }") unless defined(&DCCPF_CLOSING);
	eval("sub DCCPF_TIME_WAIT () { TCPF_TIME_WAIT; }") unless defined(&DCCPF_TIME_WAIT);
	eval("sub DCCPF_CLOSED () { TCPF_CLOSE; }") unless defined(&DCCPF_CLOSED);
	eval 'sub dccp_hdr {
	    eval q(* &dccp_hdr( &const \'struct sk_buff\' * &skb) {  ($skb->{h}->{raw}); });
	}' unless defined(&dccp_hdr);
	eval 'sub dccp_hdr_ext {
	    eval q(* &dccp_hdrx( &const \'struct sk_buff\' * &skb) { ( ($skb->{h}->{raw}) + $sizeof{\'struct dccp_hdr\'}); });
	}' unless defined(&dccp_hdr_ext);
	eval 'sub __dccp_basic_hdr_len {
	    my($dh) = @_;
    	    eval q({ $sizeof{$dh} + ( ($dh->{dccph_x}) ? $sizeof{\'struct dccp_hdr_ext\'} : 0); });
	}' unless defined(&__dccp_basic_hdr_len);
	eval 'sub dccp_basic_hdr_len {
	    my($skb) = @_;
    	    eval q({  &const \'struct dccp_hdr\' * &dh =  &dccp_hdr($skb);  &__dccp_basic_hdr_len( &dh); });
	}' unless defined(&dccp_basic_hdr_len);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub dccp_hdr_seq {
	    my($skb) = @_;
    	    eval q({  &const \'struct dccp_hdr\' * &dh =  &dccp_hdr($skb);  &if ( ($dh->{dccph_x}) != 0)  &seq_nr = ( &seq_nr << 32) +  &ntohl( &dccp_hdrx($skb)-> &dccph_seq_low);  &seq_nr; });
	}' unless defined(&dccp_hdr_seq);
	eval 'sub dccp_hdr_request {
	    eval q(* &dccp_hdr_request(\'struct sk_buff\' * &skb) { ( ($skb->{h}->{raw}) +  &dccp_basic_hdr_len( &skb)); });
	}' unless defined(&dccp_hdr_request);
	eval 'sub dccp_hdr_ack_bits {
	    eval q(* &dccp_hdr_ack_bits( &const \'struct sk_buff\' * &skb) { ( ($skb->{h}->{raw}) +  &dccp_basic_hdr_len( &skb)); });
	}' unless defined(&dccp_hdr_ack_bits);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub dccp_hdr_ack_seq {
	    my($skb) = @_;
    	    eval q({  &const \'struct dccp_hdr_ack_bits\' * &dhack =  &dccp_hdr_ack_bits($skb); });
	}' unless defined(&dccp_hdr_ack_seq);
	eval 'sub dccp_hdr_response {
	    eval q(* &dccp_hdr_response(\'struct sk_buff\' * &skb) { ( ($skb->{h}->{raw}) +  &dccp_basic_hdr_len( &skb)); });
	}' unless defined(&dccp_hdr_response);
	eval 'sub dccp_hdr_reset {
	    eval q(* &dccp_hdr_reset(\'struct sk_buff\' * &skb) { ( ($skb->{h}->{raw}) +  &dccp_basic_hdr_len( &skb)); });
	}' unless defined(&dccp_hdr_reset);
	eval 'sub __dccp_hdr_len {
	    my($dh) = @_;
    	    eval q({  &__dccp_basic_hdr_len($dh) +  &dccp_packet_hdr_len( ($dh->{dccph_type})); });
	}' unless defined(&__dccp_hdr_len);
	eval 'sub dccp_hdr_len {
	    my($skb) = @_;
    	    eval q({  &__dccp_hdr_len( &dccp_hdr($skb)); });
	}' unless defined(&dccp_hdr_len);
	eval 'sub DCCPF_INITIAL_SEQUENCE_WINDOW {100;}' unless defined(&DCCPF_INITIAL_SEQUENCE_WINDOW);
	eval 'sub DCCPF_INITIAL_CCID {3;}' unless defined(&DCCPF_INITIAL_CCID);
	eval 'sub DCCPF_INITIAL_SEND_ACK_VECTOR {0;}' unless defined(&DCCPF_INITIAL_SEND_ACK_VECTOR);
	eval 'sub DCCPF_INITIAL_SEND_NDP_COUNT {1;}' unless defined(&DCCPF_INITIAL_SEND_NDP_COUNT);
	eval 'sub DCCP_NDP_LIMIT {0xffffff;}' unless defined(&DCCP_NDP_LIMIT);
	eval 'sub dccp_request_sock {
	    eval q(* &dccp_rsk( &const \'struct request_sock\' * &req) {  &req; });
	}' unless defined(&dccp_request_sock);
	eval("sub DCCP_ROLE_UNDEFINED () { 0; }") unless defined(&DCCP_ROLE_UNDEFINED);
	eval("sub DCCP_ROLE_LISTEN () { 1; }") unless defined(&DCCP_ROLE_LISTEN);
	eval("sub DCCP_ROLE_CLIENT () { 2; }") unless defined(&DCCP_ROLE_CLIENT);
	eval("sub DCCP_ROLE_SERVER () { 3; }") unless defined(&DCCP_ROLE_SERVER);
	eval 'sub DCCP_SERVICE_INVALID_VALUE { &htonl(( &__u32)-1);}' unless defined(&DCCP_SERVICE_INVALID_VALUE);
	eval 'sub dccp_list_has_service {
	    my($sl,$service) = @_;
    	    eval q({  &if ( &likely($sl !=  &NULL)) {  &u32  &i =  ($sl->{dccpsl_nr});  &while ( &i--)  &if ( ($sl->{dccpsl_list[&i]}) == $service) 1; } 0; });
	}' unless defined(&dccp_list_has_service);
	eval 'sub dccp_service_not_initialized {
	    my($sk) = @_;
    	    eval q({  &dccp_sk($sk)-> &dccps_service ==  &DCCP_SERVICE_INVALID_VALUE; });
	}' unless defined(&dccp_service_not_initialized);
	eval 'sub char {
	    eval q(* &dccp_role( &const \'struct sock\' * &sk) {  &switch ( &dccp_sk( &sk)-> &dccps_role) {  &case  &DCCP_ROLE_UNDEFINED: \\"undefined\\";  &case  &DCCP_ROLE_LISTEN: \\"listen\\";  &case  &DCCP_ROLE_SERVER: \\"server\\";  &case  &DCCP_ROLE_CLIENT: \\"client\\"; }  &NULL; });
	}' unless defined(&char);
    }
}
1;
