require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_EFI_H)) {
    eval 'sub _LINUX_EFI_H {1;}' unless defined(&_LINUX_EFI_H);
    require 'linux/init.ph';
    require 'linux/string.ph';
    require 'linux/time.ph';
    require 'linux/types.ph';
    require 'linux/proc_fs.ph';
    require 'linux/rtc.ph';
    require 'linux/ioport.ph';
    require 'asm/page.ph';
    require 'asm/system.ph';
    eval 'sub EFI_SUCCESS {0;}' unless defined(&EFI_SUCCESS);
    eval 'sub EFI_LOAD_ERROR {( 1| (1 << ( &BITS_PER_LONG-1)));}' unless defined(&EFI_LOAD_ERROR);
    eval 'sub EFI_INVALID_PARAMETER {( 2| (1 << ( &BITS_PER_LONG-1)));}' unless defined(&EFI_INVALID_PARAMETER);
    eval 'sub EFI_UNSUPPORTED {( 3| (1 << ( &BITS_PER_LONG-1)));}' unless defined(&EFI_UNSUPPORTED);
    eval 'sub EFI_BAD_BUFFER_SIZE {( 4| (1 << ( &BITS_PER_LONG-1)));}' unless defined(&EFI_BAD_BUFFER_SIZE);
    eval 'sub EFI_BUFFER_TOO_SMALL {( 5| (1 << ( &BITS_PER_LONG-1)));}' unless defined(&EFI_BUFFER_TOO_SMALL);
    eval 'sub EFI_NOT_FOUND {(14| (1 << ( &BITS_PER_LONG-1)));}' unless defined(&EFI_NOT_FOUND);
    eval 'sub EFI_GUID {
        my($a,$b,$c,$d0,$d1,$d2,$d3,$d4,$d5,$d6,$d7) = @_;
	    eval q((( &efi_guid_t) {{ ($a) & 0xff, (($a) >> 8) & 0xff, (($a) >> 16) & 0xff, (($a) >> 24) & 0xff, ($b) & 0xff, (($b) >> 8) & 0xff, ($c) & 0xff, (($c) >> 8) & 0xff, ($d0), ($d1), ($d2), ($d3), ($d4), ($d5), ($d6), ($d7) }}));
    }' unless defined(&EFI_GUID);
    eval 'sub EFI_RESERVED_TYPE {0;}' unless defined(&EFI_RESERVED_TYPE);
    eval 'sub EFI_LOADER_CODE {1;}' unless defined(&EFI_LOADER_CODE);
    eval 'sub EFI_LOADER_DATA {2;}' unless defined(&EFI_LOADER_DATA);
    eval 'sub EFI_BOOT_SERVICES_CODE {3;}' unless defined(&EFI_BOOT_SERVICES_CODE);
    eval 'sub EFI_BOOT_SERVICES_DATA {4;}' unless defined(&EFI_BOOT_SERVICES_DATA);
    eval 'sub EFI_RUNTIME_SERVICES_CODE {5;}' unless defined(&EFI_RUNTIME_SERVICES_CODE);
    eval 'sub EFI_RUNTIME_SERVICES_DATA {6;}' unless defined(&EFI_RUNTIME_SERVICES_DATA);
    eval 'sub EFI_CONVENTIONAL_MEMORY {7;}' unless defined(&EFI_CONVENTIONAL_MEMORY);
    eval 'sub EFI_UNUSABLE_MEMORY {8;}' unless defined(&EFI_UNUSABLE_MEMORY);
    eval 'sub EFI_ACPI_RECLAIM_MEMORY {9;}' unless defined(&EFI_ACPI_RECLAIM_MEMORY);
    eval 'sub EFI_ACPI_MEMORY_NVS {10;}' unless defined(&EFI_ACPI_MEMORY_NVS);
    eval 'sub EFI_MEMORY_MAPPED_IO {11;}' unless defined(&EFI_MEMORY_MAPPED_IO);
    eval 'sub EFI_MEMORY_MAPPED_IO_PORT_SPACE {12;}' unless defined(&EFI_MEMORY_MAPPED_IO_PORT_SPACE);
    eval 'sub EFI_PAL_CODE {13;}' unless defined(&EFI_PAL_CODE);
    eval 'sub EFI_MAX_MEMORY_TYPE {14;}' unless defined(&EFI_MAX_MEMORY_TYPE);
    eval 'sub EFI_MEMORY_UC {(( &u64)0x1);}' unless defined(&EFI_MEMORY_UC);
    eval 'sub EFI_MEMORY_WC {(( &u64)0x2);}' unless defined(&EFI_MEMORY_WC);
    eval 'sub EFI_MEMORY_WT {(( &u64)0x4);}' unless defined(&EFI_MEMORY_WT);
    eval 'sub EFI_MEMORY_WB {(( &u64)0x8);}' unless defined(&EFI_MEMORY_WB);
    eval 'sub EFI_MEMORY_WP {(( &u64)0x1000);}' unless defined(&EFI_MEMORY_WP);
    eval 'sub EFI_MEMORY_RP {(( &u64)0x2000);}' unless defined(&EFI_MEMORY_RP);
    eval 'sub EFI_MEMORY_XP {(( &u64)0x4000);}' unless defined(&EFI_MEMORY_XP);
    eval 'sub EFI_MEMORY_RUNTIME {(( &u64)9.22337203685478e+18);}' unless defined(&EFI_MEMORY_RUNTIME);
    eval 'sub EFI_MEMORY_DESCRIPTOR_VERSION {1;}' unless defined(&EFI_MEMORY_DESCRIPTOR_VERSION);
    eval 'sub EFI_PAGE_SHIFT {12;}' unless defined(&EFI_PAGE_SHIFT);
    eval 'sub EFI_TIME_ADJUST_DAYLIGHT {0x1;}' unless defined(&EFI_TIME_ADJUST_DAYLIGHT);
    eval 'sub EFI_TIME_IN_DAYLIGHT {0x2;}' unless defined(&EFI_TIME_IN_DAYLIGHT);
    eval 'sub EFI_UNSPECIFIED_TIMEZONE {0x7ff;}' unless defined(&EFI_UNSPECIFIED_TIMEZONE);
    eval 'sub EFI_RESET_COLD {0;}' unless defined(&EFI_RESET_COLD);
    eval 'sub EFI_RESET_WARM {1;}' unless defined(&EFI_RESET_WARM);
    eval 'sub EFI_RESET_SHUTDOWN {2;}' unless defined(&EFI_RESET_SHUTDOWN);
    eval 'sub EFI_RUNTIME_SERVICES_SIGNATURE {(( &u64)3.88756883152721e+17);}' unless defined(&EFI_RUNTIME_SERVICES_SIGNATURE);
    eval 'sub EFI_RUNTIME_SERVICES_REVISION {0x10000;}' unless defined(&EFI_RUNTIME_SERVICES_REVISION);
    eval 'sub NULL_GUID { &EFI_GUID( 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x );}' unless defined(&NULL_GUID);
    eval 'sub MPS_TABLE_GUID { &EFI_GUID( 0xeb9d2d2f, 0x2d88, 0x11d3, 0x9a, 0x16, 0x, 0x90, 0x27, 0x3f, 0xc1, 0x4d );}' unless defined(&MPS_TABLE_GUID);
    eval 'sub ACPI_TABLE_GUID { &EFI_GUID( 0xeb9d2d30, 0x2d88, 0x11d3, 0x9a, 0x16, 0x, 0x90, 0x27, 0x3f, 0xc1, 0x4d );}' unless defined(&ACPI_TABLE_GUID);
    eval 'sub ACPI_20_TABLE_GUID { &EFI_GUID( 0x8868e871, 0xe4f1, 0x11d3, 0xbc, 0x22, 0x, 0x80, 0xc7, 0x3c, 0x88, 0x81 );}' unless defined(&ACPI_20_TABLE_GUID);
    eval 'sub SMBIOS_TABLE_GUID { &EFI_GUID( 0xeb9d2d31, 0x2d88, 0x11d3, 0x9a, 0x16, 0x, 0x90, 0x27, 0x3f, 0xc1, 0x4d );}' unless defined(&SMBIOS_TABLE_GUID);
    eval 'sub SAL_SYSTEM_TABLE_GUID { &EFI_GUID( 0xeb9d2d32, 0x2d88, 0x11d3, 0x9a, 0x16, 0x, 0x90, 0x27, 0x3f, 0xc1, 0x4d );}' unless defined(&SAL_SYSTEM_TABLE_GUID);
    eval 'sub HCDP_TABLE_GUID { &EFI_GUID( 0xf951938d, 0x620b, 0x42ef, 0x82, 0x79, 0xa8, 0x4b, 0x79, 0x61, 0x78, 0x98 );}' unless defined(&HCDP_TABLE_GUID);
    eval 'sub UGA_IO_PROTOCOL_GUID { &EFI_GUID( 0x61a4d49e, 0x6f68, 0x4f1b, 0xb9, 0x22, 0xa8, 0x6e, 0xed, 0xb, 0x7, 0xa2 );}' unless defined(&UGA_IO_PROTOCOL_GUID);
    eval 'sub EFI_GLOBAL_VARIABLE_GUID { &EFI_GUID( 0x8be4df61, 0x93ca, 0x11d2, 0xaa, 0xd, 0x, 0xe0, 0x98, 0x3, 0x2b, 0x8c );}' unless defined(&EFI_GLOBAL_VARIABLE_GUID);
    eval 'sub EFI_SYSTEM_TABLE_SIGNATURE {(( &u64)6.07629853581176e+18);}' unless defined(&EFI_SYSTEM_TABLE_SIGNATURE);
    eval 'sub EFI_SYSTEM_TABLE_REVISION {((1<< 16) | 00);}' unless defined(&EFI_SYSTEM_TABLE_REVISION);
    eval 'sub efi_guidcmp {
        my($left,$right) = @_;
	    eval q({  &memcmp($left, $right, $sizeof{ &efi_guid_t}); });
    }' unless defined(&efi_guidcmp);
    eval 'sub efi_guid_unparse {
        my($guid,$out) = @_;
	    eval q({  &sprintf($out, \\"%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x\\",  ($guid->{b[3]}),  ($guid->{b[2]}),  ($guid->{b[1]}),  ($guid->{b[0]}),  ($guid->{b[5]}),  ($guid->{b[4]}),  ($guid->{b[7]}),  ($guid->{b[6]}),  ($guid->{b[8]}),  ($guid->{b[9]}),  ($guid->{b[10]}),  ($guid->{b[11]}),  ($guid->{b[12]}),  ($guid->{b[13]}),  ($guid->{b[14]}),  ($guid->{b[15]})); $out; });
    }' unless defined(&efi_guid_unparse);
    if(defined(&CONFIG_EFI_PCDP)) {
    }
    if(defined(&CONFIG_EFI)) {
	if(defined(&CONFIG_X86)) {
	} else {
	    eval 'sub efi_enabled {1;}' unless defined(&efi_enabled);
	}
    } else {
	eval 'sub efi_enabled {0;}' unless defined(&efi_enabled);
    }
    eval 'sub EFI_VARIABLE_NON_VOLATILE {0x1;}' unless defined(&EFI_VARIABLE_NON_VOLATILE);
    eval 'sub EFI_VARIABLE_BOOTSERVICE_ACCESS {0x2;}' unless defined(&EFI_VARIABLE_BOOTSERVICE_ACCESS);
    eval 'sub EFI_VARIABLE_RUNTIME_ACCESS {0x4;}' unless defined(&EFI_VARIABLE_RUNTIME_ACCESS);
    eval 'sub EFI_DEV_HW {0x1;}' unless defined(&EFI_DEV_HW);
    eval 'sub EFI_DEV_PCI {1;}' unless defined(&EFI_DEV_PCI);
    eval 'sub EFI_DEV_PCCARD {2;}' unless defined(&EFI_DEV_PCCARD);
    eval 'sub EFI_DEV_MEM_MAPPED {3;}' unless defined(&EFI_DEV_MEM_MAPPED);
    eval 'sub EFI_DEV_VENDOR {4;}' unless defined(&EFI_DEV_VENDOR);
    eval 'sub EFI_DEV_CONTROLLER {5;}' unless defined(&EFI_DEV_CONTROLLER);
    eval 'sub EFI_DEV_ACPI {0x2;}' unless defined(&EFI_DEV_ACPI);
    eval 'sub EFI_DEV_BASIC_ACPI {1;}' unless defined(&EFI_DEV_BASIC_ACPI);
    eval 'sub EFI_DEV_EXPANDED_ACPI {2;}' unless defined(&EFI_DEV_EXPANDED_ACPI);
    eval 'sub EFI_DEV_MSG {0x3;}' unless defined(&EFI_DEV_MSG);
    eval 'sub EFI_DEV_MSG_ATAPI {1;}' unless defined(&EFI_DEV_MSG_ATAPI);
    eval 'sub EFI_DEV_MSG_SCSI {2;}' unless defined(&EFI_DEV_MSG_SCSI);
    eval 'sub EFI_DEV_MSG_FC {3;}' unless defined(&EFI_DEV_MSG_FC);
    eval 'sub EFI_DEV_MSG_1394 {4;}' unless defined(&EFI_DEV_MSG_1394);
    eval 'sub EFI_DEV_MSG_USB {5;}' unless defined(&EFI_DEV_MSG_USB);
    eval 'sub EFI_DEV_MSG_USB_CLASS {15;}' unless defined(&EFI_DEV_MSG_USB_CLASS);
    eval 'sub EFI_DEV_MSG_I20 {6;}' unless defined(&EFI_DEV_MSG_I20);
    eval 'sub EFI_DEV_MSG_MAC {11;}' unless defined(&EFI_DEV_MSG_MAC);
    eval 'sub EFI_DEV_MSG_IPV4 {12;}' unless defined(&EFI_DEV_MSG_IPV4);
    eval 'sub EFI_DEV_MSG_IPV6 {13;}' unless defined(&EFI_DEV_MSG_IPV6);
    eval 'sub EFI_DEV_MSG_INFINIBAND {9;}' unless defined(&EFI_DEV_MSG_INFINIBAND);
    eval 'sub EFI_DEV_MSG_UART {14;}' unless defined(&EFI_DEV_MSG_UART);
    eval 'sub EFI_DEV_MSG_VENDOR {10;}' unless defined(&EFI_DEV_MSG_VENDOR);
    eval 'sub EFI_DEV_MEDIA {0x4;}' unless defined(&EFI_DEV_MEDIA);
    eval 'sub EFI_DEV_MEDIA_HARD_DRIVE {1;}' unless defined(&EFI_DEV_MEDIA_HARD_DRIVE);
    eval 'sub EFI_DEV_MEDIA_CDROM {2;}' unless defined(&EFI_DEV_MEDIA_CDROM);
    eval 'sub EFI_DEV_MEDIA_VENDOR {3;}' unless defined(&EFI_DEV_MEDIA_VENDOR);
    eval 'sub EFI_DEV_MEDIA_FILE {4;}' unless defined(&EFI_DEV_MEDIA_FILE);
    eval 'sub EFI_DEV_MEDIA_PROTOCOL {5;}' unless defined(&EFI_DEV_MEDIA_PROTOCOL);
    eval 'sub EFI_DEV_BIOS_BOOT {0x5;}' unless defined(&EFI_DEV_BIOS_BOOT);
    eval 'sub EFI_DEV_END_PATH {0x7f;}' unless defined(&EFI_DEV_END_PATH);
    eval 'sub EFI_DEV_END_PATH2 {0xff;}' unless defined(&EFI_DEV_END_PATH2);
    eval 'sub EFI_DEV_END_INSTANCE {0x1;}' unless defined(&EFI_DEV_END_INSTANCE);
    eval 'sub EFI_DEV_END_ENTIRE {0xff;}' unless defined(&EFI_DEV_END_ENTIRE);
}
1;
