require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_EXT3_FS_H)) {
    eval 'sub _LINUX_EXT3_FS_H {1;}' unless defined(&_LINUX_EXT3_FS_H);
    require 'linux/types.ph';
    require 'linux/ext3_fs_i.ph';
    require 'linux/ext3_fs_sb.ph';
    undef(&EXT3FS_DEBUG) if defined(&EXT3FS_DEBUG);
    eval 'sub EXT3_DEFAULT_RESERVE_BLOCKS {8;}' unless defined(&EXT3_DEFAULT_RESERVE_BLOCKS);
    eval 'sub EXT3_MAX_RESERVE_BLOCKS {1024;}' unless defined(&EXT3_MAX_RESERVE_BLOCKS);
    eval 'sub EXT3_RESERVE_WINDOW_NOT_ALLOCATED {0;}' unless defined(&EXT3_RESERVE_WINDOW_NOT_ALLOCATED);
    eval 'sub CONFIG_EXT3_INDEX {1;}' unless defined(&CONFIG_EXT3_INDEX);
    if(defined(&EXT3FS_DEBUG)) {
	eval 'sub ext3_debug {( &f,  &a...)  &do {  &printk ( &KERN_DEBUG "EXT3-fs DEBUG (%s, %d): %s:",  &__FILE__,  &__LINE__,  &__FUNCTION__);  &printk ( &KERN_DEBUG  &f,   &a); }  &while (0);}' unless defined(&ext3_debug);
    } else {
	eval 'sub ext3_debug {( &f,  &a...)  &do {}  &while (0);}' unless defined(&ext3_debug);
    }
    eval 'sub EXT3_BAD_INO {1;}' unless defined(&EXT3_BAD_INO);
    eval 'sub EXT3_ROOT_INO {2;}' unless defined(&EXT3_ROOT_INO);
    eval 'sub EXT3_BOOT_LOADER_INO {5;}' unless defined(&EXT3_BOOT_LOADER_INO);
    eval 'sub EXT3_UNDEL_DIR_INO {6;}' unless defined(&EXT3_UNDEL_DIR_INO);
    eval 'sub EXT3_RESIZE_INO {7;}' unless defined(&EXT3_RESIZE_INO);
    eval 'sub EXT3_JOURNAL_INO {8;}' unless defined(&EXT3_JOURNAL_INO);
    eval 'sub EXT3_GOOD_OLD_FIRST_INO {11;}' unless defined(&EXT3_GOOD_OLD_FIRST_INO);
    eval 'sub EXT3_SUPER_MAGIC {0xef53;}' unless defined(&EXT3_SUPER_MAGIC);
    eval 'sub EXT3_LINK_MAX {32000;}' unless defined(&EXT3_LINK_MAX);
    eval 'sub EXT3_MIN_BLOCK_SIZE {1024;}' unless defined(&EXT3_MIN_BLOCK_SIZE);
    eval 'sub EXT3_MAX_BLOCK_SIZE {4096;}' unless defined(&EXT3_MAX_BLOCK_SIZE);
    eval 'sub EXT3_MIN_BLOCK_LOG_SIZE {10;}' unless defined(&EXT3_MIN_BLOCK_LOG_SIZE);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT3_BLOCK_SIZE {
	    my($s) = @_;
    	    eval q((($s)-> &s_blocksize));
	}' unless defined(&EXT3_BLOCK_SIZE);
    } else {
	eval 'sub EXT3_BLOCK_SIZE {
	    my($s) = @_;
    	    eval q(( &EXT3_MIN_BLOCK_SIZE << ($s)-> &s_log_block_size));
	}' unless defined(&EXT3_BLOCK_SIZE);
    }
    eval 'sub EXT3_ADDR_PER_BLOCK {
        my($s) = @_;
	    eval q(( &EXT3_BLOCK_SIZE($s) / $sizeof{ &__u32}));
    }' unless defined(&EXT3_ADDR_PER_BLOCK);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT3_BLOCK_SIZE_BITS {
	    my($s) = @_;
    	    eval q((($s)-> &s_blocksize_bits));
	}' unless defined(&EXT3_BLOCK_SIZE_BITS);
    } else {
	eval 'sub EXT3_BLOCK_SIZE_BITS {
	    my($s) = @_;
    	    eval q((($s)-> &s_log_block_size + 10));
	}' unless defined(&EXT3_BLOCK_SIZE_BITS);
    }
    if(defined(&__KERNEL__)) {
	eval 'sub EXT3_ADDR_PER_BLOCK_BITS {
	    my($s) = @_;
    	    eval q(( &EXT3_SB($s)-> &s_addr_per_block_bits));
	}' unless defined(&EXT3_ADDR_PER_BLOCK_BITS);
	eval 'sub EXT3_INODE_SIZE {
	    my($s) = @_;
    	    eval q(( &EXT3_SB($s)-> &s_inode_size));
	}' unless defined(&EXT3_INODE_SIZE);
	eval 'sub EXT3_FIRST_INO {
	    my($s) = @_;
    	    eval q(( &EXT3_SB($s)-> &s_first_ino));
	}' unless defined(&EXT3_FIRST_INO);
    } else {
	eval 'sub EXT3_INODE_SIZE {
	    my($s) = @_;
    	    eval q(((($s)-> &s_rev_level ==  &EXT3_GOOD_OLD_REV) ?  &EXT3_GOOD_OLD_INODE_SIZE : ($s)-> &s_inode_size));
	}' unless defined(&EXT3_INODE_SIZE);
	eval 'sub EXT3_FIRST_INO {
	    my($s) = @_;
    	    eval q(((($s)-> &s_rev_level ==  &EXT3_GOOD_OLD_REV) ?  &EXT3_GOOD_OLD_FIRST_INO : ($s)-> &s_first_ino));
	}' unless defined(&EXT3_FIRST_INO);
    }
    eval 'sub EXT3_MIN_FRAG_SIZE {1024;}' unless defined(&EXT3_MIN_FRAG_SIZE);
    eval 'sub EXT3_MAX_FRAG_SIZE {4096;}' unless defined(&EXT3_MAX_FRAG_SIZE);
    eval 'sub EXT3_MIN_FRAG_LOG_SIZE {10;}' unless defined(&EXT3_MIN_FRAG_LOG_SIZE);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT3_FRAG_SIZE {
	    my($s) = @_;
    	    eval q(( &EXT3_SB($s)-> &s_frag_size));
	}' unless defined(&EXT3_FRAG_SIZE);
	eval 'sub EXT3_FRAGS_PER_BLOCK {
	    my($s) = @_;
    	    eval q(( &EXT3_SB($s)-> &s_frags_per_block));
	}' unless defined(&EXT3_FRAGS_PER_BLOCK);
    } else {
	eval 'sub EXT3_FRAG_SIZE {
	    my($s) = @_;
    	    eval q(( &EXT3_MIN_FRAG_SIZE << ($s)-> &s_log_frag_size));
	}' unless defined(&EXT3_FRAG_SIZE);
	eval 'sub EXT3_FRAGS_PER_BLOCK {
	    my($s) = @_;
    	    eval q(( &EXT3_BLOCK_SIZE($s) /  &EXT3_FRAG_SIZE($s)));
	}' unless defined(&EXT3_FRAGS_PER_BLOCK);
    }
    if(defined(&__KERNEL__)) {
	eval 'sub EXT3_BLOCKS_PER_GROUP {
	    my($s) = @_;
    	    eval q(( &EXT3_SB($s)-> &s_blocks_per_group));
	}' unless defined(&EXT3_BLOCKS_PER_GROUP);
	eval 'sub EXT3_DESC_PER_BLOCK {
	    my($s) = @_;
    	    eval q(( &EXT3_SB($s)-> &s_desc_per_block));
	}' unless defined(&EXT3_DESC_PER_BLOCK);
	eval 'sub EXT3_INODES_PER_GROUP {
	    my($s) = @_;
    	    eval q(( &EXT3_SB($s)-> &s_inodes_per_group));
	}' unless defined(&EXT3_INODES_PER_GROUP);
	eval 'sub EXT3_DESC_PER_BLOCK_BITS {
	    my($s) = @_;
    	    eval q(( &EXT3_SB($s)-> &s_desc_per_block_bits));
	}' unless defined(&EXT3_DESC_PER_BLOCK_BITS);
    } else {
	eval 'sub EXT3_BLOCKS_PER_GROUP {
	    my($s) = @_;
    	    eval q((($s)-> &s_blocks_per_group));
	}' unless defined(&EXT3_BLOCKS_PER_GROUP);
	eval 'sub EXT3_DESC_PER_BLOCK {
	    my($s) = @_;
    	    eval q(( &EXT3_BLOCK_SIZE($s) / $sizeof{\'struct ext3_group_desc\'}));
	}' unless defined(&EXT3_DESC_PER_BLOCK);
	eval 'sub EXT3_INODES_PER_GROUP {
	    my($s) = @_;
    	    eval q((($s)-> &s_inodes_per_group));
	}' unless defined(&EXT3_INODES_PER_GROUP);
    }
    eval 'sub EXT3_NDIR_BLOCKS {12;}' unless defined(&EXT3_NDIR_BLOCKS);
    eval 'sub EXT3_IND_BLOCK { &EXT3_NDIR_BLOCKS;}' unless defined(&EXT3_IND_BLOCK);
    eval 'sub EXT3_DIND_BLOCK {( &EXT3_IND_BLOCK + 1);}' unless defined(&EXT3_DIND_BLOCK);
    eval 'sub EXT3_TIND_BLOCK {( &EXT3_DIND_BLOCK + 1);}' unless defined(&EXT3_TIND_BLOCK);
    eval 'sub EXT3_N_BLOCKS {( &EXT3_TIND_BLOCK + 1);}' unless defined(&EXT3_N_BLOCKS);
    eval 'sub EXT3_SECRM_FL {0x1;}' unless defined(&EXT3_SECRM_FL);
    eval 'sub EXT3_UNRM_FL {0x2;}' unless defined(&EXT3_UNRM_FL);
    eval 'sub EXT3_COMPR_FL {0x4;}' unless defined(&EXT3_COMPR_FL);
    eval 'sub EXT3_SYNC_FL {0x8;}' unless defined(&EXT3_SYNC_FL);
    eval 'sub EXT3_IMMUTABLE_FL {0x10;}' unless defined(&EXT3_IMMUTABLE_FL);
    eval 'sub EXT3_APPEND_FL {0x20;}' unless defined(&EXT3_APPEND_FL);
    eval 'sub EXT3_NODUMP_FL {0x40;}' unless defined(&EXT3_NODUMP_FL);
    eval 'sub EXT3_NOATIME_FL {0x80;}' unless defined(&EXT3_NOATIME_FL);
    eval 'sub EXT3_DIRTY_FL {0x100;}' unless defined(&EXT3_DIRTY_FL);
    eval 'sub EXT3_COMPRBLK_FL {0x200;}' unless defined(&EXT3_COMPRBLK_FL);
    eval 'sub EXT3_NOCOMPR_FL {0x400;}' unless defined(&EXT3_NOCOMPR_FL);
    eval 'sub EXT3_ECOMPR_FL {0x800;}' unless defined(&EXT3_ECOMPR_FL);
    eval 'sub EXT3_INDEX_FL {0x1000;}' unless defined(&EXT3_INDEX_FL);
    eval 'sub EXT3_IMAGIC_FL {0x2000;}' unless defined(&EXT3_IMAGIC_FL);
    eval 'sub EXT3_JOURNAL_DATA_FL {0x4000;}' unless defined(&EXT3_JOURNAL_DATA_FL);
    eval 'sub EXT3_NOTAIL_FL {0x8000;}' unless defined(&EXT3_NOTAIL_FL);
    eval 'sub EXT3_DIRSYNC_FL {0x10000;}' unless defined(&EXT3_DIRSYNC_FL);
    eval 'sub EXT3_TOPDIR_FL {0x20000;}' unless defined(&EXT3_TOPDIR_FL);
    eval 'sub EXT3_RESERVED_FL {0x80000000;}' unless defined(&EXT3_RESERVED_FL);
    eval 'sub EXT3_FL_USER_VISIBLE {0x3dfff;}' unless defined(&EXT3_FL_USER_VISIBLE);
    eval 'sub EXT3_FL_USER_MODIFIABLE {0x380ff;}' unless defined(&EXT3_FL_USER_MODIFIABLE);
    eval 'sub EXT3_STATE_JDATA {0x1;}' unless defined(&EXT3_STATE_JDATA);
    eval 'sub EXT3_STATE_NEW {0x2;}' unless defined(&EXT3_STATE_NEW);
    eval 'sub EXT3_STATE_XATTR {0x4;}' unless defined(&EXT3_STATE_XATTR);
    eval 'sub EXT3_IOC_GETFLAGS { &_IOR(ord(\'f\'), 1, \'long\');}' unless defined(&EXT3_IOC_GETFLAGS);
    eval 'sub EXT3_IOC_SETFLAGS { &_IOW(ord(\'f\'), 2, \'long\');}' unless defined(&EXT3_IOC_SETFLAGS);
    eval 'sub EXT3_IOC_GETVERSION { &_IOR(ord(\'f\'), 3, \'long\');}' unless defined(&EXT3_IOC_GETVERSION);
    eval 'sub EXT3_IOC_SETVERSION { &_IOW(ord(\'f\'), 4, \'long\');}' unless defined(&EXT3_IOC_SETVERSION);
    eval 'sub EXT3_IOC_GROUP_EXTEND { &_IOW(ord(\'f\'), 7, \'unsigned long\');}' unless defined(&EXT3_IOC_GROUP_EXTEND);
    eval 'sub EXT3_IOC_GROUP_ADD { &_IOW(ord(\'f\'), 8,\'struct ext3_new_group_input\');}' unless defined(&EXT3_IOC_GROUP_ADD);
    eval 'sub EXT3_IOC_GETVERSION_OLD { &_IOR(ord(\'v\'), 1, \'long\');}' unless defined(&EXT3_IOC_GETVERSION_OLD);
    eval 'sub EXT3_IOC_SETVERSION_OLD { &_IOW(ord(\'v\'), 2, \'long\');}' unless defined(&EXT3_IOC_SETVERSION_OLD);
    if(defined(&CONFIG_JBD_DEBUG)) {
	eval 'sub EXT3_IOC_WAIT_FOR_READONLY { &_IOR(ord(\'f\'), 99, \'long\');}' unless defined(&EXT3_IOC_WAIT_FOR_READONLY);
    }
    eval 'sub EXT3_IOC_GETRSVSZ { &_IOR(ord(\'f\'), 5, \'long\');}' unless defined(&EXT3_IOC_GETRSVSZ);
    eval 'sub EXT3_IOC_SETRSVSZ { &_IOW(ord(\'f\'), 6, \'long\');}' unless defined(&EXT3_IOC_SETRSVSZ);
    if(defined(&CONFIG_QUOTA)) {
    }
    eval 'sub i_size_high { &i_dir_acl;}' unless defined(&i_size_high);
    if(defined( &__KERNEL__) || defined( &__linux__)) {
	eval 'sub i_reserved1 { ($osd1->{linux1}->{l_i_reserved1});}' unless defined(&i_reserved1);
	eval 'sub i_frag { ($osd2->{linux2}->{l_i_frag});}' unless defined(&i_frag);
	eval 'sub i_fsize { ($osd2->{linux2}->{l_i_fsize});}' unless defined(&i_fsize);
	eval 'sub i_uid_low { &i_uid;}' unless defined(&i_uid_low);
	eval 'sub i_gid_low { &i_gid;}' unless defined(&i_gid_low);
	eval 'sub i_uid_high { ($osd2->{linux2}->{l_i_uid_high});}' unless defined(&i_uid_high);
	eval 'sub i_gid_high { ($osd2->{linux2}->{l_i_gid_high});}' unless defined(&i_gid_high);
	eval 'sub i_reserved2 { ($osd2->{linux2}->{l_i_reserved2});}' unless defined(&i_reserved2);
    }
 elsif(defined( &__GNU__)) {
	eval 'sub i_translator { ($osd1->{hurd1}->{h_i_translator});}' unless defined(&i_translator);
	eval 'sub i_frag { ($osd2->{hurd2}->{h_i_frag});;}' unless defined(&i_frag);
	eval 'sub i_fsize { ($osd2->{hurd2}->{h_i_fsize});;}' unless defined(&i_fsize);
	eval 'sub i_uid_high { ($osd2->{hurd2}->{h_i_uid_high});}' unless defined(&i_uid_high);
	eval 'sub i_gid_high { ($osd2->{hurd2}->{h_i_gid_high});}' unless defined(&i_gid_high);
	eval 'sub i_author { ($osd2->{hurd2}->{h_i_author});}' unless defined(&i_author);
    }
 elsif(defined( &__masix__)) {
	eval 'sub i_reserved1 { ($osd1->{masix1}->{m_i_reserved1});}' unless defined(&i_reserved1);
	eval 'sub i_frag { ($osd2->{masix2}->{m_i_frag});}' unless defined(&i_frag);
	eval 'sub i_fsize { ($osd2->{masix2}->{m_i_fsize});}' unless defined(&i_fsize);
	eval 'sub i_reserved2 { ($osd2->{masix2}->{m_i_reserved2});}' unless defined(&i_reserved2);
    }
    eval 'sub EXT3_VALID_FS {0x1;}' unless defined(&EXT3_VALID_FS);
    eval 'sub EXT3_ERROR_FS {0x2;}' unless defined(&EXT3_ERROR_FS);
    eval 'sub EXT3_ORPHAN_FS {0x4;}' unless defined(&EXT3_ORPHAN_FS);
    eval 'sub EXT3_MOUNT_CHECK {0x1;}' unless defined(&EXT3_MOUNT_CHECK);
    eval 'sub EXT3_MOUNT_OLDALLOC {0x2;}' unless defined(&EXT3_MOUNT_OLDALLOC);
    eval 'sub EXT3_MOUNT_GRPID {0x4;}' unless defined(&EXT3_MOUNT_GRPID);
    eval 'sub EXT3_MOUNT_DEBUG {0x8;}' unless defined(&EXT3_MOUNT_DEBUG);
    eval 'sub EXT3_MOUNT_ERRORS_CONT {0x10;}' unless defined(&EXT3_MOUNT_ERRORS_CONT);
    eval 'sub EXT3_MOUNT_ERRORS_RO {0x20;}' unless defined(&EXT3_MOUNT_ERRORS_RO);
    eval 'sub EXT3_MOUNT_ERRORS_PANIC {0x40;}' unless defined(&EXT3_MOUNT_ERRORS_PANIC);
    eval 'sub EXT3_MOUNT_MINIX_DF {0x80;}' unless defined(&EXT3_MOUNT_MINIX_DF);
    eval 'sub EXT3_MOUNT_NOLOAD {0x100;}' unless defined(&EXT3_MOUNT_NOLOAD);
    eval 'sub EXT3_MOUNT_ABORT {0x200;}' unless defined(&EXT3_MOUNT_ABORT);
    eval 'sub EXT3_MOUNT_DATA_FLAGS {0xc00;}' unless defined(&EXT3_MOUNT_DATA_FLAGS);
    eval 'sub EXT3_MOUNT_JOURNAL_DATA {0x400;}' unless defined(&EXT3_MOUNT_JOURNAL_DATA);
    eval 'sub EXT3_MOUNT_ORDERED_DATA {0x800;}' unless defined(&EXT3_MOUNT_ORDERED_DATA);
    eval 'sub EXT3_MOUNT_WRITEBACK_DATA {0xc00;}' unless defined(&EXT3_MOUNT_WRITEBACK_DATA);
    eval 'sub EXT3_MOUNT_UPDATE_JOURNAL {0x1000;}' unless defined(&EXT3_MOUNT_UPDATE_JOURNAL);
    eval 'sub EXT3_MOUNT_NO_UID32 {0x2000;}' unless defined(&EXT3_MOUNT_NO_UID32);
    eval 'sub EXT3_MOUNT_XATTR_USER {0x4000;}' unless defined(&EXT3_MOUNT_XATTR_USER);
    eval 'sub EXT3_MOUNT_POSIX_ACL {0x8000;}' unless defined(&EXT3_MOUNT_POSIX_ACL);
    eval 'sub EXT3_MOUNT_RESERVATION {0x10000;}' unless defined(&EXT3_MOUNT_RESERVATION);
    eval 'sub EXT3_MOUNT_BARRIER {0x20000;}' unless defined(&EXT3_MOUNT_BARRIER);
    eval 'sub EXT3_MOUNT_NOBH {0x40000;}' unless defined(&EXT3_MOUNT_NOBH);
    eval 'sub EXT3_MOUNT_QUOTA {0x80000;}' unless defined(&EXT3_MOUNT_QUOTA);
    eval 'sub EXT3_MOUNT_USRQUOTA {0x100000;}' unless defined(&EXT3_MOUNT_USRQUOTA);
    eval 'sub EXT3_MOUNT_GRPQUOTA {0x200000;}' unless defined(&EXT3_MOUNT_GRPQUOTA);
    unless(defined(&_LINUX_EXT2_FS_H)) {
	eval 'sub clear_opt {
	    my($o, $opt) = @_;
    	    eval q($o &= ~ &EXT3_MOUNT_$opt);
	}' unless defined(&clear_opt);
	eval 'sub set_opt {
	    my($o, $opt) = @_;
    	    eval q($o |=  &EXT3_MOUNT_$opt);
	}' unless defined(&set_opt);
	eval 'sub test_opt {
	    my($sb, $opt) = @_;
    	    eval q(( &EXT3_SB($sb)-> &s_mount_opt &  &EXT3_MOUNT_$opt));
	}' unless defined(&test_opt);
    } else {
	eval 'sub EXT2_MOUNT_NOLOAD { &EXT3_MOUNT_NOLOAD;}' unless defined(&EXT2_MOUNT_NOLOAD);
	eval 'sub EXT2_MOUNT_ABORT { &EXT3_MOUNT_ABORT;}' unless defined(&EXT2_MOUNT_ABORT);
	eval 'sub EXT2_MOUNT_DATA_FLAGS { &EXT3_MOUNT_DATA_FLAGS;}' unless defined(&EXT2_MOUNT_DATA_FLAGS);
    }
    eval 'sub ext3_set_bit { &ext2_set_bit;}' unless defined(&ext3_set_bit);
    eval 'sub ext3_set_bit_atomic { &ext2_set_bit_atomic;}' unless defined(&ext3_set_bit_atomic);
    eval 'sub ext3_clear_bit { &ext2_clear_bit;}' unless defined(&ext3_clear_bit);
    eval 'sub ext3_clear_bit_atomic { &ext2_clear_bit_atomic;}' unless defined(&ext3_clear_bit_atomic);
    eval 'sub ext3_test_bit { &ext2_test_bit;}' unless defined(&ext3_test_bit);
    eval 'sub ext3_find_first_zero_bit { &ext2_find_first_zero_bit;}' unless defined(&ext3_find_first_zero_bit);
    eval 'sub ext3_find_next_zero_bit { &ext2_find_next_zero_bit;}' unless defined(&ext3_find_next_zero_bit);
    eval 'sub EXT3_DFL_MAX_MNT_COUNT {20;}' unless defined(&EXT3_DFL_MAX_MNT_COUNT);
    eval 'sub EXT3_DFL_CHECKINTERVAL {0;}' unless defined(&EXT3_DFL_CHECKINTERVAL);
    eval 'sub EXT3_ERRORS_CONTINUE {1;}' unless defined(&EXT3_ERRORS_CONTINUE);
    eval 'sub EXT3_ERRORS_RO {2;}' unless defined(&EXT3_ERRORS_RO);
    eval 'sub EXT3_ERRORS_PANIC {3;}' unless defined(&EXT3_ERRORS_PANIC);
    eval 'sub EXT3_ERRORS_DEFAULT { &EXT3_ERRORS_CONTINUE;}' unless defined(&EXT3_ERRORS_DEFAULT);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT3_SB {
	    my($sb) = @_;
    	    eval q({  ($sb->{s_fs_info}); });
	}' unless defined(&EXT3_SB);
	eval 'sub ext3_inode_info {
	    eval q(* &EXT3_I(\'struct inode\' * &inode) {  &container_of( &inode, \'struct ext3_inode_info\',  &vfs_inode); });
	}' unless defined(&ext3_inode_info);
    } else {
	eval 'sub EXT3_SB {
	    my($sb) = @_;
    	    eval q(($sb));
	}' unless defined(&EXT3_SB);
    }
    eval 'sub NEXT_ORPHAN {
        my($inode) = @_;
	    eval q( &EXT3_I($inode)-> &i_dtime);
    }' unless defined(&NEXT_ORPHAN);
    eval 'sub EXT3_OS_LINUX {0;}' unless defined(&EXT3_OS_LINUX);
    eval 'sub EXT3_OS_HURD {1;}' unless defined(&EXT3_OS_HURD);
    eval 'sub EXT3_OS_MASIX {2;}' unless defined(&EXT3_OS_MASIX);
    eval 'sub EXT3_OS_FREEBSD {3;}' unless defined(&EXT3_OS_FREEBSD);
    eval 'sub EXT3_OS_LITES {4;}' unless defined(&EXT3_OS_LITES);
    eval 'sub EXT3_GOOD_OLD_REV {0;}' unless defined(&EXT3_GOOD_OLD_REV);
    eval 'sub EXT3_DYNAMIC_REV {1;}' unless defined(&EXT3_DYNAMIC_REV);
    eval 'sub EXT3_CURRENT_REV { &EXT3_GOOD_OLD_REV;}' unless defined(&EXT3_CURRENT_REV);
    eval 'sub EXT3_MAX_SUPP_REV { &EXT3_DYNAMIC_REV;}' unless defined(&EXT3_MAX_SUPP_REV);
    eval 'sub EXT3_GOOD_OLD_INODE_SIZE {128;}' unless defined(&EXT3_GOOD_OLD_INODE_SIZE);
    eval 'sub EXT3_HAS_COMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q((  &EXT3_SB($sb)-> ($s_es->{s_feature_compat}) &  &cpu_to_le32($mask) ));
    }' unless defined(&EXT3_HAS_COMPAT_FEATURE);
    eval 'sub EXT3_HAS_RO_COMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q((  &EXT3_SB($sb)-> ($s_es->{s_feature_ro_compat}) &  &cpu_to_le32($mask) ));
    }' unless defined(&EXT3_HAS_RO_COMPAT_FEATURE);
    eval 'sub EXT3_HAS_INCOMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q((  &EXT3_SB($sb)-> ($s_es->{s_feature_incompat}) &  &cpu_to_le32($mask) ));
    }' unless defined(&EXT3_HAS_INCOMPAT_FEATURE);
    eval 'sub EXT3_SET_COMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q( &EXT3_SB($sb)-> ($s_es->{s_feature_compat}) |=  &cpu_to_le32($mask));
    }' unless defined(&EXT3_SET_COMPAT_FEATURE);
    eval 'sub EXT3_SET_RO_COMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q( &EXT3_SB($sb)-> ($s_es->{s_feature_ro_compat}) |=  &cpu_to_le32($mask));
    }' unless defined(&EXT3_SET_RO_COMPAT_FEATURE);
    eval 'sub EXT3_SET_INCOMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q( &EXT3_SB($sb)-> ($s_es->{s_feature_incompat}) |=  &cpu_to_le32($mask));
    }' unless defined(&EXT3_SET_INCOMPAT_FEATURE);
    eval 'sub EXT3_CLEAR_COMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q( &EXT3_SB($sb)-> ($s_es->{s_feature_compat}) &= ~ &cpu_to_le32($mask));
    }' unless defined(&EXT3_CLEAR_COMPAT_FEATURE);
    eval 'sub EXT3_CLEAR_RO_COMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q( &EXT3_SB($sb)-> ($s_es->{s_feature_ro_compat}) &= ~ &cpu_to_le32($mask));
    }' unless defined(&EXT3_CLEAR_RO_COMPAT_FEATURE);
    eval 'sub EXT3_CLEAR_INCOMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q( &EXT3_SB($sb)-> ($s_es->{s_feature_incompat}) &= ~ &cpu_to_le32($mask));
    }' unless defined(&EXT3_CLEAR_INCOMPAT_FEATURE);
    eval 'sub EXT3_FEATURE_COMPAT_DIR_PREALLOC {0x1;}' unless defined(&EXT3_FEATURE_COMPAT_DIR_PREALLOC);
    eval 'sub EXT3_FEATURE_COMPAT_IMAGIC_INODES {0x2;}' unless defined(&EXT3_FEATURE_COMPAT_IMAGIC_INODES);
    eval 'sub EXT3_FEATURE_COMPAT_HAS_JOURNAL {0x4;}' unless defined(&EXT3_FEATURE_COMPAT_HAS_JOURNAL);
    eval 'sub EXT3_FEATURE_COMPAT_EXT_ATTR {0x8;}' unless defined(&EXT3_FEATURE_COMPAT_EXT_ATTR);
    eval 'sub EXT3_FEATURE_COMPAT_RESIZE_INODE {0x10;}' unless defined(&EXT3_FEATURE_COMPAT_RESIZE_INODE);
    eval 'sub EXT3_FEATURE_COMPAT_DIR_INDEX {0x20;}' unless defined(&EXT3_FEATURE_COMPAT_DIR_INDEX);
    eval 'sub EXT3_FEATURE_RO_COMPAT_SPARSE_SUPER {0x1;}' unless defined(&EXT3_FEATURE_RO_COMPAT_SPARSE_SUPER);
    eval 'sub EXT3_FEATURE_RO_COMPAT_LARGE_FILE {0x2;}' unless defined(&EXT3_FEATURE_RO_COMPAT_LARGE_FILE);
    eval 'sub EXT3_FEATURE_RO_COMPAT_BTREE_DIR {0x4;}' unless defined(&EXT3_FEATURE_RO_COMPAT_BTREE_DIR);
    eval 'sub EXT3_FEATURE_INCOMPAT_COMPRESSION {0x1;}' unless defined(&EXT3_FEATURE_INCOMPAT_COMPRESSION);
    eval 'sub EXT3_FEATURE_INCOMPAT_FILETYPE {0x2;}' unless defined(&EXT3_FEATURE_INCOMPAT_FILETYPE);
    eval 'sub EXT3_FEATURE_INCOMPAT_RECOVER {0x4;}' unless defined(&EXT3_FEATURE_INCOMPAT_RECOVER);
    eval 'sub EXT3_FEATURE_INCOMPAT_JOURNAL_DEV {0x8;}' unless defined(&EXT3_FEATURE_INCOMPAT_JOURNAL_DEV);
    eval 'sub EXT3_FEATURE_INCOMPAT_META_BG {0x10;}' unless defined(&EXT3_FEATURE_INCOMPAT_META_BG);
    eval 'sub EXT3_FEATURE_COMPAT_SUPP { &EXT2_FEATURE_COMPAT_EXT_ATTR;}' unless defined(&EXT3_FEATURE_COMPAT_SUPP);
    eval 'sub EXT3_FEATURE_INCOMPAT_SUPP {( &EXT3_FEATURE_INCOMPAT_FILETYPE|  &EXT3_FEATURE_INCOMPAT_RECOVER|  &EXT3_FEATURE_INCOMPAT_META_BG);}' unless defined(&EXT3_FEATURE_INCOMPAT_SUPP);
    eval 'sub EXT3_FEATURE_RO_COMPAT_SUPP {( &EXT3_FEATURE_RO_COMPAT_SPARSE_SUPER|  &EXT3_FEATURE_RO_COMPAT_LARGE_FILE|  &EXT3_FEATURE_RO_COMPAT_BTREE_DIR);}' unless defined(&EXT3_FEATURE_RO_COMPAT_SUPP);
    eval 'sub EXT3_DEF_RESUID {0;}' unless defined(&EXT3_DEF_RESUID);
    eval 'sub EXT3_DEF_RESGID {0;}' unless defined(&EXT3_DEF_RESGID);
    eval 'sub EXT3_DEFM_DEBUG {0x1;}' unless defined(&EXT3_DEFM_DEBUG);
    eval 'sub EXT3_DEFM_BSDGROUPS {0x2;}' unless defined(&EXT3_DEFM_BSDGROUPS);
    eval 'sub EXT3_DEFM_XATTR_USER {0x4;}' unless defined(&EXT3_DEFM_XATTR_USER);
    eval 'sub EXT3_DEFM_ACL {0x8;}' unless defined(&EXT3_DEFM_ACL);
    eval 'sub EXT3_DEFM_UID16 {0x10;}' unless defined(&EXT3_DEFM_UID16);
    eval 'sub EXT3_DEFM_JMODE {0x60;}' unless defined(&EXT3_DEFM_JMODE);
    eval 'sub EXT3_DEFM_JMODE_DATA {0x20;}' unless defined(&EXT3_DEFM_JMODE_DATA);
    eval 'sub EXT3_DEFM_JMODE_ORDERED {0x40;}' unless defined(&EXT3_DEFM_JMODE_ORDERED);
    eval 'sub EXT3_DEFM_JMODE_WBACK {0x60;}' unless defined(&EXT3_DEFM_JMODE_WBACK);
    eval 'sub EXT3_NAME_LEN {255;}' unless defined(&EXT3_NAME_LEN);
    eval 'sub EXT3_FT_UNKNOWN {0;}' unless defined(&EXT3_FT_UNKNOWN);
    eval 'sub EXT3_FT_REG_FILE {1;}' unless defined(&EXT3_FT_REG_FILE);
    eval 'sub EXT3_FT_DIR {2;}' unless defined(&EXT3_FT_DIR);
    eval 'sub EXT3_FT_CHRDEV {3;}' unless defined(&EXT3_FT_CHRDEV);
    eval 'sub EXT3_FT_BLKDEV {4;}' unless defined(&EXT3_FT_BLKDEV);
    eval 'sub EXT3_FT_FIFO {5;}' unless defined(&EXT3_FT_FIFO);
    eval 'sub EXT3_FT_SOCK {6;}' unless defined(&EXT3_FT_SOCK);
    eval 'sub EXT3_FT_SYMLINK {7;}' unless defined(&EXT3_FT_SYMLINK);
    eval 'sub EXT3_FT_MAX {8;}' unless defined(&EXT3_FT_MAX);
    eval 'sub EXT3_DIR_PAD {4;}' unless defined(&EXT3_DIR_PAD);
    eval 'sub EXT3_DIR_ROUND {( &EXT3_DIR_PAD - 1);}' unless defined(&EXT3_DIR_ROUND);
    eval 'sub EXT3_DIR_REC_LEN {
        my($name_len) = @_;
	    eval q(((($name_len) + 8+  &EXT3_DIR_ROUND) & ~ &EXT3_DIR_ROUND));
    }' unless defined(&EXT3_DIR_REC_LEN);
    if(defined(&CONFIG_EXT3_INDEX)) {
	eval 'sub is_dx {
	    my($dir) = @_;
    	    eval q(( &EXT3_HAS_COMPAT_FEATURE( ($dir->{i_sb}),  &EXT3_FEATURE_COMPAT_DIR_INDEX)  && ( &EXT3_I($dir)-> &i_flags &  &EXT3_INDEX_FL)));
	}' unless defined(&is_dx);
	eval 'sub EXT3_DIR_LINK_MAX {
	    my($dir) = @_;
    	    eval q((! &is_dx($dir)  && ($dir)-> &i_nlink >=  &EXT3_LINK_MAX));
	}' unless defined(&EXT3_DIR_LINK_MAX);
	eval 'sub EXT3_DIR_LINK_EMPTY {
	    my($dir) = @_;
    	    eval q((($dir)-> &i_nlink == 2|| ($dir)-> &i_nlink == 1));
	}' unless defined(&EXT3_DIR_LINK_EMPTY);
    } else {
	eval 'sub is_dx {
	    my($dir) = @_;
    	    eval q(0);
	}' unless defined(&is_dx);
	eval 'sub EXT3_DIR_LINK_MAX {
	    my($dir) = @_;
    	    eval q((($dir)-> &i_nlink >=  &EXT3_LINK_MAX));
	}' unless defined(&EXT3_DIR_LINK_MAX);
	eval 'sub EXT3_DIR_LINK_EMPTY {
	    my($dir) = @_;
    	    eval q((($dir)-> &i_nlink == 2));
	}' unless defined(&EXT3_DIR_LINK_EMPTY);
    }
    eval 'sub DX_HASH_LEGACY {0;}' unless defined(&DX_HASH_LEGACY);
    eval 'sub DX_HASH_HALF_MD4 {1;}' unless defined(&DX_HASH_HALF_MD4);
    eval 'sub DX_HASH_TEA {2;}' unless defined(&DX_HASH_TEA);
    eval 'sub EXT3_HTREE_EOF {0x7fffffff;}' unless defined(&EXT3_HTREE_EOF);
    if(defined(&__KERNEL__)) {
	eval 'sub HASH_NB_ALWAYS {1;}' unless defined(&HASH_NB_ALWAYS);
	eval 'sub ext3_inode {
	    eval q(* &ext3_raw_inode(\'struct ext3_iloc\' * &iloc) {  ( ($iloc->{bh}->{b_data}) +  ($iloc->{offset})); });
	}' unless defined(&ext3_inode);
	eval 'sub ERR_BAD_DX_DIR {-75000;}' unless defined(&ERR_BAD_DX_DIR);
	eval 'sub NORET_TYPE {1;}' unless defined(&NORET_TYPE);
	eval 'sub ATTRIB_NORET { &__attribute__(( &noreturn));}' unless defined(&ATTRIB_NORET);
	eval 'sub NORET_AND { &noreturn,;}' unless defined(&NORET_AND);
	eval 'sub ext3_std_error {
	    my($sb, $errno) = @_;
    	    eval q( &do {  &if (($errno))  &__ext3_std_error(($sb),  &__FUNCTION__, ($errno)); }  &while (0));
	}' unless defined(&ext3_std_error);
    }
}
1;
