require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_EXT3_JBD_H)) {
    eval 'sub _LINUX_EXT3_JBD_H {1;}' unless defined(&_LINUX_EXT3_JBD_H);
    require 'linux/fs.ph';
    require 'linux/jbd.ph';
    require 'linux/ext3_fs.ph';
    eval 'sub EXT3_JOURNAL {
        my($inode) = @_;
	    eval q(( &EXT3_SB(($inode)-> &i_sb)-> &s_journal));
    }' unless defined(&EXT3_JOURNAL);
    eval 'sub EXT3_SINGLEDATA_TRANS_BLOCKS {8;}' unless defined(&EXT3_SINGLEDATA_TRANS_BLOCKS);
    eval 'sub EXT3_XATTR_TRANS_BLOCKS {6;}' unless defined(&EXT3_XATTR_TRANS_BLOCKS);
    eval 'sub EXT3_DATA_TRANS_BLOCKS {
        my($sb) = @_;
	    eval q(( &EXT3_SINGLEDATA_TRANS_BLOCKS +  &EXT3_XATTR_TRANS_BLOCKS - 2+ 2* &EXT3_QUOTA_TRANS_BLOCKS($sb)));
    }' unless defined(&EXT3_DATA_TRANS_BLOCKS);
    eval 'sub EXT3_DELETE_TRANS_BLOCKS {
        my($sb) = @_;
	    eval q((2*  &EXT3_DATA_TRANS_BLOCKS($sb) + 64));
    }' unless defined(&EXT3_DELETE_TRANS_BLOCKS);
    eval 'sub EXT3_MAX_TRANS_DATA {64;}' unless defined(&EXT3_MAX_TRANS_DATA);
    eval 'sub EXT3_RESERVE_TRANS_BLOCKS {12;}' unless defined(&EXT3_RESERVE_TRANS_BLOCKS);
    eval 'sub EXT3_INDEX_EXTRA_TRANS_BLOCKS {8;}' unless defined(&EXT3_INDEX_EXTRA_TRANS_BLOCKS);
    if(defined(&CONFIG_QUOTA)) {
	eval 'sub EXT3_QUOTA_TRANS_BLOCKS {
	    my($sb) = @_;
    	    eval q(( &test_opt($sb,  &QUOTA) ? 2: 0));
	}' unless defined(&EXT3_QUOTA_TRANS_BLOCKS);
	eval 'sub EXT3_QUOTA_INIT_BLOCKS {
	    my($sb) = @_;
    	    eval q(( &test_opt($sb,  &QUOTA) ? ( &DQUOT_INIT_ALLOC* ( &EXT3_SINGLEDATA_TRANS_BLOCKS-3)+3+ &DQUOT_INIT_REWRITE) : 0));
	}' unless defined(&EXT3_QUOTA_INIT_BLOCKS);
	eval 'sub EXT3_QUOTA_DEL_BLOCKS {
	    my($sb) = @_;
    	    eval q(( &test_opt($sb,  &QUOTA) ? ( &DQUOT_DEL_ALLOC* ( &EXT3_SINGLEDATA_TRANS_BLOCKS-3)+3+ &DQUOT_DEL_REWRITE) : 0));
	}' unless defined(&EXT3_QUOTA_DEL_BLOCKS);
    } else {
	eval 'sub EXT3_QUOTA_TRANS_BLOCKS {
	    my($sb) = @_;
    	    eval q(0);
	}' unless defined(&EXT3_QUOTA_TRANS_BLOCKS);
	eval 'sub EXT3_QUOTA_INIT_BLOCKS {
	    my($sb) = @_;
    	    eval q(0);
	}' unless defined(&EXT3_QUOTA_INIT_BLOCKS);
	eval 'sub EXT3_QUOTA_DEL_BLOCKS {
	    my($sb) = @_;
    	    eval q(0);
	}' unless defined(&EXT3_QUOTA_DEL_BLOCKS);
    }
    eval 'sub __ext3_journal_get_undo_access {
        my($where,$handle,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_get_undo_access($handle, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_get_undo_access);
    eval 'sub __ext3_journal_get_write_access {
        my($where,$handle,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_get_write_access($handle, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_get_write_access);
    eval 'sub ext3_journal_release_buffer {
        my($handle,$bh) = @_;
	    eval q({  &journal_release_buffer($handle, $bh); });
    }' unless defined(&ext3_journal_release_buffer);
    eval 'sub __ext3_journal_forget {
        my($where,$handle,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_forget($handle, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_forget);
    eval 'sub __ext3_journal_revoke {
        my($where,$handle,$blocknr,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_revoke($handle, $blocknr, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_revoke);
    eval 'sub __ext3_journal_get_create_access {
        my($where,$handle,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_get_create_access($handle, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_get_create_access);
    eval 'sub __ext3_journal_dirty_metadata {
        my($where,$handle,$bh) = @_;
	    eval q({ \'int\'  &err =  &journal_dirty_metadata($handle, $bh);  &if ( &err)  &ext3_journal_abort_handle($where,  &__FUNCTION__, $bh, $handle, &err);  &err; });
    }' unless defined(&__ext3_journal_dirty_metadata);
    eval 'sub ext3_journal_get_undo_access {
        my($handle, $bh) = @_;
	    eval q( &__ext3_journal_get_undo_access( &__FUNCTION__, ($handle), ($bh)));
    }' unless defined(&ext3_journal_get_undo_access);
    eval 'sub ext3_journal_get_write_access {
        my($handle, $bh) = @_;
	    eval q( &__ext3_journal_get_write_access( &__FUNCTION__, ($handle), ($bh)));
    }' unless defined(&ext3_journal_get_write_access);
    eval 'sub ext3_journal_revoke {
        my($handle, $blocknr, $bh) = @_;
	    eval q( &__ext3_journal_revoke( &__FUNCTION__, ($handle), ($blocknr), ($bh)));
    }' unless defined(&ext3_journal_revoke);
    eval 'sub ext3_journal_get_create_access {
        my($handle, $bh) = @_;
	    eval q( &__ext3_journal_get_create_access( &__FUNCTION__, ($handle), ($bh)));
    }' unless defined(&ext3_journal_get_create_access);
    eval 'sub ext3_journal_dirty_metadata {
        my($handle, $bh) = @_;
	    eval q( &__ext3_journal_dirty_metadata( &__FUNCTION__, ($handle), ($bh)));
    }' unless defined(&ext3_journal_dirty_metadata);
    eval 'sub ext3_journal_forget {
        my($handle, $bh) = @_;
	    eval q( &__ext3_journal_forget( &__FUNCTION__, ($handle), ($bh)));
    }' unless defined(&ext3_journal_forget);
    eval 'sub handle_t {
        eval q(* &ext3_journal_start(\'struct inode\' * &inode, \'int\'  &nblocks) {  &ext3_journal_start_sb( ($inode->{i_sb}),  &nblocks); });
    }' unless defined(&handle_t);
    eval 'sub ext3_journal_stop {
        my($handle) = @_;
	    eval q( &__ext3_journal_stop( &__FUNCTION__, ($handle)));
    }' unless defined(&ext3_journal_stop);
    eval 'sub handle_t {
        eval q(* &ext3_journal_current_handle( &void) {  &journal_current_handle(); });
    }' unless defined(&handle_t);
    eval 'sub ext3_journal_extend {
        my($handle,$nblocks) = @_;
	    eval q({  &journal_extend($handle, $nblocks); });
    }' unless defined(&ext3_journal_extend);
    eval 'sub ext3_journal_restart {
        my($handle,$nblocks) = @_;
	    eval q({  &journal_restart($handle, $nblocks); });
    }' unless defined(&ext3_journal_restart);
    eval 'sub ext3_journal_blocks_per_page {
        my($inode) = @_;
	    eval q({  &journal_blocks_per_page($inode); });
    }' unless defined(&ext3_journal_blocks_per_page);
    eval 'sub ext3_journal_force_commit {
        my($journal) = @_;
	    eval q({  &journal_force_commit($journal); });
    }' unless defined(&ext3_journal_force_commit);
    eval 'sub ext3_should_journal_data {
        my($inode) = @_;
	    eval q({  &if (! &S_ISREG( ($inode->{i_mode}))) 1;  &if ( &test_opt( ($inode->{i_sb}),  &DATA_FLAGS) ==  &EXT3_MOUNT_JOURNAL_DATA) 1;  &if ( &EXT3_I($inode)-> &i_flags &  &EXT3_JOURNAL_DATA_FL) 1; 0; });
    }' unless defined(&ext3_should_journal_data);
    eval 'sub ext3_should_order_data {
        my($inode) = @_;
	    eval q({  &if (! &S_ISREG( ($inode->{i_mode}))) 0;  &if ( &EXT3_I($inode)-> &i_flags &  &EXT3_JOURNAL_DATA_FL) 0;  &if ( &test_opt( ($inode->{i_sb}),  &DATA_FLAGS) ==  &EXT3_MOUNT_ORDERED_DATA) 1; 0; });
    }' unless defined(&ext3_should_order_data);
    eval 'sub ext3_should_writeback_data {
        my($inode) = @_;
	    eval q({  &if (! &S_ISREG( ($inode->{i_mode}))) 0;  &if ( &EXT3_I($inode)-> &i_flags &  &EXT3_JOURNAL_DATA_FL) 0;  &if ( &test_opt( ($inode->{i_sb}),  &DATA_FLAGS) ==  &EXT3_MOUNT_WRITEBACK_DATA) 1; 0; });
    }' unless defined(&ext3_should_writeback_data);
}
1;
