require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&LINUX_HARDIRQ_H)) {
    eval 'sub LINUX_HARDIRQ_H {1;}' unless defined(&LINUX_HARDIRQ_H);
    require 'linux/config.ph';
    require 'linux/preempt.ph';
    require 'linux/smp_lock.ph';
    require 'asm/hardirq.ph';
    require 'asm/system.ph';
    eval 'sub PREEMPT_BITS {8;}' unless defined(&PREEMPT_BITS);
    eval 'sub SOFTIRQ_BITS {8;}' unless defined(&SOFTIRQ_BITS);
    unless(defined(&HARDIRQ_BITS)) {
	eval 'sub HARDIRQ_BITS {12;}' unless defined(&HARDIRQ_BITS);
	if((1<< (defined(&HARDIRQ_BITS) ? &HARDIRQ_BITS : 0)) < (defined(&NR_IRQS) ? &NR_IRQS : 0)) {
	    die("HARDIRQ_BITS\ is\ too\ low\!");
	}
    }
    eval 'sub PREEMPT_SHIFT {0;}' unless defined(&PREEMPT_SHIFT);
    eval 'sub SOFTIRQ_SHIFT {( &PREEMPT_SHIFT +  &PREEMPT_BITS);}' unless defined(&SOFTIRQ_SHIFT);
    eval 'sub HARDIRQ_SHIFT {( &SOFTIRQ_SHIFT +  &SOFTIRQ_BITS);}' unless defined(&HARDIRQ_SHIFT);
    eval 'sub __IRQ_MASK {
        my($x) = @_;
	    eval q(((1 << ($x))-1));
    }' unless defined(&__IRQ_MASK);
    eval 'sub PREEMPT_MASK {( &__IRQ_MASK( &PREEMPT_BITS) <<  &PREEMPT_SHIFT);}' unless defined(&PREEMPT_MASK);
    eval 'sub SOFTIRQ_MASK {( &__IRQ_MASK( &SOFTIRQ_BITS) <<  &SOFTIRQ_SHIFT);}' unless defined(&SOFTIRQ_MASK);
    eval 'sub HARDIRQ_MASK {( &__IRQ_MASK( &HARDIRQ_BITS) <<  &HARDIRQ_SHIFT);}' unless defined(&HARDIRQ_MASK);
    eval 'sub PREEMPT_OFFSET {(1 <<  &PREEMPT_SHIFT);}' unless defined(&PREEMPT_OFFSET);
    eval 'sub SOFTIRQ_OFFSET {(1 <<  &SOFTIRQ_SHIFT);}' unless defined(&SOFTIRQ_OFFSET);
    eval 'sub HARDIRQ_OFFSET {(1 <<  &HARDIRQ_SHIFT);}' unless defined(&HARDIRQ_OFFSET);
    if((defined(&PREEMPT_ACTIVE) ? &PREEMPT_ACTIVE : 0) < (1<< ((defined(&HARDIRQ_SHIFT) ? &HARDIRQ_SHIFT : 0) + (defined(&HARDIRQ_BITS) ? &HARDIRQ_BITS : 0)))) {
	die("PREEMPT_ACTIVE\ is\ too\ low\!");
    }
    eval 'sub hardirq_count () {
        eval q(( &preempt_count() &  &HARDIRQ_MASK));
    }' unless defined(&hardirq_count);
    eval 'sub softirq_count () {
        eval q(( &preempt_count() &  &SOFTIRQ_MASK));
    }' unless defined(&softirq_count);
    eval 'sub irq_count () {
        eval q(( &preempt_count() & ( &HARDIRQ_MASK |  &SOFTIRQ_MASK)));
    }' unless defined(&irq_count);
    eval 'sub in_irq () {
        eval q(( &hardirq_count()));
    }' unless defined(&in_irq);
    eval 'sub in_softirq () {
        eval q(( &softirq_count()));
    }' unless defined(&in_softirq);
    eval 'sub in_interrupt () {
        eval q(( &irq_count()));
    }' unless defined(&in_interrupt);
    if(defined( &CONFIG_PREEMPT)  && !defined( &CONFIG_PREEMPT_BKL)) {
	eval 'sub in_atomic () {
	    eval q((( &preempt_count() & ~ &PREEMPT_ACTIVE) !=  &kernel_locked()));
	}' unless defined(&in_atomic);
    } else {
	eval 'sub in_atomic () {
	    eval q((( &preempt_count() & ~ &PREEMPT_ACTIVE) != 0));
	}' unless defined(&in_atomic);
    }
    if(defined(&CONFIG_PREEMPT)) {
	eval 'sub preemptible () {
	    eval q(( &preempt_count() == 0 && ! &irqs_disabled()));
	}' unless defined(&preemptible);
	eval 'sub IRQ_EXIT_OFFSET {( &HARDIRQ_OFFSET-1);}' unless defined(&IRQ_EXIT_OFFSET);
    } else {
	eval 'sub preemptible () {
	    eval q(0);
	}' unless defined(&preemptible);
	eval 'sub IRQ_EXIT_OFFSET { &HARDIRQ_OFFSET;}' unless defined(&IRQ_EXIT_OFFSET);
    }
    if(defined(&CONFIG_SMP)) {
    } else {
	eval 'sub synchronize_irq {
	    my($irq) = @_;
    	    eval q( &barrier());
	}' unless defined(&synchronize_irq);
    }
    eval 'sub nmi_enter () {
        eval q( &irq_enter());
    }' unless defined(&nmi_enter);
    eval 'sub nmi_exit () {
        eval q( &sub_preempt_count( &HARDIRQ_OFFSET));
    }' unless defined(&nmi_exit);
    unless(defined(&CONFIG_VIRT_CPU_ACCOUNTING)) {
	eval 'sub account_system_vtime {
	    my($tsk) = @_;
    	    eval q({ });
	}' unless defined(&account_system_vtime);
    }
    eval 'sub irq_enter () {
        eval q( &do {  &account_system_vtime( &current);  &add_preempt_count( &HARDIRQ_OFFSET); }  &while (0));
    }' unless defined(&irq_enter);
}
1;
