require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_I2C_H)) {
    eval 'sub _LINUX_I2C_H {1;}' unless defined(&_LINUX_I2C_H);
    require 'linux/module.ph';
    require 'linux/types.ph';
    require 'linux/i2c-id.ph';
    require 'linux/mod_devicetable.ph';
    require 'linux/device.ph';
    require 'linux/sched.ph';
    require 'asm/semaphore.ph';
    eval 'sub to_i2c_driver {
        my($d) = @_;
	    eval q( &container_of($d, \'struct i2c_driver\',  &driver));
    }' unless defined(&to_i2c_driver);
    eval 'sub I2C_NAME_SIZE {50;}' unless defined(&I2C_NAME_SIZE);
    eval 'sub to_i2c_client {
        my($d) = @_;
	    eval q( &container_of($d, \'struct i2c_client\',  &dev));
    }' unless defined(&to_i2c_client);
    eval 'sub i2c_client {
        eval q(* &kobj_to_i2c_client(\'struct kobject\' * &kobj) {  &to_i2c_client( &container_of( &kobj, \'struct device\',  &kobj)); });
    }' unless defined(&i2c_client);
    eval 'sub void {
        eval q(* &i2c_get_clientdata (\'struct i2c_client\' * &dev) {  &dev_get_drvdata ( ($dev->{dev})); });
    }' unless defined(&void);
    eval 'sub i2c_set_clientdata {
        my($dev,$data) = @_;
	    eval q({  &dev_set_drvdata ( ($dev->{dev}), $data); });
    }' unless defined(&i2c_set_clientdata);
    eval 'sub dev_to_i2c_adapter {
        my($d) = @_;
	    eval q( &container_of($d, \'struct i2c_adapter\',  &dev));
    }' unless defined(&dev_to_i2c_adapter);
    eval 'sub class_dev_to_i2c_adapter {
        my($d) = @_;
	    eval q( &container_of($d, \'struct i2c_adapter\',  &class_dev));
    }' unless defined(&class_dev_to_i2c_adapter);
    eval 'sub void {
        eval q(* &i2c_get_adapdata (\'struct i2c_adapter\' * &dev) {  &dev_get_drvdata ( ($dev->{dev})); });
    }' unless defined(&void);
    eval 'sub i2c_set_adapdata {
        my($dev,$data) = @_;
	    eval q({  &dev_set_drvdata ( ($dev->{dev}), $data); });
    }' unless defined(&i2c_set_adapdata);
    eval 'sub I2C_CLIENT_PEC {0x4;}' unless defined(&I2C_CLIENT_PEC);
    eval 'sub I2C_CLIENT_TEN {0x10;}' unless defined(&I2C_CLIENT_TEN);
    eval 'sub I2C_CLASS_HWMON {(1<<0);}' unless defined(&I2C_CLASS_HWMON);
    eval 'sub I2C_CLASS_TV_ANALOG {(1<<1);}' unless defined(&I2C_CLASS_TV_ANALOG);
    eval 'sub I2C_CLASS_TV_DIGITAL {(1<<2);}' unless defined(&I2C_CLASS_TV_DIGITAL);
    eval 'sub I2C_CLASS_DDC {(1<<3);}' unless defined(&I2C_CLASS_DDC);
    eval 'sub I2C_CLASS_CAM_ANALOG {(1<<4);}' unless defined(&I2C_CLASS_CAM_ANALOG);
    eval 'sub I2C_CLASS_CAM_DIGITAL {(1<<5);}' unless defined(&I2C_CLASS_CAM_DIGITAL);
    eval 'sub I2C_CLASS_SOUND {(1<<6);}' unless defined(&I2C_CLASS_SOUND);
    eval 'sub I2C_CLASS_ALL {( &UINT_MAX);}' unless defined(&I2C_CLASS_ALL);
    eval 'sub I2C_CLIENT_END {0xfffe;}' unless defined(&I2C_CLIENT_END);
    eval 'sub ANY_I2C_BUS {0xffff;}' unless defined(&ANY_I2C_BUS);
    eval 'sub ANY_I2C_ISA_BUS {9191;}' unless defined(&ANY_I2C_ISA_BUS);
    eval 'sub i2c_add_driver {
        my($driver) = @_;
	    eval q({  &i2c_register_driver( &THIS_MODULE, $driver); });
    }' unless defined(&i2c_add_driver);
    eval 'sub I2C_M_TEN {0x10;}' unless defined(&I2C_M_TEN);
    eval 'sub I2C_M_RD {0x1;}' unless defined(&I2C_M_RD);
    eval 'sub I2C_M_NOSTART {0x4000;}' unless defined(&I2C_M_NOSTART);
    eval 'sub I2C_M_REV_DIR_ADDR {0x2000;}' unless defined(&I2C_M_REV_DIR_ADDR);
    eval 'sub I2C_M_IGNORE_NAK {0x1000;}' unless defined(&I2C_M_IGNORE_NAK);
    eval 'sub I2C_M_NO_RD_ACK {0x800;}' unless defined(&I2C_M_NO_RD_ACK);
    eval 'sub I2C_FUNC_I2C {0x1;}' unless defined(&I2C_FUNC_I2C);
    eval 'sub I2C_FUNC_10BIT_ADDR {0x2;}' unless defined(&I2C_FUNC_10BIT_ADDR);
    eval 'sub I2C_FUNC_PROTOCOL_MANGLING {0x4;}' unless defined(&I2C_FUNC_PROTOCOL_MANGLING);
    eval 'sub I2C_FUNC_SMBUS_HWPEC_CALC {0x8;}' unless defined(&I2C_FUNC_SMBUS_HWPEC_CALC);
    eval 'sub I2C_FUNC_SMBUS_BLOCK_PROC_CALL {0x8000;}' unless defined(&I2C_FUNC_SMBUS_BLOCK_PROC_CALL);
    eval 'sub I2C_FUNC_SMBUS_QUICK {0x10000;}' unless defined(&I2C_FUNC_SMBUS_QUICK);
    eval 'sub I2C_FUNC_SMBUS_READ_BYTE {0x20000;}' unless defined(&I2C_FUNC_SMBUS_READ_BYTE);
    eval 'sub I2C_FUNC_SMBUS_WRITE_BYTE {0x40000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_BYTE);
    eval 'sub I2C_FUNC_SMBUS_READ_BYTE_DATA {0x80000;}' unless defined(&I2C_FUNC_SMBUS_READ_BYTE_DATA);
    eval 'sub I2C_FUNC_SMBUS_WRITE_BYTE_DATA {0x100000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_BYTE_DATA);
    eval 'sub I2C_FUNC_SMBUS_READ_WORD_DATA {0x200000;}' unless defined(&I2C_FUNC_SMBUS_READ_WORD_DATA);
    eval 'sub I2C_FUNC_SMBUS_WRITE_WORD_DATA {0x400000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_WORD_DATA);
    eval 'sub I2C_FUNC_SMBUS_PROC_CALL {0x800000;}' unless defined(&I2C_FUNC_SMBUS_PROC_CALL);
    eval 'sub I2C_FUNC_SMBUS_READ_BLOCK_DATA {0x1000000;}' unless defined(&I2C_FUNC_SMBUS_READ_BLOCK_DATA);
    eval 'sub I2C_FUNC_SMBUS_WRITE_BLOCK_DATA {0x2000000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_BLOCK_DATA);
    eval 'sub I2C_FUNC_SMBUS_READ_I2C_BLOCK {0x4000000;}' unless defined(&I2C_FUNC_SMBUS_READ_I2C_BLOCK);
    eval 'sub I2C_FUNC_SMBUS_WRITE_I2C_BLOCK {0x8000000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_I2C_BLOCK);
    eval 'sub I2C_FUNC_SMBUS_READ_I2C_BLOCK_2 {0x10000000;}' unless defined(&I2C_FUNC_SMBUS_READ_I2C_BLOCK_2);
    eval 'sub I2C_FUNC_SMBUS_WRITE_I2C_BLOCK_2 {0x20000000;}' unless defined(&I2C_FUNC_SMBUS_WRITE_I2C_BLOCK_2);
    eval 'sub I2C_FUNC_SMBUS_BYTE {( &I2C_FUNC_SMBUS_READ_BYTE |  &I2C_FUNC_SMBUS_WRITE_BYTE);}' unless defined(&I2C_FUNC_SMBUS_BYTE);
    eval 'sub I2C_FUNC_SMBUS_BYTE_DATA {( &I2C_FUNC_SMBUS_READ_BYTE_DATA |  &I2C_FUNC_SMBUS_WRITE_BYTE_DATA);}' unless defined(&I2C_FUNC_SMBUS_BYTE_DATA);
    eval 'sub I2C_FUNC_SMBUS_WORD_DATA {( &I2C_FUNC_SMBUS_READ_WORD_DATA |  &I2C_FUNC_SMBUS_WRITE_WORD_DATA);}' unless defined(&I2C_FUNC_SMBUS_WORD_DATA);
    eval 'sub I2C_FUNC_SMBUS_BLOCK_DATA {( &I2C_FUNC_SMBUS_READ_BLOCK_DATA |  &I2C_FUNC_SMBUS_WRITE_BLOCK_DATA);}' unless defined(&I2C_FUNC_SMBUS_BLOCK_DATA);
    eval 'sub I2C_FUNC_SMBUS_I2C_BLOCK {( &I2C_FUNC_SMBUS_READ_I2C_BLOCK |  &I2C_FUNC_SMBUS_WRITE_I2C_BLOCK);}' unless defined(&I2C_FUNC_SMBUS_I2C_BLOCK);
    eval 'sub I2C_FUNC_SMBUS_I2C_BLOCK_2 {( &I2C_FUNC_SMBUS_READ_I2C_BLOCK_2 |  &I2C_FUNC_SMBUS_WRITE_I2C_BLOCK_2);}' unless defined(&I2C_FUNC_SMBUS_I2C_BLOCK_2);
    eval 'sub I2C_FUNC_SMBUS_EMUL {( &I2C_FUNC_SMBUS_QUICK |  &I2C_FUNC_SMBUS_BYTE |  &I2C_FUNC_SMBUS_BYTE_DATA |  &I2C_FUNC_SMBUS_WORD_DATA |  &I2C_FUNC_SMBUS_PROC_CALL |  &I2C_FUNC_SMBUS_WRITE_BLOCK_DATA |  &I2C_FUNC_SMBUS_I2C_BLOCK);}' unless defined(&I2C_FUNC_SMBUS_EMUL);
    eval 'sub I2C_SMBUS_BLOCK_MAX {32;}' unless defined(&I2C_SMBUS_BLOCK_MAX);
    eval 'sub I2C_SMBUS_READ {1;}' unless defined(&I2C_SMBUS_READ);
    eval 'sub I2C_SMBUS_WRITE {0;}' unless defined(&I2C_SMBUS_WRITE);
    eval 'sub I2C_SMBUS_QUICK {0;}' unless defined(&I2C_SMBUS_QUICK);
    eval 'sub I2C_SMBUS_BYTE {1;}' unless defined(&I2C_SMBUS_BYTE);
    eval 'sub I2C_SMBUS_BYTE_DATA {2;}' unless defined(&I2C_SMBUS_BYTE_DATA);
    eval 'sub I2C_SMBUS_WORD_DATA {3;}' unless defined(&I2C_SMBUS_WORD_DATA);
    eval 'sub I2C_SMBUS_PROC_CALL {4;}' unless defined(&I2C_SMBUS_PROC_CALL);
    eval 'sub I2C_SMBUS_BLOCK_DATA {5;}' unless defined(&I2C_SMBUS_BLOCK_DATA);
    eval 'sub I2C_SMBUS_I2C_BLOCK_DATA {6;}' unless defined(&I2C_SMBUS_I2C_BLOCK_DATA);
    eval 'sub I2C_SMBUS_BLOCK_PROC_CALL {7;}' unless defined(&I2C_SMBUS_BLOCK_PROC_CALL);
    eval 'sub I2C_RETRIES {0x701;}' unless defined(&I2C_RETRIES);
    eval 'sub I2C_TIMEOUT {0x702;}' unless defined(&I2C_TIMEOUT);
    eval 'sub I2C_SLAVE {0x703;}' unless defined(&I2C_SLAVE);
    eval 'sub I2C_SLAVE_FORCE {0x706;}' unless defined(&I2C_SLAVE_FORCE);
    eval 'sub I2C_TENBIT {0x704;}' unless defined(&I2C_TENBIT);
    eval 'sub I2C_FUNCS {0x705;}' unless defined(&I2C_FUNCS);
    eval 'sub I2C_RDWR {0x707;}' unless defined(&I2C_RDWR);
    eval 'sub I2C_PEC {0x708;}' unless defined(&I2C_PEC);
    eval 'sub I2C_SMBUS {0x720;}' unless defined(&I2C_SMBUS);
    eval 'sub I2C_MAJOR {89;}' unless defined(&I2C_MAJOR);
    eval 'sub I2C_CLIENT_MAX_OPTS {48;}' unless defined(&I2C_CLIENT_MAX_OPTS);
    eval 'sub I2C_CLIENT_DEFAULTS {{ &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END,  &I2C_CLIENT_END};}' unless defined(&I2C_CLIENT_DEFAULTS);
    eval 'sub I2C_CLIENT_MODULE_PARM {
        my($var,$desc) = @_;
	    eval q( &static \'unsigned short var\'[ &I2C_CLIENT_MAX_OPTS] =  &I2C_CLIENT_DEFAULTS;  &static \'unsigned int var\' &_num;  &module_param_array($var, \'short\', $var &_num, 0);  &MODULE_PARM_DESC($var,$desc));
    }' unless defined(&I2C_CLIENT_MODULE_PARM);
    eval 'sub I2C_CLIENT_MODULE_PARM_FORCE {
        my($name) = @_;
	    eval q( &I2C_CLIENT_MODULE_PARM( &force_$name, \\"List of adapter,address pairs which are \\" \\"unquestionably assumed to contain a `\\"  $name \\"\' chip\\"));
    }' unless defined(&I2C_CLIENT_MODULE_PARM_FORCE);
    eval 'sub I2C_CLIENT_INSMOD_COMMON { &I2C_CLIENT_MODULE_PARM( &probe, "List of adapter,address pairs to scan " "additionally");  &I2C_CLIENT_MODULE_PARM( &ignore, "List of adapter,address pairs not to " "scan");  &static \'struct i2c_client_address_data\'  &addr_data = { . &normal_i2c =  &normal_i2c, . &probe =  &probe, . &ignore =  &ignore, . &forces =  &forces, };}' unless defined(&I2C_CLIENT_INSMOD_COMMON);
    eval 'sub I2C_CLIENT_INSMOD { &I2C_CLIENT_MODULE_PARM( &force, "List of adapter,address pairs to boldly assume " "to be present");  &static \'unsigned short\' * $forces[] = {  &force,  &NULL };  &I2C_CLIENT_INSMOD_COMMON;}' unless defined(&I2C_CLIENT_INSMOD);
    eval 'sub I2C_CLIENT_INSMOD_1 {
        my($chip1) = @_;
	    eval q( &enum  &chips {  &any_chip, $chip1 };  &I2C_CLIENT_MODULE_PARM( &force, \\"List of adapter,address pairs to \\" \\"boldly assume to be present\\");  &I2C_CLIENT_MODULE_PARM_FORCE($chip1);  &static \'unsigned short\' * $forces[] = {  &force,  &force_$chip1,  &NULL };  &I2C_CLIENT_INSMOD_COMMON);
    }' unless defined(&I2C_CLIENT_INSMOD_1);
    eval 'sub I2C_CLIENT_INSMOD_2 {
        my($chip1, $chip2) = @_;
	    eval q( &enum  &chips {  &any_chip, $chip1, $chip2 };  &I2C_CLIENT_MODULE_PARM( &force, \\"List of adapter,address pairs to \\" \\"boldly assume to be present\\");  &I2C_CLIENT_MODULE_PARM_FORCE($chip1);  &I2C_CLIENT_MODULE_PARM_FORCE($chip2);  &static \'unsigned short\' * $forces[] = {  &force,  &force_$chip1,  &force_$chip2,  &NULL };  &I2C_CLIENT_INSMOD_COMMON);
    }' unless defined(&I2C_CLIENT_INSMOD_2);
    eval 'sub I2C_CLIENT_INSMOD_3 {
        my($chip1, $chip2, $chip3) = @_;
	    eval q( &enum  &chips {  &any_chip, $chip1, $chip2, $chip3 };  &I2C_CLIENT_MODULE_PARM( &force, \\"List of adapter,address pairs to \\" \\"boldly assume to be present\\");  &I2C_CLIENT_MODULE_PARM_FORCE($chip1);  &I2C_CLIENT_MODULE_PARM_FORCE($chip2);  &I2C_CLIENT_MODULE_PARM_FORCE($chip3);  &static \'unsigned short\' * $forces[] = {  &force,  &force_$chip1,  &force_$chip2,  &force_$chip3,  &NULL };  &I2C_CLIENT_INSMOD_COMMON);
    }' unless defined(&I2C_CLIENT_INSMOD_3);
    eval 'sub I2C_CLIENT_INSMOD_4 {
        my($chip1, $chip2, $chip3, $chip4) = @_;
	    eval q( &enum  &chips {  &any_chip, $chip1, $chip2, $chip3, $chip4 };  &I2C_CLIENT_MODULE_PARM( &force, \\"List of adapter,address pairs to \\" \\"boldly assume to be present\\");  &I2C_CLIENT_MODULE_PARM_FORCE($chip1);  &I2C_CLIENT_MODULE_PARM_FORCE($chip2);  &I2C_CLIENT_MODULE_PARM_FORCE($chip3);  &I2C_CLIENT_MODULE_PARM_FORCE($chip4);  &static \'unsigned short\' * $forces[] = {  &force,  &force_$chip1,  &force_$chip2,  &force_$chip3,  &force_$chip4,  &NULL};  &I2C_CLIENT_INSMOD_COMMON);
    }' unless defined(&I2C_CLIENT_INSMOD_4);
    eval 'sub I2C_CLIENT_INSMOD_5 {
        my($chip1, $chip2, $chip3, $chip4, $chip5) = @_;
	    eval q( &enum  &chips {  &any_chip, $chip1, $chip2, $chip3, $chip4, $chip5 };  &I2C_CLIENT_MODULE_PARM( &force, \\"List of adapter,address pairs to \\" \\"boldly assume to be present\\");  &I2C_CLIENT_MODULE_PARM_FORCE($chip1);  &I2C_CLIENT_MODULE_PARM_FORCE($chip2);  &I2C_CLIENT_MODULE_PARM_FORCE($chip3);  &I2C_CLIENT_MODULE_PARM_FORCE($chip4);  &I2C_CLIENT_MODULE_PARM_FORCE($chip5);  &static \'unsigned short\' * $forces[] = {  &force,  &force_$chip1,  &force_$chip2,  &force_$chip3,  &force_$chip4,  &force_$chip5,  &NULL };  &I2C_CLIENT_INSMOD_COMMON);
    }' unless defined(&I2C_CLIENT_INSMOD_5);
    eval 'sub I2C_CLIENT_INSMOD_6 {
        my($chip1, $chip2, $chip3, $chip4, $chip5, $chip6) = @_;
	    eval q( &enum  &chips {  &any_chip, $chip1, $chip2, $chip3, $chip4, $chip5, $chip6 };  &I2C_CLIENT_MODULE_PARM( &force, \\"List of adapter,address pairs to \\" \\"boldly assume to be present\\");  &I2C_CLIENT_MODULE_PARM_FORCE($chip1);  &I2C_CLIENT_MODULE_PARM_FORCE($chip2);  &I2C_CLIENT_MODULE_PARM_FORCE($chip3);  &I2C_CLIENT_MODULE_PARM_FORCE($chip4);  &I2C_CLIENT_MODULE_PARM_FORCE($chip5);  &I2C_CLIENT_MODULE_PARM_FORCE($chip6);  &static \'unsigned short\' * $forces[] = {  &force,  &force_$chip1,  &force_$chip2,  &force_$chip3,  &force_$chip4,  &force_$chip5,  &force_$chip6,  &NULL };  &I2C_CLIENT_INSMOD_COMMON);
    }' unless defined(&I2C_CLIENT_INSMOD_6);
    eval 'sub I2C_CLIENT_INSMOD_7 {
        my($chip1, $chip2, $chip3, $chip4, $chip5, $chip6, $chip7) = @_;
	    eval q( &enum  &chips {  &any_chip, $chip1, $chip2, $chip3, $chip4, $chip5, $chip6, $chip7 };  &I2C_CLIENT_MODULE_PARM( &force, \\"List of adapter,address pairs to \\" \\"boldly assume to be present\\");  &I2C_CLIENT_MODULE_PARM_FORCE($chip1);  &I2C_CLIENT_MODULE_PARM_FORCE($chip2);  &I2C_CLIENT_MODULE_PARM_FORCE($chip3);  &I2C_CLIENT_MODULE_PARM_FORCE($chip4);  &I2C_CLIENT_MODULE_PARM_FORCE($chip5);  &I2C_CLIENT_MODULE_PARM_FORCE($chip6);  &I2C_CLIENT_MODULE_PARM_FORCE($chip7);  &static \'unsigned short\' * $forces[] = {  &force,  &force_$chip1,  &force_$chip2,  &force_$chip3,  &force_$chip4,  &force_$chip5,  &force_$chip6,  &force_$chip7,  &NULL };  &I2C_CLIENT_INSMOD_COMMON);
    }' unless defined(&I2C_CLIENT_INSMOD_7);
    eval 'sub I2C_CLIENT_INSMOD_8 {
        my($chip1, $chip2, $chip3, $chip4, $chip5, $chip6, $chip7, $chip8) = @_;
	    eval q( &enum  &chips {  &any_chip, $chip1, $chip2, $chip3, $chip4, $chip5, $chip6, $chip7, $chip8 };  &I2C_CLIENT_MODULE_PARM( &force, \\"List of adapter,address pairs to \\" \\"boldly assume to be present\\");  &I2C_CLIENT_MODULE_PARM_FORCE($chip1);  &I2C_CLIENT_MODULE_PARM_FORCE($chip2);  &I2C_CLIENT_MODULE_PARM_FORCE($chip3);  &I2C_CLIENT_MODULE_PARM_FORCE($chip4);  &I2C_CLIENT_MODULE_PARM_FORCE($chip5);  &I2C_CLIENT_MODULE_PARM_FORCE($chip6);  &I2C_CLIENT_MODULE_PARM_FORCE($chip7);  &I2C_CLIENT_MODULE_PARM_FORCE($chip8);  &static \'unsigned short\' * $forces[] = {  &force,  &force_$chip1,  &force_$chip2,  &force_$chip3,  &force_$chip4,  &force_$chip5,  &force_$chip6,  &force_$chip7,  &force_$chip8,  &NULL };  &I2C_CLIENT_INSMOD_COMMON);
    }' unless defined(&I2C_CLIENT_INSMOD_8);
}
1;
