require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_KDEV_T_H)) {
    eval 'sub _LINUX_KDEV_T_H {1;}' unless defined(&_LINUX_KDEV_T_H);
    if(defined(&__KERNEL__)) {
	eval 'sub MINORBITS {20;}' unless defined(&MINORBITS);
	eval 'sub MINORMASK {((1 <<  &MINORBITS) - 1);}' unless defined(&MINORMASK);
	eval 'sub MAJOR {
	    my($dev) = @_;
    	    eval q(( (($dev) >>  &MINORBITS)));
	}' unless defined(&MAJOR);
	eval 'sub MINOR {
	    my($dev) = @_;
    	    eval q(( (($dev) &  &MINORMASK)));
	}' unless defined(&MINOR);
	eval 'sub MKDEV {
	    my($ma,$mi) = @_;
    	    eval q(((($ma) <<  &MINORBITS) | ($mi)));
	}' unless defined(&MKDEV);
	eval 'sub print_dev_t {
	    my($buffer, $dev) = @_;
    	    eval q( &sprintf(($buffer), \\"%u:%u\\\\n\\",  &MAJOR($dev),  &MINOR($dev)));
	}' unless defined(&print_dev_t);
	eval 'sub format_dev_t {
	    my($buffer, $dev) = @_;
    	    eval q(({  &sprintf($buffer, \\"%u:%u\\",  &MAJOR($dev),  &MINOR($dev)); $buffer; }));
	}' unless defined(&format_dev_t);
	eval 'sub old_encode_dev {
	    my($dev) = @_;
    	    eval q({ ( &MAJOR($dev) << 8) |  &MINOR($dev); });
	}' unless defined(&old_encode_dev);
	eval 'sub old_decode_dev {
	    my($val) = @_;
    	    eval q({  &MKDEV(($val >> 8) & 255, $val & 255); });
	}' unless defined(&old_decode_dev);
	eval 'sub new_valid_dev {
	    my($dev) = @_;
    	    eval q({ 1; });
	}' unless defined(&new_valid_dev);
	eval 'sub new_encode_dev {
	    my($dev) = @_;
    	    eval q({ \'unsigned major\' =  &MAJOR($dev); \'unsigned minor\' =  &MINOR($dev); ( &minor & 0xff) | ( &major << 8) | (( &minor & ~0xff) << 12); });
	}' unless defined(&new_encode_dev);
	eval 'sub new_decode_dev {
	    my($dev) = @_;
    	    eval q({ \'unsigned major\' = ($dev & 0xfff00) >> 8; \'unsigned minor\' = ($dev & 0xff) | (($dev >> 12) & 0xfff00);  &MKDEV( &major,  &minor); });
	}' unless defined(&new_decode_dev);
	eval 'sub huge_valid_dev {
	    my($dev) = @_;
    	    eval q({ 1; });
	}' unless defined(&huge_valid_dev);
	eval 'sub huge_encode_dev {
	    my($dev) = @_;
    	    eval q({  &new_encode_dev($dev); });
	}' unless defined(&huge_encode_dev);
	eval 'sub huge_decode_dev {
	    my($dev) = @_;
    	    eval q({  &new_decode_dev($dev); });
	}' unless defined(&huge_decode_dev);
	eval 'sub sysv_valid_dev {
	    my($dev) = @_;
    	    eval q({  &MAJOR($dev) < (1<<14)  &&  &MINOR($dev) < (1<<18); });
	}' unless defined(&sysv_valid_dev);
	eval 'sub sysv_encode_dev {
	    my($dev) = @_;
    	    eval q({  &MINOR($dev) | ( &MAJOR($dev) << 18); });
	}' unless defined(&sysv_encode_dev);
	eval 'sub sysv_major {
	    my($dev) = @_;
    	    eval q({ ($dev >> 18) & 0x3fff; });
	}' unless defined(&sysv_major);
	eval 'sub sysv_minor {
	    my($dev) = @_;
    	    eval q({ $dev & 0x3ffff; });
	}' unless defined(&sysv_minor);
    } else {
	eval 'sub MAJOR {
	    my($dev) = @_;
    	    eval q((($dev)>>8));
	}' unless defined(&MAJOR);
	eval 'sub MINOR {
	    my($dev) = @_;
    	    eval q((($dev) & 0xff));
	}' unless defined(&MINOR);
	eval 'sub MKDEV {
	    my($ma,$mi) = @_;
    	    eval q((($ma)<<8| ($mi)));
	}' unless defined(&MKDEV);
    }
}
1;
