require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_MEMPOLICY_H)) {
    eval 'sub _LINUX_MEMPOLICY_H {1;}' unless defined(&_LINUX_MEMPOLICY_H);
    require 'linux/errno.ph';
    eval 'sub MPOL_DEFAULT {0;}' unless defined(&MPOL_DEFAULT);
    eval 'sub MPOL_PREFERRED {1;}' unless defined(&MPOL_PREFERRED);
    eval 'sub MPOL_BIND {2;}' unless defined(&MPOL_BIND);
    eval 'sub MPOL_INTERLEAVE {3;}' unless defined(&MPOL_INTERLEAVE);
    eval 'sub MPOL_MAX { &MPOL_INTERLEAVE;}' unless defined(&MPOL_MAX);
    eval 'sub MPOL_F_NODE {(1<<0);}' unless defined(&MPOL_F_NODE);
    eval 'sub MPOL_F_ADDR {(1<<1);}' unless defined(&MPOL_F_ADDR);
    eval 'sub MPOL_MF_STRICT {(1<<0);}' unless defined(&MPOL_MF_STRICT);
    eval 'sub MPOL_MF_MOVE {(1<<1);}' unless defined(&MPOL_MF_MOVE);
    eval 'sub MPOL_MF_MOVE_ALL {(1<<2);}' unless defined(&MPOL_MF_MOVE_ALL);
    eval 'sub MPOL_MF_INTERNAL {(1<<3);}' unless defined(&MPOL_MF_INTERNAL);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/mmzone.ph';
	require 'linux/slab.ph';
	require 'linux/rbtree.ph';
	require 'linux/spinlock.ph';
	require 'linux/nodemask.ph';
	if(defined(&CONFIG_NUMA)) {
	    eval 'sub mpol_free {
	        my($pol) = @_;
    		eval q({  &if ($pol)  &__mpol_free($pol); });
	    }' unless defined(&mpol_free);
	    eval 'sub mempolicy {
	        eval q(* &mpol_copy(\'struct mempolicy\' * &pol) {  &if ( &pol)  &pol =  &__mpol_copy( &pol);  &pol; });
	    }' unless defined(&mempolicy);
	    eval 'sub vma_policy {
	        my($vma) = @_;
    		eval q((($vma)-> &vm_policy));
	    }' unless defined(&vma_policy);
	    eval 'sub vma_set_policy {
	        my($vma, $pol) = @_;
    		eval q((($vma)-> &vm_policy = ($pol)));
	    }' unless defined(&vma_set_policy);
	    eval 'sub mpol_get {
	        my($pol) = @_;
    		eval q({  &if ($pol)  &atomic_inc( ($pol->{refcnt})); });
	    }' unless defined(&mpol_get);
	    eval 'sub mpol_equal {
	        my($a,$b) = @_;
    		eval q({  &if ($a == $b) 1;  &__mpol_equal($a, $b); });
	    }' unless defined(&mpol_equal);
	    eval 'sub vma_mpol_equal {
	        my($a,$b) = @_;
    		eval q( &mpol_equal( &vma_policy($a),  &vma_policy($b)));
	    }' unless defined(&vma_mpol_equal);
	    eval 'sub mpol_set_vma_default {
	        my($vma) = @_;
    		eval q((($vma)-> &vm_policy =  &NULL));
	    }' unless defined(&mpol_set_vma_default);
	    eval 'sub set_cpuset_being_rebound {
	        my($x) = @_;
    		eval q(( &cpuset_being_rebound = ($x)));
	    }' unless defined(&set_cpuset_being_rebound);
	    if(defined(&CONFIG_CPUSET)) {
		eval 'sub current_cpuset_is_being_rebound () {
		    eval q(( &cpuset_being_rebound ==  ($current->{cpuset})));
		}' unless defined(&current_cpuset_is_being_rebound);
	    } else {
		eval 'sub current_cpuset_is_being_rebound () {
		    eval q(0);
		}' unless defined(&current_cpuset_is_being_rebound);
	    }
	    eval 'sub check_highest_zone {
	        my($k) = @_;
    		eval q({  &if ($k >  &policy_zone)  &policy_zone = $k; });
	    }' unless defined(&check_highest_zone);
	} else {
	    eval 'sub mpol_equal {
	        my($a,$b) = @_;
    		eval q({ 1; });
	    }' unless defined(&mpol_equal);
	    eval 'sub vma_mpol_equal {
	        my($a,$b) = @_;
    		eval q(1);
	    }' unless defined(&vma_mpol_equal);
	    eval 'sub mpol_set_vma_default {
	        my($vma) = @_;
    		eval q( &do {}  &while(0));
	    }' unless defined(&mpol_set_vma_default);
	    eval 'sub mpol_free {
	        my($p) = @_;
    		eval q({ });
	    }' unless defined(&mpol_free);
	    eval 'sub mpol_get {
	        my($pol) = @_;
    		eval q({ });
	    }' unless defined(&mpol_get);
	    eval 'sub mempolicy {
	        eval q(* &mpol_copy(\'struct mempolicy\' * &old) {  &NULL; });
	    }' unless defined(&mempolicy);
	    eval 'sub mpol_set_shared_policy {
	        my($info,$vma,$new) = @_;
    		eval q({ - &EINVAL; });
	    }' unless defined(&mpol_set_shared_policy);
	    eval 'sub mpol_shared_policy_init {
	        my($info,$policy,$nodes) = @_;
    		eval q({ });
	    }' unless defined(&mpol_shared_policy_init);
	    eval 'sub mpol_free_shared_policy {
	        my($p) = @_;
    		eval q({ });
	    }' unless defined(&mpol_free_shared_policy);
	    eval 'sub mpol_shared_policy_lookup {
	        my($sp,$idx) = @_;
    		eval q({  &NULL; });
	    }' unless defined(&mpol_shared_policy_lookup);
	    eval 'sub vma_policy {
	        my($vma) = @_;
    		eval q( &NULL);
	    }' unless defined(&vma_policy);
	    eval 'sub vma_set_policy {
	        my($vma, $pol) = @_;
    		eval q( &do {}  &while(0));
	    }' unless defined(&vma_set_policy);
	    eval 'sub numa_policy_init {
	        my($void) = @_;
    		eval q({ });
	    }' unless defined(&numa_policy_init);
	    eval 'sub numa_default_policy {
	        my($void) = @_;
    		eval q({ });
	    }' unless defined(&numa_default_policy);
	    eval 'sub mpol_rebind_policy {
	        my($pol,$new) = @_;
    		eval q({ });
	    }' unless defined(&mpol_rebind_policy);
	    eval 'sub mpol_rebind_task {
	        my($tsk,$new) = @_;
    		eval q({ });
	    }' unless defined(&mpol_rebind_task);
	    eval 'sub mpol_rebind_mm {
	        my($mm,$new) = @_;
    		eval q({ });
	    }' unless defined(&mpol_rebind_mm);
	    eval 'sub set_cpuset_being_rebound {
	        my($x) = @_;
    		eval q( &do {}  &while (0));
	    }' unless defined(&set_cpuset_being_rebound);
	    eval 'sub zonelist {
	        eval q(* &huge_zonelist(\'struct vm_area_struct\' * &vma, my $addr) {  &NODE_DATA(0)-> &node_zonelists +  &gfp_zone( &GFP_HIGHUSER); });
	    }' unless defined(&zonelist);
	    eval 'sub do_migrate_pages {
	        my($mm,$from_nodes,$to_nodes,$flags) = @_;
    		eval q({ 0; });
	    }' unless defined(&do_migrate_pages);
	    eval 'sub check_highest_zone {
	        my($k) = @_;
    		eval q({ });
	    }' unless defined(&check_highest_zone);
	}
    }
}
1;
