require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NET_H)) {
    eval 'sub _LINUX_NET_H {1;}' unless defined(&_LINUX_NET_H);
    require 'linux/config.ph';
    require 'linux/wait.ph';
    require 'linux/stringify.ph';
    require 'asm/socket.ph';
    eval 'sub NPROTO {32;}' unless defined(&NPROTO);
    eval 'sub SYS_SOCKET {1;}' unless defined(&SYS_SOCKET);
    eval 'sub SYS_BIND {2;}' unless defined(&SYS_BIND);
    eval 'sub SYS_CONNECT {3;}' unless defined(&SYS_CONNECT);
    eval 'sub SYS_LISTEN {4;}' unless defined(&SYS_LISTEN);
    eval 'sub SYS_ACCEPT {5;}' unless defined(&SYS_ACCEPT);
    eval 'sub SYS_GETSOCKNAME {6;}' unless defined(&SYS_GETSOCKNAME);
    eval 'sub SYS_GETPEERNAME {7;}' unless defined(&SYS_GETPEERNAME);
    eval 'sub SYS_SOCKETPAIR {8;}' unless defined(&SYS_SOCKETPAIR);
    eval 'sub SYS_SEND {9;}' unless defined(&SYS_SEND);
    eval 'sub SYS_RECV {10;}' unless defined(&SYS_RECV);
    eval 'sub SYS_SENDTO {11;}' unless defined(&SYS_SENDTO);
    eval 'sub SYS_RECVFROM {12;}' unless defined(&SYS_RECVFROM);
    eval 'sub SYS_SHUTDOWN {13;}' unless defined(&SYS_SHUTDOWN);
    eval 'sub SYS_SETSOCKOPT {14;}' unless defined(&SYS_SETSOCKOPT);
    eval 'sub SYS_GETSOCKOPT {15;}' unless defined(&SYS_GETSOCKOPT);
    eval 'sub SYS_SENDMSG {16;}' unless defined(&SYS_SENDMSG);
    eval 'sub SYS_RECVMSG {17;}' unless defined(&SYS_RECVMSG);
    eval("sub SS_FREE () { 0; }") unless defined(&SS_FREE);
    eval("sub SS_UNCONNECTED () { 1; }") unless defined(&SS_UNCONNECTED);
    eval("sub SS_CONNECTING () { 2; }") unless defined(&SS_CONNECTING);
    eval("sub SS_CONNECTED () { 3; }") unless defined(&SS_CONNECTED);
    eval("sub SS_DISCONNECTING () { 4; }") unless defined(&SS_DISCONNECTING);
    eval 'sub __SO_ACCEPTCON {(1<< 16);}' unless defined(&__SO_ACCEPTCON);
    if(defined(&__KERNEL__)) {
	eval 'sub SOCK_ASYNC_NOSPACE {0;}' unless defined(&SOCK_ASYNC_NOSPACE);
	eval 'sub SOCK_ASYNC_WAITDATA {1;}' unless defined(&SOCK_ASYNC_WAITDATA);
	eval 'sub SOCK_NOSPACE {2;}' unless defined(&SOCK_NOSPACE);
	eval 'sub SOCK_PASSCRED {3;}' unless defined(&SOCK_PASSCRED);
	unless(defined(&ARCH_HAS_SOCKET_TYPES)) {
	    eval("sub SOCK_STREAM () { 1; }") unless defined(&SOCK_STREAM);
	    eval("sub SOCK_DGRAM () { 2; }") unless defined(&SOCK_DGRAM);
	    eval("sub SOCK_RAW () { 3; }") unless defined(&SOCK_RAW);
	    eval("sub SOCK_RDM () { 4; }") unless defined(&SOCK_RDM);
	    eval("sub SOCK_SEQPACKET () { 5; }") unless defined(&SOCK_SEQPACKET);
	    eval("sub SOCK_DCCP () { 6; }") unless defined(&SOCK_DCCP);
	    eval("sub SOCK_PACKET () { 10; }") unless defined(&SOCK_PACKET);
	    eval 'sub SOCK_MAX {( &SOCK_PACKET + 1);}' unless defined(&SOCK_MAX);
	}
	eval 'sub sockfd_put {
	    my($sock) = @_;
    	    eval q( &fput( ($sock->{file})));
	}' unless defined(&sockfd_put);
	unless(defined(&CONFIG_SMP)) {
	    eval 'sub SOCKOPS_WRAPPED {
	        my($name) = @_;
    		eval q($name);
	    }' unless defined(&SOCKOPS_WRAPPED);
	    eval 'sub SOCKOPS_WRAP {
	        my($name, $fam) = @_;
    		eval q();
	    }' unless defined(&SOCKOPS_WRAP);
	} else {
	    eval 'sub SOCKOPS_WRAPPED {
	        my($name) = @_;
    		eval q( &__unlocked_$name);
	    }' unless defined(&SOCKOPS_WRAPPED);
	    eval 'sub SOCKCALL_WRAP {
	        my($name, $call, $parms, $args) = @_;
    		eval q( &static \'int\'  &__lock_$name &_$call $parms { \'int\'  &ret;  &lock_kernel();  &ret =  &__unlocked_$name ($_ops->{call})  $args ;  &unlock_kernel();  &return  &ret; });
	    }' unless defined(&SOCKCALL_WRAP);
	    eval 'sub SOCKCALL_UWRAP {
	        my($name, $call, $parms, $args) = @_;
    		eval q( &static \'unsigned int __lock_\'$name &_$call $parms { \'int\'  &ret;  &lock_kernel();  &ret =  &__unlocked_$name ($_ops->{call})  $args ;  &unlock_kernel();  &return  &ret; });
	    }' unless defined(&SOCKCALL_UWRAP);
	    eval 'sub SOCKOPS_WRAP {
	        my($name, $fam) = @_;
    		eval q( &SOCKCALL_WRAP($name,  &release, (\'struct socket\' * &sock), ( &sock))  &SOCKCALL_WRAP($name,  &bind, (\'struct socket\' * &sock, \'struct sockaddr\' * &uaddr, \'int\'  &addr_len), ( &sock,  &uaddr,  &addr_len))  &SOCKCALL_WRAP($name,  &connect, (\'struct socket\' * &sock, \'struct sockaddr\' *  &uaddr, \'int\'  &addr_len, \'int\'  &flags), ( &sock,  &uaddr,  &addr_len,  &flags))  &SOCKCALL_WRAP($name,  &socketpair, (\'struct socket\' * &sock1, \'struct socket\' * &sock2), ( &sock1,  &sock2))  &SOCKCALL_WRAP($name,  &accept, (\'struct socket\' * &sock, \'struct socket\' * &newsock, \'int\'  &flags), ( &sock,  &newsock,  &flags))  &SOCKCALL_WRAP($name,  &getname, (\'struct socket\' * &sock, \'struct sockaddr\' * &uaddr, \'int\' * &addr_len, \'int\'  &peer), ( &sock,  &uaddr,  &addr_len,  &peer))  &SOCKCALL_UWRAP($name,  &poll, (\'struct file\' * &file, \'struct socket\' * &sock, \'struct poll_table_struct\' * &wait), ( &file,  &sock,  &wait))  &SOCKCALL_WRAP($name,  &ioctl, (\'struct socket\' * &sock, \'unsigned int cmd\', \'unsigned long arg\'), ( &sock,  &cmd,  &arg))  &SOCKCALL_WRAP($name,  &listen, (\'struct socket\' * &sock, \'int\'  &len), ( &sock,  &len))  &SOCKCALL_WRAP($name,  &shutdown, (\'struct socket\' * &sock, \'int\'  &flags), ( &sock,  &flags))  &SOCKCALL_WRAP($name,  &setsockopt, (\'struct socket\' * &sock, \'int\'  &level, \'int\'  &optname, \'char\'  &__user * &optval, \'int\'  &optlen), ( &sock,  &level,  &optname,  &optval,  &optlen))  &SOCKCALL_WRAP($name,  &getsockopt, (\'struct socket\' * &sock, \'int\'  &level, \'int\'  &optname, \'char\'  &__user * &optval, \'int\'  &__user * &optlen), ( &sock,  &level,  &optname,  &optval,  &optlen))  &SOCKCALL_WRAP($name,  &sendmsg, (\'struct kiocb\' * &iocb, \'struct socket\' * &sock, \'struct msghdr\' * &m, \'size_t\'  &len), ( &iocb,  &sock,  &m,  &len))  &SOCKCALL_WRAP($name,  &recvmsg, (\'struct kiocb\' * &iocb, \'struct socket\' * &sock, \'struct msghdr\' * &m, \'size_t\'  &len, \'int\'  &flags), ( &iocb,  &sock,  &m,  &len,  &flags))  &SOCKCALL_WRAP($name,  &mmap, (\'struct file\' * &file, \'struct socket\' * &sock, \'struct vm_area_struct\' * &vma), ( &file,  &sock,  &vma))  &static  &const \'struct proto_ops\' $name &_ops = { . &family = $fam, . &owner =  &THIS_MODULE, . &release =  &__lock_$name &_release, . &bind =  &__lock_$name &_bind, . &connect =  &__lock_$name &_connect, . &socketpair =  &__lock_$name &_socketpair, . &accept =  &__lock_$name &_accept, . &getname =  &__lock_$name &_getname, . &poll =  &__lock_$name &_poll, . &ioctl =  &__lock_$name &_ioctl, . &listen =  &__lock_$name &_listen, . &shutdown =  &__lock_$name &_shutdown, . &setsockopt =  &__lock_$name &_setsockopt, . &getsockopt =  &__lock_$name &_getsockopt, . &sendmsg =  &__lock_$name &_sendmsg, . &recvmsg =  &__lock_$name &_recvmsg, . &mmap =  &__lock_$name &_mmap, };);
	    }' unless defined(&SOCKOPS_WRAP);
	}
	eval 'sub MODULE_ALIAS_NETPROTO {
	    my($proto) = @_;
    	    eval q( &MODULE_ALIAS(\\"net-pf-\\"  &__stringify($proto)));
	}' unless defined(&MODULE_ALIAS_NETPROTO);
	eval 'sub MODULE_ALIAS_NET_PF_PROTO {
	    my($pf, $proto) = @_;
    	    eval q( &MODULE_ALIAS(\\"net-pf-\\"  &__stringify($pf) \\"-proto-\\"  &__stringify($proto)));
	}' unless defined(&MODULE_ALIAS_NET_PF_PROTO);
	if(defined(&CONFIG_SYSCTL)) {
	    require 'linux/sysctl.ph';
	}
    }
}
1;
