require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_PERCPU_COUNTER_H)) {
    eval 'sub _LINUX_PERCPU_COUNTER_H {1;}' unless defined(&_LINUX_PERCPU_COUNTER_H);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/spinlock.ph';
	require 'linux/smp.ph';
	require 'linux/threads.ph';
	require 'linux/percpu.ph';
    }
    if(defined( &CONFIG_SMP)  && defined( &__KERNEL__)) {
	if((defined(&NR_CPUS) ? &NR_CPUS : 0) >= 16) {
	    eval 'sub FBC_BATCH {( &NR_CPUS*2);}' unless defined(&FBC_BATCH);
	} else {
	    eval 'sub FBC_BATCH {( &NR_CPUS*4);}' unless defined(&FBC_BATCH);
	}
	eval 'sub percpu_counter_init {
	    my($fbc) = @_;
    	    eval q({  &spin_lock_init( ($fbc->{lock}));  ($fbc->{count}) = 0;  ($fbc->{counters}) =  &alloc_percpu; });
	}' unless defined(&percpu_counter_init);
	eval 'sub percpu_counter_destroy {
	    my($fbc) = @_;
    	    eval q({  &free_percpu( ($fbc->{counters})); });
	}' unless defined(&percpu_counter_destroy);
	eval 'sub percpu_counter_read {
	    my($fbc) = @_;
    	    eval q({  ($fbc->{count}); });
	}' unless defined(&percpu_counter_read);
    } else {
	eval 'sub percpu_counter_init {
	    my($fbc) = @_;
    	    eval q({  ($fbc->{count}) = 0; });
	}' unless defined(&percpu_counter_init);
	eval 'sub percpu_counter_destroy {
	    my($fbc) = @_;
    	    eval q({ });
	}' unless defined(&percpu_counter_destroy);
	eval 'sub percpu_counter_mod {
	    my($fbc,$amount) = @_;
    	    eval q({  &preempt_disable();  ($fbc->{count}) += $amount;  &preempt_enable(); });
	}' unless defined(&percpu_counter_mod);
	eval 'sub percpu_counter_read {
	    my($fbc) = @_;
    	    eval q({  ($fbc->{count}); });
	}' unless defined(&percpu_counter_read);
	eval 'sub percpu_counter_read_positive {
	    my($fbc) = @_;
    	    eval q({  ($fbc->{count}); });
	}' unless defined(&percpu_counter_read_positive);
	eval 'sub percpu_counter_sum {
	    my($fbc) = @_;
    	    eval q({  &percpu_counter_read_positive($fbc); });
	}' unless defined(&percpu_counter_sum);
    }
    eval 'sub percpu_counter_inc {
        my($fbc) = @_;
	    eval q({  &percpu_counter_mod($fbc, 1); });
    }' unless defined(&percpu_counter_inc);
    eval 'sub percpu_counter_dec {
        my($fbc) = @_;
	    eval q({  &percpu_counter_mod($fbc, -1); });
    }' unless defined(&percpu_counter_dec);
}
1;
