require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_RMAP_H)) {
    eval 'sub _LINUX_RMAP_H {1;}' unless defined(&_LINUX_RMAP_H);
    require 'linux/config.ph';
    require 'linux/list.ph';
    require 'linux/slab.ph';
    require 'linux/mm.ph';
    require 'linux/spinlock.ph';
    if(defined(&CONFIG_MMU)) {
	eval 'sub anon_vma {
	    eval q(* &anon_vma_alloc( &void) {  &kmem_cache_alloc( &anon_vma_cachep,  &SLAB_KERNEL); });
	}' unless defined(&anon_vma);
	eval 'sub anon_vma_free {
	    my($anon_vma) = @_;
    	    eval q({  &kmem_cache_free( &anon_vma_cachep, $anon_vma); });
	}' unless defined(&anon_vma_free);
	eval 'sub anon_vma_lock {
	    my($vma) = @_;
    	    eval q({ \'struct anon_vma\' * &anon_vma =  ($vma->{anon_vma});  &if ( &anon_vma)  &spin_lock( ($anon_vma->{lock})); });
	}' unless defined(&anon_vma_lock);
	eval 'sub anon_vma_unlock {
	    my($vma) = @_;
    	    eval q({ \'struct anon_vma\' * &anon_vma =  ($vma->{anon_vma});  &if ( &anon_vma)  &spin_unlock( ($anon_vma->{lock})); });
	}' unless defined(&anon_vma_unlock);
    } else {
	eval 'sub anon_vma_init () {
	    eval q( &do {}  &while (0));
	}' unless defined(&anon_vma_init);
	eval 'sub anon_vma_prepare {
	    my($vma) = @_;
    	    eval q((0));
	}' unless defined(&anon_vma_prepare);
	eval 'sub anon_vma_link {
	    my($vma) = @_;
    	    eval q( &do {}  &while (0));
	}' unless defined(&anon_vma_link);
	eval 'sub page_referenced {
	    my($page,$l) = @_;
    	    eval q( &TestClearPageReferenced($page));
	}' unless defined(&page_referenced);
	eval 'sub try_to_unmap {
	    my($page, $refs) = @_;
    	    eval q( &SWAP_FAIL);
	}' unless defined(&try_to_unmap);
    }
    eval 'sub SWAP_SUCCESS {0;}' unless defined(&SWAP_SUCCESS);
    eval 'sub SWAP_AGAIN {1;}' unless defined(&SWAP_AGAIN);
    eval 'sub SWAP_FAIL {2;}' unless defined(&SWAP_FAIL);
}
1;
