require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_SECURITY_H)) {
    eval 'sub __LINUX_SECURITY_H {1;}' unless defined(&__LINUX_SECURITY_H);
    require 'linux/fs.ph';
    require 'linux/binfmts.ph';
    require 'linux/signal.ph';
    require 'linux/resource.ph';
    require 'linux/sem.ph';
    require 'linux/shm.ph';
    require 'linux/msg.ph';
    require 'linux/sched.ph';
    require 'linux/key.ph';
    eval 'sub LSM_SETID_ID {1;}' unless defined(&LSM_SETID_ID);
    eval 'sub LSM_SETID_RE {2;}' unless defined(&LSM_SETID_RE);
    eval 'sub LSM_SETID_RES {4;}' unless defined(&LSM_SETID_RES);
    eval 'sub LSM_SETID_FS {8;}' unless defined(&LSM_SETID_FS);
    eval 'sub LSM_UNSAFE_SHARE {1;}' unless defined(&LSM_UNSAFE_SHARE);
    eval 'sub LSM_UNSAFE_PTRACE {2;}' unless defined(&LSM_UNSAFE_PTRACE);
    eval 'sub LSM_UNSAFE_PTRACE_CAP {4;}' unless defined(&LSM_UNSAFE_PTRACE_CAP);
    if(defined(&CONFIG_SECURITY)) {
	if(defined(&CONFIG_SECURITY_NETWORK)) {
	}
	if(defined(&CONFIG_SECURITY_NETWORK_XFRM)) {
	}
	if(defined(&CONFIG_KEYS)) {
	}
	eval 'sub security_capget {
	    my($target,$effective,$inheritable,$permitted) = @_;
    	    eval q({  ($security_ops->{capget}) ($target, $effective, $inheritable, $permitted); });
	}' unless defined(&security_capget);
	eval 'sub security_capset_check {
	    my($target,$effective,$inheritable,$permitted) = @_;
    	    eval q({  ($security_ops->{capset_check}) ($target, $effective, $inheritable, $permitted); });
	}' unless defined(&security_capset_check);
	eval 'sub security_capset_set {
	    my($target,$effective,$inheritable,$permitted) = @_;
    	    eval q({  ($security_ops->{capset_set}) ($target, $effective, $inheritable, $permitted); });
	}' unless defined(&security_capset_set);
	eval 'sub security_acct {
	    my($file) = @_;
    	    eval q({  ($security_ops->{acct}) ($file); });
	}' unless defined(&security_acct);
	eval 'sub security_sysctl {
	    my($table,$op) = @_;
    	    eval q({  ($security_ops->{sysctl})($table, $op); });
	}' unless defined(&security_sysctl);
	eval 'sub security_quotactl {
	    my($cmds,$type,$id,$sb) = @_;
    	    eval q({  ($security_ops->{quotactl}) ($cmds, $type, $id, $sb); });
	}' unless defined(&security_quotactl);
	eval 'sub security_quota_on {
	    my($dentry) = @_;
    	    eval q({  ($security_ops->{quota_on}) ($dentry); });
	}' unless defined(&security_quota_on);
	eval 'sub security_syslog {
	    my($type) = @_;
    	    eval q({  ($security_ops->{syslog})($type); });
	}' unless defined(&security_syslog);
	eval 'sub security_settime {
	    my($ts,$tz) = @_;
    	    eval q({  ($security_ops->{settime})($ts, $tz); });
	}' unless defined(&security_settime);
	eval 'sub security_vm_enough_memory {
	    my($pages) = @_;
    	    eval q({  ($security_ops->{vm_enough_memory})($pages); });
	}' unless defined(&security_vm_enough_memory);
	eval 'sub security_bprm_alloc {
	    my($bprm) = @_;
    	    eval q({  ($security_ops->{bprm_alloc_security}) ($bprm); });
	}' unless defined(&security_bprm_alloc);
	eval 'sub security_bprm_free {
	    my($bprm) = @_;
    	    eval q({  ($security_ops->{bprm_free_security}) ($bprm); });
	}' unless defined(&security_bprm_free);
	eval 'sub security_bprm_apply_creds {
	    my($bprm,$unsafe) = @_;
    	    eval q({  ($security_ops->{bprm_apply_creds}) ($bprm, $unsafe); });
	}' unless defined(&security_bprm_apply_creds);
	eval 'sub security_bprm_post_apply_creds {
	    my($bprm) = @_;
    	    eval q({  ($security_ops->{bprm_post_apply_creds}) ($bprm); });
	}' unless defined(&security_bprm_post_apply_creds);
	eval 'sub security_bprm_set {
	    my($bprm) = @_;
    	    eval q({  ($security_ops->{bprm_set_security}) ($bprm); });
	}' unless defined(&security_bprm_set);
	eval 'sub security_bprm_check {
	    my($bprm) = @_;
    	    eval q({  ($security_ops->{bprm_check_security}) ($bprm); });
	}' unless defined(&security_bprm_check);
	eval 'sub security_bprm_secureexec {
	    my($bprm) = @_;
    	    eval q({  ($security_ops->{bprm_secureexec}) ($bprm); });
	}' unless defined(&security_bprm_secureexec);
	eval 'sub security_sb_alloc {
	    my($sb) = @_;
    	    eval q({  ($security_ops->{sb_alloc_security}) ($sb); });
	}' unless defined(&security_sb_alloc);
	eval 'sub security_sb_free {
	    my($sb) = @_;
    	    eval q({  ($security_ops->{sb_free_security}) ($sb); });
	}' unless defined(&security_sb_free);
	eval 'sub security_sb_copy_data {
	    my($type,$orig,$copy) = @_;
    	    eval q({  ($security_ops->{sb_copy_data}) ($type, $orig, $copy); });
	}' unless defined(&security_sb_copy_data);
	eval 'sub security_sb_kern_mount {
	    my($sb,$data) = @_;
    	    eval q({  ($security_ops->{sb_kern_mount}) ($sb, $data); });
	}' unless defined(&security_sb_kern_mount);
	eval 'sub security_sb_statfs {
	    my($sb) = @_;
    	    eval q({  ($security_ops->{sb_statfs}) ($sb); });
	}' unless defined(&security_sb_statfs);
	eval 'sub security_sb_mount {
	    my($dev_name,$nd,$type,$flags,$data) = @_;
    	    eval q({  ($security_ops->{sb_mount}) ($dev_name, $nd, $type, $flags, $data); });
	}' unless defined(&security_sb_mount);
	eval 'sub security_sb_check_sb {
	    my($mnt,$nd) = @_;
    	    eval q({  ($security_ops->{sb_check_sb}) ($mnt, $nd); });
	}' unless defined(&security_sb_check_sb);
	eval 'sub security_sb_umount {
	    my($mnt,$flags) = @_;
    	    eval q({  ($security_ops->{sb_umount}) ($mnt, $flags); });
	}' unless defined(&security_sb_umount);
	eval 'sub security_sb_umount_close {
	    my($mnt) = @_;
    	    eval q({  ($security_ops->{sb_umount_close}) ($mnt); });
	}' unless defined(&security_sb_umount_close);
	eval 'sub security_sb_umount_busy {
	    my($mnt) = @_;
    	    eval q({  ($security_ops->{sb_umount_busy}) ($mnt); });
	}' unless defined(&security_sb_umount_busy);
	eval 'sub security_sb_post_remount {
	    my($mnt,$flags,$data) = @_;
    	    eval q({  ($security_ops->{sb_post_remount}) ($mnt, $flags, $data); });
	}' unless defined(&security_sb_post_remount);
	eval 'sub security_sb_post_mountroot {
	    my($void) = @_;
    	    eval q({  ($security_ops->{sb_post_mountroot}) (); });
	}' unless defined(&security_sb_post_mountroot);
	eval 'sub security_sb_post_addmount {
	    my($mnt,$mountpoint_nd) = @_;
    	    eval q({  ($security_ops->{sb_post_addmount}) ($mnt, $mountpoint_nd); });
	}' unless defined(&security_sb_post_addmount);
	eval 'sub security_sb_pivotroot {
	    my($old_nd,$new_nd) = @_;
    	    eval q({  ($security_ops->{sb_pivotroot}) ($old_nd, $new_nd); });
	}' unless defined(&security_sb_pivotroot);
	eval 'sub security_sb_post_pivotroot {
	    my($old_nd,$new_nd) = @_;
    	    eval q({  ($security_ops->{sb_post_pivotroot}) ($old_nd, $new_nd); });
	}' unless defined(&security_sb_post_pivotroot);
	eval 'sub security_inode_alloc {
	    my($inode) = @_;
    	    eval q({  ($security_ops->{inode_alloc_security}) ($inode); });
	}' unless defined(&security_inode_alloc);
	eval 'sub security_inode_free {
	    my($inode) = @_;
    	    eval q({  ($security_ops->{inode_free_security}) ($inode); });
	}' unless defined(&security_inode_free);
	eval 'sub security_inode_init_security {
	    my($inode,$dir,$name,$value,$len) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ($inode))) - &EOPNOTSUPP;  ($security_ops->{inode_init_security}) ($inode, $dir, $name, $value, $len); });
	}' unless defined(&security_inode_init_security);
	eval 'sub security_inode_link {
	    my($old_dentry,$dir,$new_dentry) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($old_dentry->{d_inode})))) 0;  ($security_ops->{inode_link}) ($old_dentry, $dir, $new_dentry); });
	}' unless defined(&security_inode_link);
	eval 'sub security_inode_unlink {
	    my($dir,$dentry) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_unlink}) ($dir, $dentry); });
	}' unless defined(&security_inode_unlink);
	eval 'sub security_inode_symlink {
	    my($dir,$dentry,$old_name) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ($dir))) 0;  ($security_ops->{inode_symlink}) ($dir, $dentry, $old_name); });
	}' unless defined(&security_inode_symlink);
	eval 'sub security_inode_mkdir {
	    my($dir,$dentry,$mode) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ($dir))) 0;  ($security_ops->{inode_mkdir}) ($dir, $dentry, $mode); });
	}' unless defined(&security_inode_mkdir);
	eval 'sub security_inode_rmdir {
	    my($dir,$dentry) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_rmdir}) ($dir, $dentry); });
	}' unless defined(&security_inode_rmdir);
	eval 'sub security_inode_mknod {
	    my($dir,$dentry,$mode,$dev) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ($dir))) 0;  ($security_ops->{inode_mknod}) ($dir, $dentry, $mode, $dev); });
	}' unless defined(&security_inode_mknod);
	eval 'sub security_inode_rename {
	    my($old_dir,$old_dentry,$new_dir,$new_dentry) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($old_dentry->{d_inode})) || ( ($new_dentry->{d_inode})  &&  &IS_PRIVATE ( ($new_dentry->{d_inode}))))) 0;  ($security_ops->{inode_rename}) ($old_dir, $old_dentry, $new_dir, $new_dentry); });
	}' unless defined(&security_inode_rename);
	eval 'sub security_inode_readlink {
	    my($dentry) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_readlink}) ($dentry); });
	}' unless defined(&security_inode_readlink);
	eval 'sub security_inode_follow_link {
	    my($dentry,$nd) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_follow_link}) ($dentry, $nd); });
	}' unless defined(&security_inode_follow_link);
	eval 'sub security_inode_permission {
	    my($inode,$mask,$nd) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ($inode))) 0;  ($security_ops->{inode_permission}) ($inode, $mask, $nd); });
	}' unless defined(&security_inode_permission);
	eval 'sub security_inode_setattr {
	    my($dentry,$attr) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_setattr}) ($dentry, $attr); });
	}' unless defined(&security_inode_setattr);
	eval 'sub security_inode_getattr {
	    my($mnt,$dentry) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_getattr}) ($mnt, $dentry); });
	}' unless defined(&security_inode_getattr);
	eval 'sub security_inode_delete {
	    my($inode) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ($inode))) ;  ($security_ops->{inode_delete}) ($inode); });
	}' unless defined(&security_inode_delete);
	eval 'sub security_inode_setxattr {
	    my($dentry,$name,$value,$size,$flags) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_setxattr}) ($dentry, $name, $value, $size, $flags); });
	}' unless defined(&security_inode_setxattr);
	eval 'sub security_inode_post_setxattr {
	    my($dentry,$name,$value,$size,$flags) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) ;  ($security_ops->{inode_post_setxattr}) ($dentry, $name, $value, $size, $flags); });
	}' unless defined(&security_inode_post_setxattr);
	eval 'sub security_inode_getxattr {
	    my($dentry,$name) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_getxattr}) ($dentry, $name); });
	}' unless defined(&security_inode_getxattr);
	eval 'sub security_inode_listxattr {
	    my($dentry) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_listxattr}) ($dentry); });
	}' unless defined(&security_inode_listxattr);
	eval 'sub security_inode_removexattr {
	    my($dentry,$name) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ( ($dentry->{d_inode})))) 0;  ($security_ops->{inode_removexattr}) ($dentry, $name); });
	}' unless defined(&security_inode_removexattr);
	eval 'sub security_inode_getsecurity {
	    my($inode,$name,$buffer,$size,$err) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ($inode))) 0;  ($security_ops->{inode_getsecurity})($inode, $name, $buffer, $size, $err); });
	}' unless defined(&security_inode_getsecurity);
	eval 'sub security_inode_setsecurity {
	    my($inode,$name,$value,$size,$flags) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ($inode))) 0;  ($security_ops->{inode_setsecurity})($inode, $name, $value, $size, $flags); });
	}' unless defined(&security_inode_setsecurity);
	eval 'sub security_inode_listsecurity {
	    my($inode,$buffer,$buffer_size) = @_;
    	    eval q({  &if ( &unlikely ( &IS_PRIVATE ($inode))) 0;  ($security_ops->{inode_listsecurity})($inode, $buffer, $buffer_size); });
	}' unless defined(&security_inode_listsecurity);
	eval 'sub security_file_permission {
	    my($file,$mask) = @_;
    	    eval q({  ($security_ops->{file_permission}) ($file, $mask); });
	}' unless defined(&security_file_permission);
	eval 'sub security_file_alloc {
	    my($file) = @_;
    	    eval q({  ($security_ops->{file_alloc_security}) ($file); });
	}' unless defined(&security_file_alloc);
	eval 'sub security_file_free {
	    my($file) = @_;
    	    eval q({  ($security_ops->{file_free_security}) ($file); });
	}' unless defined(&security_file_free);
	eval 'sub security_file_ioctl {
	    my($file,$cmd,$arg) = @_;
    	    eval q({  ($security_ops->{file_ioctl}) ($file, $cmd, $arg); });
	}' unless defined(&security_file_ioctl);
	eval 'sub security_file_mmap {
	    my($file,$reqprot,$prot,$flags) = @_;
    	    eval q({  ($security_ops->{file_mmap}) ($file, $reqprot, $prot, $flags); });
	}' unless defined(&security_file_mmap);
	eval 'sub security_file_mprotect {
	    my($vma,$reqprot,$prot) = @_;
    	    eval q({  ($security_ops->{file_mprotect}) ($vma, $reqprot, $prot); });
	}' unless defined(&security_file_mprotect);
	eval 'sub security_file_lock {
	    my($file,$cmd) = @_;
    	    eval q({  ($security_ops->{file_lock}) ($file, $cmd); });
	}' unless defined(&security_file_lock);
	eval 'sub security_file_fcntl {
	    my($file,$cmd,$arg) = @_;
    	    eval q({  ($security_ops->{file_fcntl}) ($file, $cmd, $arg); });
	}' unless defined(&security_file_fcntl);
	eval 'sub security_file_set_fowner {
	    my($file) = @_;
    	    eval q({  ($security_ops->{file_set_fowner}) ($file); });
	}' unless defined(&security_file_set_fowner);
	eval 'sub security_file_send_sigiotask {
	    my($tsk,$fown,$sig) = @_;
    	    eval q({  ($security_ops->{file_send_sigiotask}) ($tsk, $fown, $sig); });
	}' unless defined(&security_file_send_sigiotask);
	eval 'sub security_file_receive {
	    my($file) = @_;
    	    eval q({  ($security_ops->{file_receive}) ($file); });
	}' unless defined(&security_file_receive);
	eval 'sub security_task_create {
	    my($clone_flags) = @_;
    	    eval q({  ($security_ops->{task_create}) ($clone_flags); });
	}' unless defined(&security_task_create);
	eval 'sub security_task_alloc {
	    my($p) = @_;
    	    eval q({  ($security_ops->{task_alloc_security}) ($p); });
	}' unless defined(&security_task_alloc);
	eval 'sub security_task_free {
	    my($p) = @_;
    	    eval q({  ($security_ops->{task_free_security}) ($p); });
	}' unless defined(&security_task_free);
	eval 'sub security_task_setuid {
	    my($id0,$id1,$id2,$flags) = @_;
    	    eval q({  ($security_ops->{task_setuid}) ($id0, $id1, $id2, $flags); });
	}' unless defined(&security_task_setuid);
	eval 'sub security_task_post_setuid {
	    my($old_ruid,$old_euid,$old_suid,$flags) = @_;
    	    eval q({  ($security_ops->{task_post_setuid}) ($old_ruid, $old_euid, $old_suid, $flags); });
	}' unless defined(&security_task_post_setuid);
	eval 'sub security_task_setgid {
	    my($id0,$id1,$id2,$flags) = @_;
    	    eval q({  ($security_ops->{task_setgid}) ($id0, $id1, $id2, $flags); });
	}' unless defined(&security_task_setgid);
	eval 'sub security_task_setpgid {
	    my($p,$pgid) = @_;
    	    eval q({  ($security_ops->{task_setpgid}) ($p, $pgid); });
	}' unless defined(&security_task_setpgid);
	eval 'sub security_task_getpgid {
	    my($p) = @_;
    	    eval q({  ($security_ops->{task_getpgid}) ($p); });
	}' unless defined(&security_task_getpgid);
	eval 'sub security_task_getsid {
	    my($p) = @_;
    	    eval q({  ($security_ops->{task_getsid}) ($p); });
	}' unless defined(&security_task_getsid);
	eval 'sub security_task_setgroups {
	    my($group_info) = @_;
    	    eval q({  ($security_ops->{task_setgroups}) ($group_info); });
	}' unless defined(&security_task_setgroups);
	eval 'sub security_task_setnice {
	    my($p,$nice) = @_;
    	    eval q({  ($security_ops->{task_setnice}) ($p, $nice); });
	}' unless defined(&security_task_setnice);
	eval 'sub security_task_setrlimit {
	    my($resource,$new_rlim) = @_;
    	    eval q({  ($security_ops->{task_setrlimit}) ($resource, $new_rlim); });
	}' unless defined(&security_task_setrlimit);
	eval 'sub security_task_setscheduler {
	    my($p,$policy,$lp) = @_;
    	    eval q({  ($security_ops->{task_setscheduler}) ($p, $policy, $lp); });
	}' unless defined(&security_task_setscheduler);
	eval 'sub security_task_getscheduler {
	    my($p) = @_;
    	    eval q({  ($security_ops->{task_getscheduler}) ($p); });
	}' unless defined(&security_task_getscheduler);
	eval 'sub security_task_kill {
	    my($p,$info,$sig) = @_;
    	    eval q({  ($security_ops->{task_kill}) ($p, $info, $sig); });
	}' unless defined(&security_task_kill);
	eval 'sub security_task_wait {
	    my($p) = @_;
    	    eval q({  ($security_ops->{task_wait}) ($p); });
	}' unless defined(&security_task_wait);
	eval 'sub security_task_prctl {
	    my($option,$arg2,$arg3,$arg4,$arg5) = @_;
    	    eval q({  ($security_ops->{task_prctl}) ($option, $arg2, $arg3, $arg4, $arg5); });
	}' unless defined(&security_task_prctl);
	eval 'sub security_task_reparent_to_init {
	    my($p) = @_;
    	    eval q({  ($security_ops->{task_reparent_to_init}) ($p); });
	}' unless defined(&security_task_reparent_to_init);
	eval 'sub security_task_to_inode {
	    my($p,$inode) = @_;
    	    eval q({  ($security_ops->{task_to_inode})($p, $inode); });
	}' unless defined(&security_task_to_inode);
	eval 'sub security_ipc_permission {
	    my($ipcp,$flag) = @_;
    	    eval q({  ($security_ops->{ipc_permission}) ($ipcp, $flag); });
	}' unless defined(&security_ipc_permission);
	eval 'sub security_msg_msg_alloc {
	    my($msg) = @_;
    	    eval q({  ($security_ops->{msg_msg_alloc_security}) ($msg); });
	}' unless defined(&security_msg_msg_alloc);
	eval 'sub security_msg_msg_free {
	    my($msg) = @_;
    	    eval q({  ($security_ops->{msg_msg_free_security})($msg); });
	}' unless defined(&security_msg_msg_free);
	eval 'sub security_msg_queue_alloc {
	    my($msq) = @_;
    	    eval q({  ($security_ops->{msg_queue_alloc_security}) ($msq); });
	}' unless defined(&security_msg_queue_alloc);
	eval 'sub security_msg_queue_free {
	    my($msq) = @_;
    	    eval q({  ($security_ops->{msg_queue_free_security}) ($msq); });
	}' unless defined(&security_msg_queue_free);
	eval 'sub security_msg_queue_associate {
	    my($msq,$msqflg) = @_;
    	    eval q({  ($security_ops->{msg_queue_associate}) ($msq, $msqflg); });
	}' unless defined(&security_msg_queue_associate);
	eval 'sub security_msg_queue_msgctl {
	    my($msq,$cmd) = @_;
    	    eval q({  ($security_ops->{msg_queue_msgctl}) ($msq, $cmd); });
	}' unless defined(&security_msg_queue_msgctl);
	eval 'sub security_msg_queue_msgsnd {
	    my($msq,$msg,$msqflg) = @_;
    	    eval q({  ($security_ops->{msg_queue_msgsnd}) ($msq, $msg, $msqflg); });
	}' unless defined(&security_msg_queue_msgsnd);
	eval 'sub security_msg_queue_msgrcv {
	    my($msq,$msg,$target,$type,$mode) = @_;
    	    eval q({  ($security_ops->{msg_queue_msgrcv}) ($msq, $msg, $target, $type, $mode); });
	}' unless defined(&security_msg_queue_msgrcv);
	eval 'sub security_shm_alloc {
	    my($shp) = @_;
    	    eval q({  ($security_ops->{shm_alloc_security}) ($shp); });
	}' unless defined(&security_shm_alloc);
	eval 'sub security_shm_free {
	    my($shp) = @_;
    	    eval q({  ($security_ops->{shm_free_security}) ($shp); });
	}' unless defined(&security_shm_free);
	eval 'sub security_shm_associate {
	    my($shp,$shmflg) = @_;
    	    eval q({  ($security_ops->{shm_associate})($shp, $shmflg); });
	}' unless defined(&security_shm_associate);
	eval 'sub security_shm_shmctl {
	    my($shp,$cmd) = @_;
    	    eval q({  ($security_ops->{shm_shmctl}) ($shp, $cmd); });
	}' unless defined(&security_shm_shmctl);
	eval 'sub security_shm_shmat {
	    my($shp,$shmaddr,$shmflg) = @_;
    	    eval q({  ($security_ops->{shm_shmat})($shp, $shmaddr, $shmflg); });
	}' unless defined(&security_shm_shmat);
	eval 'sub security_sem_alloc {
	    my($sma) = @_;
    	    eval q({  ($security_ops->{sem_alloc_security}) ($sma); });
	}' unless defined(&security_sem_alloc);
	eval 'sub security_sem_free {
	    my($sma) = @_;
    	    eval q({  ($security_ops->{sem_free_security}) ($sma); });
	}' unless defined(&security_sem_free);
	eval 'sub security_sem_associate {
	    my($sma,$semflg) = @_;
    	    eval q({  ($security_ops->{sem_associate}) ($sma, $semflg); });
	}' unless defined(&security_sem_associate);
	eval 'sub security_sem_semctl {
	    my($sma,$cmd) = @_;
    	    eval q({  ($security_ops->{sem_semctl})($sma, $cmd); });
	}' unless defined(&security_sem_semctl);
	eval 'sub security_sem_semop {
	    my($sma,$sops,$nsops,$alter) = @_;
    	    eval q({  ($security_ops->{sem_semop})($sma, $sops, $nsops, $alter); });
	}' unless defined(&security_sem_semop);
	eval 'sub security_d_instantiate {
	    my($dentry,$inode) = @_;
    	    eval q({  &if ( &unlikely ($inode  &&  &IS_PRIVATE ($inode))) ;  ($security_ops->{d_instantiate}) ($dentry, $inode); });
	}' unless defined(&security_d_instantiate);
	eval 'sub security_getprocattr {
	    my($p,$name,$value,$size) = @_;
    	    eval q({  ($security_ops->{getprocattr})($p, $name, $value, $size); });
	}' unless defined(&security_getprocattr);
	eval 'sub security_setprocattr {
	    my($p,$name,$value,$size) = @_;
    	    eval q({  ($security_ops->{setprocattr})($p, $name, $value, $size); });
	}' unless defined(&security_setprocattr);
	eval 'sub security_netlink_send {
	    my($sk,$skb) = @_;
    	    eval q({  ($security_ops->{netlink_send})($sk, $skb); });
	}' unless defined(&security_netlink_send);
	eval 'sub security_netlink_recv {
	    my($skb) = @_;
    	    eval q({  ($security_ops->{netlink_recv})($skb); });
	}' unless defined(&security_netlink_recv);
    } else {
	eval 'sub security_ptrace {
	    my($parent,$child) = @_;
    	    eval q({  &cap_ptrace ($parent, $child); });
	}' unless defined(&security_ptrace);
	eval 'sub security_capget {
	    my($target,$effective,$inheritable,$permitted) = @_;
    	    eval q({  &cap_capget ($target, $effective, $inheritable, $permitted); });
	}' unless defined(&security_capget);
	eval 'sub security_capset_check {
	    my($target,$effective,$inheritable,$permitted) = @_;
    	    eval q({  &cap_capset_check ($target, $effective, $inheritable, $permitted); });
	}' unless defined(&security_capset_check);
	eval 'sub security_capset_set {
	    my($target,$effective,$inheritable,$permitted) = @_;
    	    eval q({  &cap_capset_set ($target, $effective, $inheritable, $permitted); });
	}' unless defined(&security_capset_set);
	eval 'sub security_acct {
	    my($file) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_acct);
	eval 'sub security_sysctl {
	    my($table,$op) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sysctl);
	eval 'sub security_quotactl {
	    my($cmds,$type,$id,$sb) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_quotactl);
	eval 'sub security_quota_on {
	    my($dentry) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_quota_on);
	eval 'sub security_syslog {
	    my($type) = @_;
    	    eval q({  &cap_syslog($type); });
	}' unless defined(&security_syslog);
	eval 'sub security_settime {
	    my($ts,$tz) = @_;
    	    eval q({  &cap_settime($ts, $tz); });
	}' unless defined(&security_settime);
	eval 'sub security_vm_enough_memory {
	    my($pages) = @_;
    	    eval q({  &cap_vm_enough_memory($pages); });
	}' unless defined(&security_vm_enough_memory);
	eval 'sub security_bprm_alloc {
	    my($bprm) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_bprm_alloc);
	eval 'sub security_bprm_free {
	    my($bprm) = @_;
    	    eval q({ });
	}' unless defined(&security_bprm_free);
	eval 'sub security_bprm_apply_creds {
	    my($bprm,$unsafe) = @_;
    	    eval q({  &cap_bprm_apply_creds ($bprm, $unsafe); });
	}' unless defined(&security_bprm_apply_creds);
	eval 'sub security_bprm_post_apply_creds {
	    my($bprm) = @_;
    	    eval q({ ; });
	}' unless defined(&security_bprm_post_apply_creds);
	eval 'sub security_bprm_set {
	    my($bprm) = @_;
    	    eval q({  &cap_bprm_set_security ($bprm); });
	}' unless defined(&security_bprm_set);
	eval 'sub security_bprm_check {
	    my($bprm) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_bprm_check);
	eval 'sub security_bprm_secureexec {
	    my($bprm) = @_;
    	    eval q({  &cap_bprm_secureexec($bprm); });
	}' unless defined(&security_bprm_secureexec);
	eval 'sub security_sb_alloc {
	    my($sb) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sb_alloc);
	eval 'sub security_sb_free {
	    my($sb) = @_;
    	    eval q({ });
	}' unless defined(&security_sb_free);
	eval 'sub security_sb_copy_data {
	    my($type,$orig,$copy) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sb_copy_data);
	eval 'sub security_sb_kern_mount {
	    my($sb,$data) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sb_kern_mount);
	eval 'sub security_sb_statfs {
	    my($sb) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sb_statfs);
	eval 'sub security_sb_mount {
	    my($dev_name,$nd,$type,$flags,$data) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sb_mount);
	eval 'sub security_sb_check_sb {
	    my($mnt,$nd) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sb_check_sb);
	eval 'sub security_sb_umount {
	    my($mnt,$flags) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sb_umount);
	eval 'sub security_sb_umount_close {
	    my($mnt) = @_;
    	    eval q({ });
	}' unless defined(&security_sb_umount_close);
	eval 'sub security_sb_umount_busy {
	    my($mnt) = @_;
    	    eval q({ });
	}' unless defined(&security_sb_umount_busy);
	eval 'sub security_sb_post_remount {
	    my($mnt,$flags,$data) = @_;
    	    eval q({ });
	}' unless defined(&security_sb_post_remount);
	eval 'sub security_sb_post_mountroot {
	    my($void) = @_;
    	    eval q({ });
	}' unless defined(&security_sb_post_mountroot);
	eval 'sub security_sb_post_addmount {
	    my($mnt,$mountpoint_nd) = @_;
    	    eval q({ });
	}' unless defined(&security_sb_post_addmount);
	eval 'sub security_sb_pivotroot {
	    my($old_nd,$new_nd) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sb_pivotroot);
	eval 'sub security_sb_post_pivotroot {
	    my($old_nd,$new_nd) = @_;
    	    eval q({ });
	}' unless defined(&security_sb_post_pivotroot);
	eval 'sub security_inode_alloc {
	    my($inode) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_alloc);
	eval 'sub security_inode_free {
	    my($inode) = @_;
    	    eval q({ });
	}' unless defined(&security_inode_free);
	eval 'sub security_inode_init_security {
	    my($inode,$dir,$name,$value,$len) = @_;
    	    eval q({ - &EOPNOTSUPP; });
	}' unless defined(&security_inode_init_security);
	eval 'sub security_inode_link {
	    my($old_dentry,$dir,$new_dentry) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_link);
	eval 'sub security_inode_unlink {
	    my($dir,$dentry) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_unlink);
	eval 'sub security_inode_symlink {
	    my($dir,$dentry,$old_name) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_symlink);
	eval 'sub security_inode_mkdir {
	    my($dir,$dentry,$mode) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_mkdir);
	eval 'sub security_inode_rmdir {
	    my($dir,$dentry) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_rmdir);
	eval 'sub security_inode_mknod {
	    my($dir,$dentry,$mode,$dev) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_mknod);
	eval 'sub security_inode_rename {
	    my($old_dir,$old_dentry,$new_dir,$new_dentry) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_rename);
	eval 'sub security_inode_readlink {
	    my($dentry) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_readlink);
	eval 'sub security_inode_follow_link {
	    my($dentry,$nd) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_follow_link);
	eval 'sub security_inode_permission {
	    my($inode,$mask,$nd) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_permission);
	eval 'sub security_inode_setattr {
	    my($dentry,$attr) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_setattr);
	eval 'sub security_inode_getattr {
	    my($mnt,$dentry) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_getattr);
	eval 'sub security_inode_delete {
	    my($inode) = @_;
    	    eval q({ });
	}' unless defined(&security_inode_delete);
	eval 'sub security_inode_setxattr {
	    my($dentry,$name,$value,$size,$flags) = @_;
    	    eval q({  &cap_inode_setxattr($dentry, $name, $value, $size, $flags); });
	}' unless defined(&security_inode_setxattr);
	eval 'sub security_inode_post_setxattr {
	    my($dentry,$name,$value,$size,$flags) = @_;
    	    eval q({ });
	}' unless defined(&security_inode_post_setxattr);
	eval 'sub security_inode_getxattr {
	    my($dentry,$name) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_getxattr);
	eval 'sub security_inode_listxattr {
	    my($dentry) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_listxattr);
	eval 'sub security_inode_removexattr {
	    my($dentry,$name) = @_;
    	    eval q({  &cap_inode_removexattr($dentry, $name); });
	}' unless defined(&security_inode_removexattr);
	eval 'sub security_inode_getsecurity {
	    my($inode,$name,$buffer,$size,$err) = @_;
    	    eval q({ - &EOPNOTSUPP; });
	}' unless defined(&security_inode_getsecurity);
	eval 'sub security_inode_setsecurity {
	    my($inode,$name,$value,$size,$flags) = @_;
    	    eval q({ - &EOPNOTSUPP; });
	}' unless defined(&security_inode_setsecurity);
	eval 'sub security_inode_listsecurity {
	    my($inode,$buffer,$buffer_size) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_inode_listsecurity);
	eval 'sub security_file_permission {
	    my($file,$mask) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_permission);
	eval 'sub security_file_alloc {
	    my($file) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_alloc);
	eval 'sub security_file_free {
	    my($file) = @_;
    	    eval q({ });
	}' unless defined(&security_file_free);
	eval 'sub security_file_ioctl {
	    my($file,$cmd,$arg) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_ioctl);
	eval 'sub security_file_mmap {
	    my($file,$reqprot,$prot,$flags) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_mmap);
	eval 'sub security_file_mprotect {
	    my($vma,$reqprot,$prot) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_mprotect);
	eval 'sub security_file_lock {
	    my($file,$cmd) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_lock);
	eval 'sub security_file_fcntl {
	    my($file,$cmd,$arg) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_fcntl);
	eval 'sub security_file_set_fowner {
	    my($file) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_set_fowner);
	eval 'sub security_file_send_sigiotask {
	    my($tsk,$fown,$sig) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_send_sigiotask);
	eval 'sub security_file_receive {
	    my($file) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_file_receive);
	eval 'sub security_task_create {
	    my($clone_flags) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_create);
	eval 'sub security_task_alloc {
	    my($p) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_alloc);
	eval 'sub security_task_free {
	    my($p) = @_;
    	    eval q({ });
	}' unless defined(&security_task_free);
	eval 'sub security_task_setuid {
	    my($id0,$id1,$id2,$flags) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_setuid);
	eval 'sub security_task_post_setuid {
	    my($old_ruid,$old_euid,$old_suid,$flags) = @_;
    	    eval q({  &cap_task_post_setuid ($old_ruid, $old_euid, $old_suid, $flags); });
	}' unless defined(&security_task_post_setuid);
	eval 'sub security_task_setgid {
	    my($id0,$id1,$id2,$flags) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_setgid);
	eval 'sub security_task_setpgid {
	    my($p,$pgid) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_setpgid);
	eval 'sub security_task_getpgid {
	    my($p) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_getpgid);
	eval 'sub security_task_getsid {
	    my($p) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_getsid);
	eval 'sub security_task_setgroups {
	    my($group_info) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_setgroups);
	eval 'sub security_task_setnice {
	    my($p,$nice) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_setnice);
	eval 'sub security_task_setrlimit {
	    my($resource,$new_rlim) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_setrlimit);
	eval 'sub security_task_setscheduler {
	    my($p,$policy,$lp) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_setscheduler);
	eval 'sub security_task_getscheduler {
	    my($p) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_getscheduler);
	eval 'sub security_task_kill {
	    my($p,$info,$sig) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_kill);
	eval 'sub security_task_wait {
	    my($p) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_wait);
	eval 'sub security_task_prctl {
	    my($option,$arg2,$arg3,$arg4,$arg5) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_task_prctl);
	eval 'sub security_task_reparent_to_init {
	    my($p) = @_;
    	    eval q({  &cap_task_reparent_to_init ($p); });
	}' unless defined(&security_task_reparent_to_init);
	eval 'sub security_task_to_inode {
	    my($p,$inode) = @_;
    	    eval q({ });
	}' unless defined(&security_task_to_inode);
	eval 'sub security_ipc_permission {
	    my($ipcp,$flag) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_ipc_permission);
	eval 'sub security_msg_msg_alloc {
	    my($msg) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_msg_msg_alloc);
	eval 'sub security_msg_msg_free {
	    my($msg) = @_;
    	    eval q({ });
	}' unless defined(&security_msg_msg_free);
	eval 'sub security_msg_queue_alloc {
	    my($msq) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_msg_queue_alloc);
	eval 'sub security_msg_queue_free {
	    my($msq) = @_;
    	    eval q({ });
	}' unless defined(&security_msg_queue_free);
	eval 'sub security_msg_queue_associate {
	    my($msq,$msqflg) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_msg_queue_associate);
	eval 'sub security_msg_queue_msgctl {
	    my($msq,$cmd) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_msg_queue_msgctl);
	eval 'sub security_msg_queue_msgsnd {
	    my($msq,$msg,$msqflg) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_msg_queue_msgsnd);
	eval 'sub security_msg_queue_msgrcv {
	    my($msq,$msg,$target,$type,$mode) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_msg_queue_msgrcv);
	eval 'sub security_shm_alloc {
	    my($shp) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_shm_alloc);
	eval 'sub security_shm_free {
	    my($shp) = @_;
    	    eval q({ });
	}' unless defined(&security_shm_free);
	eval 'sub security_shm_associate {
	    my($shp,$shmflg) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_shm_associate);
	eval 'sub security_shm_shmctl {
	    my($shp,$cmd) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_shm_shmctl);
	eval 'sub security_shm_shmat {
	    my($shp,$shmaddr,$shmflg) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_shm_shmat);
	eval 'sub security_sem_alloc {
	    my($sma) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sem_alloc);
	eval 'sub security_sem_free {
	    my($sma) = @_;
    	    eval q({ });
	}' unless defined(&security_sem_free);
	eval 'sub security_sem_associate {
	    my($sma,$semflg) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sem_associate);
	eval 'sub security_sem_semctl {
	    my($sma,$cmd) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sem_semctl);
	eval 'sub security_sem_semop {
	    my($sma,$sops,$nsops,$alter) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sem_semop);
	eval 'sub security_d_instantiate {
	    my($dentry,$inode) = @_;
    	    eval q({ });
	}' unless defined(&security_d_instantiate);
	eval 'sub security_getprocattr {
	    my($p,$name,$value,$size) = @_;
    	    eval q({ - &EINVAL; });
	}' unless defined(&security_getprocattr);
	eval 'sub security_setprocattr {
	    my($p,$name,$value,$size) = @_;
    	    eval q({ - &EINVAL; });
	}' unless defined(&security_setprocattr);
	eval 'sub security_netlink_send {
	    my($sk,$skb) = @_;
    	    eval q({  &cap_netlink_send ($sk, $skb); });
	}' unless defined(&security_netlink_send);
	eval 'sub security_netlink_recv {
	    my($skb) = @_;
    	    eval q({  &cap_netlink_recv ($skb); });
	}' unless defined(&security_netlink_recv);
	eval 'sub dentry {
	    eval q(* &securityfs_create_dir( &const \'char\' * &name, \'struct dentry\' * &parent) {  &ERR_PTR(- &ENODEV); });
	}' unless defined(&dentry);
	eval 'sub dentry {
	    eval q(* &securityfs_create_file( &const \'char\' * &name,  &mode_t  &mode, \'struct dentry\' * &parent,  &void * &data, \'struct file_operations\' * &fops) {  &ERR_PTR(- &ENODEV); });
	}' unless defined(&dentry);
	eval 'sub securityfs_remove {
	    my($dentry) = @_;
    	    eval q({ });
	}' unless defined(&securityfs_remove);
    }
    if(defined(&CONFIG_SECURITY_NETWORK)) {
	eval 'sub security_unix_stream_connect {
	    my($sock,$other,$newsk) = @_;
    	    eval q({  ($security_ops->{unix_stream_connect})($sock, $other, $newsk); });
	}' unless defined(&security_unix_stream_connect);
	eval 'sub security_unix_may_send {
	    my($sock,$other) = @_;
    	    eval q({  ($security_ops->{unix_may_send})($sock, $other); });
	}' unless defined(&security_unix_may_send);
	eval 'sub security_socket_create {
	    my($family,$type,$protocol,$kern) = @_;
    	    eval q({  ($security_ops->{socket_create})($family, $type, $protocol, $kern); });
	}' unless defined(&security_socket_create);
	eval 'sub security_socket_post_create {
	    my($sock,$family,$type,$protocol,$kern) = @_;
    	    eval q({  ($security_ops->{socket_post_create})($sock, $family, $type, $protocol, $kern); });
	}' unless defined(&security_socket_post_create);
	eval 'sub security_socket_bind {
	    my($sock,$address,$addrlen) = @_;
    	    eval q({  ($security_ops->{socket_bind})($sock, $address, $addrlen); });
	}' unless defined(&security_socket_bind);
	eval 'sub security_socket_connect {
	    my($sock,$address,$addrlen) = @_;
    	    eval q({  ($security_ops->{socket_connect})($sock, $address, $addrlen); });
	}' unless defined(&security_socket_connect);
	eval 'sub security_socket_listen {
	    my($sock,$backlog) = @_;
    	    eval q({  ($security_ops->{socket_listen})($sock, $backlog); });
	}' unless defined(&security_socket_listen);
	eval 'sub security_socket_accept {
	    my($sock,$newsock) = @_;
    	    eval q({  ($security_ops->{socket_accept})($sock, $newsock); });
	}' unless defined(&security_socket_accept);
	eval 'sub security_socket_post_accept {
	    my($sock,$newsock) = @_;
    	    eval q({  ($security_ops->{socket_post_accept})($sock, $newsock); });
	}' unless defined(&security_socket_post_accept);
	eval 'sub security_socket_sendmsg {
	    my($sock,$msg,$size) = @_;
    	    eval q({  ($security_ops->{socket_sendmsg})($sock, $msg, $size); });
	}' unless defined(&security_socket_sendmsg);
	eval 'sub security_socket_recvmsg {
	    my($sock,$msg,$size,$flags) = @_;
    	    eval q({  ($security_ops->{socket_recvmsg})($sock, $msg, $size, $flags); });
	}' unless defined(&security_socket_recvmsg);
	eval 'sub security_socket_getsockname {
	    my($sock) = @_;
    	    eval q({  ($security_ops->{socket_getsockname})($sock); });
	}' unless defined(&security_socket_getsockname);
	eval 'sub security_socket_getpeername {
	    my($sock) = @_;
    	    eval q({  ($security_ops->{socket_getpeername})($sock); });
	}' unless defined(&security_socket_getpeername);
	eval 'sub security_socket_getsockopt {
	    my($sock,$level,$optname) = @_;
    	    eval q({  ($security_ops->{socket_getsockopt})($sock, $level, $optname); });
	}' unless defined(&security_socket_getsockopt);
	eval 'sub security_socket_setsockopt {
	    my($sock,$level,$optname) = @_;
    	    eval q({  ($security_ops->{socket_setsockopt})($sock, $level, $optname); });
	}' unless defined(&security_socket_setsockopt);
	eval 'sub security_socket_shutdown {
	    my($sock,$how) = @_;
    	    eval q({  ($security_ops->{socket_shutdown})($sock, $how); });
	}' unless defined(&security_socket_shutdown);
	eval 'sub security_sock_rcv_skb {
	    my($sk,$skb) = @_;
    	    eval q({  ($security_ops->{socket_sock_rcv_skb}) ($sk, $skb); });
	}' unless defined(&security_sock_rcv_skb);
	eval 'sub security_socket_getpeersec {
	    my($sock,$optval,$optlen,$len) = @_;
    	    eval q({  ($security_ops->{socket_getpeersec})($sock, $optval, $optlen, $len); });
	}' unless defined(&security_socket_getpeersec);
	eval 'sub security_sk_alloc {
	    my($sk,$family,$priority) = @_;
    	    eval q({  ($security_ops->{sk_alloc_security})($sk, $family, $priority); });
	}' unless defined(&security_sk_alloc);
	eval 'sub security_sk_free {
	    my($sk) = @_;
    	    eval q({  ($security_ops->{sk_free_security})($sk); });
	}' unless defined(&security_sk_free);
	eval 'sub security_sk_sid {
	    my($sk,$fl,$dir) = @_;
    	    eval q({  ($security_ops->{sk_getsid})($sk, $fl, $dir); });
	}' unless defined(&security_sk_sid);
    } else {
	eval 'sub security_unix_stream_connect {
	    my($sock,$other,$newsk) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_unix_stream_connect);
	eval 'sub security_unix_may_send {
	    my($sock,$other) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_unix_may_send);
	eval 'sub security_socket_create {
	    my($family,$type,$protocol,$kern) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_create);
	eval 'sub security_socket_post_create {
	    my($sock,$family,$type,$protocol,$kern) = @_;
    	    eval q({ });
	}' unless defined(&security_socket_post_create);
	eval 'sub security_socket_bind {
	    my($sock,$address,$addrlen) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_bind);
	eval 'sub security_socket_connect {
	    my($sock,$address,$addrlen) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_connect);
	eval 'sub security_socket_listen {
	    my($sock,$backlog) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_listen);
	eval 'sub security_socket_accept {
	    my($sock,$newsock) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_accept);
	eval 'sub security_socket_post_accept {
	    my($sock,$newsock) = @_;
    	    eval q({ });
	}' unless defined(&security_socket_post_accept);
	eval 'sub security_socket_sendmsg {
	    my($sock,$msg,$size) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_sendmsg);
	eval 'sub security_socket_recvmsg {
	    my($sock,$msg,$size,$flags) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_recvmsg);
	eval 'sub security_socket_getsockname {
	    my($sock) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_getsockname);
	eval 'sub security_socket_getpeername {
	    my($sock) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_getpeername);
	eval 'sub security_socket_getsockopt {
	    my($sock,$level,$optname) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_getsockopt);
	eval 'sub security_socket_setsockopt {
	    my($sock,$level,$optname) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_setsockopt);
	eval 'sub security_socket_shutdown {
	    my($sock,$how) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_socket_shutdown);
	eval 'sub security_sock_rcv_skb {
	    my($sk,$skb) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sock_rcv_skb);
	eval 'sub security_socket_getpeersec {
	    my($sock,$optval,$optlen,$len) = @_;
    	    eval q({ - &ENOPROTOOPT; });
	}' unless defined(&security_socket_getpeersec);
	eval 'sub security_sk_alloc {
	    my($sk,$family,$priority) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sk_alloc);
	eval 'sub security_sk_free {
	    my($sk) = @_;
    	    eval q({ });
	}' unless defined(&security_sk_free);
	eval 'sub security_sk_sid {
	    my($sk,$fl,$dir) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_sk_sid);
    }
    if(defined(&CONFIG_SECURITY_NETWORK_XFRM)) {
	eval 'sub security_xfrm_policy_alloc {
	    my($xp,$sec_ctx) = @_;
    	    eval q({  ($security_ops->{xfrm_policy_alloc_security})($xp, $sec_ctx); });
	}' unless defined(&security_xfrm_policy_alloc);
	eval 'sub security_xfrm_policy_clone {
	    my($old,$new) = @_;
    	    eval q({  ($security_ops->{xfrm_policy_clone_security})($old, $new); });
	}' unless defined(&security_xfrm_policy_clone);
	eval 'sub security_xfrm_policy_free {
	    my($xp) = @_;
    	    eval q({  ($security_ops->{xfrm_policy_free_security})($xp); });
	}' unless defined(&security_xfrm_policy_free);
	eval 'sub security_xfrm_state_alloc {
	    my($x,$sec_ctx) = @_;
    	    eval q({  ($security_ops->{xfrm_state_alloc_security})($x, $sec_ctx); });
	}' unless defined(&security_xfrm_state_alloc);
	eval 'sub security_xfrm_state_free {
	    my($x) = @_;
    	    eval q({  ($security_ops->{xfrm_state_free_security})($x); });
	}' unless defined(&security_xfrm_state_free);
	eval 'sub security_xfrm_policy_lookup {
	    my($xp,$sk_sid,$dir) = @_;
    	    eval q({  ($security_ops->{xfrm_policy_lookup})($xp, $sk_sid, $dir); });
	}' unless defined(&security_xfrm_policy_lookup);
    } else {
	eval 'sub security_xfrm_policy_alloc {
	    my($xp,$sec_ctx) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_xfrm_policy_alloc);
	eval 'sub security_xfrm_policy_clone {
	    my($old,$new) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_xfrm_policy_clone);
	eval 'sub security_xfrm_policy_free {
	    my($xp) = @_;
    	    eval q({ });
	}' unless defined(&security_xfrm_policy_free);
	eval 'sub security_xfrm_state_alloc {
	    my($x,$sec_ctx) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_xfrm_state_alloc);
	eval 'sub security_xfrm_state_free {
	    my($x) = @_;
    	    eval q({ });
	}' unless defined(&security_xfrm_state_free);
	eval 'sub security_xfrm_policy_lookup {
	    my($xp,$sk_sid,$dir) = @_;
    	    eval q({ 0; });
	}' unless defined(&security_xfrm_policy_lookup);
    }
    if(defined(&CONFIG_KEYS)) {
	if(defined(&CONFIG_SECURITY)) {
	    eval 'sub security_key_alloc {
	        my($key) = @_;
    		eval q({  ($security_ops->{key_alloc})($key); });
	    }' unless defined(&security_key_alloc);
	    eval 'sub security_key_free {
	        my($key) = @_;
    		eval q({  ($security_ops->{key_free})($key); });
	    }' unless defined(&security_key_free);
	    eval 'sub security_key_permission {
	        my($key_ref,$context,$perm) = @_;
    		eval q({  ($security_ops->{key_permission})($key_ref, $context, $perm); });
	    }' unless defined(&security_key_permission);
	} else {
	    eval 'sub security_key_alloc {
	        my($key) = @_;
    		eval q({ 0; });
	    }' unless defined(&security_key_alloc);
	    eval 'sub security_key_free {
	        my($key) = @_;
    		eval q({ });
	    }' unless defined(&security_key_free);
	    eval 'sub security_key_permission {
	        my($key_ref,$context,$perm) = @_;
    		eval q({ 0; });
	    }' unless defined(&security_key_permission);
	}
    }
}
1;
