require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_SPINLOCK_UP_H)) {
    eval 'sub __LINUX_SPINLOCK_UP_H {1;}' unless defined(&__LINUX_SPINLOCK_UP_H);
    unless(defined(&__LINUX_SPINLOCK_H)) {
	die("please don't include this file directly");
    }
    if(defined(&CONFIG_DEBUG_SPINLOCK)) {
	eval 'sub __raw_spin_is_locked {
	    my($x) = @_;
    	    eval q((($x)-> &slock == 0));
	}' unless defined(&__raw_spin_is_locked);
	eval 'sub __raw_spin_lock {
	    my($lock) = @_;
    	    eval q({  ($lock->{s$lock}) = 0; });
	}' unless defined(&__raw_spin_lock);
	eval 'sub __raw_spin_lock_flags {
	    my($lock,$flags) = @_;
    	    eval q({  &local_irq_save($flags);  ($lock->{s$lock}) = 0; });
	}' unless defined(&__raw_spin_lock_flags);
	eval 'sub __raw_spin_trylock {
	    my($lock) = @_;
    	    eval q({ \'char\'  &oldval =  ($lock->{s$lock});  ($lock->{s$lock}) = 0;  &oldval > 0; });
	}' unless defined(&__raw_spin_trylock);
	eval 'sub __raw_spin_unlock {
	    my($lock) = @_;
    	    eval q({  ($lock->{s$lock}) = 1; });
	}' unless defined(&__raw_spin_unlock);
	eval 'sub __raw_read_lock {
	    my($lock) = @_;
    	    eval q( &do { ( &void)($lock); }  &while (0));
	}' unless defined(&__raw_read_lock);
	eval 'sub __raw_write_lock {
	    my($lock) = @_;
    	    eval q( &do { ( &void)($lock); }  &while (0));
	}' unless defined(&__raw_write_lock);
	eval 'sub __raw_read_trylock {
	    my($lock) = @_;
    	    eval q(({ ( &void)($lock); 1; }));
	}' unless defined(&__raw_read_trylock);
	eval 'sub __raw_write_trylock {
	    my($lock) = @_;
    	    eval q(({ ( &void)($lock); 1; }));
	}' unless defined(&__raw_write_trylock);
	eval 'sub __raw_read_unlock {
	    my($lock) = @_;
    	    eval q( &do { ( &void)($lock); }  &while (0));
	}' unless defined(&__raw_read_unlock);
	eval 'sub __raw_write_unlock {
	    my($lock) = @_;
    	    eval q( &do { ( &void)($lock); }  &while (0));
	}' unless defined(&__raw_write_unlock);
    } else {
	eval 'sub __raw_spin_is_locked {
	    my($lock) = @_;
    	    eval q((( &void)($lock), 0));
	}' unless defined(&__raw_spin_is_locked);
	eval 'sub __raw_spin_lock {
	    my($lock) = @_;
    	    eval q( &do { ( &void)($lock); }  &while (0));
	}' unless defined(&__raw_spin_lock);
	eval 'sub __raw_spin_unlock {
	    my($lock) = @_;
    	    eval q( &do { ( &void)($lock); }  &while (0));
	}' unless defined(&__raw_spin_unlock);
	eval 'sub __raw_spin_trylock {
	    my($lock) = @_;
    	    eval q(({ ( &void)($lock); 1; }));
	}' unless defined(&__raw_spin_trylock);
    }
    eval 'sub __raw_read_can_lock {
        my($lock) = @_;
	    eval q(((( &void)($lock), 1)));
    }' unless defined(&__raw_read_can_lock);
    eval 'sub __raw_write_can_lock {
        my($lock) = @_;
	    eval q(((( &void)($lock), 1)));
    }' unless defined(&__raw_write_can_lock);
    eval 'sub __raw_spin_unlock_wait {
        my($lock) = @_;
	    eval q( &do {  &cpu_relax(); }  &while ( &__raw_spin_is_locked($lock)));
    }' unless defined(&__raw_spin_unlock_wait);
}
1;
