require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_ZORRO_H)) {
    eval 'sub _LINUX_ZORRO_H {1;}' unless defined(&_LINUX_ZORRO_H);
    unless(defined(&__ASSEMBLY__)) {
	require 'linux/device.ph';
	eval 'sub ZORRO_MANUF {
	    my($id) = @_;
    	    eval q((($id) >> 16));
	}' unless defined(&ZORRO_MANUF);
	eval 'sub ZORRO_PROD {
	    my($id) = @_;
    	    eval q(((($id) >> 8) & 0xff));
	}' unless defined(&ZORRO_PROD);
	eval 'sub ZORRO_EPC {
	    my($id) = @_;
    	    eval q((($id) & 0xff));
	}' unless defined(&ZORRO_EPC);
	eval 'sub ZORRO_ID {
	    my($manuf, $prod, $epc) = @_;
    	    eval q((( &ZORRO_MANUF_$manuf << 16) | (($prod) << 8) | ($epc)));
	}' unless defined(&ZORRO_ID);
	eval 'sub ZORRO_WILDCARD {(0xffffffff);}' unless defined(&ZORRO_WILDCARD);
	require 'linux/zorro_ids.ph';
	eval 'sub GVP_PRODMASK {(0xf8);}' unless defined(&GVP_PRODMASK);
	eval 'sub GVP_SCSICLKMASK {(0x1);}' unless defined(&GVP_SCSICLKMASK);
	eval("sub GVP_IO () { 0x01; }") unless defined(&GVP_IO);
	eval("sub GVP_ACCEL () { 0x02; }") unless defined(&GVP_ACCEL);
	eval("sub GVP_SCSI () { 0x04; }") unless defined(&GVP_SCSI);
	eval("sub GVP_24BITDMA () { 0x08; }") unless defined(&GVP_24BITDMA);
	eval("sub GVP_25BITDMA () { 0x10; }") unless defined(&GVP_25BITDMA);
	eval("sub GVP_NOBANK () { 0x20; }") unless defined(&GVP_NOBANK);
	eval("sub GVP_14MHZ () { 0x40; }") unless defined(&GVP_14MHZ);
	eval 'sub ERT_TYPEMASK {0xc0;}' unless defined(&ERT_TYPEMASK);
	eval 'sub ERT_ZORROII {0xc0;}' unless defined(&ERT_ZORROII);
	eval 'sub ERT_ZORROIII {0x80;}' unless defined(&ERT_ZORROIII);
	eval 'sub ERTB_MEMLIST {5;}' unless defined(&ERTB_MEMLIST);
	eval 'sub ERTF_MEMLIST {(1<<5);}' unless defined(&ERTF_MEMLIST);
    } else {
    }
    unless(defined(&__ASSEMBLY__)) {
	eval 'sub ZORRO_NUM_AUTO {16;}' unless defined(&ZORRO_NUM_AUTO);
	if(defined(&__KERNEL__)) {
	    require 'linux/init.ph';
	    require 'linux/ioport.ph';
	    require 'asm/zorro.ph';
	    eval 'sub to_zorro_dev {
	        my($n) = @_;
    		eval q( &container_of($n, \'struct zorro_dev\',  &dev));
	    }' unless defined(&to_zorro_dev);
	    eval 'sub to_zorro_driver {
	        my($drv) = @_;
    		eval q( &container_of($drv, \'struct zorro_driver\',  &driver));
	    }' unless defined(&to_zorro_driver);
	    eval 'sub zorro_for_each_dev {
	        my($dev) = @_;
    		eval q( &for ($dev =  $zorro_autocon[0]; $dev <  &zorro_autocon+ &zorro_num_autocon; $dev++));
	    }' unless defined(&zorro_for_each_dev);
	    eval 'sub zorro_driver {
	        eval q(* &zorro_dev_driver( &const \'struct zorro_dev\' * &z) {  ($z->{driver}); });
	    }' unless defined(&zorro_driver);
	    eval 'sub zorro_resource_start {
	        my($z) = @_;
    		eval q((($z)-> ($resource->{start})));
	    }' unless defined(&zorro_resource_start);
	    eval 'sub zorro_resource_end {
	        my($z) = @_;
    		eval q((($z)-> ($resource->{end})));
	    }' unless defined(&zorro_resource_end);
	    eval 'sub zorro_resource_len {
	        my($z) = @_;
    		eval q((($z)-> ($resource->{end})-($z)-> ($resource->{start})+1));
	    }' unless defined(&zorro_resource_len);
	    eval 'sub zorro_resource_flags {
	        my($z) = @_;
    		eval q((($z)-> ($resource->{flags})));
	    }' unless defined(&zorro_resource_flags);
	    eval 'sub zorro_request_device {
	        my($z, $name) = @_;
    		eval q( &request_mem_region( &zorro_resource_start($z),  &zorro_resource_len($z), $name));
	    }' unless defined(&zorro_request_device);
	    eval 'sub zorro_release_device {
	        my($z) = @_;
    		eval q( &release_mem_region( &zorro_resource_start($z),  &zorro_resource_len($z)));
	    }' unless defined(&zorro_release_device);
	    eval 'sub zorro_set_drvdata {
	        my($z,$data) = @_;
    		eval q({  &dev_set_drvdata( ($z->{dev}), $data); });
	    }' unless defined(&zorro_set_drvdata);
	    if(defined( &CONFIG_HOTPLUG)  && !defined( &MODULE)) {
	    } else {
	    }
	    eval 'sub Z2RAM_START {(0x200000);}' unless defined(&Z2RAM_START);
	    eval 'sub Z2RAM_END {(0xa00000);}' unless defined(&Z2RAM_END);
	    eval 'sub Z2RAM_SIZE {(0x800000);}' unless defined(&Z2RAM_SIZE);
	    eval 'sub Z2RAM_CHUNKSIZE {(0x10000);}' unless defined(&Z2RAM_CHUNKSIZE);
	    eval 'sub Z2RAM_CHUNKMASK {(0xffff);}' unless defined(&Z2RAM_CHUNKMASK);
	    eval 'sub Z2RAM_CHUNKSHIFT {(16);}' unless defined(&Z2RAM_CHUNKSHIFT);
	}
    }
}
1;
