require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&SAFE_CTYPE_H)) {
    eval 'sub SAFE_CTYPE_H {1;}' unless defined(&SAFE_CTYPE_H);
    if(defined(&isalpha)) {
	die("safe-ctype.h and ctype.h may not be used simultaneously");
    }
    eval 'sub HOST_CHARSET_UNKNOWN {0;}' unless defined(&HOST_CHARSET_UNKNOWN);
    eval 'sub HOST_CHARSET_ASCII {1;}' unless defined(&HOST_CHARSET_ASCII);
    eval 'sub HOST_CHARSET_EBCDIC {2;}' unless defined(&HOST_CHARSET_EBCDIC);
    if(ord('\n' == 0x0A && ' ' == 0x20 && '0' == 0x30    && 'A' == 0x41 && 'a' == 0x61 && '!') == 0x21) {
	eval 'sub HOST_CHARSET { &HOST_CHARSET_ASCII;}' unless defined(&HOST_CHARSET);
    } else {
	if(ord('\n' == 0x15 && ' ' == 0x40 && '0' == 0xF0    && 'A' == 0xC1 && 'a' == 0x81 && '!') == 0x5a) {
	    eval 'sub HOST_CHARSET { &HOST_CHARSET_EBCDIC;}' unless defined(&HOST_CHARSET);
	} else {
	    eval 'sub HOST_CHARSET { &HOST_CHARSET_UNKNOWN;}' unless defined(&HOST_CHARSET);
	}
    }
    eval("sub _sch_isblank () { 0x0001; }") unless defined(&_sch_isblank);
    eval("sub _sch_iscntrl () { 0x0002; }") unless defined(&_sch_iscntrl);
    eval("sub _sch_isdigit () { 0x0004; }") unless defined(&_sch_isdigit);
    eval("sub _sch_islower () { 0x0008; }") unless defined(&_sch_islower);
    eval("sub _sch_isprint () { 0x0010; }") unless defined(&_sch_isprint);
    eval("sub _sch_ispunct () { 0x0020; }") unless defined(&_sch_ispunct);
    eval("sub _sch_isspace () { 0x0040; }") unless defined(&_sch_isspace);
    eval("sub _sch_isupper () { 0x0080; }") unless defined(&_sch_isupper);
    eval("sub _sch_isxdigit () { 0x0100; }") unless defined(&_sch_isxdigit);
    eval("sub _sch_isidst () { 0x0200; }") unless defined(&_sch_isidst);
    eval("sub _sch_isvsp () { 0x0400; }") unless defined(&_sch_isvsp);
    eval("sub _sch_isnvsp () { 0x0800; }") unless defined(&_sch_isnvsp);
    eval("sub _sch_isalpha () { _sch_isupper|_sch_islower; }") unless defined(&_sch_isalpha);
    eval("sub _sch_isalnum () { _sch_isalpha|_sch_isdigit; }") unless defined(&_sch_isalnum);
    eval("sub _sch_isidnum () { _sch_isidst|_sch_isdigit; }") unless defined(&_sch_isidnum);
    eval("sub _sch_isgraph () { _sch_isalnum|_sch_ispunct; }") unless defined(&_sch_isgraph);
    eval("sub _sch_iscppsp () { _sch_isvsp|_sch_isnvsp; }") unless defined(&_sch_iscppsp);
    eval("sub _sch_isbasic () { _sch_isprint|_sch_iscppsp; }") unless defined(&_sch_isbasic);
    eval 'sub _sch_test {
        my($c, $bit) = @_;
	    eval q(( $_sch_istable[($c) & 0xff] & ($bit)));
    }' unless defined(&_sch_test);
    eval 'sub ISALPHA {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isalpha));
    }' unless defined(&ISALPHA);
    eval 'sub ISALNUM {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isalnum));
    }' unless defined(&ISALNUM);
    eval 'sub ISBLANK {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isblank));
    }' unless defined(&ISBLANK);
    eval 'sub ISCNTRL {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_iscntrl));
    }' unless defined(&ISCNTRL);
    eval 'sub ISDIGIT {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isdigit));
    }' unless defined(&ISDIGIT);
    eval 'sub ISGRAPH {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isgraph));
    }' unless defined(&ISGRAPH);
    eval 'sub ISLOWER {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_islower));
    }' unless defined(&ISLOWER);
    eval 'sub ISPRINT {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isprint));
    }' unless defined(&ISPRINT);
    eval 'sub ISPUNCT {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_ispunct));
    }' unless defined(&ISPUNCT);
    eval 'sub ISSPACE {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isspace));
    }' unless defined(&ISSPACE);
    eval 'sub ISUPPER {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isupper));
    }' unless defined(&ISUPPER);
    eval 'sub ISXDIGIT {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isxdigit));
    }' unless defined(&ISXDIGIT);
    eval 'sub ISIDNUM {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isidnum));
    }' unless defined(&ISIDNUM);
    eval 'sub ISIDST {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isidst));
    }' unless defined(&ISIDST);
    eval 'sub IS_ISOBASIC {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isbasic));
    }' unless defined(&IS_ISOBASIC);
    eval 'sub IS_VSPACE {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isvsp));
    }' unless defined(&IS_VSPACE);
    eval 'sub IS_NVSPACE {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_isnvsp));
    }' unless defined(&IS_NVSPACE);
    eval 'sub IS_SPACE_OR_NUL {
        my($c) = @_;
	    eval q( &_sch_test($c,  &_sch_iscppsp));
    }' unless defined(&IS_SPACE_OR_NUL);
    eval 'sub TOUPPER {
        my($c) = @_;
	    eval q( $_sch_toupper[($c) & 0xff]);
    }' unless defined(&TOUPPER);
    eval 'sub TOLOWER {
        my($c) = @_;
	    eval q( $_sch_tolower[($c) & 0xff]);
    }' unless defined(&TOLOWER);
}
1;
