require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_HW_IRQ_H)) {
    eval 'sub _ASM_HW_IRQ_H () {1;}' unless defined(&_ASM_HW_IRQ_H);
    unless(defined(&__ASSEMBLY__)) {
	require 'asm/atomic.ph';
	require 'asm/irq.ph';
	require 'linux/profile.ph';
	require 'linux/smp.ph';
    }
    eval 'sub NMI_VECTOR () {0x2;}' unless defined(&NMI_VECTOR);
    eval 'sub FIRST_EXTERNAL_VECTOR () {0x20;}' unless defined(&FIRST_EXTERNAL_VECTOR);
    eval 'sub IA32_SYSCALL_VECTOR () {0x80;}' unless defined(&IA32_SYSCALL_VECTOR);
    eval 'sub SPURIOUS_APIC_VECTOR () {0xff;}' unless defined(&SPURIOUS_APIC_VECTOR);
    eval 'sub ERROR_APIC_VECTOR () {0xfe;}' unless defined(&ERROR_APIC_VECTOR);
    eval 'sub RESCHEDULE_VECTOR () {0xfd;}' unless defined(&RESCHEDULE_VECTOR);
    eval 'sub CALL_FUNCTION_VECTOR () {0xfc;}' unless defined(&CALL_FUNCTION_VECTOR);
    eval 'sub THERMAL_APIC_VECTOR () {0xfa;}' unless defined(&THERMAL_APIC_VECTOR);
    eval 'sub THRESHOLD_APIC_VECTOR () {0xf9;}' unless defined(&THRESHOLD_APIC_VECTOR);
    eval 'sub INVALIDATE_TLB_VECTOR_END () {0xf7;}' unless defined(&INVALIDATE_TLB_VECTOR_END);
    eval 'sub INVALIDATE_TLB_VECTOR_START () {0xf0;}' unless defined(&INVALIDATE_TLB_VECTOR_START);
    eval 'sub NUM_INVALIDATE_TLB_VECTORS () {8;}' unless defined(&NUM_INVALIDATE_TLB_VECTORS);
    eval 'sub LOCAL_TIMER_VECTOR () {0xef;}' unless defined(&LOCAL_TIMER_VECTOR);
    eval 'sub FIRST_DEVICE_VECTOR () {0x31;}' unless defined(&FIRST_DEVICE_VECTOR);
    eval 'sub FIRST_SYSTEM_VECTOR () {0xef;}' unless defined(&FIRST_SYSTEM_VECTOR);
    unless(defined(&__ASSEMBLY__)) {
	eval 'sub IO_APIC_VECTOR {
	    my($irq) = @_;
    	    eval q(( $irq_vector[$irq]));
	}' unless defined(&IO_APIC_VECTOR);
	eval 'sub AUTO_ASSIGN () {-1;}' unless defined(&AUTO_ASSIGN);
	eval 'sub IO_APIC_IRQ {
	    my($x) = @_;
    	    eval q(((($x) >= 16) || ((1<<($x)) &  &io_apic_irqs)));
	}' unless defined(&IO_APIC_IRQ);
	eval 'sub __STR {
	    my($x) = @_;
    	    eval q($x);
	}' unless defined(&__STR);
	eval 'sub STR {
	    my($x) = @_;
    	    eval q( &__STR($x));
	}' unless defined(&STR);
	require 'asm/ptrace.ph';
	eval 'sub IRQ_NAME2 {
	    my($nr) = @_;
    	    eval q($nr &_interrupt( &void));
	}' unless defined(&IRQ_NAME2);
	eval 'sub IRQ_NAME {
	    my($nr) = @_;
    	    eval q( &IRQ_NAME2( &IRQ$nr));
	}' unless defined(&IRQ_NAME);
	eval 'sub BUILD_IRQ {
	    my($nr) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&BUILD_IRQ);
	eval 'sub platform_legacy_irq {
	    my($irq) = @_;
    	    eval q((($irq) < 16));
	}' unless defined(&platform_legacy_irq);
    }
}
1;
