require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_INTERRUPT_H)) {
    eval 'sub _LINUX_INTERRUPT_H () {1;}' unless defined(&_LINUX_INTERRUPT_H);
    require 'linux/kernel.ph';
    require 'linux/linkage.ph';
    require 'linux/bitops.ph';
    require 'linux/preempt.ph';
    require 'linux/cpumask.ph';
    require 'linux/irqreturn.ph';
    require 'linux/hardirq.ph';
    require 'linux/sched.ph';
    require 'linux/irqflags.ph';
    require 'asm/atomic.ph';
    require 'asm/ptrace.ph';
    require 'asm/system.ph';
    eval 'sub IRQF_TRIGGER_NONE () {0x;}' unless defined(&IRQF_TRIGGER_NONE);
    eval 'sub IRQF_TRIGGER_RISING () {0x1;}' unless defined(&IRQF_TRIGGER_RISING);
    eval 'sub IRQF_TRIGGER_FALLING () {0x2;}' unless defined(&IRQF_TRIGGER_FALLING);
    eval 'sub IRQF_TRIGGER_HIGH () {0x4;}' unless defined(&IRQF_TRIGGER_HIGH);
    eval 'sub IRQF_TRIGGER_LOW () {0x8;}' unless defined(&IRQF_TRIGGER_LOW);
    eval 'sub IRQF_TRIGGER_MASK () {( &IRQF_TRIGGER_HIGH |  &IRQF_TRIGGER_LOW |  &IRQF_TRIGGER_RISING |  &IRQF_TRIGGER_FALLING);}' unless defined(&IRQF_TRIGGER_MASK);
    eval 'sub IRQF_TRIGGER_PROBE () {0x10;}' unless defined(&IRQF_TRIGGER_PROBE);
    eval 'sub IRQF_DISABLED () {0x20;}' unless defined(&IRQF_DISABLED);
    eval 'sub IRQF_SAMPLE_RANDOM () {0x40;}' unless defined(&IRQF_SAMPLE_RANDOM);
    eval 'sub IRQF_SHARED () {0x80;}' unless defined(&IRQF_SHARED);
    eval 'sub IRQF_PROBE_SHARED () {0x100;}' unless defined(&IRQF_PROBE_SHARED);
    eval 'sub IRQF_TIMER () {0x200;}' unless defined(&IRQF_TIMER);
    eval 'sub IRQF_PERCPU () {0x400;}' unless defined(&IRQF_PERCPU);
    eval 'sub SA_INTERRUPT () { &IRQF_DISABLED;}' unless defined(&SA_INTERRUPT);
    eval 'sub SA_SAMPLE_RANDOM () { &IRQF_SAMPLE_RANDOM;}' unless defined(&SA_SAMPLE_RANDOM);
    eval 'sub SA_SHIRQ () { &IRQF_SHARED;}' unless defined(&SA_SHIRQ);
    eval 'sub SA_PROBEIRQ () { &IRQF_PROBE_SHARED;}' unless defined(&SA_PROBEIRQ);
    eval 'sub SA_PERCPU () { &IRQF_PERCPU;}' unless defined(&SA_PERCPU);
    eval 'sub SA_TRIGGER_LOW () { &IRQF_TRIGGER_LOW;}' unless defined(&SA_TRIGGER_LOW);
    eval 'sub SA_TRIGGER_HIGH () { &IRQF_TRIGGER_HIGH;}' unless defined(&SA_TRIGGER_HIGH);
    eval 'sub SA_TRIGGER_FALLING () { &IRQF_TRIGGER_FALLING;}' unless defined(&SA_TRIGGER_FALLING);
    eval 'sub SA_TRIGGER_RISING () { &IRQF_TRIGGER_RISING;}' unless defined(&SA_TRIGGER_RISING);
    eval 'sub SA_TRIGGER_MASK () { &IRQF_TRIGGER_MASK;}' unless defined(&SA_TRIGGER_MASK);
    if(defined(&CONFIG_LOCKDEP)) {
	eval 'sub local_irq_enable_in_hardirq () {
	    eval q( &do { }  &while (0));
	}' unless defined(&local_irq_enable_in_hardirq);
    } else {
	eval 'sub local_irq_enable_in_hardirq () {
	    eval q( &local_irq_enable());
	}' unless defined(&local_irq_enable_in_hardirq);
    }
    if(defined(&CONFIG_GENERIC_HARDIRQS)) {
	if(defined(&CONFIG_LOCKDEP)) {
	}
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub disable_irq_lockdep {
	    my($irq) = @_;
    	    eval q({  &disable_irq($irq); });
	}' unless defined(&disable_irq_lockdep);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub enable_irq_lockdep {
	    my($irq) = @_;
    	    eval q({  &enable_irq($irq); });
	}' unless defined(&enable_irq_lockdep);
	eval 'sub enable_irq_wake {
	    my($irq) = @_;
    	    eval q({  &set_irq_wake($irq, 1); });
	}' unless defined(&enable_irq_wake);
	eval 'sub disable_irq_wake {
	    my($irq) = @_;
    	    eval q({  &set_irq_wake($irq, 0); });
	}' unless defined(&disable_irq_wake);
    } else {
	unless(defined(&CONFIG_LOCKDEP)) {
	    eval 'sub disable_irq_nosync_lockdep {
	        my($irq) = @_;
    		eval q( &disable_irq_nosync($irq));
	    }' unless defined(&disable_irq_nosync_lockdep);
	    eval 'sub disable_irq_lockdep {
	        my($irq) = @_;
    		eval q( &disable_irq($irq));
	    }' unless defined(&disable_irq_lockdep);
	    eval 'sub enable_irq_lockdep {
	        my($irq) = @_;
    		eval q( &enable_irq($irq));
	    }' unless defined(&enable_irq_lockdep);
	}
    }
    unless(defined(&__ARCH_SET_SOFTIRQ_PENDING)) {
	eval 'sub set_softirq_pending {
	    my($x) = @_;
    	    eval q(( &local_softirq_pending() = ($x)));
	}' unless defined(&set_softirq_pending);
	eval 'sub or_softirq_pending {
	    my($x) = @_;
    	    eval q(( &local_softirq_pending() |= ($x)));
	}' unless defined(&or_softirq_pending);
    }
    unless(defined(&CONFIG_SMP)) {
	eval 'sub cli {
	    my($void) = @_;
    	    eval q({  &local_irq_disable(); });
	}' unless defined(&cli);
	eval 'sub sti {
	    my($void) = @_;
    	    eval q({  &local_irq_enable(); });
	}' unless defined(&sti);
	eval 'sub save_flags {
	    my($x) = @_;
    	    eval q({  &local_save_flags(*$x); });
	}' unless defined(&save_flags);
	eval 'sub save_flags {
	    my($x) = @_;
    	    eval q( &save_flags($x));
	}' unless defined(&save_flags);
	eval 'sub restore_flags {
	    my($x) = @_;
    	    eval q({  &local_irq_restore($x); });
	}' unless defined(&restore_flags);
	eval 'sub save_and_cli {
	    my($x) = @_;
    	    eval q({  &local_irq_save(*$x); });
	}' unless defined(&save_and_cli);
	eval 'sub save_and_cli {
	    my($x) = @_;
    	    eval q( &save_and_cli($x));
	}' unless defined(&save_and_cli);
    }
    eval("sub HI_SOFTIRQ () { 0; }") unless defined(&HI_SOFTIRQ);
    eval("sub TIMER_SOFTIRQ () { 1; }") unless defined(&TIMER_SOFTIRQ);
    eval("sub NET_TX_SOFTIRQ () { 2; }") unless defined(&NET_TX_SOFTIRQ);
    eval("sub NET_RX_SOFTIRQ () { 3; }") unless defined(&NET_RX_SOFTIRQ);
    eval("sub BLOCK_SOFTIRQ () { 4; }") unless defined(&BLOCK_SOFTIRQ);
    eval("sub TASKLET_SOFTIRQ () { 5; }") unless defined(&TASKLET_SOFTIRQ);
    eval 'sub __raise_softirq_irqoff {
        my($nr) = @_;
	    eval q( &do {  &or_softirq_pending(1 << ($nr)); }  &while (0));
    }' unless defined(&__raise_softirq_irqoff);
    eval 'sub DECLARE_TASKLET {
        my($name, $func, $data) = @_;
	    eval q(1;
    }' unless defined(&DECLARE_TASKLET);
    eval 'sub DECLARE_TASKLET_DISABLED {
        my($name, $func, $data) = @_;
	    eval q(1;
    }' unless defined(&DECLARE_TASKLET_DISABLED);
    eval("sub TASKLET_STATE_SCHED () { 0; }") unless defined(&TASKLET_STATE_SCHED);
    eval("sub TASKLET_STATE_RUN () { 1; }") unless defined(&TASKLET_STATE_RUN);
    if(defined(&CONFIG_SMP)) {
	eval 'sub tasklet_trylock {
	    my($t) = @_;
    	    eval q({ ! &test_and_set_bit( &TASKLET_STATE_RUN, ($t)-> &state); });
	}' unless defined(&tasklet_trylock);
	eval 'sub tasklet_unlock {
	    my($t) = @_;
    	    eval q({  &smp_mb__before_clear_bit();  &clear_bit( &TASKLET_STATE_RUN, ($t)-> &state); });
	}' unless defined(&tasklet_unlock);
	eval 'sub tasklet_unlock_wait {
	    my($t) = @_;
    	    eval q({  &while ( &test_bit( &TASKLET_STATE_RUN, ($t)-> &state)) {  &barrier(); } });
	}' unless defined(&tasklet_unlock_wait);
    } else {
	eval 'sub tasklet_trylock {
	    my($t) = @_;
    	    eval q(1);
	}' unless defined(&tasklet_trylock);
	eval 'sub tasklet_unlock_wait {
	    my($t) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&tasklet_unlock_wait);
	eval 'sub tasklet_unlock {
	    my($t) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&tasklet_unlock);
    }
    eval 'sub tasklet_schedule {
        my($t) = @_;
	    eval q({  &if (! &test_and_set_bit( &TASKLET_STATE_SCHED,  ($t->{s$tate})))  &__tasklet_schedule($t); });
    }' unless defined(&tasklet_schedule);
    eval 'sub tasklet_hi_schedule {
        my($t) = @_;
	    eval q({  &if (! &test_and_set_bit( &TASKLET_STATE_SCHED,  ($t->{s$tate})))  &__tasklet_hi_schedule($t); });
    }' unless defined(&tasklet_hi_schedule);
    eval 'sub tasklet_disable_nosync {
        my($t) = @_;
	    eval q({  &atomic_inc( ($t->{count}));  &smp_mb__after_atomic_inc(); });
    }' unless defined(&tasklet_disable_nosync);
    eval 'sub tasklet_disable {
        my($t) = @_;
	    eval q({  &tasklet_disable_nosync($t);  &tasklet_unlock_wait($t);  &smp_mb(); });
    }' unless defined(&tasklet_disable);
    eval 'sub tasklet_enable {
        my($t) = @_;
	    eval q({  &smp_mb__before_atomic_dec();  &atomic_dec( ($t->{count})); });
    }' unless defined(&tasklet_enable);
    eval 'sub tasklet_hi_enable {
        my($t) = @_;
	    eval q({  &smp_mb__before_atomic_dec();  &atomic_dec( ($t->{count})); });
    }' unless defined(&tasklet_hi_enable);
    if(defined( &CONFIG_GENERIC_HARDIRQS)  && !defined( &CONFIG_GENERIC_IRQ_PROBE) ) {
	eval 'sub probe_irq_on {
	    my($void) = @_;
    	    eval q({ 0; });
	}' unless defined(&probe_irq_on);
	eval 'sub probe_irq_off {
	    my($val) = @_;
    	    eval q({ 0; });
	}' unless defined(&probe_irq_off);
	eval 'sub probe_irq_mask {
	    my($val) = @_;
    	    eval q({ 0; });
	}' unless defined(&probe_irq_mask);
    } else {
    }
}
1;
