require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_RWSEM_SPINLOCK_H)) {
    eval 'sub _LINUX_RWSEM_SPINLOCK_H () {1;}' unless defined(&_LINUX_RWSEM_SPINLOCK_H);
    unless(defined(&_LINUX_RWSEM_H)) {
	die("please don't include linux/rwsem-spinlock.h directly, use linux/rwsem.h instead");
    }
    require 'linux/spinlock.ph';
    require 'linux/list.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/types.ph';
	if(defined(&CONFIG_DEBUG_LOCK_ALLOC)) {
	}
	if(defined(&CONFIG_DEBUG_LOCK_ALLOC)) {
	    eval 'sub __RWSEM_DEP_MAP_INIT {
	        my($lockname) = @_;
    		eval q(, . &dep_map = { . &name = $lockname });
	    }' unless defined(&__RWSEM_DEP_MAP_INIT);
	} else {
	    eval 'sub __RWSEM_DEP_MAP_INIT {
	        my($lockname) = @_;
    		eval q();
	    }' unless defined(&__RWSEM_DEP_MAP_INIT);
	}
	eval 'sub __RWSEM_INITIALIZER {
	    my($name) = @_;
    	    eval q({ 0,  &SPIN_LOCK_UNLOCKED,  &LIST_HEAD_INIT(($name). &wait_list)  &__RWSEM_DEP_MAP_INIT($name) });
	}' unless defined(&__RWSEM_INITIALIZER);
	eval 'sub DECLARE_RWSEM {
	    my($name) = @_;
    	    eval q(1;
	}' unless defined(&DECLARE_RWSEM);
	eval 'sub init_rwsem {
	    my($sem) = @_;
    	    eval q( &do {  &static 1;  &__init_rwsem(($sem), $sem, & &__key); }  &while (0));
	}' unless defined(&init_rwsem);
	eval 'sub rwsem_is_locked {
	    my($sem) = @_;
    	    eval q({ ( ($sem->{activity}) != 0); });
	}' unless defined(&rwsem_is_locked);
    }
}
1;
