--TEST--
GH-7752: DateTimeZone::getTransitions() does not return enough information
--FILE--
<?php
function showTransitions(string $tzid, int $from)
{
	$to = $from + ((2.5 * 366) * 24 * 60 * 60);

	echo "{$tzid} from @{$from}-@{$to}:\n\n";

	$tz = new DateTimeZone($tzid);
	foreach ($tz->getTransitions($from, $to) as $t) {
		printf("%12d %s %6d %s %s\n", $t['ts'], $t['time'], $t['offset'], $t['isdst'] ? "DST" : " x ", $t['abbr']);
	}
	echo "\n";
}


showTransitions('Europe/London', 1648342200);
showTransitions('America/Los_Angeles', 1648557596); // GH Issue 7752
showTransitions('America/Chicago', 1293861600);     // PHP Bug 81660
showTransitions('Europe/Paris', 1645095600);        // GH Issue 8108
?>
--EXPECT--
Europe/London from @1648342200-@1727398200:

  1648342200 2022-03-27T00:50:00+0000      0  x  GMT
  1648342800 2022-03-27T01:00:00+0000   3600 DST BST
  1667091600 2022-10-30T01:00:00+0000      0  x  GMT
  1679792400 2023-03-26T01:00:00+0000   3600 DST BST
  1698541200 2023-10-29T01:00:00+0000      0  x  GMT
  1711846800 2024-03-31T01:00:00+0000   3600 DST BST

America/Los_Angeles from @1648557596-@1727613596:

  1648557596 2022-03-29T12:39:56+0000 -25200 DST PDT
  1667725200 2022-11-06T09:00:00+0000 -28800  x  PST
  1678615200 2023-03-12T10:00:00+0000 -25200 DST PDT
  1699174800 2023-11-05T09:00:00+0000 -28800  x  PST
  1710064800 2024-03-10T10:00:00+0000 -25200 DST PDT

America/Chicago from @1293861600-@1372917600:

  1293861600 2011-01-01T06:00:00+0000 -21600  x  CST
  1300003200 2011-03-13T08:00:00+0000 -18000 DST CDT
  1320562800 2011-11-06T07:00:00+0000 -21600  x  CST
  1331452800 2012-03-11T08:00:00+0000 -18000 DST CDT
  1352012400 2012-11-04T07:00:00+0000 -21600  x  CST
  1362902400 2013-03-10T08:00:00+0000 -18000 DST CDT

Europe/Paris from @1645095600-@1724151600:

  1645095600 2022-02-17T11:00:00+0000   3600  x  CET
  1648342800 2022-03-27T01:00:00+0000   7200 DST CEST
  1667091600 2022-10-30T01:00:00+0000   3600  x  CET
  1679792400 2023-03-26T01:00:00+0000   7200 DST CEST
  1698541200 2023-10-29T01:00:00+0000   3600  x  CET
  1711846800 2024-03-31T01:00:00+0000   7200 DST CEST
